/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ApplyImports;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;

public class NextMatch
extends ApplyImports {
    boolean useTailRecursion;

    public NextMatch(boolean useTailRecursion) {
        this.useTailRecursion = useTailRecursion;
    }

    public int getInstructionNameCode() {
        return 178;
    }

    public Expression copy() {
        NextMatch nm2 = new NextMatch(this.useTailRecursion);
        nm2.setActualParameters(WithParam.copy(this.actualParams), WithParam.copy(this.tunnelParams));
        return nm2;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        ParameterSet params = NextMatch.assembleParams(context, this.actualParams);
        ParameterSet tunnels = NextMatch.assembleTunnelParams(context, this.tunnelParams);
        Rule currentRule = context.getCurrentTemplateRule();
        if (currentRule == null) {
            XPathException e = new XPathException("There is no current template rule");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0560");
            throw e;
        }
        Mode mode = context.getCurrentMode();
        if (mode == null) {
            mode = controller.getRuleManager().getUnnamedMode();
        }
        if (context.getCurrentIterator() == null) {
            XPathException e = new XPathException("There is no context item");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0565");
            throw e;
        }
        Item currentItem = context.getCurrentIterator().current();
        if (!(currentItem instanceof NodeInfo)) {
            XPathException e = new XPathException("Cannot call xsl:next-match when context item is not a node");
            e.setXPathContext(context);
            e.setErrorCode("XTDE0565");
            throw e;
        }
        NodeInfo node = (NodeInfo)currentItem;
        Rule rule = controller.getRuleManager().getNextMatchHandler(node, mode, currentRule, context);
        if (rule == null) {
            mode.getBuiltInRuleSet().process(node, params, tunnels, context, this.getLocationId());
        } else {
            if (this.useTailRecursion) {
                Arrays.fill(context.getStackFrame().getStackFrameValues(), null);
                return new NextMatchPackage(rule, params, tunnels, context);
            }
            Template nh = (Template)rule.getAction();
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            c2.setOriginatingConstructType(2008);
            c2.openStackFrame(nh.getStackFrameMap());
            c2.setLocalParameters(params);
            c2.setTunnelParameters(tunnels);
            c2.setCurrentTemplateRule(rule);
            nh.apply(c2);
        }
        return null;
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("nextMatch");
        if (this.actualParams != null && this.actualParams.length > 0) {
            out.startSubsidiaryElement("withParams");
            WithParam.displayExpressions(this.actualParams, out);
            out.endSubsidiaryElement();
        }
        if (this.tunnelParams != null && this.tunnelParams.length > 0) {
            out.startSubsidiaryElement("tunnelParams");
            WithParam.displayExpressions(this.tunnelParams, out);
            out.endSubsidiaryElement();
        }
        out.endElement();
    }

    private class NextMatchPackage
    implements TailCall {
        private Rule rule;
        private ParameterSet params;
        private ParameterSet tunnelParams;
        private XPathContext evaluationContext;

        public NextMatchPackage(Rule rule, ParameterSet params, ParameterSet tunnelParams, XPathContext evaluationContext) {
            this.rule = rule;
            this.params = params;
            this.tunnelParams = tunnelParams;
            this.evaluationContext = evaluationContext;
        }

        public TailCall processLeavingTail() throws XPathException {
            Template nh = (Template)this.rule.getAction();
            XPathContextMajor c2 = this.evaluationContext.newContext();
            c2.setOrigin(NextMatch.this);
            c2.setOriginatingConstructType(2008);
            c2.setLocalParameters(this.params);
            c2.setTunnelParameters(this.tunnelParams);
            c2.openStackFrame(nh.getStackFrameMap());
            c2.setCurrentTemplateRule(this.rule);
            return nh.applyLeavingTail(c2);
        }
    }
}

