/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class NodeToBytes {
    private static final QName _encoding = new QName("encoding");
    private static final QName _content_type = new QName("content-type");
    private static final QName c_encoding = new QName("c", "http://www.w3.org/ns/xproc-step", "encoding");
    private static final QName c_body = new QName("c", "http://www.w3.org/ns/xproc-step", "body");
    private static final QName c_json = new QName("c", "http://www.w3.org/ns/xproc-step", "json");
    private static final QName cx_decode = new QName("cx", "http://xmlcalabash.com/ns/extensions", "decode");

    private NodeToBytes() {
    }

    public static byte[] convert(XProcRuntime xProcRuntime, XdmNode xdmNode, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XdmNode xdmNode2 = S9apiUtils.getDocumentElement(xdmNode);
        if (bl && ("http://www.w3.org/ns/xproc-step".equals(xdmNode2.getNodeName().getNamespaceURI()) && "base64".equals(xdmNode2.getAttributeValue(_encoding)) || "".equals(xdmNode2.getNodeName().getNamespaceURI()) && "base64".equals(xdmNode2.getAttributeValue(c_encoding)))) {
            NodeToBytes.storeBinary(xdmNode, byteArrayOutputStream);
        } else if (xProcRuntime.transparentJSON() && (c_body.equals((Object)xdmNode2.getNodeName()) && ("application/json".equals(xdmNode2.getAttributeValue(_content_type)) || "text/json".equals(xdmNode2.getAttributeValue(_content_type))) || c_json.equals((Object)xdmNode2.getNodeName()) || "http://www.ibm.com/xmlns/prod/2009/jsonx".equals(xdmNode2.getNodeName().getNamespaceURI()) || "http://www.xmlsh.org/jxml".equals(xdmNode2.getNodeName().getNamespaceURI()) || "http://marklogic.com/json".equals(xdmNode2.getNodeName().getNamespaceURI()))) {
            NodeToBytes.storeJSON(xdmNode, byteArrayOutputStream);
        } else {
            NodeToBytes.storeXML(xProcRuntime, xdmNode, byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void storeXML(XProcRuntime xProcRuntime, XdmNode xdmNode, OutputStream outputStream) {
        Serializer serializer = new Serializer();
        serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
        serializer.setOutputProperty(Serializer.Property.INDENT, "no");
        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        try {
            serializer.setOutputStream(outputStream);
            S9apiUtils.serialize(xProcRuntime, xdmNode, serializer);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new XProcException("Failed to serialize as XML: " + xdmNode, (Throwable)iOException);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException("Failed to serialize as XML: " + xdmNode, (Throwable)saxonApiException);
        }
    }

    private static void storeBinary(XdmNode xdmNode, OutputStream outputStream) {
        try {
            byte[] byArray = Base64.decode(xdmNode.getStringValue());
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new XProcException(iOException);
        }
    }

    private static void storeJSON(XdmNode xdmNode, OutputStream outputStream) {
        try {
            PrintWriter printWriter = new PrintWriter(outputStream);
            String string = XMLtoJSON.convert(xdmNode);
            printWriter.print(string);
            printWriter.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw XProcException.stepError(50, iOException);
        }
    }
}

