/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.io.Reader;
import java.util.zip.DataFormatException;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldReaderException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.CloseableThreadLocal;

final class FieldsReader
implements Cloneable {
    private final FieldInfos fieldInfos;
    private final IndexInput cloneableFieldsStream;
    private final IndexInput fieldsStream;
    private final IndexInput cloneableIndexStream;
    private final IndexInput indexStream;
    private int numTotalDocs;
    private int size;
    private boolean closed;
    private final int format;
    private final int formatSize;
    private int docStoreOffset;
    private CloseableThreadLocal<IndexInput> fieldsStreamTL = new CloseableThreadLocal();
    private boolean isOriginal = false;

    public Object clone() {
        this.ensureOpen();
        return new FieldsReader(this.fieldInfos, this.numTotalDocs, this.size, this.format, this.formatSize, this.docStoreOffset, this.cloneableFieldsStream, this.cloneableIndexStream);
    }

    private FieldsReader(FieldInfos fieldInfos, int numTotalDocs, int size, int format, int formatSize, int docStoreOffset, IndexInput cloneableFieldsStream, IndexInput cloneableIndexStream) {
        this.fieldInfos = fieldInfos;
        this.numTotalDocs = numTotalDocs;
        this.size = size;
        this.format = format;
        this.formatSize = formatSize;
        this.docStoreOffset = docStoreOffset;
        this.cloneableFieldsStream = cloneableFieldsStream;
        this.cloneableIndexStream = cloneableIndexStream;
        this.fieldsStream = (IndexInput)cloneableFieldsStream.clone();
        this.indexStream = (IndexInput)cloneableIndexStream.clone();
    }

    FieldsReader(Directory d, String segment, FieldInfos fn) throws IOException {
        this(d, segment, fn, 1024, -1, 0);
    }

    FieldsReader(Directory d, String segment, FieldInfos fn, int readBufferSize) throws IOException {
        this(d, segment, fn, readBufferSize, -1, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsReader(Directory d, String segment, FieldInfos fn, int readBufferSize, int docStoreOffset, int size) throws IOException {
        boolean success = false;
        this.isOriginal = true;
        try {
            this.fieldInfos = fn;
            this.cloneableFieldsStream = d.openInput(segment + "." + "fdt", readBufferSize);
            this.cloneableIndexStream = d.openInput(segment + "." + "fdx", readBufferSize);
            int firstInt = this.cloneableIndexStream.readInt();
            this.format = firstInt == 0 ? 0 : firstInt;
            if (this.format > 2) {
                throw new CorruptIndexException("Incompatible format version: " + this.format + " expected " + 2 + " or lower");
            }
            this.formatSize = this.format > 0 ? 4 : 0;
            if (this.format < 1) {
                this.cloneableFieldsStream.setModifiedUTF8StringsMode();
            }
            this.fieldsStream = (IndexInput)this.cloneableFieldsStream.clone();
            long indexSize = this.cloneableIndexStream.length() - (long)this.formatSize;
            if (docStoreOffset != -1) {
                this.docStoreOffset = docStoreOffset;
                this.size = size;
                assert ((int)(indexSize / 8L) >= size + this.docStoreOffset) : "indexSize=" + indexSize + " size=" + size + " docStoreOffset=" + docStoreOffset;
            } else {
                this.docStoreOffset = 0;
                this.size = (int)(indexSize >> 3);
            }
            this.indexStream = (IndexInput)this.cloneableIndexStream.clone();
            this.numTotalDocs = (int)(indexSize >> 3);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("this FieldsReader is closed");
        }
    }

    final void close() throws IOException {
        if (!this.closed) {
            if (this.fieldsStream != null) {
                this.fieldsStream.close();
            }
            if (this.isOriginal) {
                if (this.cloneableFieldsStream != null) {
                    this.cloneableFieldsStream.close();
                }
                if (this.cloneableIndexStream != null) {
                    this.cloneableIndexStream.close();
                }
            }
            if (this.indexStream != null) {
                this.indexStream.close();
            }
            this.fieldsStreamTL.close();
            this.closed = true;
        }
    }

    final int size() {
        return this.size;
    }

    private final void seekIndex(int docID) throws IOException {
        this.indexStream.seek((long)this.formatSize + (long)(docID + this.docStoreOffset) * 8L);
    }

    boolean canReadRawDocs() {
        return this.format >= 2;
    }

    final Document doc(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.seekIndex(n);
        long position = this.indexStream.readLong();
        this.fieldsStream.seek(position);
        Document doc = new Document();
        int numFields = this.fieldsStream.readVInt();
        for (int i = 0; i < numFields; ++i) {
            boolean binary;
            boolean compressed;
            int fieldNumber = this.fieldsStream.readVInt();
            FieldInfo fi = this.fieldInfos.fieldInfo(fieldNumber);
            FieldSelectorResult acceptField = fieldSelector == null ? FieldSelectorResult.LOAD : fieldSelector.accept(fi.name);
            byte bits = this.fieldsStream.readByte();
            assert (bits <= 7);
            boolean bl = compressed = (bits & 4) != 0;
            assert (!compressed || this.format < 2) : "compressed fields are only allowed in indexes of version <= 2.9";
            boolean tokenize = (bits & 1) != 0;
            boolean bl2 = binary = (bits & 2) != 0;
            if (acceptField.equals((Object)FieldSelectorResult.LOAD)) {
                this.addField(doc, fi, binary, compressed, tokenize);
                continue;
            }
            if (acceptField.equals((Object)FieldSelectorResult.LOAD_AND_BREAK)) {
                this.addField(doc, fi, binary, compressed, tokenize);
                break;
            }
            if (acceptField.equals((Object)FieldSelectorResult.LAZY_LOAD)) {
                this.addFieldLazy(doc, fi, binary, compressed, tokenize);
                continue;
            }
            if (acceptField.equals((Object)FieldSelectorResult.SIZE)) {
                this.skipField(binary, compressed, this.addFieldSize(doc, fi, binary, compressed));
                continue;
            }
            if (acceptField.equals((Object)FieldSelectorResult.SIZE_AND_BREAK)) {
                this.addFieldSize(doc, fi, binary, compressed);
                break;
            }
            this.skipField(binary, compressed);
        }
        return doc;
    }

    final IndexInput rawDocs(int[] lengths, int startDocID, int numDocs) throws IOException {
        long startOffset;
        this.seekIndex(startDocID);
        long lastOffset = startOffset = this.indexStream.readLong();
        int count = 0;
        while (count < numDocs) {
            int docID = this.docStoreOffset + startDocID + count + 1;
            assert (docID <= this.numTotalDocs);
            long offset = docID < this.numTotalDocs ? this.indexStream.readLong() : this.fieldsStream.length();
            lengths[count++] = (int)(offset - lastOffset);
            lastOffset = offset;
        }
        this.fieldsStream.seek(startOffset);
        return this.fieldsStream;
    }

    private void skipField(boolean binary, boolean compressed) throws IOException {
        this.skipField(binary, compressed, this.fieldsStream.readVInt());
    }

    private void skipField(boolean binary, boolean compressed, int toRead) throws IOException {
        if (this.format >= 1 || binary || compressed) {
            this.fieldsStream.seek(this.fieldsStream.getFilePointer() + (long)toRead);
        } else {
            this.fieldsStream.skipChars(toRead);
        }
    }

    private void addFieldLazy(Document doc, FieldInfo fi, boolean binary, boolean compressed, boolean tokenize) throws IOException {
        if (binary) {
            int toRead = this.fieldsStream.readVInt();
            long pointer = this.fieldsStream.getFilePointer();
            doc.add(new LazyField(fi.name, Field.Store.YES, toRead, pointer, binary, compressed));
            this.fieldsStream.seek(pointer + (long)toRead);
        } else {
            LazyField f;
            Field.Store store = Field.Store.YES;
            Field.Index index = Field.Index.toIndex(fi.isIndexed, tokenize);
            Field.TermVector termVector = Field.TermVector.toTermVector(fi.storeTermVector, fi.storeOffsetWithTermVector, fi.storePositionWithTermVector);
            if (compressed) {
                int toRead = this.fieldsStream.readVInt();
                long pointer = this.fieldsStream.getFilePointer();
                f = new LazyField(fi.name, store, toRead, pointer, binary, compressed);
                this.fieldsStream.seek(pointer + (long)toRead);
                f.setOmitNorms(fi.omitNorms);
                f.setOmitTermFreqAndPositions(fi.omitTermFreqAndPositions);
            } else {
                int length = this.fieldsStream.readVInt();
                long pointer = this.fieldsStream.getFilePointer();
                if (this.format >= 1) {
                    this.fieldsStream.seek(pointer + (long)length);
                } else {
                    this.fieldsStream.skipChars(length);
                }
                f = new LazyField(fi.name, store, index, termVector, length, pointer, binary, compressed);
                f.setOmitNorms(fi.omitNorms);
                f.setOmitTermFreqAndPositions(fi.omitTermFreqAndPositions);
            }
            doc.add(f);
        }
    }

    private void addField(Document doc, FieldInfo fi, boolean binary, boolean compressed, boolean tokenize) throws CorruptIndexException, IOException {
        if (binary) {
            int toRead = this.fieldsStream.readVInt();
            byte[] b = new byte[toRead];
            this.fieldsStream.readBytes(b, 0, b.length);
            if (compressed) {
                doc.add(new Field(fi.name, this.uncompress(b), Field.Store.YES));
            } else {
                doc.add(new Field(fi.name, b, Field.Store.YES));
            }
        } else {
            Field f;
            Field.Store store = Field.Store.YES;
            Field.Index index = Field.Index.toIndex(fi.isIndexed, tokenize);
            Field.TermVector termVector = Field.TermVector.toTermVector(fi.storeTermVector, fi.storeOffsetWithTermVector, fi.storePositionWithTermVector);
            if (compressed) {
                int toRead = this.fieldsStream.readVInt();
                byte[] b = new byte[toRead];
                this.fieldsStream.readBytes(b, 0, b.length);
                f = new Field(fi.name, false, new String(this.uncompress(b), "UTF-8"), store, index, termVector);
                f.setOmitTermFreqAndPositions(fi.omitTermFreqAndPositions);
                f.setOmitNorms(fi.omitNorms);
            } else {
                f = new Field(fi.name, false, this.fieldsStream.readString(), store, index, termVector);
                f.setOmitTermFreqAndPositions(fi.omitTermFreqAndPositions);
                f.setOmitNorms(fi.omitNorms);
            }
            doc.add(f);
        }
    }

    private int addFieldSize(Document doc, FieldInfo fi, boolean binary, boolean compressed) throws IOException {
        int size = this.fieldsStream.readVInt();
        int bytesize = binary || compressed ? size : 2 * size;
        byte[] sizebytes = new byte[]{(byte)(bytesize >>> 24), (byte)(bytesize >>> 16), (byte)(bytesize >>> 8), (byte)bytesize};
        doc.add(new Field(fi.name, sizebytes, Field.Store.YES));
        return size;
    }

    private byte[] uncompress(byte[] b) throws CorruptIndexException {
        try {
            return CompressionTools.decompress(b);
        }
        catch (DataFormatException e) {
            CorruptIndexException newException = new CorruptIndexException("field data are in wrong format: " + e.toString());
            newException.initCause(e);
            throw newException;
        }
    }

    private class LazyField
    extends AbstractField
    implements Fieldable {
        private int toRead;
        private long pointer;
        private boolean isCompressed;

        public LazyField(String name, Field.Store store, int toRead, long pointer, boolean isBinary, boolean isCompressed) {
            super(name, store, Field.Index.NO, Field.TermVector.NO);
            this.toRead = toRead;
            this.pointer = pointer;
            this.isBinary = isBinary;
            if (isBinary) {
                this.binaryLength = toRead;
            }
            this.lazy = true;
            this.isCompressed = isCompressed;
        }

        public LazyField(String name, Field.Store store, Field.Index index, Field.TermVector termVector, int toRead, long pointer, boolean isBinary, boolean isCompressed) {
            super(name, store, index, termVector);
            this.toRead = toRead;
            this.pointer = pointer;
            this.isBinary = isBinary;
            if (isBinary) {
                this.binaryLength = toRead;
            }
            this.lazy = true;
            this.isCompressed = isCompressed;
        }

        private IndexInput getFieldStream() {
            IndexInput localFieldsStream = (IndexInput)FieldsReader.this.fieldsStreamTL.get();
            if (localFieldsStream == null) {
                localFieldsStream = (IndexInput)FieldsReader.this.cloneableFieldsStream.clone();
                FieldsReader.this.fieldsStreamTL.set(localFieldsStream);
            }
            return localFieldsStream;
        }

        public Reader readerValue() {
            FieldsReader.this.ensureOpen();
            return null;
        }

        public TokenStream tokenStreamValue() {
            FieldsReader.this.ensureOpen();
            return null;
        }

        public String stringValue() {
            FieldsReader.this.ensureOpen();
            if (this.isBinary) {
                return null;
            }
            if (this.fieldsData == null) {
                IndexInput localFieldsStream = this.getFieldStream();
                try {
                    localFieldsStream.seek(this.pointer);
                    if (this.isCompressed) {
                        byte[] b = new byte[this.toRead];
                        localFieldsStream.readBytes(b, 0, b.length);
                        this.fieldsData = new String(FieldsReader.this.uncompress(b), "UTF-8");
                    } else if (FieldsReader.this.format >= 1) {
                        byte[] bytes = new byte[this.toRead];
                        localFieldsStream.readBytes(bytes, 0, this.toRead);
                        this.fieldsData = new String(bytes, "UTF-8");
                    } else {
                        char[] chars = new char[this.toRead];
                        localFieldsStream.readChars(chars, 0, this.toRead);
                        this.fieldsData = new String(chars);
                    }
                }
                catch (IOException e) {
                    throw new FieldReaderException(e);
                }
            }
            return (String)this.fieldsData;
        }

        public long getPointer() {
            FieldsReader.this.ensureOpen();
            return this.pointer;
        }

        public void setPointer(long pointer) {
            FieldsReader.this.ensureOpen();
            this.pointer = pointer;
        }

        public int getToRead() {
            FieldsReader.this.ensureOpen();
            return this.toRead;
        }

        public void setToRead(int toRead) {
            FieldsReader.this.ensureOpen();
            this.toRead = toRead;
        }

        public byte[] getBinaryValue(byte[] result) {
            FieldsReader.this.ensureOpen();
            if (this.isBinary) {
                if (this.fieldsData == null) {
                    byte[] b = result == null || result.length < this.toRead ? new byte[this.toRead] : result;
                    IndexInput localFieldsStream = this.getFieldStream();
                    try {
                        localFieldsStream.seek(this.pointer);
                        localFieldsStream.readBytes(b, 0, this.toRead);
                        this.fieldsData = this.isCompressed ? (Object)FieldsReader.this.uncompress(b) : (Object)b;
                    }
                    catch (IOException e) {
                        throw new FieldReaderException(e);
                    }
                    this.binaryOffset = 0;
                    this.binaryLength = this.toRead;
                }
                return (byte[])this.fieldsData;
            }
            return null;
        }
    }
}

