-- -*-Sql-*- mode (to keep my emacs happy)
--
-- API Package Body for Seqfeature_Assoc.
--
-- Scaffold auto-generated by gen-api.pl. gen-api.pl is
-- Copyright 2002-2003 Genomics Institute of the Novartis Research Foundation
-- Copyright 2002-2008 Hilmar Lapp
-- 
--  This file is part of BioSQL.
--
--  BioSQL is free software: you can redistribute it and/or modify it
--  under the terms of the GNU Lesser General Public License as
--  published by the Free Software Foundation, either version 3 of the
--  License, or (at your option) any later version.
--
--  BioSQL is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--  GNU Lesser General Public License for more details.
--
--  You should have received a copy of the GNU Lesser General Public License
--  along with BioSQL. If not, see <http://www.gnu.org/licenses/>.
--

CREATE OR REPLACE
PACKAGE BODY FeaA IS

FeaA_cached	SG_SEQFEATURE_ASSOC.OID%TYPE DEFAULT NULL;
cache_key		VARCHAR2(1024) DEFAULT NULL;

CURSOR FeaA_c (
		FeaA_SUBJ_FEA_OID	IN SG_SEQFEATURE_ASSOC.SUBJ_FEA_OID%TYPE,
		FeaA_OBJ_FEA_OID	IN SG_SEQFEATURE_ASSOC.OBJ_FEA_OID%TYPE,
		FeaA_TRM_OID	IN SG_SEQFEATURE_ASSOC.TRM_OID%TYPE)
RETURN SG_SEQFEATURE_ASSOC%ROWTYPE IS
	SELECT t.* FROM SG_SEQFEATURE_ASSOC t
	WHERE
		t.SUBJ_FEA_OID = FeaA_SUBJ_FEA_OID
	AND	t.OBJ_FEA_OID = FeaA_OBJ_FEA_OID
	AND	t.TRM_OID = FeaA_TRM_OID
	;

FUNCTION get_oid(
		FeaA_OID	IN SG_SEQFEATURE_ASSOC.OID%TYPE DEFAULT NULL,
		SUBJ_FEA_OID	IN SG_SEQFEATURE_ASSOC.SUBJ_FEA_OID%TYPE,
		OBJ_FEA_OID	IN SG_SEQFEATURE_ASSOC.OBJ_FEA_OID%TYPE,
		TRM_OID	IN SG_SEQFEATURE_ASSOC.TRM_OID%TYPE,
		FeaA_RANK	IN SG_SEQFEATURE_ASSOC.RANK%TYPE DEFAULT NULL,
		Subj_Fea_ENT_OID	IN SG_SEQFEATURE.ENT_OID%TYPE DEFAULT NULL,
		Subj_TYPE_TRM_OID	IN SG_SEQFEATURE.TYPE_TRM_OID%TYPE DEFAULT NULL,
		Subj_SOURCE_TRM_OID	IN SG_SEQFEATURE.SOURCE_TRM_OID%TYPE DEFAULT NULL,
		Subj_Fea_RANK	IN SG_SEQFEATURE.RANK%TYPE DEFAULT NULL,
		Obj_Fea_ENT_OID	IN SG_SEQFEATURE.ENT_OID%TYPE DEFAULT NULL,
		Obj_TYPE_TRM_OID	IN SG_SEQFEATURE.TYPE_TRM_OID%TYPE DEFAULT NULL,
		Obj_SOURCE_TRM_OID	IN SG_SEQFEATURE.SOURCE_TRM_OID%TYPE DEFAULT NULL,
		Obj_Fea_RANK	IN SG_SEQFEATURE.RANK%TYPE DEFAULT NULL,
		Trm_NAME	IN SG_TERM.NAME%TYPE DEFAULT NULL,
		Trm_ONT_OID	IN SG_TERM.ONT_OID%TYPE DEFAULT NULL,
		Trm_ONT_NAME	IN SG_ONTOLOGY.NAME%TYPE DEFAULT NULL,
		Trm_IDENTIFIER	IN SG_TERM.IDENTIFIER%TYPE DEFAULT NULL,
		do_DML		IN NUMBER DEFAULT BSStd.DML_NO)
RETURN SG_SEQFEATURE_ASSOC.OID%TYPE
IS
	pk	SG_SEQFEATURE_ASSOC.OID%TYPE DEFAULT NULL;
	FeaA_row FeaA_c%ROWTYPE;
	OBJ_FEA_OID_	SG_SEQFEATURE.OID%TYPE DEFAULT OBJ_FEA_OID;
	TRM_OID_	SG_TERM.OID%TYPE DEFAULT TRM_OID;
	SUBJ_FEA_OID_	SG_SEQFEATURE.OID%TYPE DEFAULT SUBJ_FEA_OID;
	key_str	VARCHAR2(1024) DEFAULT Subj_FEA_OID || '|' || Obj_FEA_OID || '|' || Trm_OID || '|' || Obj_Fea_ENT_OID || '|' || Obj_TYPE_TRM_OID || '|' || Obj_SOURCE_TRM_OID || '|' || Obj_Fea_RANK || '|' || Subj_Fea_ENT_OID || '|' || Subj_TYPE_TRM_OID || '|' || Subj_SOURCE_TRM_OID || '|' || Subj_Fea_RANK || '|' || Trm_NAME || '|' || Trm_ONT_OID || '|' || Trm_ONT_NAME || '|' || Trm_IDENTIFIER;
BEGIN
	-- initialize
	IF (do_DML > BSStd.DML_NO) THEN
		pk := FeaA_OID;
	END IF;
	-- look up
	IF pk IS NULL THEN
		IF (key_str = cache_key) THEN
			pk := FeaA_cached;
		ELSE
			-- reset cache
			cache_key := NULL;
			FeaA_cached := NULL;
                	-- look up SG_SEQFEATURE object
                	IF (OBJ_FEA_OID_ IS NULL) THEN
                		OBJ_FEA_OID_ := Fea.get_oid(
                			ENT_OID => Obj_Fea_ENT_OID,
                			TYPE_TRM_OID => Obj_TYPE_TRM_OID,
                			SOURCE_TRM_OID => Obj_SOURCE_TRM_OID,
                			Fea_RANK => Obj_Fea_RANK);
                	END IF;
                	-- look up SG_SEQFEATURE subject
                	IF (SUBJ_FEA_OID_ IS NULL) THEN
                		SUBJ_FEA_OID_ := Fea.get_oid(
                			ENT_OID => Subj_Fea_ENT_OID,
                			TYPE_TRM_OID => Subj_TYPE_TRM_OID,
                			SOURCE_TRM_OID => Subj_SOURCE_TRM_OID,
                			Fea_RANK => Subj_Fea_RANK);
                	END IF;
                	-- look up SG_TERM
                	IF (TRM_OID_ IS NULL) THEN
                		TRM_OID_ := Trm.get_oid(
                			Trm_NAME => Trm_NAME,
                			ONT_OID => Trm_ONT_OID,
                			ONT_NAME => Trm_ONT_NAME,
                			Trm_IDENTIFIER => Trm_IDENTIFIER);
                	END IF;
			-- do the look up
			FOR FeaA_row IN FeaA_c(SUBJ_FEA_OID_, OBJ_FEA_OID_, TRM_OID_) LOOP
		        	pk := FeaA_row.OID;
				-- cache result
			    	cache_key := key_str;
			    	FeaA_cached := pk;
			END LOOP;
		END IF;
	END IF;
	-- insert/update if requested
	IF (pk IS NULL) AND 
	   ((do_DML = BSStd.DML_I) OR (do_DML = BSStd.DML_UI)) THEN
	    	-- look up foreign keys if not provided:
		-- look up SG_SEQFEATURE object successful?
		IF (OBJ_FEA_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Fea <' || Obj_Fea_ENT_OID || '|' || Obj_TYPE_TRM_OID || '|' || Obj_SOURCE_TRM_OID || '|' || Obj_Fea_RANK || '>');
		END IF;
		-- look up SG_SEQFEATURE subject successful?
		IF (SUBJ_FEA_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Fea <' || Subj_Fea_ENT_OID || '|' || Subj_TYPE_TRM_OID || '|' || Subj_SOURCE_TRM_OID || '|' || Subj_Fea_RANK || '>');
		END IF;
		-- look up SG_TERM successful?
		IF (TRM_OID_ IS NULL) THEN
			raise_application_error(-20101,
				'failed to look up Trm <' || Trm_NAME || '|' || Trm_ONT_OID || '|' || Trm_ONT_NAME || '|' || Trm_IDENTIFIER || '>');
		END IF;
	    	-- insert the record and obtain the primary key
	    	pk := do_insert(
		        SUBJ_FEA_OID => SUBJ_FEA_OID_,
			OBJ_FEA_OID => OBJ_FEA_OID_,
			TRM_OID => TRM_OID_,
			RANK => FeaA_RANK);
	ELSIF (do_DML = BSStd.DML_U) OR (do_DML = BSStd.DML_UI) THEN
	        -- update the record (note that not provided FKs will not
		-- be changed nor looked up)
		do_update(
			FeaA_OID	=> pk,
		        FeaA_SUBJ_FEA_OID => SUBJ_FEA_OID_,
			FeaA_OBJ_FEA_OID => OBJ_FEA_OID_,
			FeaA_TRM_OID => TRM_OID_,
			FeaA_RANK => FeaA_RANK);
	END IF;
	-- return the primary key
	RETURN pk;
END;

FUNCTION do_insert(
		SUBJ_FEA_OID	IN SG_SEQFEATURE_ASSOC.SUBJ_FEA_OID%TYPE,
		OBJ_FEA_OID	IN SG_SEQFEATURE_ASSOC.OBJ_FEA_OID%TYPE,
		TRM_OID	IN SG_SEQFEATURE_ASSOC.TRM_OID%TYPE,
		RANK	IN SG_SEQFEATURE_ASSOC.RANK%TYPE)
RETURN SG_SEQFEATURE_ASSOC.OID%TYPE 
IS
	pk	SG_SEQFEATURE_ASSOC.OID%TYPE;
BEGIN
	-- pre-generate the primary key value
	SELECT SG_Sequence_FeaA.nextval INTO pk FROM DUAL;
	-- insert the record
	INSERT INTO SG_SEQFEATURE_ASSOC (
		OID,
		SUBJ_FEA_OID,
		OBJ_FEA_OID,
		TRM_OID,
		RANK)
	VALUES (pk,
		SUBJ_FEA_OID,
		OBJ_FEA_OID,
		TRM_OID,
		RANK)
	;
	-- return new primary key
	RETURN pk;
END;

PROCEDURE do_update(
		FeaA_OID	IN SG_SEQFEATURE_ASSOC.OID%TYPE,
		FeaA_SUBJ_FEA_OID	IN SG_SEQFEATURE_ASSOC.SUBJ_FEA_OID%TYPE,
		FeaA_OBJ_FEA_OID	IN SG_SEQFEATURE_ASSOC.OBJ_FEA_OID%TYPE,
		FeaA_TRM_OID	IN SG_SEQFEATURE_ASSOC.TRM_OID%TYPE,
		FeaA_RANK	IN SG_SEQFEATURE_ASSOC.RANK%TYPE)
IS
BEGIN
	-- update the record (and leave attributes passed as NULL untouched)
	UPDATE SG_SEQFEATURE_ASSOC
	SET
		SUBJ_FEA_OID = NVL(FeaA_SUBJ_FEA_OID, SUBJ_FEA_OID),
		OBJ_FEA_OID = NVL(FeaA_OBJ_FEA_OID, OBJ_FEA_OID),
		TRM_OID = NVL(FeaA_TRM_OID, TRM_OID),
		RANK = NVL(FeaA_RANK, RANK)
	WHERE OID = FeaA_OID
	;
END;

END FeaA;
/

