/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternInterner;

public class PatternBuilder {
    private final EmptyPattern empty;
    protected final NotAllowedPattern notAllowed;
    protected final PatternInterner interner;

    public PatternBuilder() {
        this.empty = new EmptyPattern();
        this.notAllowed = new NotAllowedPattern();
        this.interner = new PatternInterner();
    }

    public PatternBuilder(PatternBuilder patternBuilder) {
        this.empty = patternBuilder.empty;
        this.notAllowed = patternBuilder.notAllowed;
        this.interner = new PatternInterner(patternBuilder.interner);
    }

    Pattern makeEmpty() {
        return this.empty;
    }

    Pattern makeNotAllowed() {
        return this.notAllowed;
    }

    Pattern makeGroup(Pattern pattern, Pattern pattern2) {
        if (pattern == this.empty) {
            return pattern2;
        }
        if (pattern2 == this.empty) {
            return pattern;
        }
        if (pattern == this.notAllowed || pattern2 == this.notAllowed) {
            return this.notAllowed;
        }
        GroupPattern groupPattern = new GroupPattern(pattern, pattern2);
        return this.interner.intern(groupPattern);
    }

    Pattern makeInterleave(Pattern pattern, Pattern pattern2) {
        if (pattern == this.empty) {
            return pattern2;
        }
        if (pattern2 == this.empty) {
            return pattern;
        }
        if (pattern == this.notAllowed || pattern2 == this.notAllowed) {
            return this.notAllowed;
        }
        InterleavePattern interleavePattern = new InterleavePattern(pattern, pattern2);
        return this.interner.intern(interleavePattern);
    }

    Pattern makeChoice(Pattern pattern, Pattern pattern2) {
        if (pattern == this.empty && pattern2.isNullable()) {
            return pattern2;
        }
        if (pattern2 == this.empty && pattern.isNullable()) {
            return pattern;
        }
        ChoicePattern choicePattern = new ChoicePattern(pattern, pattern2);
        return this.interner.intern(choicePattern);
    }

    Pattern makeOneOrMore(Pattern pattern) {
        if (pattern == this.empty || pattern == this.notAllowed || pattern instanceof OneOrMorePattern) {
            return pattern;
        }
        OneOrMorePattern oneOrMorePattern = new OneOrMorePattern(pattern);
        return this.interner.intern(oneOrMorePattern);
    }

    Pattern makeOptional(Pattern pattern) {
        return this.makeChoice(pattern, this.empty);
    }

    Pattern makeZeroOrMore(Pattern pattern) {
        return this.makeOptional(this.makeOneOrMore(pattern));
    }
}

