import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import { COLOR_MODE_ATTRIBUTE, THEME_DATA_ATTRIBUTE } from './constants';
import { themeColorModes } from './theme-config';
import { themeStringToObject } from './theme-state-transformer';
var isThemeColorMode = function isThemeColorMode(colorMode) {
  return themeColorModes.find(function (mode) {
    return mode === colorMode;
  }) !== undefined;
};
var getGlobalTheme = function getGlobalTheme() {
  if (typeof document === 'undefined') {
    return {};
  }
  var element = document.documentElement;
  var colorMode = element.getAttribute(COLOR_MODE_ATTRIBUTE) || '';
  var theme = element.getAttribute(THEME_DATA_ATTRIBUTE) || '';
  return _objectSpread(_objectSpread({}, themeStringToObject(theme)), isThemeColorMode(colorMode) && {
    colorMode: colorMode
  });
};
export default getGlobalTheme;