import { type Dispatch, type MutableRefObject, type SetStateAction } from 'react';
/**
 * Functions similarly to `useState` however the return value is a ref.
 *
 * ```js
 * const [valueRef, setValue] = useStateRef(0);
 * ```
 *
 * @param initialState
 */
export default function useStateRef<TValue>(initialState: (() => TValue) | TValue): [MutableRefObject<TValue>, Dispatch<SetStateAction<TValue>>];
