// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutBucketLifecycleConfiguration`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the bucket for which to set the configuration.</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm used to create the checksum for the request when you use the SDK. This header will not provide any additional functionality if you don't use the SDK. When you send this header, there must be a corresponding <code>x-amz-checksum</code> or <code>x-amz-trailer</code> header sent. Otherwise, Amazon S3 fails the request with the HTTP status code <code>400 Bad Request</code>. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html">Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p> <p>If you provide an individual checksum, Amazon S3 ignores any provided <code>ChecksumAlgorithm</code> parameter.</p><br>
    ///   - [`lifecycle_configuration(BucketLifecycleConfiguration)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::lifecycle_configuration) / [`set_lifecycle_configuration(Option<BucketLifecycleConfiguration>)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::set_lifecycle_configuration):<br>required: **false**<br><p>Container for lifecycle rules. You can add as many as 1,000 rules.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The account ID of the expected bucket owner. If the account ID that you provide does not match the actual owner of the bucket, the request fails with the HTTP status code <code>403 Forbidden</code> (access denied).</p><note>  <p>This parameter applies to general purpose buckets only. It is not supported for directory bucket lifecycle configurations.</p> </note><br>
    ///   - [`transition_default_minimum_object_size(TransitionDefaultMinimumObjectSize)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::transition_default_minimum_object_size) / [`set_transition_default_minimum_object_size(Option<TransitionDefaultMinimumObjectSize>)`](crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::set_transition_default_minimum_object_size):<br>required: **false**<br><p>Indicates which default minimum object size behavior is applied to the lifecycle configuration.</p><note>  <p>This parameter applies to general purpose buckets only. It is not supported for directory bucket lifecycle configurations.</p> </note> <ul>  <li>   <p><code>all_storage_classes_128K</code> - Objects smaller than 128 KB will not transition to any storage class by default.</p></li>  <li>   <p><code>varies_by_storage_class</code> - Objects smaller than 128 KB will transition to Glacier Flexible Retrieval or Glacier Deep Archive storage classes. By default, all other storage classes will prevent transitions smaller than 128 KB.</p></li> </ul> <p>To customize the minimum object size for any transition you can add a filter that specifies a custom <code>ObjectSizeGreaterThan</code> or <code>ObjectSizeLessThan</code> in the body of your transition rule. Custom filters always take precedence over the default transition behavior.</p><br>
    /// - On success, responds with [`PutBucketLifecycleConfigurationOutput`](crate::operation::put_bucket_lifecycle_configuration::PutBucketLifecycleConfigurationOutput) with field(s):
    ///   - [`transition_default_minimum_object_size(Option<TransitionDefaultMinimumObjectSize>)`](crate::operation::put_bucket_lifecycle_configuration::PutBucketLifecycleConfigurationOutput::transition_default_minimum_object_size): <p>Indicates which default minimum object size behavior is applied to the lifecycle configuration.</p><note>  <p>This parameter applies to general purpose buckets only. It is not supported for directory bucket lifecycle configurations.</p> </note> <ul>  <li>   <p><code>all_storage_classes_128K</code> - Objects smaller than 128 KB will not transition to any storage class by default.</p></li>  <li>   <p><code>varies_by_storage_class</code> - Objects smaller than 128 KB will transition to Glacier Flexible Retrieval or Glacier Deep Archive storage classes. By default, all other storage classes will prevent transitions smaller than 128 KB.</p></li> </ul> <p>To customize the minimum object size for any transition you can add a filter that specifies a custom <code>ObjectSizeGreaterThan</code> or <code>ObjectSizeLessThan</code> in the body of your transition rule. Custom filters always take precedence over the default transition behavior.</p>
    /// - On failure, responds with [`SdkError<PutBucketLifecycleConfigurationError>`](crate::operation::put_bucket_lifecycle_configuration::PutBucketLifecycleConfigurationError)
    pub fn put_bucket_lifecycle_configuration(
        &self,
    ) -> crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder {
        crate::operation::put_bucket_lifecycle_configuration::builders::PutBucketLifecycleConfigurationFluentBuilder::new(self.handle.clone())
    }
}
