package deviceupdate

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// PrivateEndpointConnectionProxiesClient is the microsoft Device Update resource provider.
type PrivateEndpointConnectionProxiesClient struct {
	BaseClient
}

// NewPrivateEndpointConnectionProxiesClient creates an instance of the PrivateEndpointConnectionProxiesClient client.
func NewPrivateEndpointConnectionProxiesClient(subscriptionID string) PrivateEndpointConnectionProxiesClient {
	return NewPrivateEndpointConnectionProxiesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewPrivateEndpointConnectionProxiesClientWithBaseURI creates an instance of the
// PrivateEndpointConnectionProxiesClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewPrivateEndpointConnectionProxiesClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionProxiesClient {
	return PrivateEndpointConnectionProxiesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate (INTERNAL - DO NOT USE) Creates or updates the specified private endpoint connection proxy resource
// associated with the device update account.
// Parameters:
// resourceGroupName - the resource group name.
// accountName - account name.
// privateEndpointConnectionProxyID - the ID of the private endpoint connection proxy object.
// privateEndpointConnectionProxy - the parameters for creating a private endpoint connection proxy.
func (client PrivateEndpointConnectionProxiesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string, privateEndpointConnectionProxy PrivateEndpointConnectionProxy) (result PrivateEndpointConnectionProxiesCreateOrUpdateFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionProxiesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[A-Za-z0-9]+(-[A-Za-z0-9]+)*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("deviceupdate.PrivateEndpointConnectionProxiesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, accountName, privateEndpointConnectionProxyID, privateEndpointConnectionProxy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateOrUpdateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "CreateOrUpdate", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client PrivateEndpointConnectionProxiesClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string, privateEndpointConnectionProxy PrivateEndpointConnectionProxy) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":                      autorest.Encode("path", accountName),
		"privateEndpointConnectionProxyId": autorest.Encode("path", privateEndpointConnectionProxyID),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-04-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	privateEndpointConnectionProxy.ETag = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/privateEndpointConnectionProxies/{privateEndpointConnectionProxyId}", pathParameters),
		autorest.WithJSON(privateEndpointConnectionProxy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client PrivateEndpointConnectionProxiesClient) CreateOrUpdateSender(req *http.Request) (future PrivateEndpointConnectionProxiesCreateOrUpdateFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client PrivateEndpointConnectionProxiesClient) CreateOrUpdateResponder(resp *http.Response) (result PrivateEndpointConnectionProxy, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete (INTERNAL - DO NOT USE) Deletes the specified private endpoint connection proxy associated with the device
// update account.
// Parameters:
// resourceGroupName - the resource group name.
// accountName - account name.
// privateEndpointConnectionProxyID - the ID of the private endpoint connection proxy object.
func (client PrivateEndpointConnectionProxiesClient) Delete(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string) (result PrivateEndpointConnectionProxiesDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionProxiesClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[A-Za-z0-9]+(-[A-Za-z0-9]+)*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("deviceupdate.PrivateEndpointConnectionProxiesClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, accountName, privateEndpointConnectionProxyID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client PrivateEndpointConnectionProxiesClient) DeletePreparer(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":                      autorest.Encode("path", accountName),
		"privateEndpointConnectionProxyId": autorest.Encode("path", privateEndpointConnectionProxyID),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-04-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/privateEndpointConnectionProxies/{privateEndpointConnectionProxyId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client PrivateEndpointConnectionProxiesClient) DeleteSender(req *http.Request) (future PrivateEndpointConnectionProxiesDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client PrivateEndpointConnectionProxiesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get (INTERNAL - DO NOT USE) Get the specified private endpoint connection proxy associated with the device update
// account.
// Parameters:
// resourceGroupName - the resource group name.
// accountName - account name.
// privateEndpointConnectionProxyID - the ID of the private endpoint connection proxy object.
func (client PrivateEndpointConnectionProxiesClient) Get(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string) (result PrivateEndpointConnectionProxy, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionProxiesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[A-Za-z0-9]+(-[A-Za-z0-9]+)*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("deviceupdate.PrivateEndpointConnectionProxiesClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, accountName, privateEndpointConnectionProxyID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client PrivateEndpointConnectionProxiesClient) GetPreparer(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":                      autorest.Encode("path", accountName),
		"privateEndpointConnectionProxyId": autorest.Encode("path", privateEndpointConnectionProxyID),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-04-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/privateEndpointConnectionProxies/{privateEndpointConnectionProxyId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client PrivateEndpointConnectionProxiesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client PrivateEndpointConnectionProxiesClient) GetResponder(resp *http.Response) (result PrivateEndpointConnectionProxy, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByAccount (INTERNAL - DO NOT USE) List all private endpoint connection proxies in a device update account.
// Parameters:
// resourceGroupName - the resource group name.
// accountName - account name.
func (client PrivateEndpointConnectionProxiesClient) ListByAccount(ctx context.Context, resourceGroupName string, accountName string) (result PrivateEndpointConnectionProxyListResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionProxiesClient.ListByAccount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[A-Za-z0-9]+(-[A-Za-z0-9]+)*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("deviceupdate.PrivateEndpointConnectionProxiesClient", "ListByAccount", err.Error())
	}

	req, err := client.ListByAccountPreparer(ctx, resourceGroupName, accountName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "ListByAccount", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByAccountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "ListByAccount", resp, "Failure sending request")
		return
	}

	result, err = client.ListByAccountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "ListByAccount", resp, "Failure responding to request")
		return
	}

	return
}

// ListByAccountPreparer prepares the ListByAccount request.
func (client PrivateEndpointConnectionProxiesClient) ListByAccountPreparer(ctx context.Context, resourceGroupName string, accountName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":       autorest.Encode("path", accountName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-04-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/privateEndpointConnectionProxies", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByAccountSender sends the ListByAccount request. The method will close the
// http.Response Body if it receives an error.
func (client PrivateEndpointConnectionProxiesClient) ListByAccountSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByAccountResponder handles the response to the ListByAccount request. The method always
// closes the http.Response Body.
func (client PrivateEndpointConnectionProxiesClient) ListByAccountResponder(resp *http.Response) (result PrivateEndpointConnectionProxyListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdatePrivateEndpointProperties (INTERNAL - DO NOT USE) Updates a private endpoint inside the private endpoint
// connection proxy object.
// Parameters:
// resourceGroupName - the resource group name.
// accountName - account name.
// privateEndpointConnectionProxyID - the ID of the private endpoint connection proxy object.
// privateEndpointUpdate - the parameters for updating a private endpoint connection proxy.
func (client PrivateEndpointConnectionProxiesClient) UpdatePrivateEndpointProperties(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string, privateEndpointUpdate PrivateEndpointUpdate) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionProxiesClient.UpdatePrivateEndpointProperties")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[A-Za-z0-9]+(-[A-Za-z0-9]+)*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("deviceupdate.PrivateEndpointConnectionProxiesClient", "UpdatePrivateEndpointProperties", err.Error())
	}

	req, err := client.UpdatePrivateEndpointPropertiesPreparer(ctx, resourceGroupName, accountName, privateEndpointConnectionProxyID, privateEndpointUpdate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "UpdatePrivateEndpointProperties", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdatePrivateEndpointPropertiesSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "UpdatePrivateEndpointProperties", resp, "Failure sending request")
		return
	}

	result, err = client.UpdatePrivateEndpointPropertiesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "UpdatePrivateEndpointProperties", resp, "Failure responding to request")
		return
	}

	return
}

// UpdatePrivateEndpointPropertiesPreparer prepares the UpdatePrivateEndpointProperties request.
func (client PrivateEndpointConnectionProxiesClient) UpdatePrivateEndpointPropertiesPreparer(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string, privateEndpointUpdate PrivateEndpointUpdate) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":                      autorest.Encode("path", accountName),
		"privateEndpointConnectionProxyId": autorest.Encode("path", privateEndpointConnectionProxyID),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-04-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/privateEndpointConnectionProxies/{privateEndpointConnectionProxyId}/updatePrivateEndpointProperties", pathParameters),
		autorest.WithJSON(privateEndpointUpdate),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdatePrivateEndpointPropertiesSender sends the UpdatePrivateEndpointProperties request. The method will close the
// http.Response Body if it receives an error.
func (client PrivateEndpointConnectionProxiesClient) UpdatePrivateEndpointPropertiesSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdatePrivateEndpointPropertiesResponder handles the response to the UpdatePrivateEndpointProperties request. The method always
// closes the http.Response Body.
func (client PrivateEndpointConnectionProxiesClient) UpdatePrivateEndpointPropertiesResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Validate (INTERNAL - DO NOT USE) Validates a private endpoint connection proxy object.
// Parameters:
// resourceGroupName - the resource group name.
// accountName - account name.
// privateEndpointConnectionProxyID - the ID of the private endpoint connection proxy object.
// privateEndpointConnectionProxy - the parameters for creating a private endpoint connection proxy.
func (client PrivateEndpointConnectionProxiesClient) Validate(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string, privateEndpointConnectionProxy PrivateEndpointConnectionProxy) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PrivateEndpointConnectionProxiesClient.Validate")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: accountName,
			Constraints: []validation.Constraint{{Target: "accountName", Name: validation.MaxLength, Rule: 24, Chain: nil},
				{Target: "accountName", Name: validation.MinLength, Rule: 3, Chain: nil},
				{Target: "accountName", Name: validation.Pattern, Rule: `^[A-Za-z0-9]+(-[A-Za-z0-9]+)*$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("deviceupdate.PrivateEndpointConnectionProxiesClient", "Validate", err.Error())
	}

	req, err := client.ValidatePreparer(ctx, resourceGroupName, accountName, privateEndpointConnectionProxyID, privateEndpointConnectionProxy)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "Validate", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidateSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "Validate", resp, "Failure sending request")
		return
	}

	result, err = client.ValidateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "deviceupdate.PrivateEndpointConnectionProxiesClient", "Validate", resp, "Failure responding to request")
		return
	}

	return
}

// ValidatePreparer prepares the Validate request.
func (client PrivateEndpointConnectionProxiesClient) ValidatePreparer(ctx context.Context, resourceGroupName string, accountName string, privateEndpointConnectionProxyID string, privateEndpointConnectionProxy PrivateEndpointConnectionProxy) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"accountName":                      autorest.Encode("path", accountName),
		"privateEndpointConnectionProxyId": autorest.Encode("path", privateEndpointConnectionProxyID),
		"resourceGroupName":                autorest.Encode("path", resourceGroupName),
		"subscriptionId":                   autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2022-04-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	privateEndpointConnectionProxy.ETag = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceUpdate/accounts/{accountName}/privateEndpointConnectionProxies/{privateEndpointConnectionProxyId}/validate", pathParameters),
		autorest.WithJSON(privateEndpointConnectionProxy),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateSender sends the Validate request. The method will close the
// http.Response Body if it receives an error.
func (client PrivateEndpointConnectionProxiesClient) ValidateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ValidateResponder handles the response to the Validate request. The method always
// closes the http.Response Body.
func (client PrivateEndpointConnectionProxiesClient) ValidateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}
