/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.testng.ClassMethodMap;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestRunner;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IInvoker;
import org.testng.internal.thread.ThreadUtil;
import org.testng.xml.XmlSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestMethodWorker
implements Runnable {
    private ITestNGMethod[] m_testMethods;
    private IInvoker m_invoker = null;
    private Map<String, String> m_parameters = null;
    private XmlSuite m_suite = null;
    private Map<ITestClass, ITestClass> m_invokedBeforeClassMethods = null;
    private Map<ITestClass, ITestClass> m_invokedAfterClassMethods = null;
    private ITestNGMethod[] m_allTestMethods;
    private List<ITestResult> m_testResults = new ArrayList<ITestResult>();
    private ConfigurationGroupMethods m_groupMethods = null;
    private ClassMethodMap m_classMethodMap = null;

    public TestMethodWorker(IInvoker invoker, ITestNGMethod[] testMethods, XmlSuite suite, Map<String, String> parameters, Map<ITestClass, ITestClass> invokedBeforeClassMethods, Map<ITestClass, ITestClass> invokedAfterClassMethods, ITestNGMethod[] allTestMethods, ConfigurationGroupMethods groupMethods, ClassMethodMap classMethodMap) {
        this.m_invoker = invoker;
        this.m_testMethods = testMethods;
        this.m_suite = suite;
        this.m_parameters = parameters;
        this.m_invokedBeforeClassMethods = invokedBeforeClassMethods;
        this.m_invokedAfterClassMethods = invokedAfterClassMethods;
        this.m_allTestMethods = allTestMethods;
        this.m_groupMethods = groupMethods;
        this.m_classMethodMap = classMethodMap;
    }

    public long getMaxTimeOut() {
        long result = 0L;
        for (ITestNGMethod tm : this.m_testMethods) {
            if (tm.getTimeOut() <= result) continue;
            result = tm.getTimeOut();
        }
        return result;
    }

    public String toString() {
        return "[Worker on thread:" + Thread.currentThread().getId() + " " + this.m_testMethods[0] + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int indexMethod = 0; indexMethod < this.m_testMethods.length; ++indexMethod) {
            ITestNGMethod tm = this.m_testMethods[indexMethod];
            ITestClass testClass = tm.getTestClass();
            Map<ITestClass, ITestClass> map = this.m_invokedBeforeClassMethods;
            synchronized (map) {
                if (!this.m_invokedBeforeClassMethods.containsKey(testClass)) {
                    this.m_invokedBeforeClassMethods.put(testClass, testClass);
                    this.m_invoker.invokeConfigurations(testClass, testClass.getBeforeClassMethods(), this.m_suite, this.m_parameters, null);
                }
            }
            List<ITestResult> testResults = this.m_invoker.invokeTestMethods(tm, this.m_suite, this.m_parameters, this.m_allTestMethods, this.indexOf(tm, this.m_allTestMethods), this.m_groupMethods);
            if (testResults != null) {
                this.m_testResults.addAll(testResults);
            }
            if (!this.m_classMethodMap.removeAndCheckIfLast(tm)) continue;
            boolean invokeAfter = false;
            Map<ITestClass, ITestClass> map2 = this.m_invokedAfterClassMethods;
            synchronized (map2) {
                if (!this.m_invokedAfterClassMethods.containsKey(testClass)) {
                    this.m_invokedAfterClassMethods.put(testClass, testClass);
                    invokeAfter = true;
                }
            }
            if (!invokeAfter) continue;
            this.m_invoker.invokeConfigurations(testClass, testClass.getAfterClassMethods(), this.m_suite, this.m_parameters, null);
        }
    }

    private int indexOf(ITestNGMethod tm, ITestNGMethod[] allTestMethods) {
        for (int i = 0; i < allTestMethods.length; ++i) {
            if (allTestMethods[i] != tm) continue;
            return i;
        }
        return -1;
    }

    public List<ITestResult> getTestResults() {
        return this.m_testResults;
    }

    private boolean isLastTestMethodForClass(ITestNGMethod tm, ITestNGMethod[] testMethods) {
        for (int i = testMethods.length - 1; i >= 0; --i) {
            ITestNGMethod thisMethod = testMethods[i];
            ITestClass testClass = tm.getTestClass();
            if (!thisMethod.getTestClass().equals(testClass)) continue;
            return thisMethod.equals(tm);
        }
        return false;
    }

    private void ppp(String s) {
        if (TestRunner.getVerbose() >= 2) {
            System.out.println("[TestMethodWorker " + ThreadUtil.currentThreadInfo() + "] " + s);
        }
    }

    public void setAllTestMethods(ITestNGMethod[] allTestMethods) {
        this.m_allTestMethods = allTestMethods;
    }
}

