/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lv extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "arābu";
        final String metaValue_arc = "aramiešu";
        final String metaValue_hy = "armēņu";
        final String metaValue_ban = "baliešu";
        final String metaValue_bn = "bengāļu";
        final String metaValue_ccp = "čakmu";
        final String metaValue_cop = "koptu";
        final String metaValue_ka = "gruzīnu";
        final String metaValue_got = "gotu";
        final String metaValue_el = "grieķu";
        final String metaValue_gu = "gudžaratu";
        final String metaValue_pa = "pandžabu";
        final String metaValue_he = "ivrits";
        final String metaValue_jv = "javiešu";
        final String metaValue_ja = "japāņu";
        final String metaValue_km = "khmeru";
        final String metaValue_kn = "kannadu";
        final String metaValue_ko = "korejiešu";
        final String metaValue_lo = "laosiešu";
        final String metaValue_la = "latīņu";
        final String metaValue_ml = "malajalu";
        final String metaValue_mn = "mongoļu";
        final String metaValue_my = "birmiešu";
        final String metaValue_nqo = "nko";
        final String metaValue_or = "oriju";
        final String metaValue_phn = "feniķiešu";
        final String metaValue_si = "singāļu";
        final String metaValue_su = "zundu";
        final String metaValue_syr = "sīriešu";
        final String metaValue_ta = "tamilu";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalu";
        final String metaValue_th = "taju";
        final String metaValue_bo = "tibetiešu";
        final String metaValue_vai = "vaju";
        final String metaValue_ssy = "saho";
        final Object[][] data = new Object[][] {
            { "001", "pasaule" },
            { "002", "Āfrika" },
            { "003", "Ziemeļamerika" },
            { "005", "Dienvidamerika" },
            { "009", "Okeānija" },
            { "011", "Rietumāfrika" },
            { "013", "Centrālamerika" },
            { "014", "Austrumāfrika" },
            { "015", "Ziemeļāfrika" },
            { "017", "Vidusāfrika" },
            { "018", "Dienvidāfrika" },
            { "019", "Amerika" },
            { "021", "Amerikas ziemeļu daļa" },
            { "029", "Karību jūras reģions" },
            { "030", "Austrumāzija" },
            { "034", "Dienvidāzija" },
            { "035", "Centrālaustrumāzija" },
            { "039", "Dienvideiropa" },
            { "053", "Austrālāzija" },
            { "054", "Melanēzija" },
            { "057", "Mikronēzijas reģions" },
            { "061", "Polinēzija" },
            { "142", "Āzija" },
            { "143", "Centrālāzija" },
            { "145", "Rietumāzija" },
            { "150", "Eiropa" },
            { "151", "Austrumeiropa" },
            { "154", "Ziemeļeiropa" },
            { "155", "Rietumeiropa" },
            { "202", "Subsahāras Āfrika" },
            { "419", "Latīņamerika" },
            { "AC", "Debesbraukšanas sala" },
            { "AD", "Andora" },
            { "AE", "Apvienotie Arābu Emirāti" },
            { "AF", "Afganistāna" },
            { "AG", "Antigva un Barbuda" },
            { "AI", "Angilja" },
            { "AL", "Albānija" },
            { "AM", "Armēnija" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentīna" },
            { "AS", "ASV Samoa" },
            { "AT", "Austrija" },
            { "AU", "Austrālija" },
            { "AW", "Aruba" },
            { "AX", "Olandes salas" },
            { "AZ", "Azerbaidžāna" },
            { "BA", "Bosnija un Hercegovina" },
            { "BB", "Barbadosa" },
            { "BD", "Bangladeša" },
            { "BE", "Beļģija" },
            { "BF", "Burkinafaso" },
            { "BG", "Bulgārija" },
            { "BH", "Bahreina" },
            { "BI", "Burundija" },
            { "BJ", "Benina" },
            { "BL", "Senbartelmī" },
            { "BM", "Bermudu salas" },
            { "BN", "Bruneja" },
            { "BO", "Bolīvija" },
            { "BQ", "Nīderlandes Karību salas" },
            { "BR", "Brazīlija" },
            { "BS", "Bahamu salas" },
            { "BT", "Butāna" },
            { "BV", "Buvē sala" },
            { "BW", "Botsvāna" },
            { "BY", "Baltkrievija" },
            { "BZ", "Beliza" },
            { "CA", "Kanāda" },
            { "CC", "Kokosu (Kīlinga) salas" },
            { "CD", "Kongo (Kinšasa)" },
            { "CF", "Centrālāfrikas Republika" },
            { "CG", "Kongo (Brazavila)" },
            { "CH", "Šveice" },
            { "CI", "Kotdivuāra" },
            { "CK", "Kuka salas" },
            { "CL", "Čīle" },
            { "CM", "Kamerūna" },
            { "CN", "Ķīna" },
            { "CO", "Kolumbija" },
            { "CP", "Klipertona sala" },
            { "CQ", "Sarka" },
            { "CR", "Kostarika" },
            { "CU", "Kuba" },
            { "CV", "Kaboverde" },
            { "CW", "Kirasao" },
            { "CX", "Ziemsvētku sala" },
            { "CY", "Kipra" },
            { "CZ", "Čehija" },
            { "DE", "Vācija" },
            { "DG", "Djego Garsijas atols" },
            { "DJ", "Džibutija" },
            { "DK", "Dānija" },
            { "DM", "Dominika" },
            { "DO", "Dominikāna" },
            { "DZ", "Alžīrija" },
            { "EA", "Seūta un Melilja" },
            { "EC", "Ekvadora" },
            { "EE", "Igaunija" },
            { "EG", "Ēģipte" },
            { "EH", "Rietumsahāra" },
            { "ER", "Eritreja" },
            { "ES", "Spānija" },
            { "ET", "Etiopija" },
            { "EU", "Eiropas Savienība" },
            { "EZ", "Eirozona" },
            { "FI", "Somija" },
            { "FJ", "Fidži" },
            { "FK", "Folklenda salas" },
            { "FM", "Mikronēzija" },
            { "FO", "Fēru salas" },
            { "FR", "Francija" },
            { "GA", "Gabona" },
            { "GB", "Apvienotā Karaliste" },
            { "GD", "Grenāda" },
            { "GE", "Gruzija" },
            { "GF", "Francijas Gviāna" },
            { "GG", "Gērnsija" },
            { "GH", "Gana" },
            { "GI", "Gibraltārs" },
            { "GL", "Grenlande" },
            { "GM", "Gambija" },
            { "GN", "Gvineja" },
            { "GP", "Gvadelupa" },
            { "GQ", "Ekvatoriālā Gvineja" },
            { "GR", "Grieķija" },
            { "GS", "Dienviddžordžija un Dienvidsendviču salas" },
            { "GT", "Gvatemala" },
            { "GU", "Guama" },
            { "GW", "Gvineja-Bisava" },
            { "GY", "Gajāna" },
            { "HK", "Ķīnas īpašās pārvaldes apgabals Honkonga" },
            { "HM", "Hērda sala un Makdonalda salas" },
            { "HN", "Hondurasa" },
            { "HR", "Horvātija" },
            { "HT", "Haiti" },
            { "HU", "Ungārija" },
            { "IC", "Kanāriju salas" },
            { "ID", "Indonēzija" },
            { "IE", "Īrija" },
            { "IL", "Izraēla" },
            { "IM", "Menas sala" },
            { "IN", "Indija" },
            { "IO", "Indijas okeāna Britu teritorija" },
            { "IQ", "Irāka" },
            { "IR", "Irāna" },
            { "IS", "Islande" },
            { "IT", "Itālija" },
            { "JE", "Džērsija" },
            { "JM", "Jamaika" },
            { "JO", "Jordānija" },
            { "JP", "Japāna" },
            { "KE", "Kenija" },
            { "KG", "Kirgizstāna" },
            { "KH", "Kambodža" },
            { "KI", "Kiribati" },
            { "KM", "Komoru salas" },
            { "KN", "Sentkitsa un Nevisa" },
            { "KP", "Ziemeļkoreja" },
            { "KR", "Dienvidkoreja" },
            { "KW", "Kuveita" },
            { "KY", "Kaimanu salas" },
            { "KZ", "Kazahstāna" },
            { "LA", "Laosa" },
            { "LB", "Libāna" },
            { "LC", "Sentlūsija" },
            { "LI", "Lihtenšteina" },
            { "LK", "Šrilanka" },
            { "LR", "Libērija" },
            { "LS", "Lesoto" },
            { "LT", "Lietuva" },
            { "LU", "Luksemburga" },
            { "LV", "Latvija" },
            { "LY", "Lībija" },
            { "MA", "Maroka" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Melnkalne" },
            { "MF", "Senmartēna" },
            { "MG", "Madagaskara" },
            { "MH", "Māršala salas" },
            { "MK", "Ziemeļmaķedonija" },
            { "ML", "Mali" },
            { "MM", "Mjanma (Birma)" },
            { "MN", "Mongolija" },
            { "MO", "ĶTR īpašais administratīvais reģions Makao" },
            { "MP", "Ziemeļu Marianas salas" },
            { "MQ", "Martinika" },
            { "MR", "Mauritānija" },
            { "MS", "Montserrata" },
            { "MT", "Malta" },
            { "MU", "Maurīcija" },
            { "MV", "Maldīvija" },
            { "MW", "Malāvija" },
            { "MX", "Meksika" },
            { "MY", "Malaizija" },
            { "MZ", "Mozambika" },
            { "NA", "Namībija" },
            { "NC", "Jaunkaledonija" },
            { "NE", "Nigēra" },
            { "NF", "Norfolkas sala" },
            { "NG", "Nigērija" },
            { "NI", "Nikaragva" },
            { "NL", "Nīderlande" },
            { "NO", "Norvēģija" },
            { "NP", "Nepāla" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Jaunzēlande" },
            { "OM", "Omāna" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Francijas Polinēzija" },
            { "PG", "Papua-Jaungvineja" },
            { "PH", "Filipīnas" },
            { "PK", "Pakistāna" },
            { "PL", "Polija" },
            { "PM", "Senpjēra un Mikelona" },
            { "PN", "Pitkērnas salas" },
            { "PR", "Puertoriko" },
            { "PS", "Palestīnas teritorijas" },
            { "PT", "Portugāle" },
            { "PW", "Palau" },
            { "PY", "Paragvaja" },
            { "QA", "Katara" },
            { "QO", "Okeānijas attālās salas" },
            { "RE", "Reinjona" },
            { "RO", "Rumānija" },
            { "RS", "Serbija" },
            { "RU", "Krievija" },
            { "RW", "Ruanda" },
            { "SA", "Saūda Arābija" },
            { "SB", "Zālamana salas" },
            { "SC", "Seišelu salas" },
            { "SD", "Sudāna" },
            { "SE", "Zviedrija" },
            { "SG", "Singapūra" },
            { "SH", "Sv.Helēnas sala" },
            { "SI", "Slovēnija" },
            { "SJ", "Svalbāra un Jana Majena sala" },
            { "SK", "Slovākija" },
            { "SL", "Sjerraleone" },
            { "SM", "Sanmarīno" },
            { "SN", "Senegāla" },
            { "SO", "Somālija" },
            { "SR", "Surinama" },
            { "SS", "Dienvidsudāna" },
            { "ST", "Santome un Prinsipi" },
            { "SV", "Salvadora" },
            { "SX", "Sintmārtena" },
            { "SY", "Sīrija" },
            { "SZ", "Svatini" },
            { "TA", "Tristana da Kuņjas salu teritorijas" },
            { "TC", "Tērksas un Kaikosas salas" },
            { "TD", "Čada" },
            { "TF", "Francijas Dienvidjūru teritorija" },
            { "TG", "Togo" },
            { "TH", "Taizeme" },
            { "TJ", "Tadžikistāna" },
            { "TK", "Tokelau" },
            { "TL", "Austrumtimora" },
            { "TM", "Turkmenistāna" },
            { "TN", "Tunisija" },
            { "TO", "Tonga" },
            { "TR", "Turcija" },
            { "TT", "Trinidāda un Tobāgo" },
            { "TV", "Tuvalu" },
            { "TW", "Taivāna" },
            { "TZ", "Tanzānija" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "ASV Mazās Aizjūras salas" },
            { "UN", "Apvienoto Nāciju Organizācija" },
            { "US", "Amerikas Savienotās Valstis" },
            { "UY", "Urugvaja" },
            { "UZ", "Uzbekistāna" },
            { "VA", "Vatikāns" },
            { "VC", "Sentvinsenta un Grenadīnas" },
            { "VE", "Venecuēla" },
            { "VG", "Britu Virdžīnas" },
            { "VI", "ASV Virdžīnas" },
            { "VN", "Vjetnama" },
            { "VU", "Vanuatu" },
            { "WF", "Volisa un Futunas salas" },
            { "WS", "Samoa" },
            { "XA", "pseidoakcenti" },
            { "XB", "pseidodivvirzienu" },
            { "XK", "Kosova" },
            { "YE", "Jemena" },
            { "YT", "Majota" },
            { "ZA", "Dienvidāfrikas Republika" },
            { "ZM", "Zambija" },
            { "ZW", "Zimbabve" },
            { "ZZ", "nezināms reģions" },
            { "aa", "afāru" },
            { "ab", "abhāzu" },
            { "ae", "avesta" },
            { "af", "afrikandu" },
            { "ak", "akanu" },
            { "am", "amharu" },
            { "an", "aragoniešu" },
            { "ar", metaValue_ar },
            { "as", "asamiešu" },
            { "av", "avāru" },
            { "ay", "aimaru" },
            { "az", "azerbaidžāņu" },
            { "ba", "baškīru" },
            { "be", "baltkrievu" },
            { "bg", "bulgāru" },
            { "bi", "bišlamā" },
            { "bm", "bambaru" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretoņu" },
            { "bs", "bosniešu" },
            { "ca", "katalāņu" },
            { "ce", "čečenu" },
            { "ch", "čamorru" },
            { "co", "korsikāņu" },
            { "cr", "krī" },
            { "cs", "čehu" },
            { "cu", "baznīcslāvu" },
            { "cv", "čuvašu" },
            { "cy", "velsiešu" },
            { "da", "dāņu" },
            { "de", "vācu" },
            { "dv", "maldīviešu" },
            { "dz", "dzongke" },
            { "ee", "evu" },
            { "el", metaValue_el },
            { "en", "angļu" },
            { "eo", "esperanto" },
            { "es", "spāņu" },
            { "et", "igauņu" },
            { "eu", "basku" },
            { "fa", "persiešu" },
            { "ff", "fulu" },
            { "fi", "somu" },
            { "fj", "fidžiešu" },
            { "fo", "fēru" },
            { "fr", "franču" },
            { "fy", "rietumfrīzu" },
            { "ga", "īru" },
            { "gd", "skotu gēlu" },
            { "gl", "galisiešu" },
            { "gn", "gvaranu" },
            { "gu", metaValue_gu },
            { "gv", "meniešu" },
            { "ha", "hausu" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hirimotu" },
            { "hr", "horvātu" },
            { "ht", "haitiešu" },
            { "hu", "ungāru" },
            { "hy", metaValue_hy },
            { "hz", "hereru" },
            { "ia", "interlingva" },
            { "id", "indonēziešu" },
            { "ie", "interlingve" },
            { "ig", "igbo" },
            { "ii", "Sičuaņas ji" },
            { "ik", "inupiaku" },
            { "io", "ido" },
            { "is", "islandiešu" },
            { "it", "itāļu" },
            { "iu", "inuītu" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongu" },
            { "ki", "kikuju" },
            { "kj", "kvaņamu" },
            { "kk", "kazahu" },
            { "kl", "grenlandiešu" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuru" },
            { "ks", "kašmiriešu" },
            { "ku", "kurmandži" },
            { "kv", "komiešu" },
            { "kw", "korniešu" },
            { "ky", "kirgīzu" },
            { "la", metaValue_la },
            { "lb", "luksemburgiešu" },
            { "lg", "gandu" },
            { "li", "limburgiešu" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lietuviešu" },
            { "lu", "lubakatanga" },
            { "lv", "latviešu" },
            { "mg", "malagasu" },
            { "mh", "māršaliešu" },
            { "mi", "maoru" },
            { "mk", "maķedoniešu" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathu" },
            { "ms", "malajiešu" },
            { "mt", "maltiešu" },
            { "my", metaValue_my },
            { "na", "nauruiešu" },
            { "nb", "norvēģu bukmols" },
            { "nd", "ziemeļndebelu" },
            { "ne", "nepāliešu" },
            { "ng", "ndongu" },
            { "nl", "holandiešu" },
            { "nn", "jaunnorvēģu" },
            { "no", "norvēģu" },
            { "nr", "dienvidndebelu" },
            { "nv", "navahu" },
            { "ny", "čičeva" },
            { "oc", "oksitāņu" },
            { "oj", "odžibvu" },
            { "om", "oromu" },
            { "or", metaValue_or },
            { "os", "osetīnu" },
            { "pa", metaValue_pa },
            { "pi", "pāli" },
            { "pl", "poļu" },
            { "ps", "puštu" },
            { "pt", "portugāļu" },
            { "qu", "kečvu" },
            { "rm", "retoromāņu" },
            { "rn", "rundu" },
            { "ro", "rumāņu" },
            { "ru", "krievu" },
            { "rw", "kiņaruanda" },
            { "sa", "sanskrits" },
            { "sc", "sardīniešu" },
            { "sd", "sindhu" },
            { "se", "ziemeļsāmu" },
            { "sg", "sango" },
            { "sh", "serbu–horvātu" },
            { "si", metaValue_si },
            { "sk", "slovāku" },
            { "sl", "slovēņu" },
            { "sm", "samoāņu" },
            { "sn", "šonu" },
            { "so", "somāļu" },
            { "sq", "albāņu" },
            { "sr", "serbu" },
            { "ss", "svatu" },
            { "st", "dienvidsotu" },
            { "su", metaValue_su },
            { "sv", "zviedru" },
            { "sw", "svahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadžiku" },
            { "th", metaValue_th },
            { "ti", "tigrinja" },
            { "tk", "turkmēņu" },
            { "tl", metaValue_tl },
            { "tn", "cvanu" },
            { "to", "tongiešu" },
            { "tr", "turku" },
            { "ts", "congu" },
            { "tt", "tatāru" },
            { "tw", "tvī" },
            { "ty", "taitiešu" },
            { "ug", "uiguru" },
            { "uk", "ukraiņu" },
            { "ur", "urdu" },
            { "uz", "uzbeku" },
            { "ve", "vendu" },
            { "vi", "vjetnamiešu" },
            { "vo", "volapiks" },
            { "wa", "valoņu" },
            { "wo", "volofu" },
            { "xh", "khosu" },
            { "yi", "jidišs" },
            { "yo", "jorubu" },
            { "za", "džuanu" },
            { "zh", "ķīniešu" },
            { "zu", "zulu" },
            { "ace", "ačinu" },
            { "ach", "ačolu" },
            { "ada", "adangmu" },
            { "ady", "adigu" },
            { "afh", "afrihili" },
            { "agq", "aghemu" },
            { "ain", "ainu" },
            { "akk", "akadiešu" },
            { "ale", "aleutu" },
            { "alt", "dienvidaltajiešu" },
            { "ang", "senangļu" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", metaValue_arc },
            { "arn", "araukāņu" },
            { "arp", "arapahu" },
            { "ars", "ņedžu arābu" },
            { "arw", "aravaku" },
            { "asa", "asu" },
            { "ast", "astūriešu" },
            { "atj", "atikameku" },
            { "awa", "avadhu" },
            { "bal", "beludžu" },
            { "ban", metaValue_ban },
            { "bas", "basu" },
            { "bax", "bamumu" },
            { "bbj", "gomalu" },
            { "bej", "bedžu" },
            { "bem", "bembu" },
            { "bez", "bena" },
            { "bfd", "bafutu" },
            { "bgc", "harjanvi" },
            { "bgn", "rietumbeludžu" },
            { "bho", "bhodžpūru" },
            { "bik", "bikolu" },
            { "bin", "binu" },
            { "bkm", "komu" },
            { "bla", "siksiku" },
            { "blo", "anī" },
            { "bra", "bradžiešu" },
            { "brx", "bodo" },
            { "bss", "nkosi" },
            { "bua", "burjatu" },
            { "bug", "bugu" },
            { "bum", "bulu" },
            { "byn", "bilinu" },
            { "byv", "medumbu" },
            { "cad", "kadu" },
            { "car", "karību" },
            { "cay", "kajuga" },
            { "cch", "atsamu" },
            { "ccp", metaValue_ccp },
            { "ceb", "sebuāņu" },
            { "cgg", "kiga" },
            { "chb", "čibču" },
            { "chg", "džagatajs" },
            { "chk", "čūku" },
            { "chm", "mariešu" },
            { "chn", "činuku žargons" },
            { "cho", "čoktavu" },
            { "chp", "čipevaianu" },
            { "chr", "čiroku" },
            { "chy", "šejenu" },
            { "ckb", "centrālkurdu" },
            { "clc", "čilkotīnu" },
            { "cop", metaValue_cop },
            { "crg", "mičifu" },
            { "crh", "Krimas tatāru" },
            { "crj", "dienvidaustrumu krī" },
            { "crk", "līdzenumu krī" },
            { "crl", "ziemeļaustrumu krī" },
            { "crm", "mūsu krī" },
            { "crr", "Karolīnas algonkinu" },
            { "crs", "franciskā kreoliskā valoda (Seišelu salas)" },
            { "csb", "kašubu" },
            { "csw", "purvu krī" },
            { "dak", "dakotu" },
            { "dar", "dargu" },
            { "dav", "taitu" },
            { "del", "delavēru" },
            { "den", "sleivu" },
            { "dgr", "dogribu" },
            { "din", "dinku" },
            { "dje", "zarmu" },
            { "doi", "dogru" },
            { "dsb", "lejassorbu" },
            { "dua", "dualu" },
            { "dum", "vidusholandiešu" },
            { "dyo", "diola-fonjī" },
            { "dyu", "diūlu" },
            { "dzg", "dazu" },
            { "ebu", "kjembu" },
            { "efi", "efiku" },
            { "egy", "ēģiptiešu" },
            { "eka", "ekadžuku" },
            { "elx", "elamiešu" },
            { "enm", "vidusangļu" },
            { "ewo", "evondu" },
            { "fan", "fangu" },
            { "fat", "fantu" },
            { "fil", "filipīniešu" },
            { "fon", "fonu" },
            { "frc", "kadžūnu franču" },
            { "frm", "vidusfranču" },
            { "fro", "senfranču" },
            { "frr", "ziemeļfrīzu" },
            { "frs", "austrumfrīzu" },
            { "fur", "friūlu" },
            { "gaa", "ga" },
            { "gag", "gagauzu" },
            { "gay", "gajo" },
            { "gba", "gbaju" },
            { "gez", "gēzu" },
            { "gil", "kiribatiešu" },
            { "gmh", "vidusaugšvācu" },
            { "goh", "senaugšvācu" },
            { "gon", "gondu valodas" },
            { "gor", "gorontalu" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "sengrieķu" },
            { "gsw", "Šveices vācu" },
            { "guz", "gusii" },
            { "gwi", "kučinu" },
            { "hai", "haidu" },
            { "haw", "havajiešu" },
            { "hax", "dienvidhaidu" },
            { "hil", "hiligainonu" },
            { "hit", "hetu" },
            { "hmn", "hmongu" },
            { "hsb", "augšsorbu" },
            { "hup", "hupu" },
            { "hur", "halkomelenu" },
            { "iba", "ibanu" },
            { "ibb", "ibibio" },
            { "ikt", "Rietumkanādas inuītu" },
            { "ilo", "iloku" },
            { "inh", "ingušu" },
            { "jbo", "ložbans" },
            { "jgo", "ngomba" },
            { "jmc", "mačamu" },
            { "jpr", "jūdpersiešu" },
            { "jrb", "jūdarābu" },
            { "kaa", "karakalpaku" },
            { "kab", "kabilu" },
            { "kac", "kačinu" },
            { "kaj", "kadži" },
            { "kam", "kambu" },
            { "kaw", "kāvi" },
            { "kbd", "kabardiešu" },
            { "kbl", "kaņembu" },
            { "kcg", "katabu" },
            { "kde", "makonde" },
            { "kea", "kaboverdiešu" },
            { "kfo", "koru" },
            { "kgp", "kaingangs" },
            { "kha", "khasu" },
            { "kho", "hotaniešu" },
            { "khq", "koiračiinī" },
            { "kkj", "kako" },
            { "kln", "kalendžīnu" },
            { "kmb", "kimbundu" },
            { "koi", "komiešu-permiešu" },
            { "kok", "konkanu" },
            { "kos", "kosrājiešu" },
            { "kpe", "kpellu" },
            { "krc", "karačaju un balkāru" },
            { "krl", "karēļu" },
            { "kru", "kuruhu" },
            { "ksb", "šambalu" },
            { "ksf", "bafiju" },
            { "ksh", "Ķelnes vācu" },
            { "kum", "kumiku" },
            { "kut", "kutenaju" },
            { "kwk", "kvakvala" },
            { "kxv", "kuvi" },
            { "lad", "ladino" },
            { "lag", "langi" },
            { "lah", "landu" },
            { "lam", "lambu" },
            { "lez", "lezgīnu" },
            { "lij", "ligūriešu" },
            { "lil", "lilluetu" },
            { "lkt", "lakotu" },
            { "lmo", "lombardiešu" },
            { "lol", "mongu" },
            { "lou", "Luiziānas kreolu" },
            { "loz", "lozu" },
            { "lrc", "ziemeļluru" },
            { "lsm", "sāmia" },
            { "lua", "lubalulva" },
            { "lui", "luisenu" },
            { "lun", "lundu" },
            { "lus", "lušeju" },
            { "luy", "luhju" },
            { "mad", "maduriešu" },
            { "maf", "mafu" },
            { "mag", "magahiešu" },
            { "mai", "maithili" },
            { "mak", "makasaru" },
            { "man", "mandingu" },
            { "mas", "masaju" },
            { "mde", "mabu" },
            { "mdf", "mokšu" },
            { "mdr", "mandaru" },
            { "men", "mendu" },
            { "mer", "meru" },
            { "mfe", "Maurīcijas kreolu" },
            { "mga", "vidusīru" },
            { "mgh", "makua-mīto" },
            { "mgo", "metu" },
            { "mic", "mikmaku" },
            { "min", "minangkabavu" },
            { "mnc", "mandžūru" },
            { "mni", "manipūru" },
            { "moe", "motanju" },
            { "moh", "mohauku" },
            { "mos", "mosu" },
            { "mua", "mundangu" },
            { "mul", "vairākas valodas" },
            { "mus", "krīku" },
            { "mwl", "mirandiešu" },
            { "mwr", "marvaru" },
            { "mye", "mjenu" },
            { "myv", "erzju" },
            { "mzn", "mazanderāņu" },
            { "nap", "neapoliešu" },
            { "naq", "nama" },
            { "nds", "lejasvācu" },
            { "new", "nevaru" },
            { "nia", "njasu" },
            { "niu", "niuāņu" },
            { "nmg", "kvasio" },
            { "nnh", "ngjembūnu" },
            { "nog", "nogaju" },
            { "non", "sennorvēģu" },
            { "nqo", metaValue_nqo },
            { "nso", "ziemeļsotu" },
            { "nus", "nueru" },
            { "nwc", "klasiskā nevaru" },
            { "nym", "ņamvezu" },
            { "nyn", "ņankolu" },
            { "nyo", "ņoru" },
            { "nzi", "nzemu" },
            { "ojb", "ziemeļrietumu odžibvu" },
            { "ojc", "centrālā odžibvu" },
            { "ojs", "odži-krī" },
            { "ojw", "rietumodžibvu" },
            { "oka", "okanaganu" },
            { "osa", "važāžu" },
            { "ota", "turku osmaņu" },
            { "pag", "pangasinanu" },
            { "pal", "pehlevi" },
            { "pam", "pampanganu" },
            { "pap", "papjamento" },
            { "pau", "palaviešu" },
            { "pcm", "Nigērijas pidžinvaloda" },
            { "peo", "senpersu" },
            { "phn", metaValue_phn },
            { "pis", "pidžinvaloda" },
            { "pon", "ponapiešu" },
            { "pqm", "malisetu-pasamakvodi" },
            { "prg", "prūšu" },
            { "pro", "senprovansiešu" },
            { "quc", "kiče" },
            { "raj", "radžastāņu" },
            { "rap", "rapanuju" },
            { "rar", "rarotongiešu" },
            { "rhg", "rohindžu" },
            { "rof", "rombo" },
            { "rom", "čigānu" },
            { "rup", "aromūnu" },
            { "rwk", "ruanda" },
            { "sad", "sandavu" },
            { "sah", "jakutu" },
            { "sam", "Samārijas aramiešu" },
            { "saq", "samburu" },
            { "sas", "sasaku" },
            { "sat", "santalu" },
            { "sba", "ngambeju" },
            { "sbp", "sangu" },
            { "scn", "sicīliešu" },
            { "sco", "skotu" },
            { "sdh", "dienvidkurdu" },
            { "see", "seneku" },
            { "seh", "senu" },
            { "sel", "selkupu" },
            { "ses", "koiraboro senni" },
            { "sga", "senīru" },
            { "shi", "šilhu" },
            { "shn", "šanu" },
            { "shu", "Čadas arābu" },
            { "sid", "sidamu" },
            { "slh", "dienvidlušucīdu" },
            { "sma", "dienvidsāmu" },
            { "smj", "Luleo sāmu" },
            { "smn", "Inari sāmu" },
            { "sms", "skoltsāmu" },
            { "snk", "soninku" },
            { "sog", "sogdiešu" },
            { "srn", "sranantogo" },
            { "srr", "serēru" },
            { "ssy", metaValue_ssy },
            { "str", "šauruma sališu" },
            { "suk", "sukumu" },
            { "sus", "susu" },
            { "sux", "šumeru" },
            { "swb", "komoru" },
            { "syc", "klasiskā sīriešu" },
            { "syr", metaValue_syr },
            { "szl", "silēziešu" },
            { "tce", "dienvidtutčonu" },
            { "tem", "temnu" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetumu" },
            { "tgx", "tagišu" },
            { "tht", "tahltanu" },
            { "tig", "tigru" },
            { "tiv", "tivu" },
            { "tkl", "tokelaviešu" },
            { "tlh", "klingoņu" },
            { "tli", "tlinkitu" },
            { "tmh", "tuaregu" },
            { "tog", "Njasas tongu" },
            { "tok", "tokiponu" },
            { "tpi", "tokpisins" },
            { "trv", "taroko" },
            { "tsi", "cimšiāņu" },
            { "ttm", "ziemeļu tučonu" },
            { "tum", "tumbuku" },
            { "tvl", "tuvaliešu" },
            { "twq", "tasavaku" },
            { "tyv", "tuviešu" },
            { "tzm", "Centrālmarokas tamazīts" },
            { "udm", "udmurtu" },
            { "uga", "ugaritiešu" },
            { "umb", "umbundu" },
            { "und", "nezināma valoda" },
            { "vai", metaValue_vai },
            { "vec", "venēciešu" },
            { "vmw", "makua" },
            { "vot", "votu" },
            { "vun", "vundžo" },
            { "wae", "Vallisas vācu" },
            { "wal", "valamu" },
            { "war", "varaju" },
            { "was", "vašo" },
            { "wbp", "varlpirī" },
            { "wuu", "vu ķīniešu" },
            { "xal", "kalmiku" },
            { "xnr", "kangri" },
            { "xog", "sogu" },
            { "yao", "jao" },
            { "yap", "japiešu" },
            { "yav", "janbaņu" },
            { "ybb", "jembu" },
            { "yrl", "njengatu" },
            { "yue", "kantoniešu" },
            { "zap", "sapoteku" },
            { "zbl", "blissimbolika" },
            { "zen", "zenagu" },
            { "zgh", "standarta tamazigtu (Maroka)" },
            { "zun", "zunju" },
            { "zxx", "bez lingvistiska satura" },
            { "zza", "zazaki" },
            { "Adlm", "adlama" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliku" },
            { "Armi", metaValue_arc },
            { "Armn", metaValue_hy },
            { "Bali", metaValue_ban },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "Braila raksts" },
            { "Cakm", metaValue_ccp },
            { "Cans", "vienotā Kanādas aborigēnu zilbju rakstība" },
            { "Cher", "irokēzu" },
            { "Copt", metaValue_cop },
            { "Cyrl", "kirilica" },
            { "Cyrs", "senslāvu" },
            { "Deva", "dēvanāgari" },
            { "Egyd", "demotiskais raksts" },
            { "Egyh", "hierātiskais raksts" },
            { "Egyp", "ēģiptiešu hieroglifi" },
            { "Ethi", "etiopiešu" },
            { "Geor", metaValue_ka },
            { "Goth", metaValue_got },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", metaValue_pa },
            { "Hanb", "haņu ar bopomofo" },
            { "Hang", "hangils" },
            { "Hani", "haņu" },
            { "Hans", "vienkāršotā" },
            { "Hant", "tradicionālā" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hrkt", "japāņu zilbju alfabēts" },
            { "Hung", "senungāru" },
            { "Ital", "vecitāļu" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Lina", "lineārā A" },
            { "Linb", "lineārā B" },
            { "Lydi", "līdiešu" },
            { "Maya", "maiju" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "Mūna raksts" },
            { "Mtei", "meitei-majeku" },
            { "Mymr", metaValue_my },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "ogamiskais raksts" },
            { "Olck", "olčiki" },
            { "Orya", metaValue_or },
            { "Osma", "osmaņu turku" },
            { "Phnx", metaValue_phn },
            { "Rohg", "hanifi" },
            { "Roro", "rongorongo" },
            { "Runr", "rūnu raksts" },
            { "Samr", "samariešu" },
            { "Sinh", metaValue_si },
            { "Sund", metaValue_su },
            { "Syrc", metaValue_syr },
            { "Syrj", "rietumsīriešu" },
            { "Syrn", "austrumsīriešu" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "tifinagu" },
            { "Tglg", metaValue_tl },
            { "Thaa", "tāna" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Xpeo", "senperiešu" },
            { "Xsux", "šumeru-akadiešu ķīļraksts" },
            { "Yiii", "ji" },
            { "Zinh", "mantotā" },
            { "Zmth", "matemātiskais pieraksts" },
            { "Zsye", "emocijzīmes" },
            { "Zsym", "simboli" },
            { "Zxxx", "bez rakstības" },
            { "Zyyy", "vispārējā" },
            { "Zzzz", "nezināma rakstība" },
            { "de_CH", "augšvācu (Šveice)" },
            { "en_GB", "angļu (Lielbritānija)" },
            { "fa_AF", "darī" },
            { "nl_BE", "flāmu" },
            { "ro_MD", "moldāvu" },
            { "sw_CD", "svahili (Kongo)" },
            { "%%1901", "tradicionālā vācu ortogrāfija" },
            { "%%1996", "vācu ortogrāfija no 1996. gada" },
            { "ar_001", "mūsdienu standarta arābu" },
            { "key.ca", "Kalendārs" },
            { "key.cf", "valūtas formāts" },
            { "key.co", "kārtošanas secība" },
            { "key.cu", "valūta" },
            { "key.em", "Emocijzīmes attēlojums" },
            { "key.hc", "Stundu formāts (12 vai 24)" },
            { "key.lb", "Rindiņas pārtraukuma stils" },
            { "key.lw", "Rindiņu pārtraukumi vārdos" },
            { "key.ms", "mērvienību sistēma" },
            { "key.nu", "Cipari" },
            { "key.ss", "Teikuma beigas pēc abr." },
            { "key.tz", "laika josla" },
            { "key.va", "lokalizācijas variants" },
            { "nds_NL", "lejassakšu" },
            { "%%KKCOR", "tradicionālā ortogrāfija" },
            { "%%NEDIS", "Natisona dialekts" },
            { "%%POSIX", "datoru" },
            { "%%SAAHO", metaValue_ssy },
            { "%%UCCOR", "vienotā ortogrāfija" },
            { "az_Arab", "dienvidazerbaidžāņu" },
            { "zh_Hans", "ķīniešu vienkāršotā" },
            { "zh_Hant", "ķīniešu tradicionālā" },
            { "%%FONIPA", "Starptautiskais fonētiskais alfabēts" },
            { "%%FONUPA", "UPA fonētika" },
            { "%%PINYIN", "piņjiņa romanizācija" },
            { "%%TARASK", "Taraškeviča ortogrāfija" },
            { "%%AREVELA", "austrumarmēņu" },
            { "%%AREVMDA", "rietumarmēņu" },
            { "%%MONOTON", "monotons" },
            { "%%POLYTON", "politons" },
            { "%%1959ACAD", "akadēmiskā" },
            { "%%SCOTLAND", "Skotijas angļu" },
            { "%%VALENCIA", "valensiešu" },
            { "%%WADEGILE", "Veida-Džailza romanizācija" },
            { "type.ca.roc", "Ķīnas Republikas kalendārs" },
            { "type.co.eor", "Eiropas rakstību kārtošanas secīa" },
            { "type.hc.h11", "12 stundu sistēma (0–11)" },
            { "type.hc.h12", "12 stundu sistēma (1–12)" },
            { "type.hc.h23", "24 stundu sistēma (0–23)" },
            { "type.hc.h24", "24 stundu sistēma (1–24)" },
            { "type.m0.bgn", "transliterācijas sistēma US BGN" },
            { "type.nu.arab", "Arābu-indiešu cipari" },
            { "type.nu.armn", "Armēņu cipari" },
            { "type.nu.beng", "Bengāļu cipari" },
            { "type.nu.cakm", "Čakmas cipari" },
            { "type.nu.deva", "Devanāgarī cipari" },
            { "type.nu.ethi", "Etiopiešu cipari" },
            { "type.nu.geor", "Gruzīnu cipari" },
            { "type.nu.grek", "Grieķu cipari" },
            { "type.nu.gujr", "Gudžaratu cipari" },
            { "type.nu.guru", "Gurmuki cipari" },
            { "type.nu.hans", "Vienkāršotie ķīniešu cipari" },
            { "type.nu.hant", "Tradicionālie ķīniešu cipari" },
            { "type.nu.hebr", "Ivrita cipari" },
            { "type.nu.java", "Javas cipari" },
            { "type.nu.jpan", "Japāņu cipari" },
            { "type.nu.khmr", "Khmeru cipari" },
            { "type.nu.knda", "Kannadu cipari" },
            { "type.nu.laoo", "Laosiešu cipari" },
            { "type.nu.latn", "Arābu cipari" },
            { "type.nu.mlym", "Malajalu cipari" },
            { "type.nu.mong", "Mongoļu cipari" },
            { "type.nu.mtei", "Mītei majek cipari" },
            { "type.nu.mymr", "Birmiešu cipari" },
            { "type.nu.olck", "Olčiki cipari" },
            { "type.nu.orya", "Oriju cipari" },
            { "type.nu.taml", "Tamilu tradicionālie cipari" },
            { "type.nu.telu", "Telugu cipari" },
            { "type.nu.thai", "Tajiešu cipari" },
            { "type.nu.tibt", "Tibetiešu cipari" },
            { "type.nu.vaii", "VAI cipari" },
            { "type.ca.dangi", "dangi kalendārs" },
            { "type.co.ducet", "noklusējuma unikoda kārtošanas secība" },
            { "type.lb.loose", "Brīvais rindiņas pārtraukuma stils" },
            { "type.nu.roman", "Romiešu cipari" },
            { "type.ca.coptic", "Koptu kalendārs" },
            { "type.ca.hebrew", "ebreju kalendārs" },
            { "type.ca.indian", "Indijas nacionālais kalendārs" },
            { "type.co.compat", "saderīgā kārtošanas secība" },
            { "type.co.pinyin", "piņjiņa kārtošanas secība" },
            { "type.co.search", "vispārīga meklēšana" },
            { "type.co.stroke", "Stroke kārtošanas secība" },
            { "type.co.unihan", "Radikālā kārtošanas secība pēc vilkumu skaita" },
            { "type.d0.fwidth", "Pilna platuma" },
            { "type.d0.hwidth", "Pusplatuma" },
            { "type.lb.normal", "Parastais rindiņas pārtraukuma stils" },
            { "type.lb.strict", "Stingrais rindiņas pārtraukuma stils" },
            { "type.m0.ungegn", "transliterācijas sistēma UN GEGN" },
            { "type.ms.metric", "metriskā sistēma" },
            { "type.nu.native", "Vietējie cipari" },
            { "type.ca.chinese", "ķīniešu kalendārs" },
            { "type.ca.islamic", "Hidžrī kalendārs" },
            { "type.ca.iso8601", "ISO 8601 kalendārs" },
            { "type.ca.persian", "persiešu kalendārs" },
            { "type.cf.account", "uzskaites valūtas formāts" },
            { "type.d0.npinyin", "Ciparu" },
            { "type.nu.arabext", "Izvērstie arābu-indiešu cipari" },
            { "type.nu.armnlow", "Mazie armēņu cipari" },
            { "type.nu.finance", "Finanšu cipari" },
            { "type.nu.greklow", "Mazie grieķu cipari" },
            { "type.nu.hanidec", "Ķīniešu decimāldaļskaitļi" },
            { "type.nu.hansfin", "Vienkāršotie ķīniešu cipari finanšu dokumentiem" },
            { "type.nu.hantfin", "Tradicionālie ķīniešu cipari finanšu dokumentiem" },
            { "type.nu.jpanfin", "Japāņu cipari finanšu dokumentiem" },
            { "type.nu.tamldec", "Tamilu cipari" },
            { "type.ca.buddhist", "budistu kalendārs" },
            { "type.ca.ethiopic", "etiopiešu kalendārs" },
            { "type.ca.japanese", "japāņu kalendārs" },
            { "type.cf.standard", "standarta valūtas formāts" },
            { "type.co.phonetic", "Fonētiskā kārtošanas secība" },
            { "type.co.searchjl", "Meklēt pēc Hangul sākuma līdzskaņa" },
            { "type.co.standard", "standarta kārtošanas secība" },
            { "type.ms.uksystem", "britu mērvienību sistēma" },
            { "type.ms.ussystem", "amerikāņu mērvienību sistēma" },
            { "type.nu.fullwide", "Pilna platuma cipari" },
            { "type.nu.romanlow", "Mazie romiešu cipari" },
            { "type.ca.gregorian", "Gregora kalendārs" },
            { "type.co.phonebook", "tālruņu grāmatas kārtošanas secība" },
            { "type.co.dictionary", "Vārdnīcas kārtošanas secība" },
            { "type.co.traditional", "tradicionālā kārtošanas secība" },
            { "type.nu.traditional", "Tradicionālā ciparu sistēma" },
            { "type.ca.islamic-civil", "Hidžrī kalendārs (pilsoņu)" },
            { "type.ca.islamic-umalqura", "Hidžrī kalendārs (Umm al-kura)" },
            { "type.ca.ethiopic-amete-alem", "etiopiešu Amete Alem kalendārs" },
        };
        return data;
    }
}
