/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx.skins;

import com.dlsc.gemsfx.SemiCircleProgressIndicator;
import com.dlsc.gemsfx.skins.ArcProgressIndicatorSkin;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.util.Duration;

public class SemiCircleProgressIndicatorSkin
extends ArcProgressIndicatorSkin<SemiCircleProgressIndicator> {
    public SemiCircleProgressIndicatorSkin(SemiCircleProgressIndicator control) {
        super(control);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.trackArc.setStartAngle(0.0);
        this.trackArc.setLength(180.0);
    }

    @Override
    protected double getProgressMaxLength() {
        return -180.0;
    }

    @Override
    protected void stopAnimation() {
        super.stopAnimation();
        this.progressArc.setStartAngle(180.0);
    }

    @Override
    protected double computeLabelHeight(double diameter) {
        return diameter / 2.0;
    }

    @Override
    protected Timeline initIndeterminateAnimation() {
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.progressArc.startAngleProperty(), (Object)180), new KeyValue((WritableValue)this.progressArc.lengthProperty(), (Object)0)}), new KeyFrame(Duration.seconds((double)0.75), new KeyValue[]{new KeyValue((WritableValue)this.progressArc.startAngleProperty(), (Object)90), new KeyValue((WritableValue)this.progressArc.lengthProperty(), (Object)-60)}), new KeyFrame(Duration.seconds((double)1.5), new KeyValue[]{new KeyValue((WritableValue)this.progressArc.startAngleProperty(), (Object)0), new KeyValue((WritableValue)this.progressArc.lengthProperty(), (Object)0)})});
        timeline.setCycleCount(-1);
        return timeline;
    }

    @Override
    protected DoubleBinding getRadiusBinding(SemiCircleProgressIndicator control) {
        return Bindings.createDoubleBinding(() -> {
            Insets insets = control.getInsets() != null ? control.getInsets() : Insets.EMPTY;
            double totalHorInset = insets.getLeft() + insets.getRight();
            double totalVerInset = insets.getTop() + insets.getBottom();
            double maxRadius = Math.max(this.trackArc.getStrokeWidth(), this.progressArc.getStrokeWidth());
            return Math.min(control.getWidth() - totalHorInset - maxRadius, (control.getHeight() - totalVerInset - maxRadius) * 2.0) / 2.0;
        }, (Observable[])new Observable[]{control.widthProperty(), control.heightProperty(), control.insetsProperty(), this.trackArc.strokeWidthProperty(), this.progressArc.strokeWidthProperty()});
    }

    @Override
    protected double computeArcCenterY(double contentY, double contentHeight) {
        return contentY + contentHeight / 2.0 + this.radiusBinding.get() / 2.0;
    }

    @Override
    protected double computeLabelY(double centerY, double labelHeight) {
        return centerY - labelHeight;
    }
}

