/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.output;

import de.undercouch.citeproc.output.SecondFieldAlign;
import java.util.Arrays;

public class Bibliography {
    private final String[] entries;
    private final String bibStart;
    private final String bibEnd;
    private final String[] entryIds;
    private final Integer maxOffset;
    private final Integer entrySpacing;
    private final Integer lineSpacing;
    private final Boolean hangingIndent;
    private final Boolean done;
    private final SecondFieldAlign secondFieldAlign;

    public Bibliography(String ... entries) {
        this.entries = entries;
        this.bibStart = null;
        this.bibEnd = null;
        this.entryIds = null;
        this.maxOffset = null;
        this.entrySpacing = null;
        this.lineSpacing = null;
        this.hangingIndent = null;
        this.done = null;
        this.secondFieldAlign = null;
    }

    public Bibliography(String[] entries, String bibStart, String bibEnd, String[] entryIds, Integer maxOffset, Integer entrySpacing, Integer lineSpacing, Boolean hangingIndent, Boolean done, SecondFieldAlign secondFieldAlign) {
        this.entries = entries;
        this.bibStart = bibStart;
        this.bibEnd = bibEnd;
        this.entryIds = entryIds;
        this.maxOffset = maxOffset;
        this.entrySpacing = entrySpacing;
        this.lineSpacing = lineSpacing;
        this.hangingIndent = hangingIndent;
        this.done = done;
        this.secondFieldAlign = secondFieldAlign;
    }

    public String[] getEntries() {
        return this.entries;
    }

    public String getBibStart() {
        return this.bibStart;
    }

    public String getBibEnd() {
        return this.bibEnd;
    }

    public String[] getEntryIds() {
        return this.entryIds;
    }

    public Integer getMaxOffset() {
        return this.maxOffset;
    }

    public Integer getEntrySpacing() {
        return this.entrySpacing;
    }

    public Integer getLineSpacing() {
        return this.lineSpacing;
    }

    public Boolean getHangingIndent() {
        return this.hangingIndent;
    }

    public Boolean getDone() {
        return this.done;
    }

    public SecondFieldAlign getSecondFieldAlign() {
        return this.secondFieldAlign;
    }

    public String makeString() {
        StringBuilder b = new StringBuilder();
        if (this.getBibStart() != null) {
            b.append(this.getBibStart());
        }
        if (this.entries != null) {
            for (String e : this.entries) {
                b.append(e);
            }
        }
        if (this.getBibEnd() != null) {
            b.append(this.getBibEnd());
        }
        return b.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.bibStart == null ? 0 : this.bibStart.hashCode());
        result = 31 * result + (this.bibEnd == null ? 0 : this.bibEnd.hashCode());
        result = 31 * result + Arrays.hashCode(this.entryIds);
        result = 31 * result + (this.maxOffset == null ? 0 : this.maxOffset.hashCode());
        result = 31 * result + (this.entrySpacing == null ? 0 : this.entrySpacing.hashCode());
        result = 31 * result + (this.lineSpacing == null ? 0 : this.lineSpacing.hashCode());
        result = 31 * result + (this.hangingIndent == null ? 0 : this.hangingIndent.hashCode());
        result = 31 * result + (this.done == null ? 0 : this.done.hashCode());
        result = 31 * result + (this.secondFieldAlign == null ? 0 : this.secondFieldAlign.hashCode());
        result = 31 * result + Arrays.hashCode(this.entries);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bibliography)) {
            return false;
        }
        Bibliography other = (Bibliography)obj;
        if (this.bibStart == null ? other.bibStart != null : !this.bibStart.equals(other.bibStart)) {
            return false;
        }
        if (this.bibEnd == null ? other.bibEnd != null : !this.bibEnd.equals(other.bibEnd)) {
            return false;
        }
        if (!Arrays.equals(this.entryIds, other.entryIds)) {
            return false;
        }
        if (this.maxOffset == null ? other.maxOffset != null : !this.maxOffset.equals(other.maxOffset)) {
            return false;
        }
        if (this.entrySpacing == null ? other.entrySpacing != null : !this.entrySpacing.equals(other.entrySpacing)) {
            return false;
        }
        if (this.lineSpacing == null ? other.lineSpacing != null : !this.lineSpacing.equals(other.lineSpacing)) {
            return false;
        }
        if (this.hangingIndent == null ? other.hangingIndent != null : !this.hangingIndent.equals(other.hangingIndent)) {
            return false;
        }
        if (this.done == null ? other.done != null : !this.done.equals(other.done)) {
            return false;
        }
        if (this.secondFieldAlign == null ? other.secondFieldAlign != null : !this.secondFieldAlign.equals((Object)other.secondFieldAlign)) {
            return false;
        }
        return Arrays.equals(this.entries, other.entries);
    }
}

