/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_dz extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Cuba = new String[] {
               "ཀིའུ་བྷ་ཚད་ལྡན་ཆུ་ཚོད",
               "CST",
               "ཀིའུ་བྷ་ཉིན་སྲུང་ཆུ་ཚོད",
               "CDT",
               "ཀིའུ་བྷ་ཆུ་ཚོད",
               "CT",
            };
        final String[] Gulf = new String[] {
               "གཱལཕི་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "ཨི་རཱན་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨི་རཱན་ཉིན་སྲུང་ཆུ་ཚོད",
               "",
               "ཨི་རཱན་ཆུ་ཚོད",
               "",
            };
        final String[] Omsk = new String[] {
               "ཨོམསཀི་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨོམསཀི་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཨོམསཀི་ཆུ་ཚོད",
               "",
            };
        final String[] Peru = new String[] {
               "པ་རུ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "པ་རུ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "པ་རུ་ཆུ་ཚོད",
               "",
            };
        final String[] Chile = new String[] {
               "ཅི་ལི་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཅི་ལི་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཅི་ལི་ཆུ་ཚོད",
               "",
            };
        final String[] China = new String[] {
               "རྒྱ་ནག་ཚད་ལྡན་ཆུ་ཚོད",
               "CST",
               "རྒྱ་ནག་ཉིན་སྲུང་ཆུ་ཚོད",
               "CDT",
               "རྒྱ་ནག་ཆུ་ཚོད",
               "CT",
            };
        final String[] India = new String[] {
               "རྒྱ་གར་ཆུ་ཚོད",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ཇ་པཱན་ཚད་ལྡན་ཆུ་ཚོད",
               "JST",
               "ཇ་པཱན་ཉིན་སྲུང་ཆུ་ཚོད",
               "JDT",
               "ཇ་པཱན་ཆུ་ཚོད",
               "JT",
            };
        final String[] Korea = new String[] {
               "ཀོ་རི་ཡ་ཚད་ལྡན་ཆུ་ཚོད",
               "KST",
               "ཀོ་རི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད",
               "KST",
               "ཀོ་རི་ཡ་ཆུ་ཚོད",
               "KST",
            };
        final String[] Nepal = new String[] {
               "ནེ་པཱལ་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Alaska = new String[] {
               "ཨ་ལསི་ཀ་ཚད་ལྡན་ཆུ་ཚོད",
               "AKST",
               "ཨ་ལསི་ཀ་ཉིན་སྲུང་ཆུ་ཚོད",
               "AKDT",
               "ཨ་ལསི་ཀ་ཆུ་ཚོད",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ཨེ་མ་ཛཱོན་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨེ་མ་ཛཱོན་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཨེ་མ་ཛཱོན་ཆུ་ཚོད",
               "",
            };
        final String[] Azores = new String[] {
               "ཨེ་ཛོརས་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨེ་ཛོརས་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཨེ་ཛོརས་ཆུ་ཚོད",
               "",
            };
        final String[] Bhutan = new String[] {
               "འབྲུག་ཡུལ་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ཨིསི་ཊར་ཨཱའི་ལེནཌ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨིསི་ཊར་ཨཱའི་ལེནཌ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཨིསི་ཊར་ཨཱའི་ལེནཌ་ཆུ་ཚོད",
               "",
            };
        final String[] Guyana = new String[] {
               "གུ་ཡ་ན་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "ཧ་ཝའི་-ཨེ་ལིའུ་ཤེན་ཚད་ལྡན་ཆུ་ཚོད",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ཨིས་རེལ་ཚད་ལྡན་ཆུ་ཚོད",
               "IST",
               "ཨིས་རེལ་ཉིན་སྲུང་ཆུ་ཚོད",
               "IDT",
               "ཨིས་རེལ་ཆུ་ཚོད",
               "IT",
            };
        final String[] Moscow = new String[] {
               "མཽས་ཀོ་ཚད་ལྡན་ཆུ་ཚོད",
               "MSK",
               "མཽས་ཀོ་བྱཱར་དུས་ཆུ་ཚོད",
               "MSK",
               "མཽས་ཀོ་ཆུ་ཚོད",
               "MSK",
            };
        final String[] Arabian = new String[] {
               "ཨ་རེ་བྷི་ཡན་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨ་རེ་བྷི་ཡན་སྲུང་ཆུ་ཚོད",
               "",
               "ཨ་རེ་བྷི་ཡན་ཆུ་ཚོད",
               "",
            };
        final String[] Armenia = new String[] {
               "ཨར་མི་ནི་ཡ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨར་མི་ནི་ཡ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཨར་མི་ནི་ཡ་ཆུ་ཚོད",
               "",
            };
        final String[] Bolivia = new String[] {
               "བྷོ་ལི་བི་ཡ་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ཨེ་ཀུ་ཌཽ་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ཇཽ་ཇཱ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཇཽ་ཇཱ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཇཽ་ཇཱ་ཆུ་ཚོད",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ཨར་ཀུཙི་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨར་ཀུཙི་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཨར་ཀུཙི་ཆུ་ཚོད",
               "",
            };
        final String[] Magadan = new String[] {
               "མ་གྷ་དཱན་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "མ་གྷ་དཱན་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "མ་གྷ་དཱན་ཆུ་ཚོད",
               "",
            };
        final String[] Noronha = new String[] {
               "ཕར་ནེན་ཌོ་ ཌི་ ནོ་རཱོན་ཧ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཕར་ནེན་ཌོ་ ཌི་ ནོ་རཱོན་ཧ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཕར་ནེན་ཌོ་ ཌི་ ནོ་རཱོན་ཧ་ཆུ་ཚོད",
               "",
            };
        final String[] Reunion = new String[] {
               "རི་ཡུ་ནི་ཡཱན་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ཡུ་རུ་གུ་ཝཱའི་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཡུ་རུ་གུ་ཝཱའི་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཡུ་རུ་གུ་ཝཱའི་ཆུ་ཚོད",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ཡ་ཀུཙིཀི་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཡ་ཀུཙིཀི་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཡ་ཀུཙིཀི་ཆུ་ཚོད",
               "",
            };
        final String[] Atlantic = new String[] {
               "ཨེཊ་ལེན་ཊིཀ་ཚད་ལྡན་ཆུ་ཚོད",
               "AST",
               "ཨེཊ་ལེན་ཊིཀ་ཉིན་སྲུང་ཆུ་ཚོད",
               "AST",
               "ཨེཊ་ལེན་ཊིཀ་ཆུ་ཚོད",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "བྲ་ཛི་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "བྲ་ཛི་ལི་ཡ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "བྲ་ཛི་ལི་ཡ་ཆུ་ཚོད",
               "",
            };
        final String[] Colombia = new String[] {
               "ཀོ་ལོམ་བྷི་ཡ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཀོ་ལོམ་བྷི་ཡ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཀོ་ལོམ་བྷི་ཡ་ཆུ་ཚོད",
               "",
            };
        final String[] Falkland = new String[] {
               "ཕལཀ་ལེནཌ་ཨཱའི་ལེནཌས་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཕལཀ་ལེནཌ་ཨཱའི་ལེནཌས་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཕལཀ་ལེནཌ་ཨཱའི་ལེནཌས་ཆུ་ཚོད",
               "",
            };
        final String[] Maldives = new String[] {
               "མཱལ་དིབས་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pakistan = new String[] {
               "པ་ཀི་ས྄ཏཱན་ཚད་ལྡན་ཆུ་ཚོད",
               "PKT",
               "པ་ཀི་ས྄ཏཱན་བྱཱར་དུས་ཆུ་ཚོད",
               "PKST",
               "པ་ཀི་ས྄ཏཱན་ཆུ་ཚོད",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "པ་ར་གུ་ཝའི་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "པ་ར་གུ་ཝའི་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "པ་ར་གུ་ཝའི་ཆུ་ཚོད",
               "",
            };
        final String[] Suriname = new String[] {
               "སུ་རི་ནཱམ་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ཨར་ཇེན་ཊི་ན་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨར་ཇེན་ཊི་ན་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཨར་ཇེན་ཊི་ན་ཆུ་ཚོད",
               "",
            };
        final String[] Christmas = new String[] {
               "ཁི་རིསྟ་མེས་མཚོ་གླིང་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ག་ལ་པ་གོསི་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indochina = new String[] {
               "ཨིན་ཌོ་ཅཱའི་ན་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "མོ་རི་ཤཱས་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "མོ་རི་ཤཱས་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "མོ་རི་ཤཱས་ཆུ་ཚོད",
               "",
            };
        final String[] Venezuela = new String[] {
               "བེ་ནི་ཛུ་ཝེ་ལ་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "ཨ་ཛར་བྷའི་ཇཱན་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཨ་ཛར་བྷའི་ཇཱན་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཨ་ཛར་བྷའི་ཇཱན་ཆུ་ཚོད",
               "",
            };
        final String[] Bangladesh = new String[] {
               "བངྒ་ལ་དེཤ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "བངྒ་ལ་དེཤ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "བངྒ་ལ་དེཤ་ཆུ་ཚོད",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "ཀེཔ་བཱཌ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཀེཔ་བཱཌ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཀེཔ་བཱཌ་ཆུ་ཚོད",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "སེ་ཤཱལས་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ཨཕ་ག་ནི་ས྄ཏཱནཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ཀརསི་ནོ་ཡརསཀི་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཀརསི་ནོ་ཡརསཀི་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཀརསི་ནོ་ཡརསཀི་ཆུ་ཚོད",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ནིའུ་ཛི་ལེནཌ་ཚད་ལྡན་ཆུ་ཚོད",
               "NZST",
               "ནིའུ་ཛི་ལེནཌ་ཉིན་སྲུང་ཆུ་ཚོད",
               "NZDT",
               "ནིའུ་ཛི་ལེནཌ་ཆུ་ཚོད",
               "NZT",
            };
        final String[] Vladivostok = new String[] {
               "བ་ལ་ཌི་བོསི་ཏོཀ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "བ་ལ་ཌི་བོསི་ཏོཀ་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "བ་ལ་ཌི་བོསི་ཏོཀ་ཆུ་ཚོད",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "རྒྱ་གར་གྱི་རྒྱ་མཚོ་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ནིའུ་ཕའུནཌ་ལེནཌ་ཚད་ལྡན་ཆུ་ཚོད",
               "NST",
               "ནིའུ་ཕའུནཌ་ལེནཌ་ཉིན་སྲུང་ཆུ་ཚོད",
               "NDT",
               "ནིའུ་ཕའུནཌ་ལེནཌ་ཆུ་ཚོད",
               "NT",
            };
        final String[] French_Guiana = new String[] {
               "ཕིརེནཅ་གི་ཡ་ན་ཆུ་ཚོད",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ཡེ་ཀ་ཏེ་རིན་བརག་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "ཡེ་ཀ་ཏེ་རིན་བརག་བྱཱར་དུས་ཆུ་ཚོད",
               "",
               "ཡེ་ཀ་ཏེ་རིན་བརག་ཆུ་ཚོད",
               "",
            };
        final String[] Africa_Central = new String[] {
               "དབུས་ཕྱོགས་ཨཕ་རི་ཀཱ་ཆུ་ཚོད",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "ཤར་ཕྱོགས་ཨཕ་རི་ཀཱ་ཆུ་ཚོད",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "ནུབ་ཕྱོགས་ཨཕ་རི་ཀཱ་ཆུ་ཚོད",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] Europe_Central = new String[] {
               "དབུས་ཕྱོགས་ཡུ་རོ་པེན་ཚད་ལྡན་ཆུ་ཚོད",
               "CET",
               "དབུས་ཕྱོགས་ཡུ་རོ་པེན་བྱཱར་དུས་ཆུ་ཚོད",
               "CEST",
               "དབུས་ཕྱོགས་ཡུ་རོ་པེན་ཆུ་ཚོད",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "ཤར་ཕྱོགས་ཡུ་རོ་པེན་ཚད་ལྡན་ཆུ་ཚོད",
               "EET",
               "ཤར་ཕྱོགས་ཡུ་རོ་པེན་བྱཱར་དུས་ཆུ་ཚོད",
               "EEST",
               "ཤར་ཕྱོགས་ཡུ་རོ་པེན་ཆུ་ཚོད",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "ནུབ་ཕྱོགས་ཡུ་རོ་པེན་ཚད་ལྡན་ཆུ་ཚོད",
               "WET",
               "ནུབ་ཕྱོགས་ཡུ་རོ་པེན་བྱཱར་དུས་ཆུ་ཚོད",
               "WEST",
               "ནུབ་ཕྱོགས་ཡུ་རོ་པེན་ཆུ་ཚོད",
               "WET",
            };
        final String[] Africa_Southern = new String[] {
               "ལྷོ་ཕྱོགས་ཨཕ་རི་ཀཱ་ཆུ་ཚོད",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "བྱང་ཨ་མི་རི་ཀ་དབུས་ཕྱོགས་ཚད་ལྡན་ཆུ་ཚོད",
               "CST",
               "བྱང་ཨ་མི་རི་ཀ་དབུས་ཕྱོགས་ཉིན་སྲུང་ཆུ་ཚོད",
               "CDT",
               "བྱང་ཨ་མི་རི་ཀ་དབུས་ཕྱོགས་ཆུ་ཚོད",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "བྱང་ཨ་མི་རི་ཀ་ཤར་ཕྱོགས་ཚད་ལྡན་ཆུ་ཚོད",
               "EST",
               "བྱང་ཨ་མི་རི་ཀ་ཤར་ཕྱོགས་ཉིན་སྲུང་ཆུ་ཚོད",
               "EST",
               "བྱང་ཨ་མི་རི་ཀ་ཤར་ཕྱོགས་ཆུ་ཚོད",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "བྱང་ཨ་མི་རི་ཀ་པེ་སི་ཕིག་ཚད་ལྡན་ཆུ་ཚོད",
               "PST",
               "བྱང་ཨ་མི་རི་ཀ་པེ་སི་ཕིག་ཉིན་སྲུང་ཆུ་ཚོད",
               "PDT",
               "བྱང་ཨ་མི་རི་ཀ་པེ་སི་ཕིག་ཆུ་ཚོད",
               "PT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ཧ་ཝའི་-ཨེ་ལིའུ་ཤེན་ཚད་ལྡན་ཆུ་ཚོད",
               "HST",
               "ཧ་ཝའི་-ཨེ་ལིའུ་ཤེན་ཉིན་སྲུང་ཆུ་ཚོད",
               "HDT",
               "ཧ་ཝའི་-ཨེ་ལིའུ་ཤེན་ཆུ་ཚོད",
               "HT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "པའི་རི་དང་མི་ཀི་ལཱོན་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "པའི་རི་དང་མི་ཀི་ལཱོན་ཉིན་སྲུང་ཆུ་ཚོད",
               "",
               "པའི་རི་དང་མི་ཀི་ལཱོན་ཆུ་ཚོད",
               "",
            };
        final String[] America_Mountain = new String[] {
               "བྱང་ཨ་མི་རི་ཀ་མའུ་ཊེན་ཚད་ལྡན་ཆུ་ཚོད",
               "MST",
               "བྱང་ཨ་མི་རི་ཀ་མའུ་ཊེན་ཉིན་སྲུང་ཆུ་ཚོད",
               "MST",
               "བྱང་ཨ་མི་རི་ཀ་མའུ་ཊེན་ཆུ་ཚོད",
               "MST",
            };
        final String[] Australia_Central = new String[] {
               "དབུས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད",
               "ACST",
               "དབུས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད",
               "ACDT",
               "དབུས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཆུ་ཚོད",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ཤར་ཕྱོགས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད",
               "AEST",
               "ཤར་ཕྱོགས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད",
               "AEDT",
               "ཤར་ཕྱོགས་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཆུ་ཚོད",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད",
               "AWST",
               "ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད",
               "AWDT",
               "ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཆུ་ཚོད",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "དབུས་ཕྱོགས་ཨིན་ཌོ་ནེ་ཤི་ཡ་ཆུ་ཚོད",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "ཤར་ཕྱོགས་ཨིན་ཌོ་ནེ་ཤི་ཡ་ཆུ་ཚོད",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "ནུབ་ཕྱོགས་ཨིན་ཌོ་ནེ་ཤི་ཡ་ཆུ་ཚོད",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "དབུས་ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཚད་ལྡན་ཆུ་ཚོད",
               "",
               "དབུས་ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཉིན་སྲུང་ཆུ་ཚོད",
               "",
               "བུས་ནུབ་ཕྱོགས་ཨཱོས་ཊྲེལ་ལི་ཡ་ཆུ་ཚོད",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "GB",
                new String[] {
                    "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
                    "GMT",
                    "བྲཱི་ཊིཤ་བྱཱར་དུས་ཆུ་ཚོད",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
                    "GMT",
                    "ཨཱ་ཡརིཤ་བྱཱར་དུས་ཆུ་ཚོད",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "GB-Eire",
                new String[] {
                    "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
                    "GMT",
                    "བྲཱི་ཊིཤ་བྱཱར་དུས་ཆུ་ཚོད",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Portugal", Europe_Western },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Omsk", Omsk },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Calcutta", India },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
                    "GMT",
                    "ཨཱ་ཡརིཤ་བྱཱར་དུས་ཆུ་ཚོད",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
                    "GMT",
                    "བྲཱི་ཊིཤ་བྱཱར་དུས་ཆུ་ཚོད",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
                    "GMT",
                    "བྲཱི་ཊིཤ་བྱཱར་དུས་ཆུ་ཚོད",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
                    "GMT",
                    "བྲཱི་ཊིཤ་བྱཱར་དུས་ཆུ་ཚོད",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Phnom_Penh", Indochina },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
                    "GMT",
                    "བྲཱི་ཊིཤ་བྱཱར་དུས་ཆུ་ཚོད",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", Maldives },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Johnston", Hawaii },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Galapagos", Galapagos },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "Antarctica/McMurdo", New_Zealand },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "གིརིན་ཝིཆ་ལུ་ཡོད་པའི་ཆུ་ཚོད",
                    "GMT",
                    "བྲཱི་ཊིཤ་བྱཱར་དུས་ཆུ་ཚོད",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "ལོ་མེ" },
            { "timezone.excity.Etc/Unknown", "མ་ཤེས་པའི་ཁྲོམ་སྡེ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "ཀཱའི་རོ" },
            { "timezone.excity.Africa/Dakar", "ཌཱ་ཀར" },
            { "timezone.excity.Africa/Tunis", "ཊུ་ནིས྄" },
            { "timezone.excity.Asia/Bahrain", "བྷ་རེན་" },
            { "timezone.excity.Asia/Thimphu", "ཐིམ་ཕུག" },
            { "timezone.excity.Pacific/Apia", "ཨ་པི་ཡ" },
            { "timezone.excity.Europe/Athens", "ཨེ་ཐེནས་" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Tripoli", "ཏྲི་པོ་ལི" },
            { "timezone.excity.America/Belize", "བྷེ་ལིཛ" },
            { "timezone.excity.America/Bogota", "བྷོ་ག་ཊ" },
            { "timezone.excity.America/Dawson", "དའུ་སཱོན" },
            { "timezone.excity.America/Inuvik", "ཨི་ནུ་ཝིཀ" },
            { "timezone.excity.America/La_Paz", "ལ་པཱཛ྄" },
            { "timezone.excity.America/Panama", "པ་ན་མ" },
            { "timezone.excity.America/Regina", "རི་ཇི་ན" },
            { "timezone.excity.Europe/Tallinn", "ཊཱ་ལཱིན" },
            { "timezone.excity.Africa/Khartoum", "ཁཱར་ཊུམ" },
            { "timezone.excity.America/Antigua", "ཨན་ཊི་གུ་ཝ་" },
            { "timezone.excity.America/Chicago", "ཅི་ཀཱ་གོ" },
            { "timezone.excity.America/Halifax", "ཧ་ལི་ཕེགསི" },
            { "timezone.excity.America/Moncton", "མཱོངཀ་ཊོན" },
            { "timezone.excity.America/Tijuana", "ཏིའུ་ཝ་ན" },
            { "timezone.excity.America/Toronto", "ཊོ་རོན་ཊོ" },
            { "timezone.excity.America/Yakutat", "ཡ་ཀུ་ཏཏ" },
            { "timezone.excity.Atlantic/Faeroe", "ཕཱའེ་རོ་" },
            { "timezone.excity.Europe/Helsinki", "ཧེལ་སིང་ཀི" },
            { "timezone.excity.America/Barbados", "བྷར་བེ་ཌོས" },
            { "timezone.excity.America/Dominica", "ཌོ་མི་ནི་ཀ" },
            { "timezone.excity.America/Edmonton", "ཨེཌ་མཱོན་ཊོན" },
            { "timezone.excity.America/Resolute", "རི་སོ་ལིའུཊ" },
            { "timezone.excity.America/Santiago", "སཱན་ཊི་ཡ་གྷོ" },
            { "timezone.excity.America/St_Johns", "ཨིསི་ཊེཊ་ ཇཱོནསི་" },
            { "timezone.excity.Antarctica/Davis", "ཌེ་ཝིས།" },
            { "timezone.excity.Atlantic/Bermuda", "བར་མུ་ད" },
            { "timezone.excity.America/Goose_Bay", "གཱུསི་ བའེ" },
            { "timezone.excity.America/Guatemala", "གྷོ་ཊ་མ་ལ" },
            { "timezone.excity.Antarctica/Mawson", "མའུ་སཱོན" },
            { "timezone.excity.Europe/Copenhagen", "ཀོ་པེན་ཧེ་གེན" },
            { "timezone.excity.America/Costa_Rica", "ཀོས་ཊ་རི་ཀ" },
            { "timezone.excity.America/El_Salvador", "ཨེལ་ སཱལ་བ་ཌོ" },
            { "timezone.excity.America/Mexico_City", "མེཀ་སི་ཀོ་ སི་ཊི" },
            { "timezone.excity.America/Tegucigalpa", "ཊེ་གུ་སི་གཱལ་པ" },
            { "timezone.excity.America/Dawson_Creek", "དའུ་སཱོན་ ཀིརིཀ" },
            { "timezone.excity.America/Rankin_Inlet", "རེན་ཀིན་ ཨིན་ལེཊ" },
            { "timezone.excity.America/Cambridge_Bay", "ཀེམ་བིརིདཆ་ བའེ" },
            { "timezone.excity.America/Coral_Harbour", "ཨ་ཏི་ཀོ་ཀཱན" },
            { "timezone.excity.America/Santo_Domingo", "སཱན་ཊོ་ ཌོ་མིང་གྷོ" },
            { "timezone.excity.America/Swift_Current", "སུ་ཨིཕཊ་ཀ་རེནཊ" },
        };
        return data;
    }
}
