/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.wizard;

import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.DataTransferPipe;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferNode;
import org.jkiss.dbeaver.tools.transfer.IDataTransferProducer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferNodeDescriptor;
import org.jkiss.dbeaver.tools.transfer.registry.DataTransferProcessorDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.internal.DTUIMessages;
import org.jkiss.dbeaver.tools.transfer.ui.wizard.DataTransferWizard;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.IWizardPageNavigable;
import org.jkiss.utils.CommonUtils;

class DataTransferPageFinal
extends ActiveWizardPage<DataTransferWizard>
implements IWizardPageNavigable {
    private static final Log log = Log.getLog(DataTransferPageFinal.class);
    private Table resultTable;
    private boolean activated = false;
    private Text sourceSettingsText;
    private Text targetSettingsText;

    DataTransferPageFinal() {
        super(DTUIMessages.data_transfer_wizard_final_name);
        this.setTitle(DTUIMessages.data_transfer_wizard_final_title);
        this.setDescription(DTUIMessages.data_transfer_wizard_final_description);
        this.setPageComplete(true);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        SashForm sash = new SashForm(composite, 512);
        sash.setLayoutData((Object)new GridData(1808));
        Group tablesGroup = UIUtils.createControlGroup((Composite)sash, (String)DTUIMessages.data_transfer_wizard_final_group_objects, (int)3, (int)1808, (int)0);
        this.resultTable = new Table((Composite)tablesGroup, 67588);
        this.resultTable.setLayoutData((Object)new GridData(1808));
        this.resultTable.setHeaderVisible(true);
        this.resultTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.resultTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_source_container);
        UIUtils.createTableColumn((Table)this.resultTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_source);
        UIUtils.createTableColumn((Table)this.resultTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_target_container);
        UIUtils.createTableColumn((Table)this.resultTable, (int)16384, (String)DTUIMessages.data_transfer_wizard_final_column_target);
        Composite settingsGroup = UIUtils.createComposite((Composite)sash, (int)2);
        settingsGroup.setLayoutData((Object)new GridData(1808));
        Group sourceSettingsGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)DTUIMessages.data_transfer_wizard_final_group_settings_source, (int)1, (int)1808, (int)0);
        this.sourceSettingsText = new Text((Composite)sourceSettingsGroup, 2568);
        this.sourceSettingsText.setLayoutData((Object)new GridData(1808));
        ((GridData)this.sourceSettingsText.getLayoutData()).widthHint = 150;
        ((GridData)this.sourceSettingsText.getLayoutData()).heightHint = 30;
        Group targetSettingsGroup = UIUtils.createControlGroup((Composite)settingsGroup, (String)DTUIMessages.data_transfer_wizard_final_group_settings_target, (int)1, (int)1808, (int)0);
        this.targetSettingsText = new Text((Composite)targetSettingsGroup, 2568);
        this.targetSettingsText.setLayoutData((Object)new GridData(1808));
        ((GridData)this.targetSettingsText.getLayoutData()).widthHint = 150;
        ((GridData)this.targetSettingsText.getLayoutData()).heightHint = 30;
        this.setControl((Control)composite);
    }

    public void activatePage() {
        ((DataTransferWizard)this.getWizard()).loadNodeSettings();
        this.resultTable.removeAll();
        DataTransferSettings settings = ((DataTransferWizard)this.getWizard()).getSettings();
        List dataPipes = settings.getDataPipes();
        IDataTransferSettings consumerSettings = null;
        IDataTransferSettings producerSettings = null;
        int i = 0;
        while (i < dataPipes.size()) {
            block16: {
                DataTransferPipe pipe = (DataTransferPipe)dataPipes.get(i);
                try {
                    pipe.initPipe(settings, i, dataPipes.size());
                }
                catch (DBException e) {
                    DBWorkbench.getPlatformUI().showError(DTUIMessages.data_transfer_page_final_title_error_initializing_transfer_pipe, DTUIMessages.data_transfer_page_final_message_error_initializing_data_transfer_pipe, (Throwable)e);
                    break block16;
                }
                IDataTransferConsumer consumer = pipe.getConsumer();
                IDataTransferProducer producer = pipe.getProducer();
                if (consumerSettings == null) {
                    consumerSettings = settings.getNodeSettings(settings.getConsumer());
                }
                if (producerSettings == null) {
                    producerSettings = settings.getNodeSettings(settings.getProducer());
                }
                DataTransferProcessorDescriptor processorDescriptor = settings.getProcessor();
                TableItem item = new TableItem(this.resultTable, 0);
                if (producer != null) {
                    Color producerColor;
                    item.setText(0, producer.getObjectContainerName());
                    if (producer.getObjectContainerIcon() != null) {
                        item.setImage(0, DBeaverIcons.getImage((DBPImage)producer.getObjectContainerIcon()));
                    }
                    item.setText(1, CommonUtils.notEmpty((String)producer.getObjectName()));
                    DBPImage producerObjectIcon = producer.getObjectIcon();
                    if (producerObjectIcon == null) {
                        producerObjectIcon = settings.getProducer().getIcon();
                    }
                    if (producerObjectIcon != null) {
                        item.setImage(1, DBeaverIcons.getImage((DBPImage)producerObjectIcon));
                    }
                    if ((producerColor = this.getNodeColor((IDataTransferNode<?>)producer)) != null) {
                        item.setBackground(0, producerColor);
                        item.setBackground(1, producerColor);
                    }
                }
                if (consumer != null) {
                    Color consumerColor;
                    item.setText(2, consumer.getObjectContainerName());
                    if (consumer.getObjectContainerIcon() != null) {
                        item.setImage(2, DBeaverIcons.getImage((DBPImage)consumer.getObjectContainerIcon()));
                    }
                    item.setText(3, consumer.getObjectName());
                    DBPImage consumerObjectIcon = consumer.getObjectIcon();
                    if (consumerObjectIcon == null && processorDescriptor != null) {
                        consumerObjectIcon = processorDescriptor.getIcon();
                    }
                    if (consumerObjectIcon == null && settings.getConsumer() != null) {
                        consumerObjectIcon = settings.getConsumer().getIcon();
                    }
                    if (consumerObjectIcon != null) {
                        item.setImage(3, DBeaverIcons.getImage((DBPImage)consumerObjectIcon));
                    }
                    if ((consumerColor = this.getNodeColor((IDataTransferNode<?>)consumer)) != null) {
                        item.setBackground(2, consumerColor);
                        item.setBackground(3, consumerColor);
                    }
                }
            }
            ++i;
        }
        this.printSummary(this.sourceSettingsText, settings.getProducer(), producerSettings, settings.isProducerProcessor() ? settings.getProcessor() : null);
        this.printSummary(this.targetSettingsText, settings.getConsumer(), consumerSettings, settings.isProducerProcessor() ? null : settings.getProcessor());
        this.activated = true;
        UIUtils.asyncExec(() -> {
            if (!this.resultTable.isDisposed()) {
                TableColumn[] columns;
                int tableWidth = this.resultTable.getSize().x;
                TableColumn[] tableColumnArray = columns = this.resultTable.getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.setWidth(tableWidth / columns.length - 1);
                    ++n2;
                }
            }
        });
        this.updatePageCompletion();
        ((DataTransferWizard)this.getWizard()).updateSaveTaskButtons();
    }

    public boolean isPageComplete() {
        return this.activated;
    }

    private Color getNodeColor(IDataTransferNode<?> node) {
        DBPDataSource dataSource;
        DBSObject dbObject = node.getDatabaseObject();
        if (dbObject != null && (dataSource = dbObject.getDataSource()) != null) {
            DBPDataSourceContainer container = dataSource.getContainer();
            return UIUtils.getConnectionColor((DBPConnectionConfiguration)container.getConnectionConfiguration());
        }
        return null;
    }

    private void printSummary(Text text, DataTransferNodeDescriptor node, IDataTransferSettings settings, DataTransferProcessorDescriptor processor) {
        String settingsSummary;
        StringBuilder summary = new StringBuilder();
        if (settings != null && !CommonUtils.isEmpty((String)(settingsSummary = settings.getSettingsSummary()))) {
            if (node != null) {
                summary.append(NLS.bind((String)DTMessages.data_transfer_summary_title, (Object)node.getName())).append(":\n");
            }
            summary.append(CommonUtils.notEmpty((String)settingsSummary));
        }
        if (processor != null) {
            DTUtils.addSummary((StringBuilder)summary, (DataTransferProcessorDescriptor)processor, (Map)((DataTransferWizard)this.getWizard()).getSettings().getProcessorProperties());
        }
        text.setText(summary.toString());
    }

    public boolean isActivated() {
        return this.activated;
    }

    protected boolean determinePageCompletion() {
        for (DataTransferPipe pipe : ((DataTransferWizard)this.getWizard()).getSettings().getDataPipes()) {
            if (pipe.getProducer() == null || !pipe.getProducer().isConfigurationComplete()) {
                this.setErrorMessage(NLS.bind((String)DTUIMessages.data_transfer_error_source_not_specified, (Object)pipe.getConsumer().getObjectName()));
                return false;
            }
            if (pipe.getConsumer() != null && pipe.getConsumer().isConfigurationComplete()) continue;
            this.setErrorMessage(NLS.bind((String)DTUIMessages.data_transfer_error_target_not_specified, (Object)pipe.getProducer().getObjectName()));
            return false;
        }
        return this.activated;
    }

    public boolean isPageNavigable() {
        return true;
    }

    public boolean isPageApplicable() {
        return true;
    }
}

