package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCommonBandwidthPackageInternetChargeType invokes the vpc.ModifyCommonBandwidthPackageInternetChargeType API synchronously
func (client *Client) ModifyCommonBandwidthPackageInternetChargeType(request *ModifyCommonBandwidthPackageInternetChargeTypeRequest) (response *ModifyCommonBandwidthPackageInternetChargeTypeResponse, err error) {
	response = CreateModifyCommonBandwidthPackageInternetChargeTypeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCommonBandwidthPackageInternetChargeTypeWithChan invokes the vpc.ModifyCommonBandwidthPackageInternetChargeType API asynchronously
func (client *Client) ModifyCommonBandwidthPackageInternetChargeTypeWithChan(request *ModifyCommonBandwidthPackageInternetChargeTypeRequest) (<-chan *ModifyCommonBandwidthPackageInternetChargeTypeResponse, <-chan error) {
	responseChan := make(chan *ModifyCommonBandwidthPackageInternetChargeTypeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCommonBandwidthPackageInternetChargeType(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCommonBandwidthPackageInternetChargeTypeWithCallback invokes the vpc.ModifyCommonBandwidthPackageInternetChargeType API asynchronously
func (client *Client) ModifyCommonBandwidthPackageInternetChargeTypeWithCallback(request *ModifyCommonBandwidthPackageInternetChargeTypeRequest, callback func(response *ModifyCommonBandwidthPackageInternetChargeTypeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCommonBandwidthPackageInternetChargeTypeResponse
		var err error
		defer close(result)
		response, err = client.ModifyCommonBandwidthPackageInternetChargeType(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCommonBandwidthPackageInternetChargeTypeRequest is the request struct for api ModifyCommonBandwidthPackageInternetChargeType
type ModifyCommonBandwidthPackageInternetChargeTypeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceChargeType   string           `position:"Query" name:"InstanceChargeType"`
	BandwidthPackageId   string           `position:"Query" name:"BandwidthPackageId"`
	AutoPay              requests.Boolean `position:"Query" name:"AutoPay"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth            requests.Integer `position:"Query" name:"Bandwidth"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InternetChargeType   string           `position:"Query" name:"InternetChargeType"`
	Ratio                requests.Integer `position:"Query" name:"Ratio"`
}

// ModifyCommonBandwidthPackageInternetChargeTypeResponse is the response struct for api ModifyCommonBandwidthPackageInternetChargeType
type ModifyCommonBandwidthPackageInternetChargeTypeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCommonBandwidthPackageInternetChargeTypeRequest creates a request to invoke ModifyCommonBandwidthPackageInternetChargeType API
func CreateModifyCommonBandwidthPackageInternetChargeTypeRequest() (request *ModifyCommonBandwidthPackageInternetChargeTypeRequest) {
	request = &ModifyCommonBandwidthPackageInternetChargeTypeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyCommonBandwidthPackageInternetChargeType", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCommonBandwidthPackageInternetChargeTypeResponse creates a response to parse from ModifyCommonBandwidthPackageInternetChargeType response
func CreateModifyCommonBandwidthPackageInternetChargeTypeResponse() (response *ModifyCommonBandwidthPackageInternetChargeTypeResponse) {
	response = &ModifyCommonBandwidthPackageInternetChargeTypeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
