package retailcloud

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitInfo invokes the retailcloud.SubmitInfo API synchronously
func (client *Client) SubmitInfo(request *SubmitInfoRequest) (response *SubmitInfoResponse, err error) {
	response = CreateSubmitInfoResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitInfoWithChan invokes the retailcloud.SubmitInfo API asynchronously
func (client *Client) SubmitInfoWithChan(request *SubmitInfoRequest) (<-chan *SubmitInfoResponse, <-chan error) {
	responseChan := make(chan *SubmitInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitInfoWithCallback invokes the retailcloud.SubmitInfo API asynchronously
func (client *Client) SubmitInfoWithCallback(request *SubmitInfoRequest, callback func(response *SubmitInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitInfoResponse
		var err error
		defer close(result)
		response, err = client.SubmitInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitInfoRequest is the request struct for api SubmitInfo
type SubmitInfoRequest struct {
	*requests.RpcRequest
	RequestId   string                   `position:"Query" name:"RequestId"`
	MainUserId  requests.Integer         `position:"Query" name:"MainUserId"`
	EcsDescList *[]SubmitInfoEcsDescList `position:"Body" name:"EcsDescList"  type:"Repeated"`
	CallerUid   requests.Integer         `position:"Query" name:"CallerUid"`
}

// SubmitInfoEcsDescList is a repeated param struct in SubmitInfoRequest
type SubmitInfoEcsDescList struct {
	ResourceId          string `name:"ResourceId"`
	BussinessDesc       string `name:"BussinessDesc"`
	MiddleWareDesc      string `name:"MiddleWareDesc"`
	OtherMiddleWareDesc string `name:"OtherMiddleWareDesc"`
	BussinessType       string `name:"BussinessType"`
	AppType             string `name:"AppType"`
	EnvType             string `name:"EnvType"`
	UserId              string `name:"UserId"`
}

// SubmitInfoResponse is the response struct for api SubmitInfo
type SubmitInfoResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrMsg    string `json:"ErrMsg" xml:"ErrMsg"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSubmitInfoRequest creates a request to invoke SubmitInfo API
func CreateSubmitInfoRequest() (request *SubmitInfoRequest) {
	request = &SubmitInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailcloud", "2018-03-13", "SubmitInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateSubmitInfoResponse creates a response to parse from SubmitInfo response
func CreateSubmitInfoResponse() (response *SubmitInfoResponse) {
	response = &SubmitInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
