package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMcuJob invokes the mts.QueryMcuJob API synchronously
func (client *Client) QueryMcuJob(request *QueryMcuJobRequest) (response *QueryMcuJobResponse, err error) {
	response = CreateQueryMcuJobResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMcuJobWithChan invokes the mts.QueryMcuJob API asynchronously
func (client *Client) QueryMcuJobWithChan(request *QueryMcuJobRequest) (<-chan *QueryMcuJobResponse, <-chan error) {
	responseChan := make(chan *QueryMcuJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMcuJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMcuJobWithCallback invokes the mts.QueryMcuJob API asynchronously
func (client *Client) QueryMcuJobWithCallback(request *QueryMcuJobRequest, callback func(response *QueryMcuJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMcuJobResponse
		var err error
		defer close(result)
		response, err = client.QueryMcuJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMcuJobRequest is the request struct for api QueryMcuJob
type QueryMcuJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	JobIds               string           `position:"Query" name:"JobIds"`
}

// QueryMcuJobResponse is the response struct for api QueryMcuJob
type QueryMcuJobResponse struct {
	*responses.BaseResponse
	RequestId      string                      `json:"RequestId" xml:"RequestId"`
	NonExistJobIds NonExistJobIdsInQueryMcuJob `json:"NonExistJobIds" xml:"NonExistJobIds"`
	JobResult      JobResultInQueryMcuJob      `json:"JobResult" xml:"JobResult"`
}

// CreateQueryMcuJobRequest creates a request to invoke QueryMcuJob API
func CreateQueryMcuJobRequest() (request *QueryMcuJobRequest) {
	request = &QueryMcuJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryMcuJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryMcuJobResponse creates a response to parse from QueryMcuJob response
func CreateQueryMcuJobResponse() (response *QueryMcuJobResponse) {
	response = &QueryMcuJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
