package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSparkJobDetail invokes the dms_enterprise.GetSparkJobDetail API synchronously
func (client *Client) GetSparkJobDetail(request *GetSparkJobDetailRequest) (response *GetSparkJobDetailResponse, err error) {
	response = CreateGetSparkJobDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetSparkJobDetailWithChan invokes the dms_enterprise.GetSparkJobDetail API asynchronously
func (client *Client) GetSparkJobDetailWithChan(request *GetSparkJobDetailRequest) (<-chan *GetSparkJobDetailResponse, <-chan error) {
	responseChan := make(chan *GetSparkJobDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSparkJobDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSparkJobDetailWithCallback invokes the dms_enterprise.GetSparkJobDetail API asynchronously
func (client *Client) GetSparkJobDetailWithCallback(request *GetSparkJobDetailRequest, callback func(response *GetSparkJobDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSparkJobDetailResponse
		var err error
		defer close(result)
		response, err = client.GetSparkJobDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSparkJobDetailRequest is the request struct for api GetSparkJobDetail
type GetSparkJobDetailRequest struct {
	*requests.RpcRequest
	JobId requests.Integer `position:"Query" name:"JobId"`
	Tid   requests.Integer `position:"Query" name:"Tid"`
}

// GetSparkJobDetailResponse is the response struct for api GetSparkJobDetail
type GetSparkJobDetailResponse struct {
	*responses.BaseResponse
	RequestId    string    `json:"RequestId" xml:"RequestId"`
	Success      bool      `json:"Success" xml:"Success"`
	ErrorMessage string    `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string    `json:"ErrorCode" xml:"ErrorCode"`
	JobDetail    JobDetail `json:"JobDetail" xml:"JobDetail"`
}

// CreateGetSparkJobDetailRequest creates a request to invoke GetSparkJobDetail API
func CreateGetSparkJobDetailRequest() (request *GetSparkJobDetailRequest) {
	request = &GetSparkJobDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetSparkJobDetail", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSparkJobDetailResponse creates a response to parse from GetSparkJobDetail response
func CreateGetSparkJobDetailResponse() (response *GetSparkJobDetailResponse) {
	response = &GetSparkJobDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
