#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 416
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 119
#define ALIAS_COUNT 0
#define TOKEN_COUNT 74
#define EXTERNAL_TOKEN_COUNT 2
#define FIELD_COUNT 18
#define MAX_ALIAS_SEQUENCE_LENGTH 13
#define PRODUCTION_ID_COUNT 38

enum ts_symbol_identifiers {
  sym_bool = 1,
  sym_number = 2,
  anon_sym_SQUOTE = 3,
  aux_sym_string_token1 = 4,
  anon_sym_DQUOTE = 5,
  aux_sym_string_token2 = 6,
  anon_sym_BQUOTE = 7,
  aux_sym_string_token3 = 8,
  anon_sym_LBRACK = 9,
  anon_sym_COMMA = 10,
  anon_sym_RBRACK = 11,
  sym_identifier = 12,
  anon_sym_DOT = 13,
  anon_sym_LPAREN = 14,
  anon_sym_RPAREN = 15,
  anon_sym_STAR = 16,
  anon_sym_SLASH = 17,
  anon_sym_PERCENT = 18,
  anon_sym_PLUS = 19,
  anon_sym_DASH = 20,
  anon_sym_TILDE = 21,
  anon_sym_EQ_EQ = 22,
  anon_sym_BANG_EQ = 23,
  anon_sym_LT = 24,
  anon_sym_GT = 25,
  anon_sym_LT_EQ = 26,
  anon_sym_GT_EQ = 27,
  anon_sym_in = 28,
  anon_sym_and = 29,
  anon_sym_or = 30,
  anon_sym_PIPE = 31,
  anon_sym_not = 32,
  anon_sym_EQ = 33,
  anon_sym_COLON_COLON = 34,
  anon_sym_is = 35,
  anon_sym_LBRACE_POUND = 36,
  anon_sym_LBRACE_POUND_DASH = 37,
  aux_sym_comment_tag_token1 = 38,
  anon_sym_POUND_RBRACE = 39,
  anon_sym_DASH_POUND_RBRACE = 40,
  anon_sym_LBRACE_LBRACE = 41,
  anon_sym_LBRACE_LBRACE_DASH = 42,
  anon_sym_RBRACE_RBRACE = 43,
  anon_sym_DASH_RBRACE_RBRACE = 44,
  anon_sym_LBRACE_PERCENT = 45,
  anon_sym_LBRACE_PERCENT_DASH = 46,
  anon_sym_if = 47,
  anon_sym_PERCENT_RBRACE = 48,
  anon_sym_DASH_PERCENT_RBRACE = 49,
  anon_sym_endif = 50,
  anon_sym_elif = 51,
  anon_sym_else = 52,
  anon_sym_for = 53,
  anon_sym_endfor = 54,
  anon_sym_break = 55,
  anon_sym_continue = 56,
  anon_sym_set = 57,
  anon_sym_set_global = 58,
  anon_sym_include = 59,
  anon_sym_ignoremissing = 60,
  anon_sym_import = 61,
  anon_sym_as = 62,
  anon_sym_extends = 63,
  anon_sym_macro = 64,
  anon_sym_endmacro = 65,
  anon_sym_filter = 66,
  anon_sym_endfilter = 67,
  anon_sym_block = 68,
  anon_sym_endblock = 69,
  anon_sym_raw = 70,
  anon_sym_endraw = 71,
  sym_frontmatter_delimiter = 72,
  sym_content = 73,
  sym_source_file = 74,
  sym_frontmatter = 75,
  sym_string = 76,
  sym__literal = 77,
  sym_array = 78,
  sym_member_expression = 79,
  sym_parenthesized_expression = 80,
  sym_binary_expression = 81,
  sym_filter_expression = 82,
  sym_unary_expression = 83,
  sym_assignment_expression = 84,
  sym_keyword_argument = 85,
  sym_argument_list = 86,
  sym_call_expression = 87,
  sym_test_expression = 88,
  sym__value = 89,
  sym__template = 90,
  sym_comment_tag = 91,
  sym_expression_tag = 92,
  sym__statement_tag = 93,
  sym_if_statement = 94,
  sym_elif_clause = 95,
  sym_else_clause = 96,
  sym_for_statement = 97,
  sym_for_break_statement = 98,
  sym_for_continue_statement = 99,
  sym_set_statement = 100,
  sym_include_statement = 101,
  sym_import_statement = 102,
  sym_extends_statement = 103,
  sym_optional_parameter = 104,
  sym_parameter_list = 105,
  sym_macro_statement = 106,
  sym_filter_statement = 107,
  sym_block_statement = 108,
  sym_raw_statement = 109,
  aux_sym_source_file_repeat1 = 110,
  aux_sym_string_repeat1 = 111,
  aux_sym_string_repeat2 = 112,
  aux_sym_string_repeat3 = 113,
  aux_sym_array_repeat1 = 114,
  aux_sym_member_expression_repeat1 = 115,
  aux_sym_argument_list_repeat1 = 116,
  aux_sym_if_statement_repeat1 = 117,
  aux_sym_parameter_list_repeat1 = 118,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_bool] = "bool",
  [sym_number] = "number",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token2] = "string_token2",
  [anon_sym_BQUOTE] = "`",
  [aux_sym_string_token3] = "string_token3",
  [anon_sym_LBRACK] = "[",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACK] = "]",
  [sym_identifier] = "identifier",
  [anon_sym_DOT] = ".",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_TILDE] = "~",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_in] = "in",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_PIPE] = "|",
  [anon_sym_not] = "not",
  [anon_sym_EQ] = "=",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_is] = "is",
  [anon_sym_LBRACE_POUND] = "{#",
  [anon_sym_LBRACE_POUND_DASH] = "{#-",
  [aux_sym_comment_tag_token1] = "comment_tag_token1",
  [anon_sym_POUND_RBRACE] = "#}",
  [anon_sym_DASH_POUND_RBRACE] = "-#}",
  [anon_sym_LBRACE_LBRACE] = "{{",
  [anon_sym_LBRACE_LBRACE_DASH] = "{{-",
  [anon_sym_RBRACE_RBRACE] = "}}",
  [anon_sym_DASH_RBRACE_RBRACE] = "-}}",
  [anon_sym_LBRACE_PERCENT] = "{%",
  [anon_sym_LBRACE_PERCENT_DASH] = "{%-",
  [anon_sym_if] = "if",
  [anon_sym_PERCENT_RBRACE] = "%}",
  [anon_sym_DASH_PERCENT_RBRACE] = "-%}",
  [anon_sym_endif] = "endif",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_endfor] = "endfor",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_set] = "set",
  [anon_sym_set_global] = "set_global",
  [anon_sym_include] = "include",
  [anon_sym_ignoremissing] = "ignore missing",
  [anon_sym_import] = "import",
  [anon_sym_as] = "as",
  [anon_sym_extends] = "extends",
  [anon_sym_macro] = "macro",
  [anon_sym_endmacro] = "endmacro",
  [anon_sym_filter] = "filter",
  [anon_sym_endfilter] = "endfilter",
  [anon_sym_block] = "block",
  [anon_sym_endblock] = "endblock",
  [anon_sym_raw] = "raw",
  [anon_sym_endraw] = "endraw",
  [sym_frontmatter_delimiter] = "frontmatter_delimiter",
  [sym_content] = "content",
  [sym_source_file] = "source_file",
  [sym_frontmatter] = "frontmatter",
  [sym_string] = "string",
  [sym__literal] = "_literal",
  [sym_array] = "array",
  [sym_member_expression] = "member_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_filter_expression] = "filter_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_keyword_argument] = "keyword_argument",
  [sym_argument_list] = "argument_list",
  [sym_call_expression] = "call_expression",
  [sym_test_expression] = "test_expression",
  [sym__value] = "_value",
  [sym__template] = "_template",
  [sym_comment_tag] = "comment_tag",
  [sym_expression_tag] = "expression_tag",
  [sym__statement_tag] = "_statement_tag",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_statement] = "for_statement",
  [sym_for_break_statement] = "for_break_statement",
  [sym_for_continue_statement] = "for_continue_statement",
  [sym_set_statement] = "set_statement",
  [sym_include_statement] = "include_statement",
  [sym_import_statement] = "import_statement",
  [sym_extends_statement] = "extends_statement",
  [sym_optional_parameter] = "optional_parameter",
  [sym_parameter_list] = "parameter_list",
  [sym_macro_statement] = "macro_statement",
  [sym_filter_statement] = "filter_statement",
  [sym_block_statement] = "block_statement",
  [sym_raw_statement] = "raw_statement",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [aux_sym_string_repeat3] = "string_repeat3",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_member_expression_repeat1] = "member_expression_repeat1",
  [aux_sym_argument_list_repeat1] = "argument_list_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_bool] = sym_bool,
  [sym_number] = sym_number,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token2] = aux_sym_string_token2,
  [anon_sym_BQUOTE] = anon_sym_BQUOTE,
  [aux_sym_string_token3] = aux_sym_string_token3,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [sym_identifier] = sym_identifier,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_LBRACE_POUND] = anon_sym_LBRACE_POUND,
  [anon_sym_LBRACE_POUND_DASH] = anon_sym_LBRACE_POUND_DASH,
  [aux_sym_comment_tag_token1] = aux_sym_comment_tag_token1,
  [anon_sym_POUND_RBRACE] = anon_sym_POUND_RBRACE,
  [anon_sym_DASH_POUND_RBRACE] = anon_sym_DASH_POUND_RBRACE,
  [anon_sym_LBRACE_LBRACE] = anon_sym_LBRACE_LBRACE,
  [anon_sym_LBRACE_LBRACE_DASH] = anon_sym_LBRACE_LBRACE_DASH,
  [anon_sym_RBRACE_RBRACE] = anon_sym_RBRACE_RBRACE,
  [anon_sym_DASH_RBRACE_RBRACE] = anon_sym_DASH_RBRACE_RBRACE,
  [anon_sym_LBRACE_PERCENT] = anon_sym_LBRACE_PERCENT,
  [anon_sym_LBRACE_PERCENT_DASH] = anon_sym_LBRACE_PERCENT_DASH,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_PERCENT_RBRACE] = anon_sym_PERCENT_RBRACE,
  [anon_sym_DASH_PERCENT_RBRACE] = anon_sym_DASH_PERCENT_RBRACE,
  [anon_sym_endif] = anon_sym_endif,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_endfor] = anon_sym_endfor,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_set_global] = anon_sym_set_global,
  [anon_sym_include] = anon_sym_include,
  [anon_sym_ignoremissing] = anon_sym_ignoremissing,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_macro] = anon_sym_macro,
  [anon_sym_endmacro] = anon_sym_endmacro,
  [anon_sym_filter] = anon_sym_filter,
  [anon_sym_endfilter] = anon_sym_endfilter,
  [anon_sym_block] = anon_sym_block,
  [anon_sym_endblock] = anon_sym_endblock,
  [anon_sym_raw] = anon_sym_raw,
  [anon_sym_endraw] = anon_sym_endraw,
  [sym_frontmatter_delimiter] = sym_frontmatter_delimiter,
  [sym_content] = sym_content,
  [sym_source_file] = sym_source_file,
  [sym_frontmatter] = sym_frontmatter,
  [sym_string] = sym_string,
  [sym__literal] = sym__literal,
  [sym_array] = sym_array,
  [sym_member_expression] = sym_member_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_filter_expression] = sym_filter_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_keyword_argument] = sym_keyword_argument,
  [sym_argument_list] = sym_argument_list,
  [sym_call_expression] = sym_call_expression,
  [sym_test_expression] = sym_test_expression,
  [sym__value] = sym__value,
  [sym__template] = sym__template,
  [sym_comment_tag] = sym_comment_tag,
  [sym_expression_tag] = sym_expression_tag,
  [sym__statement_tag] = sym__statement_tag,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_for_break_statement] = sym_for_break_statement,
  [sym_for_continue_statement] = sym_for_continue_statement,
  [sym_set_statement] = sym_set_statement,
  [sym_include_statement] = sym_include_statement,
  [sym_import_statement] = sym_import_statement,
  [sym_extends_statement] = sym_extends_statement,
  [sym_optional_parameter] = sym_optional_parameter,
  [sym_parameter_list] = sym_parameter_list,
  [sym_macro_statement] = sym_macro_statement,
  [sym_filter_statement] = sym_filter_statement,
  [sym_block_statement] = sym_block_statement,
  [sym_raw_statement] = sym_raw_statement,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [aux_sym_string_repeat3] = aux_sym_string_repeat3,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_member_expression_repeat1] = aux_sym_member_expression_repeat1,
  [aux_sym_argument_list_repeat1] = aux_sym_argument_list_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token3] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_POUND_DASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_comment_tag_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_POUND_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_POUND_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_LBRACE_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_RBRACE_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE_PERCENT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_PERCENT_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endfor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set_global] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_include] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ignoremissing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_macro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endmacro] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_filter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endfilter] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_block] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endblock] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_raw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_endraw] = {
    .visible = true,
    .named = false,
  },
  [sym_frontmatter_delimiter] = {
    .visible = true,
    .named = true,
  },
  [sym_content] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_frontmatter] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_filter_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_keyword_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_test_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__value] = {
    .visible = false,
    .named = true,
  },
  [sym__template] = {
    .visible = false,
    .named = true,
  },
  [sym_comment_tag] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_tag] = {
    .visible = true,
    .named = true,
  },
  [sym__statement_tag] = {
    .visible = false,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_set_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_include_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_optional_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_filter_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_block_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_raw_statement] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_member_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_argument_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_alternative = 1,
  field_argument = 2,
  field_arguments = 3,
  field_body = 4,
  field_condition = 5,
  field_consequence = 6,
  field_filter = 7,
  field_index = 8,
  field_left = 9,
  field_name = 10,
  field_operator = 11,
  field_parameter = 12,
  field_parameters = 13,
  field_property = 14,
  field_right = 15,
  field_scope = 16,
  field_test = 17,
  field_value = 18,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_argument] = "argument",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_filter] = "filter",
  [field_index] = "index",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_parameter] = "parameter",
  [field_parameters] = "parameters",
  [field_property] = "property",
  [field_right] = "right",
  [field_scope] = "scope",
  [field_test] = "test",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 3},
  [3] = {.index = 5, .length = 1},
  [4] = {.index = 6, .length = 4},
  [5] = {.index = 10, .length = 3},
  [6] = {.index = 13, .length = 3},
  [7] = {.index = 16, .length = 1},
  [8] = {.index = 17, .length = 3},
  [9] = {.index = 20, .length = 4},
  [10] = {.index = 24, .length = 2},
  [11] = {.index = 26, .length = 2},
  [12] = {.index = 28, .length = 2},
  [13] = {.index = 30, .length = 1},
  [14] = {.index = 31, .length = 1},
  [15] = {.index = 32, .length = 2},
  [16] = {.index = 34, .length = 2},
  [17] = {.index = 36, .length = 2},
  [18] = {.index = 38, .length = 1},
  [19] = {.index = 39, .length = 1},
  [20] = {.index = 40, .length = 1},
  [21] = {.index = 41, .length = 3},
  [22] = {.index = 44, .length = 3},
  [23] = {.index = 47, .length = 5},
  [24] = {.index = 52, .length = 2},
  [25] = {.index = 54, .length = 4},
  [26] = {.index = 58, .length = 4},
  [27] = {.index = 62, .length = 5},
  [28] = {.index = 67, .length = 2},
  [29] = {.index = 69, .length = 3},
  [30] = {.index = 72, .length = 5},
  [31] = {.index = 77, .length = 3},
  [32] = {.index = 80, .length = 3},
  [33] = {.index = 83, .length = 4},
  [34] = {.index = 87, .length = 4},
  [35] = {.index = 91, .length = 5},
  [36] = {.index = 96, .length = 5},
  [37] = {.index = 101, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_arguments, 1},
    {field_name, 0},
  [2] =
    {field_index, 1, .inherited = true},
    {field_property, 1, .inherited = true},
    {field_value, 0},
  [5] =
    {field_property, 1},
  [6] =
    {field_index, 0, .inherited = true},
    {field_index, 1, .inherited = true},
    {field_property, 0, .inherited = true},
    {field_property, 1, .inherited = true},
  [10] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [13] =
    {field_filter, 2},
    {field_operator, 1},
    {field_value, 0},
  [16] =
    {field_index, 1},
  [17] =
    {field_arguments, 3},
    {field_name, 2},
    {field_scope, 0},
  [20] =
    {field_arguments, 3},
    {field_filter, 2},
    {field_operator, 1},
    {field_value, 0},
  [24] =
    {field_test, 2},
    {field_value, 0},
  [26] =
    {field_name, 0},
    {field_value, 2},
  [28] =
    {field_test, 3},
    {field_value, 0},
  [30] =
    {field_scope, 4},
  [31] =
    {field_parameter, 1},
  [32] =
    {field_condition, 1},
    {field_condition, 2},
  [34] =
    {field_parameter, 1},
    {field_parameter, 2, .inherited = true},
  [36] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [38] =
    {field_parameter, 2, .inherited = true},
  [39] =
    {field_body, 3},
  [40] =
    {field_consequence, 3},
  [41] =
    {field_alternative, 4},
    {field_condition, 1},
    {field_condition, 2},
  [44] =
    {field_condition, 1},
    {field_condition, 2},
    {field_consequence, 4},
  [47] =
    {field_argument, 3},
    {field_argument, 4},
    {field_argument, 5},
    {field_test, 2},
    {field_value, 0},
  [52] =
    {field_name, 2},
    {field_parameters, 3},
  [54] =
    {field_alternative, 5},
    {field_condition, 1},
    {field_condition, 2},
    {field_consequence, 4},
  [58] =
    {field_alternative, 4},
    {field_alternative, 5},
    {field_condition, 1},
    {field_condition, 2},
  [62] =
    {field_argument, 4},
    {field_argument, 5},
    {field_argument, 6},
    {field_test, 3},
    {field_value, 0},
  [67] =
    {field_left, 2},
    {field_right, 4},
  [69] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [72] =
    {field_alternative, 5},
    {field_alternative, 6},
    {field_condition, 1},
    {field_condition, 2},
    {field_consequence, 4},
  [77] =
    {field_alternative, 6},
    {field_left, 2},
    {field_right, 4},
  [80] =
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [83] =
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_right, 6},
  [87] =
    {field_alternative, 7},
    {field_body, 6},
    {field_left, 2},
    {field_right, 4},
  [91] =
    {field_alternative, 8},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_right, 6},
  [96] =
    {field_body, 8},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_right, 6},
  [101] =
    {field_alternative, 9},
    {field_body, 8},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_right, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 13,
  [15] = 15,
  [16] = 10,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 24,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 31,
  [37] = 37,
  [38] = 32,
  [39] = 33,
  [40] = 34,
  [41] = 35,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 48,
  [59] = 43,
  [60] = 45,
  [61] = 46,
  [62] = 51,
  [63] = 63,
  [64] = 49,
  [65] = 44,
  [66] = 50,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 69,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 79,
  [81] = 81,
  [82] = 82,
  [83] = 74,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 86,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 91,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 95,
  [100] = 100,
  [101] = 97,
  [102] = 100,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 108,
  [110] = 107,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 111,
  [116] = 112,
  [117] = 113,
  [118] = 114,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 119,
  [127] = 127,
  [128] = 121,
  [129] = 123,
  [130] = 122,
  [131] = 125,
  [132] = 127,
  [133] = 120,
  [134] = 124,
  [135] = 135,
  [136] = 135,
  [137] = 137,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 137,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 158,
  [160] = 138,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 139,
  [175] = 140,
  [176] = 141,
  [177] = 142,
  [178] = 143,
  [179] = 144,
  [180] = 145,
  [181] = 146,
  [182] = 147,
  [183] = 148,
  [184] = 150,
  [185] = 151,
  [186] = 152,
  [187] = 153,
  [188] = 154,
  [189] = 155,
  [190] = 156,
  [191] = 157,
  [192] = 166,
  [193] = 167,
  [194] = 168,
  [195] = 169,
  [196] = 161,
  [197] = 170,
  [198] = 171,
  [199] = 199,
  [200] = 162,
  [201] = 163,
  [202] = 172,
  [203] = 164,
  [204] = 173,
  [205] = 165,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 209,
  [211] = 211,
  [212] = 212,
  [213] = 212,
  [214] = 211,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 215,
  [221] = 221,
  [222] = 219,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 225,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 224,
  [250] = 250,
  [251] = 236,
  [252] = 252,
  [253] = 240,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 233,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 263,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 280,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 279,
  [302] = 288,
  [303] = 303,
  [304] = 277,
  [305] = 281,
  [306] = 286,
  [307] = 287,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 275,
  [313] = 308,
  [314] = 273,
  [315] = 315,
  [316] = 296,
  [317] = 290,
  [318] = 318,
  [319] = 276,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 267,
  [326] = 326,
  [327] = 318,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 303,
  [333] = 320,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 321,
  [338] = 338,
  [339] = 339,
  [340] = 293,
  [341] = 341,
  [342] = 299,
  [343] = 343,
  [344] = 309,
  [345] = 310,
  [346] = 346,
  [347] = 347,
  [348] = 341,
  [349] = 300,
  [350] = 346,
  [351] = 289,
  [352] = 294,
  [353] = 264,
  [354] = 315,
  [355] = 343,
  [356] = 322,
  [357] = 291,
  [358] = 358,
  [359] = 359,
  [360] = 268,
  [361] = 359,
  [362] = 311,
  [363] = 358,
  [364] = 347,
  [365] = 323,
  [366] = 265,
  [367] = 269,
  [368] = 295,
  [369] = 324,
  [370] = 329,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 371,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 382,
  [387] = 375,
  [388] = 388,
  [389] = 384,
  [390] = 381,
  [391] = 391,
  [392] = 392,
  [393] = 388,
  [394] = 394,
  [395] = 380,
  [396] = 394,
  [397] = 397,
  [398] = 397,
  [399] = 399,
  [400] = 400,
  [401] = 377,
  [402] = 399,
  [403] = 403,
  [404] = 379,
  [405] = 391,
  [406] = 383,
  [407] = 407,
  [408] = 408,
  [409] = 385,
  [410] = 392,
  [411] = 411,
  [412] = 373,
  [413] = 407,
  [414] = 411,
  [415] = 415,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(124);
      ADVANCE_MAP(
        '!', 13,
        '"', 133,
        '#', 115,
        '%', 156,
        '\'', 130,
        '(', 152,
        ')', 153,
        '*', 154,
        '+', 157,
        ',', 140,
        '-', 158,
        '.', 151,
        '/', 155,
        ':', 12,
        '<', 164,
        '=', 175,
        '>', 165,
        'F', 16,
        '[', 139,
        ']', 141,
        '`', 136,
        'a', 71,
        'b', 64,
        'c', 79,
        'e', 60,
        'f', 17,
        'i', 45,
        'm', 18,
        'n', 83,
        'o', 89,
        'r', 19,
        's', 41,
        '{', 7,
        '|', 171,
        '}', 117,
        '~', 161,
        'T', 90,
        't', 90,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == ' ') ADVANCE(69);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 13,
        '%', 156,
        '(', 152,
        ')', 153,
        '*', 154,
        '+', 157,
        ',', 140,
        '-', 159,
        '.', 151,
        '/', 155,
        ':', 12,
        '<', 164,
        '=', 14,
        '>', 165,
        '[', 139,
        ']', 141,
        'a', 71,
        'i', 50,
        'o', 89,
        '|', 171,
        '}', 117,
        '~', 161,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 13,
        '%', 156,
        ')', 153,
        '*', 154,
        '+', 157,
        ',', 140,
        '-', 159,
        '.', 151,
        '/', 155,
        '<', 164,
        '=', 175,
        '>', 165,
        '[', 139,
        ']', 141,
        'a', 70,
        'i', 72,
        'o', 89,
        '|', 171,
        '}', 117,
        '~', 161,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '"', 133,
        '#', 115,
        '\'', 130,
        '+', 122,
        '-', 8,
        'F', 16,
        '`', 136,
        'b', 64,
        'c', 79,
        'e', 60,
        'f', 17,
        'i', 46,
        'm', 18,
        'r', 19,
        's', 41,
        'T', 90,
        't', 90,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '"', 133,
        '\'', 130,
        '(', 152,
        ')', 153,
        '+', 122,
        ',', 140,
        '-', 160,
        '.', 151,
        ':', 12,
        '=', 174,
        '[', 139,
        ']', 141,
        '`', 136,
        'n', 145,
        'F', 142,
        'f', 142,
        'T', 146,
        't', 146,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(5);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('_' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(133);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(135);
      if (lookahead != 0) ADVANCE(134);
      END_STATE();
    case 7:
      if (lookahead == '#') ADVANCE(178);
      if (lookahead == '%') ADVANCE(188);
      if (lookahead == '{') ADVANCE(184);
      END_STATE();
    case 8:
      if (lookahead == '#') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 9:
      if (lookahead == '%') ADVANCE(119);
      END_STATE();
    case 10:
      if (lookahead == '%') ADVANCE(116);
      if (lookahead == '(') ADVANCE(152);
      if (lookahead == ')') ADVANCE(153);
      if (lookahead == '-') ADVANCE(9);
      if (lookahead == '[') ADVANCE(139);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 11:
      if (lookahead == '\'') ADVANCE(130);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(132);
      if (lookahead != 0) ADVANCE(131);
      END_STATE();
    case 12:
      if (lookahead == ':') ADVANCE(176);
      END_STATE();
    case 13:
      if (lookahead == '=') ADVANCE(163);
      END_STATE();
    case 14:
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 15:
      if (lookahead == '`') ADVANCE(136);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(138);
      if (lookahead != 0) ADVANCE(137);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(61);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(61);
      if (lookahead == 'i') ADVANCE(67);
      if (lookahead == 'o') ADVANCE(91);
      END_STATE();
    case 18:
      if (lookahead == 'a') ADVANCE(28);
      END_STATE();
    case 19:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(114);
      END_STATE();
    case 21:
      if (lookahead == 'a') ADVANCE(58);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(62);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(30);
      END_STATE();
    case 24:
      if (lookahead == 'b') ADVANCE(65);
      if (lookahead == 'f') ADVANCE(56);
      if (lookahead == 'i') ADVANCE(48);
      if (lookahead == 'm') ADVANCE(23);
      if (lookahead == 'r') ADVANCE(20);
      END_STATE();
    case 25:
      if (lookahead == 'b') ADVANCE(22);
      END_STATE();
    case 26:
      if (lookahead == 'c') ADVANCE(57);
      END_STATE();
    case 27:
      if (lookahead == 'c') ADVANCE(59);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(95);
      END_STATE();
    case 29:
      if (lookahead == 'c') ADVANCE(63);
      END_STATE();
    case 30:
      if (lookahead == 'c') ADVANCE(98);
      END_STATE();
    case 31:
      if (lookahead == 'd') ADVANCE(169);
      END_STATE();
    case 32:
      if (lookahead == 'd') ADVANCE(24);
      END_STATE();
    case 33:
      if (lookahead == 'd') ADVANCE(99);
      END_STATE();
    case 34:
      if (lookahead == 'd') ADVANCE(39);
      END_STATE();
    case 35:
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 37:
      if (lookahead == 'e') ADVANCE(1);
      END_STATE();
    case 38:
      if (lookahead == 'e') ADVANCE(199);
      END_STATE();
    case 39:
      if (lookahead == 'e') ADVANCE(202);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(75);
      END_STATE();
    case 41:
      if (lookahead == 'e') ADVANCE(104);
      END_STATE();
    case 42:
      if (lookahead == 'e') ADVANCE(21);
      END_STATE();
    case 43:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 44:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 45:
      if (lookahead == 'f') ADVANCE(190);
      if (lookahead == 'g') ADVANCE(76);
      if (lookahead == 'm') ADVANCE(88);
      if (lookahead == 'n') ADVANCE(168);
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 46:
      if (lookahead == 'f') ADVANCE(190);
      if (lookahead == 'm') ADVANCE(88);
      if (lookahead == 'n') ADVANCE(29);
      END_STATE();
    case 47:
      if (lookahead == 'f') ADVANCE(194);
      END_STATE();
    case 48:
      if (lookahead == 'f') ADVANCE(193);
      END_STATE();
    case 49:
      if (lookahead == 'g') ADVANCE(203);
      END_STATE();
    case 50:
      if (lookahead == 'g') ADVANCE(76);
      if (lookahead == 'n') ADVANCE(168);
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 51:
      if (lookahead == 'g') ADVANCE(66);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(47);
      if (lookahead == 's') ADVANCE(35);
      END_STATE();
    case 53:
      if (lookahead == 'i') ADVANCE(100);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(78);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(74);
      END_STATE();
    case 56:
      if (lookahead == 'i') ADVANCE(68);
      if (lookahead == 'o') ADVANCE(92);
      END_STATE();
    case 57:
      if (lookahead == 'k') ADVANCE(211);
      END_STATE();
    case 58:
      if (lookahead == 'k') ADVANCE(198);
      END_STATE();
    case 59:
      if (lookahead == 'k') ADVANCE(212);
      END_STATE();
    case 60:
      if (lookahead == 'l') ADVANCE(52);
      if (lookahead == 'n') ADVANCE(32);
      if (lookahead == 'x') ADVANCE(107);
      END_STATE();
    case 61:
      if (lookahead == 'l') ADVANCE(101);
      END_STATE();
    case 62:
      if (lookahead == 'l') ADVANCE(201);
      END_STATE();
    case 63:
      if (lookahead == 'l') ADVANCE(110);
      END_STATE();
    case 64:
      if (lookahead == 'l') ADVANCE(84);
      if (lookahead == 'r') ADVANCE(42);
      END_STATE();
    case 65:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(81);
      END_STATE();
    case 67:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 68:
      if (lookahead == 'l') ADVANCE(109);
      END_STATE();
    case 69:
      if (lookahead == 'm') ADVANCE(53);
      END_STATE();
    case 70:
      if (lookahead == 'n') ADVANCE(31);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(31);
      if (lookahead == 's') ADVANCE(205);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(168);
      if (lookahead == 's') ADVANCE(177);
      END_STATE();
    case 73:
      if (lookahead == 'n') ADVANCE(145);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(49);
      END_STATE();
    case 75:
      if (lookahead == 'n') ADVANCE(33);
      END_STATE();
    case 76:
      if (lookahead == 'n') ADVANCE(86);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 78:
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 79:
      if (lookahead == 'o') ADVANCE(77);
      END_STATE();
    case 80:
      if (lookahead == 'o') ADVANCE(207);
      END_STATE();
    case 81:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 82:
      if (lookahead == 'o') ADVANCE(208);
      END_STATE();
    case 83:
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 84:
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 85:
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 86:
      if (lookahead == 'o') ADVANCE(97);
      END_STATE();
    case 87:
      if (lookahead == 'o') ADVANCE(96);
      END_STATE();
    case 88:
      if (lookahead == 'p') ADVANCE(87);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(170);
      END_STATE();
    case 90:
      if (lookahead == 'r') ADVANCE(111);
      END_STATE();
    case 91:
      if (lookahead == 'r') ADVANCE(196);
      END_STATE();
    case 92:
      if (lookahead == 'r') ADVANCE(197);
      END_STATE();
    case 93:
      if (lookahead == 'r') ADVANCE(209);
      END_STATE();
    case 94:
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 95:
      if (lookahead == 'r') ADVANCE(80);
      END_STATE();
    case 96:
      if (lookahead == 'r') ADVANCE(106);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(37);
      END_STATE();
    case 98:
      if (lookahead == 'r') ADVANCE(82);
      END_STATE();
    case 99:
      if (lookahead == 's') ADVANCE(206);
      END_STATE();
    case 100:
      if (lookahead == 's') ADVANCE(102);
      END_STATE();
    case 101:
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 102:
      if (lookahead == 's') ADVANCE(55);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(172);
      END_STATE();
    case 104:
      if (lookahead == 't') ADVANCE(200);
      END_STATE();
    case 105:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 106:
      if (lookahead == 't') ADVANCE(204);
      END_STATE();
    case 107:
      if (lookahead == 't') ADVANCE(40);
      END_STATE();
    case 108:
      if (lookahead == 't') ADVANCE(43);
      END_STATE();
    case 109:
      if (lookahead == 't') ADVANCE(44);
      END_STATE();
    case 110:
      if (lookahead == 'u') ADVANCE(34);
      END_STATE();
    case 111:
      if (lookahead == 'u') ADVANCE(36);
      END_STATE();
    case 112:
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 113:
      if (lookahead == 'w') ADVANCE(213);
      END_STATE();
    case 114:
      if (lookahead == 'w') ADVANCE(214);
      END_STATE();
    case 115:
      if (lookahead == '}') ADVANCE(182);
      END_STATE();
    case 116:
      if (lookahead == '}') ADVANCE(191);
      END_STATE();
    case 117:
      if (lookahead == '}') ADVANCE(186);
      END_STATE();
    case 118:
      if (lookahead == '}') ADVANCE(183);
      END_STATE();
    case 119:
      if (lookahead == '}') ADVANCE(192);
      END_STATE();
    case 120:
      if (lookahead == '}') ADVANCE(187);
      END_STATE();
    case 121:
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(180);
      if (lookahead != 0 &&
          lookahead != '#') ADVANCE(181);
      END_STATE();
    case 122:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 123:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_bool);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_bool);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_number);
      if (lookahead == '.') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(129);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(132);
      if (lookahead != 0 &&
          lookahead != '\'') ADVANCE(131);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym_string_token2);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(135);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(134);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_BQUOTE);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(aux_sym_string_token3);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(aux_sym_string_token3);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(138);
      if (lookahead != 0 &&
          lookahead != '`') ADVANCE(137);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(144);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'l') ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(149);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(173);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '}') ADVANCE(191);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '#') ADVANCE(118);
      if (lookahead == '%') ADVANCE(119);
      if (lookahead == '}') ADVANCE(120);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '%') ADVANCE(119);
      if (lookahead == '}') ADVANCE(120);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(128);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(166);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(167);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_not);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(150);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(162);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(anon_sym_LBRACE_POUND);
      if (lookahead == '-') ADVANCE(179);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(anon_sym_LBRACE_POUND_DASH);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(aux_sym_comment_tag_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(180);
      if (lookahead != 0 &&
          lookahead != '#') ADVANCE(181);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(aux_sym_comment_tag_token1);
      if (lookahead != 0 &&
          lookahead != '#') ADVANCE(181);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_POUND_RBRACE);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(anon_sym_DASH_POUND_RBRACE);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE);
      if (lookahead == '-') ADVANCE(185);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(anon_sym_LBRACE_LBRACE_DASH);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(anon_sym_RBRACE_RBRACE);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(anon_sym_DASH_RBRACE_RBRACE);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(anon_sym_LBRACE_PERCENT);
      if (lookahead == '-') ADVANCE(189);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(anon_sym_LBRACE_PERCENT_DASH);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_PERCENT_RBRACE);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(anon_sym_DASH_PERCENT_RBRACE);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(anon_sym_endif);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(anon_sym_endfor);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(anon_sym_set);
      if (lookahead == '_') ADVANCE(51);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_set_global);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_include);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(anon_sym_ignoremissing);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_macro);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(anon_sym_endmacro);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(anon_sym_filter);
      END_STATE();
    case 210:
      ACCEPT_TOKEN(anon_sym_endfilter);
      END_STATE();
    case 211:
      ACCEPT_TOKEN(anon_sym_block);
      END_STATE();
    case 212:
      ACCEPT_TOKEN(anon_sym_endblock);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_raw);
      END_STATE();
    case 214:
      ACCEPT_TOKEN(anon_sym_endraw);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 0, .external_lex_state = 1},
  [2] = {.lex_state = 2},
  [3] = {.lex_state = 3},
  [4] = {.lex_state = 3},
  [5] = {.lex_state = 3},
  [6] = {.lex_state = 2},
  [7] = {.lex_state = 2},
  [8] = {.lex_state = 3},
  [9] = {.lex_state = 2},
  [10] = {.lex_state = 0, .external_lex_state = 2},
  [11] = {.lex_state = 2},
  [12] = {.lex_state = 3},
  [13] = {.lex_state = 0, .external_lex_state = 2},
  [14] = {.lex_state = 0, .external_lex_state = 2},
  [15] = {.lex_state = 2},
  [16] = {.lex_state = 0, .external_lex_state = 2},
  [17] = {.lex_state = 2},
  [18] = {.lex_state = 2},
  [19] = {.lex_state = 2},
  [20] = {.lex_state = 2},
  [21] = {.lex_state = 2},
  [22] = {.lex_state = 2},
  [23] = {.lex_state = 2},
  [24] = {.lex_state = 2},
  [25] = {.lex_state = 2},
  [26] = {.lex_state = 2},
  [27] = {.lex_state = 0, .external_lex_state = 1},
  [28] = {.lex_state = 0, .external_lex_state = 1},
  [29] = {.lex_state = 0, .external_lex_state = 2},
  [30] = {.lex_state = 0, .external_lex_state = 2},
  [31] = {.lex_state = 0, .external_lex_state = 2},
  [32] = {.lex_state = 0, .external_lex_state = 2},
  [33] = {.lex_state = 0, .external_lex_state = 2},
  [34] = {.lex_state = 0, .external_lex_state = 2},
  [35] = {.lex_state = 0, .external_lex_state = 2},
  [36] = {.lex_state = 0, .external_lex_state = 1},
  [37] = {.lex_state = 0, .external_lex_state = 2},
  [38] = {.lex_state = 0, .external_lex_state = 2},
  [39] = {.lex_state = 0, .external_lex_state = 2},
  [40] = {.lex_state = 0, .external_lex_state = 2},
  [41] = {.lex_state = 0, .external_lex_state = 2},
  [42] = {.lex_state = 2},
  [43] = {.lex_state = 0, .external_lex_state = 2},
  [44] = {.lex_state = 0, .external_lex_state = 2},
  [45] = {.lex_state = 0, .external_lex_state = 2},
  [46] = {.lex_state = 0, .external_lex_state = 2},
  [47] = {.lex_state = 2},
  [48] = {.lex_state = 0, .external_lex_state = 2},
  [49] = {.lex_state = 0, .external_lex_state = 2},
  [50] = {.lex_state = 0, .external_lex_state = 2},
  [51] = {.lex_state = 0, .external_lex_state = 2},
  [52] = {.lex_state = 0, .external_lex_state = 2},
  [53] = {.lex_state = 0, .external_lex_state = 2},
  [54] = {.lex_state = 0, .external_lex_state = 2},
  [55] = {.lex_state = 0, .external_lex_state = 2},
  [56] = {.lex_state = 2},
  [57] = {.lex_state = 2},
  [58] = {.lex_state = 0, .external_lex_state = 2},
  [59] = {.lex_state = 0, .external_lex_state = 2},
  [60] = {.lex_state = 0, .external_lex_state = 2},
  [61] = {.lex_state = 0, .external_lex_state = 2},
  [62] = {.lex_state = 0, .external_lex_state = 2},
  [63] = {.lex_state = 2},
  [64] = {.lex_state = 0, .external_lex_state = 2},
  [65] = {.lex_state = 0, .external_lex_state = 2},
  [66] = {.lex_state = 0, .external_lex_state = 2},
  [67] = {.lex_state = 5},
  [68] = {.lex_state = 5},
  [69] = {.lex_state = 5},
  [70] = {.lex_state = 5},
  [71] = {.lex_state = 5},
  [72] = {.lex_state = 5},
  [73] = {.lex_state = 5},
  [74] = {.lex_state = 5},
  [75] = {.lex_state = 5},
  [76] = {.lex_state = 5},
  [77] = {.lex_state = 5},
  [78] = {.lex_state = 5},
  [79] = {.lex_state = 5},
  [80] = {.lex_state = 5},
  [81] = {.lex_state = 5},
  [82] = {.lex_state = 5},
  [83] = {.lex_state = 5},
  [84] = {.lex_state = 5},
  [85] = {.lex_state = 5},
  [86] = {.lex_state = 5},
  [87] = {.lex_state = 5},
  [88] = {.lex_state = 5},
  [89] = {.lex_state = 5},
  [90] = {.lex_state = 2},
  [91] = {.lex_state = 2},
  [92] = {.lex_state = 2},
  [93] = {.lex_state = 2},
  [94] = {.lex_state = 2},
  [95] = {.lex_state = 2},
  [96] = {.lex_state = 2},
  [97] = {.lex_state = 2},
  [98] = {.lex_state = 2},
  [99] = {.lex_state = 2},
  [100] = {.lex_state = 2},
  [101] = {.lex_state = 2},
  [102] = {.lex_state = 2},
  [103] = {.lex_state = 2},
  [104] = {.lex_state = 2},
  [105] = {.lex_state = 2},
  [106] = {.lex_state = 2},
  [107] = {.lex_state = 4},
  [108] = {.lex_state = 4},
  [109] = {.lex_state = 4},
  [110] = {.lex_state = 4},
  [111] = {.lex_state = 4},
  [112] = {.lex_state = 4},
  [113] = {.lex_state = 4},
  [114] = {.lex_state = 4},
  [115] = {.lex_state = 4},
  [116] = {.lex_state = 4},
  [117] = {.lex_state = 4},
  [118] = {.lex_state = 4},
  [119] = {.lex_state = 4},
  [120] = {.lex_state = 4},
  [121] = {.lex_state = 4},
  [122] = {.lex_state = 4},
  [123] = {.lex_state = 4},
  [124] = {.lex_state = 4},
  [125] = {.lex_state = 4},
  [126] = {.lex_state = 4},
  [127] = {.lex_state = 4},
  [128] = {.lex_state = 4},
  [129] = {.lex_state = 4},
  [130] = {.lex_state = 4},
  [131] = {.lex_state = 4},
  [132] = {.lex_state = 4},
  [133] = {.lex_state = 4},
  [134] = {.lex_state = 4},
  [135] = {.lex_state = 4},
  [136] = {.lex_state = 4},
  [137] = {.lex_state = 0, .external_lex_state = 1},
  [138] = {.lex_state = 0, .external_lex_state = 2},
  [139] = {.lex_state = 0, .external_lex_state = 2},
  [140] = {.lex_state = 0, .external_lex_state = 2},
  [141] = {.lex_state = 0, .external_lex_state = 2},
  [142] = {.lex_state = 0, .external_lex_state = 2},
  [143] = {.lex_state = 0, .external_lex_state = 2},
  [144] = {.lex_state = 0, .external_lex_state = 2},
  [145] = {.lex_state = 0, .external_lex_state = 2},
  [146] = {.lex_state = 0, .external_lex_state = 2},
  [147] = {.lex_state = 0, .external_lex_state = 2},
  [148] = {.lex_state = 0, .external_lex_state = 2},
  [149] = {.lex_state = 0, .external_lex_state = 2},
  [150] = {.lex_state = 0, .external_lex_state = 2},
  [151] = {.lex_state = 0, .external_lex_state = 2},
  [152] = {.lex_state = 0, .external_lex_state = 2},
  [153] = {.lex_state = 0, .external_lex_state = 2},
  [154] = {.lex_state = 0, .external_lex_state = 2},
  [155] = {.lex_state = 0, .external_lex_state = 2},
  [156] = {.lex_state = 0, .external_lex_state = 2},
  [157] = {.lex_state = 0, .external_lex_state = 2},
  [158] = {.lex_state = 0, .external_lex_state = 2},
  [159] = {.lex_state = 0, .external_lex_state = 1},
  [160] = {.lex_state = 0, .external_lex_state = 1},
  [161] = {.lex_state = 0, .external_lex_state = 1},
  [162] = {.lex_state = 0, .external_lex_state = 1},
  [163] = {.lex_state = 0, .external_lex_state = 1},
  [164] = {.lex_state = 0, .external_lex_state = 1},
  [165] = {.lex_state = 0, .external_lex_state = 1},
  [166] = {.lex_state = 10},
  [167] = {.lex_state = 0, .external_lex_state = 1},
  [168] = {.lex_state = 0, .external_lex_state = 1},
  [169] = {.lex_state = 0, .external_lex_state = 1},
  [170] = {.lex_state = 0, .external_lex_state = 1},
  [171] = {.lex_state = 0, .external_lex_state = 1},
  [172] = {.lex_state = 0, .external_lex_state = 1},
  [173] = {.lex_state = 0, .external_lex_state = 1},
  [174] = {.lex_state = 0, .external_lex_state = 1},
  [175] = {.lex_state = 0, .external_lex_state = 1},
  [176] = {.lex_state = 0, .external_lex_state = 1},
  [177] = {.lex_state = 0, .external_lex_state = 1},
  [178] = {.lex_state = 0, .external_lex_state = 1},
  [179] = {.lex_state = 0, .external_lex_state = 1},
  [180] = {.lex_state = 0, .external_lex_state = 1},
  [181] = {.lex_state = 0, .external_lex_state = 1},
  [182] = {.lex_state = 0, .external_lex_state = 1},
  [183] = {.lex_state = 0, .external_lex_state = 1},
  [184] = {.lex_state = 0, .external_lex_state = 1},
  [185] = {.lex_state = 0, .external_lex_state = 1},
  [186] = {.lex_state = 0, .external_lex_state = 1},
  [187] = {.lex_state = 0, .external_lex_state = 1},
  [188] = {.lex_state = 0, .external_lex_state = 1},
  [189] = {.lex_state = 0, .external_lex_state = 1},
  [190] = {.lex_state = 0, .external_lex_state = 1},
  [191] = {.lex_state = 0, .external_lex_state = 1},
  [192] = {.lex_state = 10},
  [193] = {.lex_state = 0, .external_lex_state = 2},
  [194] = {.lex_state = 0, .external_lex_state = 2},
  [195] = {.lex_state = 0, .external_lex_state = 2},
  [196] = {.lex_state = 0, .external_lex_state = 2},
  [197] = {.lex_state = 0, .external_lex_state = 2},
  [198] = {.lex_state = 0, .external_lex_state = 2},
  [199] = {.lex_state = 0, .external_lex_state = 2},
  [200] = {.lex_state = 0, .external_lex_state = 2},
  [201] = {.lex_state = 0, .external_lex_state = 2},
  [202] = {.lex_state = 0, .external_lex_state = 2},
  [203] = {.lex_state = 0, .external_lex_state = 2},
  [204] = {.lex_state = 0, .external_lex_state = 2},
  [205] = {.lex_state = 0, .external_lex_state = 2},
  [206] = {.lex_state = 0, .external_lex_state = 2},
  [207] = {.lex_state = 4},
  [208] = {.lex_state = 5},
  [209] = {.lex_state = 0},
  [210] = {.lex_state = 0},
  [211] = {.lex_state = 0},
  [212] = {.lex_state = 0},
  [213] = {.lex_state = 0},
  [214] = {.lex_state = 0},
  [215] = {.lex_state = 0},
  [216] = {.lex_state = 5},
  [217] = {.lex_state = 5},
  [218] = {.lex_state = 0},
  [219] = {.lex_state = 0},
  [220] = {.lex_state = 0},
  [221] = {.lex_state = 5},
  [222] = {.lex_state = 0},
  [223] = {.lex_state = 6},
  [224] = {.lex_state = 0},
  [225] = {.lex_state = 10},
  [226] = {.lex_state = 0},
  [227] = {.lex_state = 10},
  [228] = {.lex_state = 0},
  [229] = {.lex_state = 0},
  [230] = {.lex_state = 10},
  [231] = {.lex_state = 0},
  [232] = {.lex_state = 0},
  [233] = {.lex_state = 0},
  [234] = {.lex_state = 11},
  [235] = {.lex_state = 0},
  [236] = {.lex_state = 0},
  [237] = {.lex_state = 15},
  [238] = {.lex_state = 0},
  [239] = {.lex_state = 0},
  [240] = {.lex_state = 10},
  [241] = {.lex_state = 10},
  [242] = {.lex_state = 11},
  [243] = {.lex_state = 0},
  [244] = {.lex_state = 5},
  [245] = {.lex_state = 10},
  [246] = {.lex_state = 6},
  [247] = {.lex_state = 10},
  [248] = {.lex_state = 15},
  [249] = {.lex_state = 0},
  [250] = {.lex_state = 0},
  [251] = {.lex_state = 0},
  [252] = {.lex_state = 10},
  [253] = {.lex_state = 10},
  [254] = {.lex_state = 10},
  [255] = {.lex_state = 0},
  [256] = {.lex_state = 15},
  [257] = {.lex_state = 10},
  [258] = {.lex_state = 0},
  [259] = {.lex_state = 10},
  [260] = {.lex_state = 11},
  [261] = {.lex_state = 6},
  [262] = {.lex_state = 0},
  [263] = {.lex_state = 0},
  [264] = {.lex_state = 0},
  [265] = {.lex_state = 0},
  [266] = {.lex_state = 0},
  [267] = {.lex_state = 0},
  [268] = {.lex_state = 0},
  [269] = {.lex_state = 0},
  [270] = {.lex_state = 10},
  [271] = {.lex_state = 0},
  [272] = {.lex_state = 0},
  [273] = {.lex_state = 0},
  [274] = {.lex_state = 0},
  [275] = {.lex_state = 0},
  [276] = {.lex_state = 0},
  [277] = {.lex_state = 0},
  [278] = {.lex_state = 0},
  [279] = {.lex_state = 0},
  [280] = {.lex_state = 0},
  [281] = {.lex_state = 0},
  [282] = {.lex_state = 10},
  [283] = {.lex_state = 0},
  [284] = {.lex_state = 0},
  [285] = {.lex_state = 0},
  [286] = {.lex_state = 0},
  [287] = {.lex_state = 0},
  [288] = {.lex_state = 0},
  [289] = {.lex_state = 0},
  [290] = {.lex_state = 0},
  [291] = {.lex_state = 0},
  [292] = {.lex_state = 0},
  [293] = {.lex_state = 4},
  [294] = {.lex_state = 0},
  [295] = {.lex_state = 0},
  [296] = {.lex_state = 0},
  [297] = {.lex_state = 0},
  [298] = {.lex_state = 0},
  [299] = {.lex_state = 0},
  [300] = {.lex_state = 0},
  [301] = {.lex_state = 0},
  [302] = {.lex_state = 0},
  [303] = {.lex_state = 0},
  [304] = {.lex_state = 0},
  [305] = {.lex_state = 0},
  [306] = {.lex_state = 0},
  [307] = {.lex_state = 0},
  [308] = {.lex_state = 0},
  [309] = {.lex_state = 0},
  [310] = {.lex_state = 0},
  [311] = {.lex_state = 0},
  [312] = {.lex_state = 0},
  [313] = {.lex_state = 0},
  [314] = {.lex_state = 0},
  [315] = {.lex_state = 0},
  [316] = {.lex_state = 0},
  [317] = {.lex_state = 0},
  [318] = {.lex_state = 0},
  [319] = {.lex_state = 0},
  [320] = {.lex_state = 0},
  [321] = {.lex_state = 0},
  [322] = {.lex_state = 0},
  [323] = {.lex_state = 0},
  [324] = {.lex_state = 0},
  [325] = {.lex_state = 0},
  [326] = {.lex_state = 0},
  [327] = {.lex_state = 0},
  [328] = {.lex_state = 0},
  [329] = {.lex_state = 0},
  [330] = {.lex_state = 0},
  [331] = {.lex_state = 0},
  [332] = {.lex_state = 0},
  [333] = {.lex_state = 0},
  [334] = {.lex_state = 0},
  [335] = {.lex_state = 0},
  [336] = {.lex_state = 0},
  [337] = {.lex_state = 0},
  [338] = {.lex_state = 0},
  [339] = {.lex_state = 73},
  [340] = {.lex_state = 4},
  [341] = {.lex_state = 0},
  [342] = {.lex_state = 0},
  [343] = {.lex_state = 0},
  [344] = {.lex_state = 0},
  [345] = {.lex_state = 0},
  [346] = {.lex_state = 0},
  [347] = {.lex_state = 0},
  [348] = {.lex_state = 0},
  [349] = {.lex_state = 0},
  [350] = {.lex_state = 0},
  [351] = {.lex_state = 0},
  [352] = {.lex_state = 0},
  [353] = {.lex_state = 0},
  [354] = {.lex_state = 0},
  [355] = {.lex_state = 0},
  [356] = {.lex_state = 0},
  [357] = {.lex_state = 0},
  [358] = {.lex_state = 0},
  [359] = {.lex_state = 0},
  [360] = {.lex_state = 0},
  [361] = {.lex_state = 0},
  [362] = {.lex_state = 0},
  [363] = {.lex_state = 0},
  [364] = {.lex_state = 0},
  [365] = {.lex_state = 0},
  [366] = {.lex_state = 0},
  [367] = {.lex_state = 0},
  [368] = {.lex_state = 0},
  [369] = {.lex_state = 0},
  [370] = {.lex_state = 0},
  [371] = {.lex_state = 10},
  [372] = {.lex_state = 0},
  [373] = {.lex_state = 0},
  [374] = {.lex_state = 10},
  [375] = {.lex_state = 10},
  [376] = {.lex_state = 10},
  [377] = {.lex_state = 0},
  [378] = {.lex_state = 5},
  [379] = {.lex_state = 10},
  [380] = {.lex_state = 10},
  [381] = {.lex_state = 0},
  [382] = {.lex_state = 10},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 0},
  [385] = {.lex_state = 10},
  [386] = {.lex_state = 10},
  [387] = {.lex_state = 10},
  [388] = {.lex_state = 121},
  [389] = {.lex_state = 0},
  [390] = {.lex_state = 0},
  [391] = {.lex_state = 0},
  [392] = {.lex_state = 0},
  [393] = {.lex_state = 121},
  [394] = {.lex_state = 0},
  [395] = {.lex_state = 10},
  [396] = {.lex_state = 0},
  [397] = {.lex_state = 0},
  [398] = {.lex_state = 0},
  [399] = {.lex_state = 0},
  [400] = {.lex_state = 10},
  [401] = {.lex_state = 0},
  [402] = {.lex_state = 0},
  [403] = {.lex_state = 10},
  [404] = {.lex_state = 10},
  [405] = {.lex_state = 0},
  [406] = {.lex_state = 0},
  [407] = {.lex_state = 10},
  [408] = {.lex_state = 0},
  [409] = {.lex_state = 10},
  [410] = {.lex_state = 0},
  [411] = {.lex_state = 10},
  [412] = {.lex_state = 0},
  [413] = {.lex_state = 10},
  [414] = {.lex_state = 10},
  [415] = {.lex_state = 10},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_bool] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_BQUOTE] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_LBRACE_POUND] = ACTIONS(1),
    [anon_sym_LBRACE_POUND_DASH] = ACTIONS(1),
    [anon_sym_POUND_RBRACE] = ACTIONS(1),
    [anon_sym_DASH_POUND_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(1),
    [anon_sym_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_DASH_RBRACE_RBRACE] = ACTIONS(1),
    [anon_sym_LBRACE_PERCENT] = ACTIONS(1),
    [anon_sym_LBRACE_PERCENT_DASH] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_PERCENT_RBRACE] = ACTIONS(1),
    [anon_sym_DASH_PERCENT_RBRACE] = ACTIONS(1),
    [anon_sym_endif] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_endfor] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_set_global] = ACTIONS(1),
    [anon_sym_ignoremissing] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_macro] = ACTIONS(1),
    [anon_sym_endmacro] = ACTIONS(1),
    [anon_sym_filter] = ACTIONS(1),
    [anon_sym_endfilter] = ACTIONS(1),
    [anon_sym_block] = ACTIONS(1),
    [anon_sym_endblock] = ACTIONS(1),
    [anon_sym_raw] = ACTIONS(1),
    [anon_sym_endraw] = ACTIONS(1),
    [sym_frontmatter_delimiter] = ACTIONS(1),
    [sym_content] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(408),
    [sym_frontmatter] = STATE(29),
    [sym__template] = STATE(37),
    [sym_comment_tag] = STATE(37),
    [sym_expression_tag] = STATE(37),
    [sym__statement_tag] = STATE(37),
    [sym_if_statement] = STATE(37),
    [sym_for_statement] = STATE(37),
    [sym_for_break_statement] = STATE(37),
    [sym_for_continue_statement] = STATE(37),
    [sym_set_statement] = STATE(37),
    [sym_include_statement] = STATE(37),
    [sym_import_statement] = STATE(37),
    [sym_extends_statement] = STATE(37),
    [sym_macro_statement] = STATE(37),
    [sym_filter_statement] = STATE(37),
    [sym_block_statement] = STATE(37),
    [sym_raw_statement] = STATE(37),
    [aux_sym_source_file_repeat1] = STATE(37),
    [ts_builtin_sym_end] = ACTIONS(3),
    [anon_sym_LBRACE_POUND] = ACTIONS(5),
    [anon_sym_LBRACE_POUND_DASH] = ACTIONS(7),
    [anon_sym_LBRACE_LBRACE] = ACTIONS(9),
    [anon_sym_LBRACE_LBRACE_DASH] = ACTIONS(11),
    [anon_sym_LBRACE_PERCENT] = ACTIONS(13),
    [anon_sym_LBRACE_PERCENT_DASH] = ACTIONS(15),
    [sym_frontmatter_delimiter] = ACTIONS(17),
    [sym_content] = ACTIONS(19),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 8,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_DOT,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    STATE(5), 1,
      aux_sym_member_expression_repeat1,
    STATE(18), 1,
      sym_argument_list,
    ACTIONS(29), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(23), 20,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [47] = 3,
    STATE(4), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(35), 5,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(33), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [82] = 5,
    ACTIONS(37), 1,
      anon_sym_LBRACK,
    ACTIONS(42), 1,
      anon_sym_DOT,
    STATE(4), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(45), 5,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(40), 20,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [121] = 3,
    STATE(4), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(35), 5,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(33), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [156] = 5,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_DOT,
    STATE(3), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(29), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(23), 20,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [194] = 2,
    ACTIONS(49), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(47), 23,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_ignoremissing,
  [226] = 2,
    ACTIONS(53), 5,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(51), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [258] = 2,
    ACTIONS(57), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(55), 23,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_ignoremissing,
  [290] = 10,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(59), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(61), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(63), 1,
      sym_content,
    STATE(348), 1,
      sym_else_clause,
    STATE(214), 2,
      sym_elif_clause,
      aux_sym_if_statement_repeat1,
    STATE(14), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [338] = 2,
    ACTIONS(67), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(65), 23,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_ignoremissing,
  [370] = 2,
    ACTIONS(71), 5,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_EQ,
    ACTIONS(69), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [402] = 10,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(73), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(75), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(77), 1,
      sym_content,
    STATE(346), 1,
      sym_else_clause,
    STATE(212), 2,
      sym_elif_clause,
      aux_sym_if_statement_repeat1,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [450] = 10,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(79), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(81), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(350), 1,
      sym_else_clause,
    STATE(213), 2,
      sym_elif_clause,
      aux_sym_if_statement_repeat1,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [498] = 2,
    ACTIONS(85), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(83), 23,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_ignoremissing,
  [530] = 10,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(87), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(89), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(91), 1,
      sym_content,
    STATE(341), 1,
      sym_else_clause,
    STATE(211), 2,
      sym_elif_clause,
      aux_sym_if_statement_repeat1,
    STATE(13), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [578] = 2,
    ACTIONS(95), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(93), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [609] = 2,
    ACTIONS(99), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(97), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [640] = 2,
    ACTIONS(103), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(101), 22,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_ignoremissing,
      anon_sym_as,
  [671] = 2,
    ACTIONS(107), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(105), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [702] = 4,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(47), 1,
      sym_argument_list,
    ACTIONS(111), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(109), 20,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [737] = 2,
    ACTIONS(115), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(113), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [768] = 2,
    ACTIONS(119), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(117), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [799] = 2,
    ACTIONS(123), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(121), 22,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
      anon_sym_ignoremissing,
      anon_sym_as,
  [830] = 2,
    ACTIONS(127), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(125), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [861] = 2,
    ACTIONS(131), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(129), 22,
      anon_sym_LBRACK,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DOT,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [892] = 9,
    ACTIONS(133), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(135), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(137), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(139), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(141), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(143), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(145), 1,
      sym_frontmatter_delimiter,
    ACTIONS(147), 1,
      sym_content,
    STATE(36), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [936] = 9,
    ACTIONS(133), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(135), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(137), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(139), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(141), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(143), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(149), 1,
      sym_frontmatter_delimiter,
    ACTIONS(151), 1,
      sym_content,
    STATE(27), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [980] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(13), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(15), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(153), 1,
      ts_builtin_sym_end,
    ACTIONS(155), 1,
      sym_content,
    STATE(30), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1024] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(13), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(15), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(157), 1,
      ts_builtin_sym_end,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1068] = 9,
    ACTIONS(159), 1,
      ts_builtin_sym_end,
    ACTIONS(161), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(164), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(167), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(170), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(173), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(176), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(179), 1,
      sym_content,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1112] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(182), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(184), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(186), 1,
      sym_content,
    STATE(294), 1,
      sym_else_clause,
    STATE(33), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1156] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(188), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(190), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(264), 1,
      sym_else_clause,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1200] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(192), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(194), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(196), 1,
      sym_content,
    STATE(315), 1,
      sym_else_clause,
    STATE(35), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1244] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(198), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(200), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(343), 1,
      sym_else_clause,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1288] = 9,
    ACTIONS(159), 1,
      sym_frontmatter_delimiter,
    ACTIONS(202), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(205), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(208), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(211), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(214), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(217), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(220), 1,
      sym_content,
    STATE(36), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1332] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(13), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(15), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(153), 1,
      ts_builtin_sym_end,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1376] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(223), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(225), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(227), 1,
      sym_content,
    STATE(352), 1,
      sym_else_clause,
    STATE(39), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1420] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(229), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(231), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(353), 1,
      sym_else_clause,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1464] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(233), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(235), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(237), 1,
      sym_content,
    STATE(354), 1,
      sym_else_clause,
    STATE(41), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1508] = 9,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(239), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(241), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(355), 1,
      sym_else_clause,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1552] = 2,
    ACTIONS(245), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(243), 20,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [1581] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(247), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(249), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(251), 1,
      sym_content,
    STATE(51), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1622] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(253), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(255), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(257), 1,
      sym_content,
    STATE(50), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1663] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(259), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(261), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1704] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(263), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(265), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(267), 1,
      sym_content,
    STATE(49), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1745] = 2,
    ACTIONS(271), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(269), 20,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [1774] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(273), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(275), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(277), 1,
      sym_content,
    STATE(45), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1815] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(279), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(281), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1856] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(283), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(285), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1897] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(287), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(289), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1938] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(13), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(15), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(291), 1,
      sym_content,
    STATE(54), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [1979] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(13), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(15), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(293), 1,
      sym_content,
    STATE(55), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2020] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(295), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(297), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2061] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(299), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(301), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2102] = 2,
    ACTIONS(305), 4,
      anon_sym_PERCENT,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(303), 20,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_PIPE,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [2131] = 5,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(305), 3,
      anon_sym_DASH,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(303), 17,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_TILDE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [2166] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(313), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(315), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(317), 1,
      sym_content,
    STATE(60), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2207] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(319), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(321), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(323), 1,
      sym_content,
    STATE(62), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2248] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(325), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(327), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2289] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(329), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(331), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(333), 1,
      sym_content,
    STATE(64), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2330] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(335), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(337), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2371] = 7,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(305), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(303), 15,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_RPAREN,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
      anon_sym_is,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [2410] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(343), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(345), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2451] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(347), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(349), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    ACTIONS(351), 1,
      sym_content,
    STATE(66), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2492] = 8,
    ACTIONS(5), 1,
      anon_sym_LBRACE_POUND,
    ACTIONS(7), 1,
      anon_sym_LBRACE_POUND_DASH,
    ACTIONS(9), 1,
      anon_sym_LBRACE_LBRACE,
    ACTIONS(11), 1,
      anon_sym_LBRACE_LBRACE_DASH,
    ACTIONS(77), 1,
      sym_content,
    ACTIONS(353), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(355), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(31), 17,
      sym__template,
      sym_comment_tag,
      sym_expression_tag,
      sym__statement_tag,
      sym_if_statement,
      sym_for_statement,
      sym_for_break_statement,
      sym_for_continue_statement,
      sym_set_statement,
      sym_include_statement,
      sym_import_statement,
      sym_extends_statement,
      sym_macro_statement,
      sym_filter_statement,
      sym_block_statement,
      sym_raw_statement,
      aux_sym_source_file_repeat1,
  [2533] = 11,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(367), 1,
      anon_sym_RBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(357), 2,
      sym_bool,
      sym_number,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(98), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2577] = 11,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(375), 1,
      anon_sym_RBRACK,
    ACTIONS(357), 2,
      sym_bool,
      sym_number,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(98), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2621] = 11,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    STATE(363), 1,
      sym_test_expression,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(377), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(93), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2665] = 11,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    STATE(284), 1,
      sym_test_expression,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(379), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(92), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2709] = 11,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(383), 1,
      anon_sym_RBRACK,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(381), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(90), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2753] = 11,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    STATE(358), 1,
      sym_test_expression,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(385), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(91), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2797] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(387), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(42), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2838] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(389), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(101), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2879] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(391), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(103), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2920] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(393), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(94), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [2961] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(395), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(96), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3002] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(397), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(56), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3043] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(399), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(99), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3084] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(401), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(95), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3125] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(403), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(105), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3166] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(405), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(104), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3207] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(407), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(97), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3248] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(409), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(57), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3289] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(411), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(63), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3330] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(413), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(102), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3371] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(415), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(106), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3412] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    ACTIONS(417), 2,
      sym_bool,
      sym_number,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(100), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3453] = 10,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(369), 1,
      sym_identifier,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(357), 2,
      sym_bool,
      sym_number,
    ACTIONS(373), 2,
      anon_sym_DASH,
      anon_sym_not,
    STATE(6), 4,
      sym_array,
      sym_member_expression,
      sym_parenthesized_expression,
      sym_call_expression,
    STATE(98), 6,
      sym_string,
      sym__literal,
      sym_binary_expression,
      sym_filter_expression,
      sym_unary_expression,
      sym__value,
  [3494] = 8,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(419), 1,
      anon_sym_COMMA,
    ACTIONS(421), 1,
      anon_sym_RBRACK,
    STATE(243), 1,
      aux_sym_array_repeat1,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(307), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(339), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3530] = 9,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(427), 1,
      anon_sym_is,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(429), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3568] = 9,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(427), 1,
      anon_sym_is,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(431), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3606] = 9,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(427), 1,
      anon_sym_is,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(433), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3644] = 6,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(435), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(307), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(339), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3675] = 7,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(437), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(307), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3708] = 8,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(439), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3743] = 8,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(441), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3778] = 6,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(443), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(307), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(339), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3809] = 7,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(445), 2,
      anon_sym_RBRACE_RBRACE,
      anon_sym_DASH_RBRACE_RBRACE,
    ACTIONS(307), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3842] = 8,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(447), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3877] = 8,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(449), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3912] = 8,
    ACTIONS(309), 1,
      anon_sym_PERCENT,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(341), 1,
      anon_sym_DASH,
    ACTIONS(307), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(339), 2,
      anon_sym_PLUS,
      anon_sym_TILDE,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(451), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3947] = 6,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(453), 1,
      anon_sym_RPAREN,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(307), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(339), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [3977] = 6,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(455), 1,
      anon_sym_RPAREN,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(307), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(339), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [4007] = 6,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(457), 1,
      anon_sym_RBRACK,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(307), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(339), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [4037] = 6,
    ACTIONS(311), 1,
      anon_sym_PIPE,
    ACTIONS(459), 1,
      anon_sym_RPAREN,
    ACTIONS(425), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(307), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(339), 3,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_TILDE,
    ACTIONS(423), 7,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_in,
      anon_sym_and,
      anon_sym_or,
  [4067] = 16,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(463), 1,
      anon_sym_endif,
    ACTIONS(465), 1,
      anon_sym_elif,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
  [4116] = 16,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(465), 1,
      anon_sym_elif,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(493), 1,
      anon_sym_endif,
  [4165] = 16,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(465), 1,
      anon_sym_elif,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(495), 1,
      anon_sym_endif,
  [4214] = 16,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(465), 1,
      anon_sym_elif,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(497), 1,
      anon_sym_endif,
  [4263] = 15,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(499), 1,
      anon_sym_endfor,
  [4309] = 15,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(501), 1,
      anon_sym_endfor,
  [4355] = 15,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(503), 1,
      anon_sym_endfor,
  [4401] = 15,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(505), 1,
      anon_sym_endfor,
  [4447] = 15,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(507), 1,
      anon_sym_endfor,
  [4493] = 15,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(509), 1,
      anon_sym_endfor,
  [4539] = 15,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(511), 1,
      anon_sym_endfor,
  [4585] = 15,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(513), 1,
      anon_sym_endfor,
  [4631] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(515), 1,
      anon_sym_endraw,
  [4674] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(517), 1,
      anon_sym_endblock,
  [4717] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(519), 1,
      anon_sym_endraw,
  [4760] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(521), 1,
      anon_sym_endmacro,
  [4803] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(523), 1,
      anon_sym_endfilter,
  [4846] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(525), 1,
      anon_sym_endblock,
  [4889] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(527), 1,
      anon_sym_endmacro,
  [4932] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(529), 1,
      anon_sym_endraw,
  [4975] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(531), 1,
      anon_sym_endfilter,
  [5018] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(533), 1,
      anon_sym_endraw,
  [5061] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(535), 1,
      anon_sym_endfilter,
  [5104] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(537), 1,
      anon_sym_endmacro,
  [5147] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(539), 1,
      anon_sym_endmacro,
  [5190] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(541), 1,
      anon_sym_endfilter,
  [5233] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(543), 1,
      anon_sym_endblock,
  [5276] = 14,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
    ACTIONS(545), 1,
      anon_sym_endblock,
  [5319] = 13,
    ACTIONS(547), 1,
      anon_sym_if,
    ACTIONS(549), 1,
      anon_sym_for,
    ACTIONS(551), 1,
      anon_sym_break,
    ACTIONS(553), 1,
      anon_sym_continue,
    ACTIONS(555), 1,
      anon_sym_set,
    ACTIONS(557), 1,
      anon_sym_set_global,
    ACTIONS(559), 1,
      anon_sym_include,
    ACTIONS(561), 1,
      anon_sym_import,
    ACTIONS(563), 1,
      anon_sym_extends,
    ACTIONS(565), 1,
      anon_sym_macro,
    ACTIONS(567), 1,
      anon_sym_filter,
    ACTIONS(569), 1,
      anon_sym_block,
    ACTIONS(571), 1,
      anon_sym_raw,
  [5359] = 13,
    ACTIONS(461), 1,
      anon_sym_if,
    ACTIONS(469), 1,
      anon_sym_for,
    ACTIONS(471), 1,
      anon_sym_break,
    ACTIONS(473), 1,
      anon_sym_continue,
    ACTIONS(475), 1,
      anon_sym_set,
    ACTIONS(477), 1,
      anon_sym_set_global,
    ACTIONS(479), 1,
      anon_sym_include,
    ACTIONS(481), 1,
      anon_sym_import,
    ACTIONS(483), 1,
      anon_sym_extends,
    ACTIONS(485), 1,
      anon_sym_macro,
    ACTIONS(487), 1,
      anon_sym_filter,
    ACTIONS(489), 1,
      anon_sym_block,
    ACTIONS(491), 1,
      anon_sym_raw,
  [5399] = 2,
    ACTIONS(573), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(575), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5412] = 2,
    ACTIONS(579), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(577), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5425] = 2,
    ACTIONS(583), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(581), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5438] = 2,
    ACTIONS(587), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(585), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5451] = 2,
    ACTIONS(591), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(589), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5464] = 2,
    ACTIONS(595), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(593), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5477] = 2,
    ACTIONS(599), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(597), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5490] = 2,
    ACTIONS(603), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(601), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5503] = 2,
    ACTIONS(607), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(605), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5516] = 2,
    ACTIONS(611), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(609), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5529] = 2,
    ACTIONS(615), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(613), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5542] = 2,
    ACTIONS(619), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(617), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5555] = 2,
    ACTIONS(573), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(575), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5568] = 2,
    ACTIONS(623), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(621), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5581] = 2,
    ACTIONS(627), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(625), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5594] = 2,
    ACTIONS(631), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(629), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5607] = 2,
    ACTIONS(635), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(633), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5620] = 2,
    ACTIONS(639), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(637), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5633] = 2,
    ACTIONS(643), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(641), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5646] = 2,
    ACTIONS(647), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(645), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5659] = 2,
    ACTIONS(651), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(649), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5672] = 2,
    ACTIONS(655), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(653), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5685] = 2,
    ACTIONS(655), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(653), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5698] = 2,
    ACTIONS(579), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(577), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5711] = 2,
    ACTIONS(657), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(659), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5724] = 2,
    ACTIONS(661), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(663), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5737] = 2,
    ACTIONS(665), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(667), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5750] = 2,
    ACTIONS(669), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(671), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5763] = 2,
    ACTIONS(673), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(675), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5776] = 6,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(677), 1,
      sym_identifier,
    STATE(217), 1,
      sym_member_expression,
    STATE(280), 1,
      sym_assignment_expression,
    STATE(228), 3,
      sym_array,
      sym_parenthesized_expression,
      sym_call_expression,
  [5797] = 2,
    ACTIONS(679), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(681), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5810] = 2,
    ACTIONS(683), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(685), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5823] = 2,
    ACTIONS(687), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(689), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5836] = 2,
    ACTIONS(691), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(693), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5849] = 2,
    ACTIONS(695), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(697), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5862] = 2,
    ACTIONS(699), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(701), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5875] = 2,
    ACTIONS(703), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(705), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5888] = 2,
    ACTIONS(583), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(581), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5901] = 2,
    ACTIONS(587), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(585), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5914] = 2,
    ACTIONS(591), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(589), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5927] = 2,
    ACTIONS(595), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(593), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5940] = 2,
    ACTIONS(599), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(597), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5953] = 2,
    ACTIONS(603), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(601), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5966] = 2,
    ACTIONS(607), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(605), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5979] = 2,
    ACTIONS(611), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(609), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [5992] = 2,
    ACTIONS(615), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(613), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6005] = 2,
    ACTIONS(619), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(617), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6018] = 2,
    ACTIONS(623), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(621), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6031] = 2,
    ACTIONS(627), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(625), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6044] = 2,
    ACTIONS(631), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(629), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6057] = 2,
    ACTIONS(635), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(633), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6070] = 2,
    ACTIONS(639), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(637), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6083] = 2,
    ACTIONS(643), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(641), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6096] = 2,
    ACTIONS(647), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(645), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6109] = 2,
    ACTIONS(651), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(649), 5,
      sym_frontmatter_delimiter,
      sym_content,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6122] = 6,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(371), 1,
      anon_sym_LPAREN,
    ACTIONS(677), 1,
      sym_identifier,
    STATE(217), 1,
      sym_member_expression,
    STATE(297), 1,
      sym_assignment_expression,
    STATE(228), 3,
      sym_array,
      sym_parenthesized_expression,
      sym_call_expression,
  [6143] = 2,
    ACTIONS(679), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(681), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6156] = 2,
    ACTIONS(683), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(685), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6169] = 2,
    ACTIONS(687), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(689), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6182] = 2,
    ACTIONS(657), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(659), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6195] = 2,
    ACTIONS(691), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(693), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6208] = 2,
    ACTIONS(695), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(697), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6221] = 2,
    ACTIONS(709), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(707), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6234] = 2,
    ACTIONS(661), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(663), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6247] = 2,
    ACTIONS(665), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(667), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6260] = 2,
    ACTIONS(699), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(701), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6273] = 2,
    ACTIONS(669), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(671), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6286] = 2,
    ACTIONS(703), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(705), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6299] = 2,
    ACTIONS(673), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(675), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6312] = 2,
    ACTIONS(713), 3,
      anon_sym_LBRACE_POUND,
      anon_sym_LBRACE_LBRACE,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(711), 5,
      sym_content,
      ts_builtin_sym_end,
      anon_sym_LBRACE_POUND_DASH,
      anon_sym_LBRACE_LBRACE_DASH,
      anon_sym_LBRACE_PERCENT_DASH,
  [6325] = 5,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(715), 2,
      sym_bool,
      sym_number,
    STATE(331), 2,
      sym_string,
      sym__literal,
  [6343] = 7,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_DOT,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(31), 1,
      anon_sym_COLON_COLON,
    ACTIONS(717), 1,
      anon_sym_EQ,
    STATE(5), 1,
      aux_sym_member_expression_repeat1,
    STATE(18), 1,
      sym_argument_list,
  [6365] = 5,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    STATE(233), 2,
      sym_string,
      sym_array,
  [6382] = 5,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    STATE(262), 2,
      sym_string,
      sym_array,
  [6399] = 4,
    ACTIONS(719), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(721), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(347), 1,
      sym_else_clause,
    STATE(218), 2,
      sym_elif_clause,
      aux_sym_if_statement_repeat1,
  [6413] = 4,
    ACTIONS(723), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(725), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(351), 1,
      sym_else_clause,
    STATE(218), 2,
      sym_elif_clause,
      aux_sym_if_statement_repeat1,
  [6427] = 4,
    ACTIONS(727), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(729), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(289), 1,
      sym_else_clause,
    STATE(218), 2,
      sym_elif_clause,
      aux_sym_if_statement_repeat1,
  [6441] = 4,
    ACTIONS(731), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(733), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(364), 1,
      sym_else_clause,
    STATE(218), 2,
      sym_elif_clause,
      aux_sym_if_statement_repeat1,
  [6455] = 4,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    STATE(406), 1,
      sym_string,
  [6468] = 2,
    STATE(4), 1,
      aux_sym_member_expression_repeat1,
    ACTIONS(33), 3,
      anon_sym_LBRACK,
      anon_sym_DOT,
      anon_sym_EQ,
  [6477] = 4,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_DOT,
    ACTIONS(717), 1,
      anon_sym_EQ,
    STATE(216), 1,
      aux_sym_member_expression_repeat1,
  [6490] = 3,
    ACTIONS(735), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(738), 1,
      anon_sym_LBRACE_PERCENT_DASH,
    STATE(218), 2,
      sym_elif_clause,
      aux_sym_if_statement_repeat1,
  [6501] = 4,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    STATE(342), 1,
      sym_string,
  [6514] = 4,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    STATE(383), 1,
      sym_string,
  [6527] = 4,
    ACTIONS(741), 1,
      anon_sym_COMMA,
    ACTIONS(743), 1,
      anon_sym_RPAREN,
    ACTIONS(745), 1,
      anon_sym_EQ,
    STATE(229), 1,
      aux_sym_parameter_list_repeat1,
  [6540] = 4,
    ACTIONS(359), 1,
      anon_sym_SQUOTE,
    ACTIONS(361), 1,
      anon_sym_DQUOTE,
    ACTIONS(363), 1,
      anon_sym_BQUOTE,
    STATE(299), 1,
      sym_string,
  [6553] = 3,
    ACTIONS(747), 1,
      anon_sym_DQUOTE,
    ACTIONS(749), 1,
      aux_sym_string_token2,
    STATE(223), 1,
      aux_sym_string_repeat2,
  [6563] = 3,
    ACTIONS(465), 1,
      anon_sym_elif,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(752), 1,
      anon_sym_endif,
  [6573] = 2,
    ACTIONS(754), 1,
      sym_identifier,
    ACTIONS(756), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6581] = 2,
    ACTIONS(758), 1,
      anon_sym_LPAREN,
    ACTIONS(760), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6589] = 3,
    ACTIONS(762), 1,
      sym_identifier,
    ACTIONS(764), 1,
      anon_sym_RPAREN,
    STATE(330), 1,
      sym_optional_parameter,
  [6599] = 3,
    ACTIONS(21), 1,
      anon_sym_LBRACK,
    ACTIONS(25), 1,
      anon_sym_DOT,
    STATE(3), 1,
      aux_sym_member_expression_repeat1,
  [6609] = 3,
    ACTIONS(766), 1,
      anon_sym_COMMA,
    ACTIONS(768), 1,
      anon_sym_RPAREN,
    STATE(250), 1,
      aux_sym_parameter_list_repeat1,
  [6619] = 3,
    ACTIONS(762), 1,
      sym_identifier,
    ACTIONS(770), 1,
      anon_sym_RPAREN,
    STATE(330), 1,
      sym_optional_parameter,
  [6629] = 3,
    ACTIONS(772), 1,
      anon_sym_COMMA,
    ACTIONS(774), 1,
      anon_sym_RPAREN,
    STATE(250), 1,
      aux_sym_parameter_list_repeat1,
  [6639] = 3,
    ACTIONS(776), 1,
      anon_sym_COMMA,
    ACTIONS(778), 1,
      anon_sym_RPAREN,
    STATE(235), 1,
      aux_sym_argument_list_repeat1,
  [6649] = 2,
    ACTIONS(782), 1,
      anon_sym_ignoremissing,
    ACTIONS(780), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6657] = 3,
    ACTIONS(784), 1,
      anon_sym_SQUOTE,
    ACTIONS(786), 1,
      aux_sym_string_token1,
    STATE(234), 1,
      aux_sym_string_repeat1,
  [6667] = 3,
    ACTIONS(789), 1,
      anon_sym_COMMA,
    ACTIONS(791), 1,
      anon_sym_RPAREN,
    STATE(255), 1,
      aux_sym_argument_list_repeat1,
  [6677] = 3,
    ACTIONS(465), 1,
      anon_sym_elif,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(793), 1,
      anon_sym_endif,
  [6687] = 3,
    ACTIONS(795), 1,
      anon_sym_BQUOTE,
    ACTIONS(797), 1,
      aux_sym_string_token3,
    STATE(237), 1,
      aux_sym_string_repeat3,
  [6697] = 3,
    ACTIONS(800), 1,
      anon_sym_COMMA,
    ACTIONS(802), 1,
      anon_sym_RPAREN,
    STATE(231), 1,
      aux_sym_parameter_list_repeat1,
  [6707] = 2,
    ACTIONS(804), 1,
      anon_sym_LPAREN,
    ACTIONS(806), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6715] = 2,
    ACTIONS(808), 1,
      sym_identifier,
    ACTIONS(810), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6723] = 2,
    ACTIONS(812), 1,
      sym_identifier,
    ACTIONS(814), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6731] = 3,
    ACTIONS(816), 1,
      anon_sym_SQUOTE,
    ACTIONS(818), 1,
      aux_sym_string_token1,
    STATE(234), 1,
      aux_sym_string_repeat1,
  [6741] = 3,
    ACTIONS(375), 1,
      anon_sym_RBRACK,
    ACTIONS(820), 1,
      anon_sym_COMMA,
    STATE(258), 1,
      aux_sym_array_repeat1,
  [6751] = 2,
    ACTIONS(745), 1,
      anon_sym_EQ,
    ACTIONS(822), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [6759] = 3,
    ACTIONS(824), 1,
      sym_identifier,
    ACTIONS(826), 1,
      anon_sym_RPAREN,
    STATE(292), 1,
      sym_keyword_argument,
  [6769] = 3,
    ACTIONS(816), 1,
      anon_sym_DQUOTE,
    ACTIONS(828), 1,
      aux_sym_string_token2,
    STATE(223), 1,
      aux_sym_string_repeat2,
  [6779] = 3,
    ACTIONS(762), 1,
      sym_identifier,
    ACTIONS(830), 1,
      anon_sym_RPAREN,
    STATE(330), 1,
      sym_optional_parameter,
  [6789] = 3,
    ACTIONS(816), 1,
      anon_sym_BQUOTE,
    ACTIONS(832), 1,
      aux_sym_string_token3,
    STATE(237), 1,
      aux_sym_string_repeat3,
  [6799] = 3,
    ACTIONS(465), 1,
      anon_sym_elif,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(834), 1,
      anon_sym_endif,
  [6809] = 3,
    ACTIONS(836), 1,
      anon_sym_COMMA,
    ACTIONS(839), 1,
      anon_sym_RPAREN,
    STATE(250), 1,
      aux_sym_parameter_list_repeat1,
  [6819] = 3,
    ACTIONS(465), 1,
      anon_sym_elif,
    ACTIONS(467), 1,
      anon_sym_else,
    ACTIONS(841), 1,
      anon_sym_endif,
  [6829] = 3,
    ACTIONS(762), 1,
      sym_identifier,
    ACTIONS(843), 1,
      anon_sym_RPAREN,
    STATE(330), 1,
      sym_optional_parameter,
  [6839] = 2,
    ACTIONS(845), 1,
      sym_identifier,
    ACTIONS(847), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6847] = 3,
    ACTIONS(791), 1,
      anon_sym_RPAREN,
    ACTIONS(824), 1,
      sym_identifier,
    STATE(292), 1,
      sym_keyword_argument,
  [6857] = 3,
    ACTIONS(849), 1,
      anon_sym_COMMA,
    ACTIONS(852), 1,
      anon_sym_RPAREN,
    STATE(255), 1,
      aux_sym_argument_list_repeat1,
  [6867] = 3,
    ACTIONS(854), 1,
      anon_sym_BQUOTE,
    ACTIONS(856), 1,
      aux_sym_string_token3,
    STATE(248), 1,
      aux_sym_string_repeat3,
  [6877] = 3,
    ACTIONS(858), 1,
      sym_identifier,
    ACTIONS(860), 1,
      anon_sym_RPAREN,
    STATE(238), 1,
      sym_optional_parameter,
  [6887] = 3,
    ACTIONS(443), 1,
      anon_sym_RBRACK,
    ACTIONS(862), 1,
      anon_sym_COMMA,
    STATE(258), 1,
      aux_sym_array_repeat1,
  [6897] = 3,
    ACTIONS(824), 1,
      sym_identifier,
    ACTIONS(865), 1,
      anon_sym_RPAREN,
    STATE(232), 1,
      sym_keyword_argument,
  [6907] = 3,
    ACTIONS(854), 1,
      anon_sym_SQUOTE,
    ACTIONS(867), 1,
      aux_sym_string_token1,
    STATE(242), 1,
      aux_sym_string_repeat1,
  [6917] = 3,
    ACTIONS(854), 1,
      anon_sym_DQUOTE,
    ACTIONS(869), 1,
      aux_sym_string_token2,
    STATE(246), 1,
      aux_sym_string_repeat2,
  [6927] = 2,
    ACTIONS(873), 1,
      anon_sym_ignoremissing,
    ACTIONS(871), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6935] = 1,
    ACTIONS(875), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6940] = 2,
    ACTIONS(877), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(879), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [6947] = 2,
    ACTIONS(881), 1,
      anon_sym_LPAREN,
    STATE(359), 1,
      sym_parameter_list,
  [6954] = 1,
    ACTIONS(883), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6959] = 1,
    ACTIONS(885), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6964] = 1,
    ACTIONS(887), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6969] = 1,
    ACTIONS(889), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6974] = 2,
    ACTIONS(762), 1,
      sym_identifier,
    STATE(330), 1,
      sym_optional_parameter,
  [6981] = 1,
    ACTIONS(891), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6986] = 1,
    ACTIONS(893), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6991] = 1,
    ACTIONS(895), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [6996] = 1,
    ACTIONS(897), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7001] = 1,
    ACTIONS(899), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7006] = 2,
    ACTIONS(901), 1,
      anon_sym_COMMA,
    ACTIONS(903), 1,
      anon_sym_in,
  [7013] = 1,
    ACTIONS(905), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7018] = 1,
    ACTIONS(907), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7023] = 1,
    ACTIONS(909), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7028] = 1,
    ACTIONS(911), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7033] = 1,
    ACTIONS(913), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7038] = 2,
    ACTIONS(824), 1,
      sym_identifier,
    STATE(292), 1,
      sym_keyword_argument,
  [7045] = 1,
    ACTIONS(915), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7050] = 1,
    ACTIONS(431), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7055] = 1,
    ACTIONS(917), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7060] = 1,
    ACTIONS(919), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7065] = 1,
    ACTIONS(921), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7070] = 1,
    ACTIONS(923), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7075] = 2,
    ACTIONS(925), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(927), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7082] = 1,
    ACTIONS(929), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7087] = 1,
    ACTIONS(931), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7092] = 1,
    ACTIONS(852), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7097] = 1,
    ACTIONS(933), 2,
      anon_sym_POUND_RBRACE,
      anon_sym_DASH_POUND_RBRACE,
  [7102] = 2,
    ACTIONS(935), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(937), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7109] = 1,
    ACTIONS(939), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7114] = 1,
    ACTIONS(941), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7119] = 1,
    ACTIONS(943), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7124] = 1,
    ACTIONS(945), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7129] = 1,
    ACTIONS(947), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7134] = 1,
    ACTIONS(949), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7139] = 1,
    ACTIONS(951), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7144] = 1,
    ACTIONS(953), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7149] = 1,
    ACTIONS(955), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7154] = 1,
    ACTIONS(957), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7159] = 1,
    ACTIONS(959), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7164] = 1,
    ACTIONS(961), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7169] = 1,
    ACTIONS(963), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7174] = 1,
    ACTIONS(965), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7179] = 1,
    ACTIONS(967), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7184] = 1,
    ACTIONS(969), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7189] = 1,
    ACTIONS(971), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7194] = 1,
    ACTIONS(973), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7199] = 1,
    ACTIONS(975), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7204] = 1,
    ACTIONS(977), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7209] = 2,
    ACTIONS(979), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(981), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7216] = 1,
    ACTIONS(983), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7221] = 1,
    ACTIONS(985), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7226] = 1,
    ACTIONS(987), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7231] = 2,
    ACTIONS(989), 1,
      anon_sym_COMMA,
    ACTIONS(991), 1,
      anon_sym_in,
  [7238] = 1,
    ACTIONS(993), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7243] = 1,
    ACTIONS(995), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7248] = 1,
    ACTIONS(997), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7253] = 1,
    ACTIONS(999), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7258] = 1,
    ACTIONS(1001), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7263] = 1,
    ACTIONS(1003), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7268] = 2,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(23), 1,
      sym_argument_list,
  [7275] = 1,
    ACTIONS(1005), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7280] = 1,
    ACTIONS(1007), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7285] = 1,
    ACTIONS(1009), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7290] = 1,
    ACTIONS(1011), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7295] = 1,
    ACTIONS(1013), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
  [7300] = 1,
    ACTIONS(1015), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7305] = 1,
    ACTIONS(1017), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7310] = 1,
    ACTIONS(1019), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7315] = 1,
    ACTIONS(1021), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7320] = 1,
    ACTIONS(1023), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7325] = 1,
    ACTIONS(1025), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7330] = 1,
    ACTIONS(1027), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7335] = 2,
    ACTIONS(1029), 1,
      sym_identifier,
    ACTIONS(1031), 1,
      anon_sym_not,
  [7342] = 1,
    ACTIONS(1033), 2,
      anon_sym_POUND_RBRACE,
      anon_sym_DASH_POUND_RBRACE,
  [7347] = 2,
    ACTIONS(1035), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1037), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7354] = 1,
    ACTIONS(1039), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7359] = 2,
    ACTIONS(1041), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1043), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7366] = 1,
    ACTIONS(1045), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7371] = 1,
    ACTIONS(1047), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7376] = 2,
    ACTIONS(1049), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1051), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7383] = 2,
    ACTIONS(1053), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1055), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7390] = 2,
    ACTIONS(1057), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1059), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7397] = 1,
    ACTIONS(1061), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7402] = 2,
    ACTIONS(1063), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1065), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7409] = 2,
    ACTIONS(1067), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1069), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7416] = 2,
    ACTIONS(1071), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1073), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7423] = 2,
    ACTIONS(1075), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1077), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7430] = 2,
    ACTIONS(1079), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1081), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7437] = 2,
    ACTIONS(1083), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1085), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7444] = 1,
    ACTIONS(1087), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7449] = 1,
    ACTIONS(1089), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7454] = 1,
    ACTIONS(429), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7459] = 1,
    ACTIONS(1091), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7464] = 1,
    ACTIONS(1093), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7469] = 1,
    ACTIONS(1095), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7474] = 1,
    ACTIONS(1097), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7479] = 1,
    ACTIONS(433), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7484] = 2,
    ACTIONS(1099), 1,
      anon_sym_LBRACE_PERCENT,
    ACTIONS(1101), 1,
      anon_sym_LBRACE_PERCENT_DASH,
  [7491] = 1,
    ACTIONS(1103), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7496] = 2,
    ACTIONS(881), 1,
      anon_sym_LPAREN,
    STATE(361), 1,
      sym_parameter_list,
  [7503] = 1,
    ACTIONS(1105), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7508] = 1,
    ACTIONS(1107), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7513] = 1,
    ACTIONS(1109), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7518] = 1,
    ACTIONS(1111), 2,
      anon_sym_PERCENT_RBRACE,
      anon_sym_DASH_PERCENT_RBRACE,
  [7523] = 1,
    ACTIONS(1113), 1,
      sym_identifier,
  [7527] = 1,
    ACTIONS(465), 1,
      anon_sym_elif,
  [7531] = 1,
    ACTIONS(1115), 1,
      anon_sym_in,
  [7535] = 1,
    ACTIONS(1117), 1,
      sym_identifier,
  [7539] = 1,
    ACTIONS(1119), 1,
      sym_identifier,
  [7543] = 1,
    ACTIONS(1121), 1,
      sym_identifier,
  [7547] = 1,
    ACTIONS(1123), 1,
      anon_sym_endfor,
  [7551] = 1,
    ACTIONS(1125), 1,
      anon_sym_EQ,
  [7555] = 1,
    ACTIONS(1127), 1,
      sym_identifier,
  [7559] = 1,
    ACTIONS(1129), 1,
      sym_identifier,
  [7563] = 1,
    ACTIONS(834), 1,
      anon_sym_endif,
  [7567] = 1,
    ACTIONS(1131), 1,
      sym_identifier,
  [7571] = 1,
    ACTIONS(1133), 1,
      anon_sym_as,
  [7575] = 1,
    ACTIONS(793), 1,
      anon_sym_endif,
  [7579] = 1,
    ACTIONS(1135), 1,
      sym_identifier,
  [7583] = 1,
    ACTIONS(1137), 1,
      sym_identifier,
  [7587] = 1,
    ACTIONS(1139), 1,
      sym_identifier,
  [7591] = 1,
    ACTIONS(1141), 1,
      aux_sym_comment_tag_token1,
  [7595] = 1,
    ACTIONS(841), 1,
      anon_sym_endif,
  [7599] = 1,
    ACTIONS(752), 1,
      anon_sym_endif,
  [7603] = 1,
    ACTIONS(1143), 1,
      anon_sym_endfor,
  [7607] = 1,
    ACTIONS(1145), 1,
      anon_sym_endif,
  [7611] = 1,
    ACTIONS(1147), 1,
      aux_sym_comment_tag_token1,
  [7615] = 1,
    ACTIONS(1149), 1,
      anon_sym_endif,
  [7619] = 1,
    ACTIONS(1151), 1,
      sym_identifier,
  [7623] = 1,
    ACTIONS(1153), 1,
      anon_sym_endif,
  [7627] = 1,
    ACTIONS(1155), 1,
      anon_sym_endfor,
  [7631] = 1,
    ACTIONS(1157), 1,
      anon_sym_endfor,
  [7635] = 1,
    ACTIONS(1159), 1,
      anon_sym_endfor,
  [7639] = 1,
    ACTIONS(1161), 1,
      sym_identifier,
  [7643] = 1,
    ACTIONS(1163), 1,
      anon_sym_endfor,
  [7647] = 1,
    ACTIONS(1165), 1,
      anon_sym_endfor,
  [7651] = 1,
    ACTIONS(1167), 1,
      sym_identifier,
  [7655] = 1,
    ACTIONS(1169), 1,
      sym_identifier,
  [7659] = 1,
    ACTIONS(1171), 1,
      anon_sym_endfor,
  [7663] = 1,
    ACTIONS(1173), 1,
      anon_sym_as,
  [7667] = 1,
    ACTIONS(1175), 1,
      sym_identifier,
  [7671] = 1,
    ACTIONS(1177), 1,
      ts_builtin_sym_end,
  [7675] = 1,
    ACTIONS(1179), 1,
      sym_identifier,
  [7679] = 1,
    ACTIONS(1181), 1,
      anon_sym_endif,
  [7683] = 1,
    ACTIONS(1183), 1,
      sym_identifier,
  [7687] = 1,
    ACTIONS(1185), 1,
      anon_sym_in,
  [7691] = 1,
    ACTIONS(1187), 1,
      sym_identifier,
  [7695] = 1,
    ACTIONS(1189), 1,
      sym_identifier,
  [7699] = 1,
    ACTIONS(1191), 1,
      sym_identifier,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 47,
  [SMALL_STATE(4)] = 82,
  [SMALL_STATE(5)] = 121,
  [SMALL_STATE(6)] = 156,
  [SMALL_STATE(7)] = 194,
  [SMALL_STATE(8)] = 226,
  [SMALL_STATE(9)] = 258,
  [SMALL_STATE(10)] = 290,
  [SMALL_STATE(11)] = 338,
  [SMALL_STATE(12)] = 370,
  [SMALL_STATE(13)] = 402,
  [SMALL_STATE(14)] = 450,
  [SMALL_STATE(15)] = 498,
  [SMALL_STATE(16)] = 530,
  [SMALL_STATE(17)] = 578,
  [SMALL_STATE(18)] = 609,
  [SMALL_STATE(19)] = 640,
  [SMALL_STATE(20)] = 671,
  [SMALL_STATE(21)] = 702,
  [SMALL_STATE(22)] = 737,
  [SMALL_STATE(23)] = 768,
  [SMALL_STATE(24)] = 799,
  [SMALL_STATE(25)] = 830,
  [SMALL_STATE(26)] = 861,
  [SMALL_STATE(27)] = 892,
  [SMALL_STATE(28)] = 936,
  [SMALL_STATE(29)] = 980,
  [SMALL_STATE(30)] = 1024,
  [SMALL_STATE(31)] = 1068,
  [SMALL_STATE(32)] = 1112,
  [SMALL_STATE(33)] = 1156,
  [SMALL_STATE(34)] = 1200,
  [SMALL_STATE(35)] = 1244,
  [SMALL_STATE(36)] = 1288,
  [SMALL_STATE(37)] = 1332,
  [SMALL_STATE(38)] = 1376,
  [SMALL_STATE(39)] = 1420,
  [SMALL_STATE(40)] = 1464,
  [SMALL_STATE(41)] = 1508,
  [SMALL_STATE(42)] = 1552,
  [SMALL_STATE(43)] = 1581,
  [SMALL_STATE(44)] = 1622,
  [SMALL_STATE(45)] = 1663,
  [SMALL_STATE(46)] = 1704,
  [SMALL_STATE(47)] = 1745,
  [SMALL_STATE(48)] = 1774,
  [SMALL_STATE(49)] = 1815,
  [SMALL_STATE(50)] = 1856,
  [SMALL_STATE(51)] = 1897,
  [SMALL_STATE(52)] = 1938,
  [SMALL_STATE(53)] = 1979,
  [SMALL_STATE(54)] = 2020,
  [SMALL_STATE(55)] = 2061,
  [SMALL_STATE(56)] = 2102,
  [SMALL_STATE(57)] = 2131,
  [SMALL_STATE(58)] = 2166,
  [SMALL_STATE(59)] = 2207,
  [SMALL_STATE(60)] = 2248,
  [SMALL_STATE(61)] = 2289,
  [SMALL_STATE(62)] = 2330,
  [SMALL_STATE(63)] = 2371,
  [SMALL_STATE(64)] = 2410,
  [SMALL_STATE(65)] = 2451,
  [SMALL_STATE(66)] = 2492,
  [SMALL_STATE(67)] = 2533,
  [SMALL_STATE(68)] = 2577,
  [SMALL_STATE(69)] = 2621,
  [SMALL_STATE(70)] = 2665,
  [SMALL_STATE(71)] = 2709,
  [SMALL_STATE(72)] = 2753,
  [SMALL_STATE(73)] = 2797,
  [SMALL_STATE(74)] = 2838,
  [SMALL_STATE(75)] = 2879,
  [SMALL_STATE(76)] = 2920,
  [SMALL_STATE(77)] = 2961,
  [SMALL_STATE(78)] = 3002,
  [SMALL_STATE(79)] = 3043,
  [SMALL_STATE(80)] = 3084,
  [SMALL_STATE(81)] = 3125,
  [SMALL_STATE(82)] = 3166,
  [SMALL_STATE(83)] = 3207,
  [SMALL_STATE(84)] = 3248,
  [SMALL_STATE(85)] = 3289,
  [SMALL_STATE(86)] = 3330,
  [SMALL_STATE(87)] = 3371,
  [SMALL_STATE(88)] = 3412,
  [SMALL_STATE(89)] = 3453,
  [SMALL_STATE(90)] = 3494,
  [SMALL_STATE(91)] = 3530,
  [SMALL_STATE(92)] = 3568,
  [SMALL_STATE(93)] = 3606,
  [SMALL_STATE(94)] = 3644,
  [SMALL_STATE(95)] = 3675,
  [SMALL_STATE(96)] = 3708,
  [SMALL_STATE(97)] = 3743,
  [SMALL_STATE(98)] = 3778,
  [SMALL_STATE(99)] = 3809,
  [SMALL_STATE(100)] = 3842,
  [SMALL_STATE(101)] = 3877,
  [SMALL_STATE(102)] = 3912,
  [SMALL_STATE(103)] = 3947,
  [SMALL_STATE(104)] = 3977,
  [SMALL_STATE(105)] = 4007,
  [SMALL_STATE(106)] = 4037,
  [SMALL_STATE(107)] = 4067,
  [SMALL_STATE(108)] = 4116,
  [SMALL_STATE(109)] = 4165,
  [SMALL_STATE(110)] = 4214,
  [SMALL_STATE(111)] = 4263,
  [SMALL_STATE(112)] = 4309,
  [SMALL_STATE(113)] = 4355,
  [SMALL_STATE(114)] = 4401,
  [SMALL_STATE(115)] = 4447,
  [SMALL_STATE(116)] = 4493,
  [SMALL_STATE(117)] = 4539,
  [SMALL_STATE(118)] = 4585,
  [SMALL_STATE(119)] = 4631,
  [SMALL_STATE(120)] = 4674,
  [SMALL_STATE(121)] = 4717,
  [SMALL_STATE(122)] = 4760,
  [SMALL_STATE(123)] = 4803,
  [SMALL_STATE(124)] = 4846,
  [SMALL_STATE(125)] = 4889,
  [SMALL_STATE(126)] = 4932,
  [SMALL_STATE(127)] = 4975,
  [SMALL_STATE(128)] = 5018,
  [SMALL_STATE(129)] = 5061,
  [SMALL_STATE(130)] = 5104,
  [SMALL_STATE(131)] = 5147,
  [SMALL_STATE(132)] = 5190,
  [SMALL_STATE(133)] = 5233,
  [SMALL_STATE(134)] = 5276,
  [SMALL_STATE(135)] = 5319,
  [SMALL_STATE(136)] = 5359,
  [SMALL_STATE(137)] = 5399,
  [SMALL_STATE(138)] = 5412,
  [SMALL_STATE(139)] = 5425,
  [SMALL_STATE(140)] = 5438,
  [SMALL_STATE(141)] = 5451,
  [SMALL_STATE(142)] = 5464,
  [SMALL_STATE(143)] = 5477,
  [SMALL_STATE(144)] = 5490,
  [SMALL_STATE(145)] = 5503,
  [SMALL_STATE(146)] = 5516,
  [SMALL_STATE(147)] = 5529,
  [SMALL_STATE(148)] = 5542,
  [SMALL_STATE(149)] = 5555,
  [SMALL_STATE(150)] = 5568,
  [SMALL_STATE(151)] = 5581,
  [SMALL_STATE(152)] = 5594,
  [SMALL_STATE(153)] = 5607,
  [SMALL_STATE(154)] = 5620,
  [SMALL_STATE(155)] = 5633,
  [SMALL_STATE(156)] = 5646,
  [SMALL_STATE(157)] = 5659,
  [SMALL_STATE(158)] = 5672,
  [SMALL_STATE(159)] = 5685,
  [SMALL_STATE(160)] = 5698,
  [SMALL_STATE(161)] = 5711,
  [SMALL_STATE(162)] = 5724,
  [SMALL_STATE(163)] = 5737,
  [SMALL_STATE(164)] = 5750,
  [SMALL_STATE(165)] = 5763,
  [SMALL_STATE(166)] = 5776,
  [SMALL_STATE(167)] = 5797,
  [SMALL_STATE(168)] = 5810,
  [SMALL_STATE(169)] = 5823,
  [SMALL_STATE(170)] = 5836,
  [SMALL_STATE(171)] = 5849,
  [SMALL_STATE(172)] = 5862,
  [SMALL_STATE(173)] = 5875,
  [SMALL_STATE(174)] = 5888,
  [SMALL_STATE(175)] = 5901,
  [SMALL_STATE(176)] = 5914,
  [SMALL_STATE(177)] = 5927,
  [SMALL_STATE(178)] = 5940,
  [SMALL_STATE(179)] = 5953,
  [SMALL_STATE(180)] = 5966,
  [SMALL_STATE(181)] = 5979,
  [SMALL_STATE(182)] = 5992,
  [SMALL_STATE(183)] = 6005,
  [SMALL_STATE(184)] = 6018,
  [SMALL_STATE(185)] = 6031,
  [SMALL_STATE(186)] = 6044,
  [SMALL_STATE(187)] = 6057,
  [SMALL_STATE(188)] = 6070,
  [SMALL_STATE(189)] = 6083,
  [SMALL_STATE(190)] = 6096,
  [SMALL_STATE(191)] = 6109,
  [SMALL_STATE(192)] = 6122,
  [SMALL_STATE(193)] = 6143,
  [SMALL_STATE(194)] = 6156,
  [SMALL_STATE(195)] = 6169,
  [SMALL_STATE(196)] = 6182,
  [SMALL_STATE(197)] = 6195,
  [SMALL_STATE(198)] = 6208,
  [SMALL_STATE(199)] = 6221,
  [SMALL_STATE(200)] = 6234,
  [SMALL_STATE(201)] = 6247,
  [SMALL_STATE(202)] = 6260,
  [SMALL_STATE(203)] = 6273,
  [SMALL_STATE(204)] = 6286,
  [SMALL_STATE(205)] = 6299,
  [SMALL_STATE(206)] = 6312,
  [SMALL_STATE(207)] = 6325,
  [SMALL_STATE(208)] = 6343,
  [SMALL_STATE(209)] = 6365,
  [SMALL_STATE(210)] = 6382,
  [SMALL_STATE(211)] = 6399,
  [SMALL_STATE(212)] = 6413,
  [SMALL_STATE(213)] = 6427,
  [SMALL_STATE(214)] = 6441,
  [SMALL_STATE(215)] = 6455,
  [SMALL_STATE(216)] = 6468,
  [SMALL_STATE(217)] = 6477,
  [SMALL_STATE(218)] = 6490,
  [SMALL_STATE(219)] = 6501,
  [SMALL_STATE(220)] = 6514,
  [SMALL_STATE(221)] = 6527,
  [SMALL_STATE(222)] = 6540,
  [SMALL_STATE(223)] = 6553,
  [SMALL_STATE(224)] = 6563,
  [SMALL_STATE(225)] = 6573,
  [SMALL_STATE(226)] = 6581,
  [SMALL_STATE(227)] = 6589,
  [SMALL_STATE(228)] = 6599,
  [SMALL_STATE(229)] = 6609,
  [SMALL_STATE(230)] = 6619,
  [SMALL_STATE(231)] = 6629,
  [SMALL_STATE(232)] = 6639,
  [SMALL_STATE(233)] = 6649,
  [SMALL_STATE(234)] = 6657,
  [SMALL_STATE(235)] = 6667,
  [SMALL_STATE(236)] = 6677,
  [SMALL_STATE(237)] = 6687,
  [SMALL_STATE(238)] = 6697,
  [SMALL_STATE(239)] = 6707,
  [SMALL_STATE(240)] = 6715,
  [SMALL_STATE(241)] = 6723,
  [SMALL_STATE(242)] = 6731,
  [SMALL_STATE(243)] = 6741,
  [SMALL_STATE(244)] = 6751,
  [SMALL_STATE(245)] = 6759,
  [SMALL_STATE(246)] = 6769,
  [SMALL_STATE(247)] = 6779,
  [SMALL_STATE(248)] = 6789,
  [SMALL_STATE(249)] = 6799,
  [SMALL_STATE(250)] = 6809,
  [SMALL_STATE(251)] = 6819,
  [SMALL_STATE(252)] = 6829,
  [SMALL_STATE(253)] = 6839,
  [SMALL_STATE(254)] = 6847,
  [SMALL_STATE(255)] = 6857,
  [SMALL_STATE(256)] = 6867,
  [SMALL_STATE(257)] = 6877,
  [SMALL_STATE(258)] = 6887,
  [SMALL_STATE(259)] = 6897,
  [SMALL_STATE(260)] = 6907,
  [SMALL_STATE(261)] = 6917,
  [SMALL_STATE(262)] = 6927,
  [SMALL_STATE(263)] = 6935,
  [SMALL_STATE(264)] = 6940,
  [SMALL_STATE(265)] = 6947,
  [SMALL_STATE(266)] = 6954,
  [SMALL_STATE(267)] = 6959,
  [SMALL_STATE(268)] = 6964,
  [SMALL_STATE(269)] = 6969,
  [SMALL_STATE(270)] = 6974,
  [SMALL_STATE(271)] = 6981,
  [SMALL_STATE(272)] = 6986,
  [SMALL_STATE(273)] = 6991,
  [SMALL_STATE(274)] = 6996,
  [SMALL_STATE(275)] = 7001,
  [SMALL_STATE(276)] = 7006,
  [SMALL_STATE(277)] = 7013,
  [SMALL_STATE(278)] = 7018,
  [SMALL_STATE(279)] = 7023,
  [SMALL_STATE(280)] = 7028,
  [SMALL_STATE(281)] = 7033,
  [SMALL_STATE(282)] = 7038,
  [SMALL_STATE(283)] = 7045,
  [SMALL_STATE(284)] = 7050,
  [SMALL_STATE(285)] = 7055,
  [SMALL_STATE(286)] = 7060,
  [SMALL_STATE(287)] = 7065,
  [SMALL_STATE(288)] = 7070,
  [SMALL_STATE(289)] = 7075,
  [SMALL_STATE(290)] = 7082,
  [SMALL_STATE(291)] = 7087,
  [SMALL_STATE(292)] = 7092,
  [SMALL_STATE(293)] = 7097,
  [SMALL_STATE(294)] = 7102,
  [SMALL_STATE(295)] = 7109,
  [SMALL_STATE(296)] = 7114,
  [SMALL_STATE(297)] = 7119,
  [SMALL_STATE(298)] = 7124,
  [SMALL_STATE(299)] = 7129,
  [SMALL_STATE(300)] = 7134,
  [SMALL_STATE(301)] = 7139,
  [SMALL_STATE(302)] = 7144,
  [SMALL_STATE(303)] = 7149,
  [SMALL_STATE(304)] = 7154,
  [SMALL_STATE(305)] = 7159,
  [SMALL_STATE(306)] = 7164,
  [SMALL_STATE(307)] = 7169,
  [SMALL_STATE(308)] = 7174,
  [SMALL_STATE(309)] = 7179,
  [SMALL_STATE(310)] = 7184,
  [SMALL_STATE(311)] = 7189,
  [SMALL_STATE(312)] = 7194,
  [SMALL_STATE(313)] = 7199,
  [SMALL_STATE(314)] = 7204,
  [SMALL_STATE(315)] = 7209,
  [SMALL_STATE(316)] = 7216,
  [SMALL_STATE(317)] = 7221,
  [SMALL_STATE(318)] = 7226,
  [SMALL_STATE(319)] = 7231,
  [SMALL_STATE(320)] = 7238,
  [SMALL_STATE(321)] = 7243,
  [SMALL_STATE(322)] = 7248,
  [SMALL_STATE(323)] = 7253,
  [SMALL_STATE(324)] = 7258,
  [SMALL_STATE(325)] = 7263,
  [SMALL_STATE(326)] = 7268,
  [SMALL_STATE(327)] = 7275,
  [SMALL_STATE(328)] = 7280,
  [SMALL_STATE(329)] = 7285,
  [SMALL_STATE(330)] = 7290,
  [SMALL_STATE(331)] = 7295,
  [SMALL_STATE(332)] = 7300,
  [SMALL_STATE(333)] = 7305,
  [SMALL_STATE(334)] = 7310,
  [SMALL_STATE(335)] = 7315,
  [SMALL_STATE(336)] = 7320,
  [SMALL_STATE(337)] = 7325,
  [SMALL_STATE(338)] = 7330,
  [SMALL_STATE(339)] = 7335,
  [SMALL_STATE(340)] = 7342,
  [SMALL_STATE(341)] = 7347,
  [SMALL_STATE(342)] = 7354,
  [SMALL_STATE(343)] = 7359,
  [SMALL_STATE(344)] = 7366,
  [SMALL_STATE(345)] = 7371,
  [SMALL_STATE(346)] = 7376,
  [SMALL_STATE(347)] = 7383,
  [SMALL_STATE(348)] = 7390,
  [SMALL_STATE(349)] = 7397,
  [SMALL_STATE(350)] = 7402,
  [SMALL_STATE(351)] = 7409,
  [SMALL_STATE(352)] = 7416,
  [SMALL_STATE(353)] = 7423,
  [SMALL_STATE(354)] = 7430,
  [SMALL_STATE(355)] = 7437,
  [SMALL_STATE(356)] = 7444,
  [SMALL_STATE(357)] = 7449,
  [SMALL_STATE(358)] = 7454,
  [SMALL_STATE(359)] = 7459,
  [SMALL_STATE(360)] = 7464,
  [SMALL_STATE(361)] = 7469,
  [SMALL_STATE(362)] = 7474,
  [SMALL_STATE(363)] = 7479,
  [SMALL_STATE(364)] = 7484,
  [SMALL_STATE(365)] = 7491,
  [SMALL_STATE(366)] = 7496,
  [SMALL_STATE(367)] = 7503,
  [SMALL_STATE(368)] = 7508,
  [SMALL_STATE(369)] = 7513,
  [SMALL_STATE(370)] = 7518,
  [SMALL_STATE(371)] = 7523,
  [SMALL_STATE(372)] = 7527,
  [SMALL_STATE(373)] = 7531,
  [SMALL_STATE(374)] = 7535,
  [SMALL_STATE(375)] = 7539,
  [SMALL_STATE(376)] = 7543,
  [SMALL_STATE(377)] = 7547,
  [SMALL_STATE(378)] = 7551,
  [SMALL_STATE(379)] = 7555,
  [SMALL_STATE(380)] = 7559,
  [SMALL_STATE(381)] = 7563,
  [SMALL_STATE(382)] = 7567,
  [SMALL_STATE(383)] = 7571,
  [SMALL_STATE(384)] = 7575,
  [SMALL_STATE(385)] = 7579,
  [SMALL_STATE(386)] = 7583,
  [SMALL_STATE(387)] = 7587,
  [SMALL_STATE(388)] = 7591,
  [SMALL_STATE(389)] = 7595,
  [SMALL_STATE(390)] = 7599,
  [SMALL_STATE(391)] = 7603,
  [SMALL_STATE(392)] = 7607,
  [SMALL_STATE(393)] = 7611,
  [SMALL_STATE(394)] = 7615,
  [SMALL_STATE(395)] = 7619,
  [SMALL_STATE(396)] = 7623,
  [SMALL_STATE(397)] = 7627,
  [SMALL_STATE(398)] = 7631,
  [SMALL_STATE(399)] = 7635,
  [SMALL_STATE(400)] = 7639,
  [SMALL_STATE(401)] = 7643,
  [SMALL_STATE(402)] = 7647,
  [SMALL_STATE(403)] = 7651,
  [SMALL_STATE(404)] = 7655,
  [SMALL_STATE(405)] = 7659,
  [SMALL_STATE(406)] = 7663,
  [SMALL_STATE(407)] = 7667,
  [SMALL_STATE(408)] = 7671,
  [SMALL_STATE(409)] = 7675,
  [SMALL_STATE(410)] = 7679,
  [SMALL_STATE(411)] = 7683,
  [SMALL_STATE(412)] = 7687,
  [SMALL_STATE(413)] = 7691,
  [SMALL_STATE(414)] = 7695,
  [SMALL_STATE(415)] = 7699,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [5] = {.entry = {.count = 1, .reusable = false}}, SHIFT(388),
  [7] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(80),
  [11] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(136),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [23] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__value, 1, 0, 0),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [29] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__value, 1, 0, 0),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [33] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_expression, 2, 0, 2),
  [35] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_expression, 2, 0, 2),
  [37] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 4), SHIFT_REPEAT(81),
  [40] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 4),
  [42] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 4), SHIFT_REPEAT(374),
  [45] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 4),
  [47] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 2, 0, 0),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 2, 0, 0),
  [51] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 3),
  [53] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_member_expression_repeat1, 2, 0, 3),
  [55] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 3, 0, 0),
  [57] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 3, 0, 0),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(108),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(14),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 4, 0, 0),
  [67] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 4, 0, 0),
  [69] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_member_expression_repeat1, 3, 0, 7),
  [71] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_member_expression_repeat1, 3, 0, 7),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(110),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [79] = {.entry = {.count = 1, .reusable = false}}, SHIFT(107),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [83] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_array, 5, 0, 0),
  [85] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_array, 5, 0, 0),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(109),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [93] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 3, 0, 0),
  [95] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 3, 0, 0),
  [97] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 2, 0, 1),
  [99] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 2, 0, 1),
  [101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3, 0, 0),
  [103] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3, 0, 0),
  [105] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [107] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parenthesized_expression, 3, 0, 0),
  [109] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter_expression, 3, 0, 6),
  [111] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter_expression, 3, 0, 6),
  [113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 2, 0, 0),
  [115] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 2, 0, 0),
  [117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_call_expression, 4, 0, 8),
  [119] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_call_expression, 4, 0, 8),
  [121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 0),
  [123] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 0),
  [125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 4, 0, 0),
  [127] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 4, 0, 0),
  [129] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 5, 0, 0),
  [131] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument_list, 5, 0, 0),
  [133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(393),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [137] = {.entry = {.count = 1, .reusable = false}}, SHIFT(79),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [141] = {.entry = {.count = 1, .reusable = false}}, SHIFT(135),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [153] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [157] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 2, 0, 0),
  [159] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [161] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(388),
  [164] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(388),
  [167] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(80),
  [170] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(80),
  [173] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(136),
  [176] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(136),
  [179] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(31),
  [182] = {.entry = {.count = 1, .reusable = false}}, SHIFT(113),
  [184] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [188] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(114),
  [192] = {.entry = {.count = 1, .reusable = false}}, SHIFT(115),
  [194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [198] = {.entry = {.count = 1, .reusable = false}}, SHIFT(116),
  [200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(116),
  [202] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(393),
  [205] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(393),
  [208] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(79),
  [211] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(79),
  [214] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(135),
  [217] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(135),
  [220] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(36),
  [223] = {.entry = {.count = 1, .reusable = false}}, SHIFT(117),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(117),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [229] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [233] = {.entry = {.count = 1, .reusable = false}}, SHIFT(111),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [239] = {.entry = {.count = 1, .reusable = false}}, SHIFT(112),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [243] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, 0, 0),
  [245] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, 0, 0),
  [247] = {.entry = {.count = 1, .reusable = false}}, SHIFT(132),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [253] = {.entry = {.count = 1, .reusable = false}}, SHIFT(120),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [259] = {.entry = {.count = 1, .reusable = false}}, SHIFT(121),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [263] = {.entry = {.count = 1, .reusable = false}}, SHIFT(122),
  [265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter_expression, 4, 0, 9),
  [271] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter_expression, 4, 0, 9),
  [273] = {.entry = {.count = 1, .reusable = false}}, SHIFT(119),
  [275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [283] = {.entry = {.count = 1, .reusable = false}}, SHIFT(124),
  [285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(124),
  [287] = {.entry = {.count = 1, .reusable = false}}, SHIFT(123),
  [289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [295] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_clause, 4, 0, 20),
  [297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_clause, 4, 0, 20),
  [299] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elif_clause, 5, 0, 22),
  [301] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elif_clause, 5, 0, 22),
  [303] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, 0, 5),
  [305] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, 0, 5),
  [307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [309] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [313] = {.entry = {.count = 1, .reusable = false}}, SHIFT(126),
  [315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [319] = {.entry = {.count = 1, .reusable = false}}, SHIFT(127),
  [321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [325] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [329] = {.entry = {.count = 1, .reusable = false}}, SHIFT(130),
  [331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [333] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [335] = {.entry = {.count = 1, .reusable = false}}, SHIFT(129),
  [337] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [341] = {.entry = {.count = 1, .reusable = false}}, SHIFT(84),
  [343] = {.entry = {.count = 1, .reusable = false}}, SHIFT(131),
  [345] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [347] = {.entry = {.count = 1, .reusable = false}}, SHIFT(133),
  [349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [353] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [357] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [363] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [369] = {.entry = {.count = 1, .reusable = false}}, SHIFT(2),
  [371] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [373] = {.entry = {.count = 1, .reusable = false}}, SHIFT(73),
  [375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [377] = {.entry = {.count = 1, .reusable = false}}, SHIFT(93),
  [379] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [381] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [385] = {.entry = {.count = 1, .reusable = false}}, SHIFT(91),
  [387] = {.entry = {.count = 1, .reusable = false}}, SHIFT(42),
  [389] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [393] = {.entry = {.count = 1, .reusable = false}}, SHIFT(94),
  [395] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [397] = {.entry = {.count = 1, .reusable = false}}, SHIFT(56),
  [399] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [401] = {.entry = {.count = 1, .reusable = false}}, SHIFT(95),
  [403] = {.entry = {.count = 1, .reusable = false}}, SHIFT(105),
  [405] = {.entry = {.count = 1, .reusable = false}}, SHIFT(104),
  [407] = {.entry = {.count = 1, .reusable = false}}, SHIFT(97),
  [409] = {.entry = {.count = 1, .reusable = false}}, SHIFT(57),
  [411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(63),
  [413] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [415] = {.entry = {.count = 1, .reusable = false}}, SHIFT(106),
  [417] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [425] = {.entry = {.count = 1, .reusable = false}}, SHIFT(85),
  [427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_keyword_argument, 3, 0, 11),
  [437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_assignment_expression, 3, 0, 5),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2, 0, 0),
  [445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [475] = {.entry = {.count = 1, .reusable = false}}, SHIFT(166),
  [477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [555] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 5, 0, 0),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 5, 0, 0),
  [577] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_expression_tag, 3, 0, 0),
  [579] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_expression_tag, 3, 0, 0),
  [581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_statement, 8, 0, 24),
  [583] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_statement, 8, 0, 24),
  [585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter_statement, 8, 0, 0),
  [587] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter_statement, 8, 0, 0),
  [589] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement, 8, 0, 0),
  [591] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement, 8, 0, 0),
  [593] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 9, 0, 25),
  [595] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 9, 0, 25),
  [597] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 9, 0, 26),
  [599] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 9, 0, 26),
  [601] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 9, 0, 28),
  [603] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 9, 0, 28),
  [605] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_statement, 9, 0, 24),
  [607] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_statement, 9, 0, 24),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_statement, 9, 0, 29),
  [611] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_statement, 9, 0, 29),
  [613] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_statement, 9, 0, 0),
  [615] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_statement, 9, 0, 0),
  [617] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 10, 0, 30),
  [619] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 10, 0, 30),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 10, 0, 31),
  [623] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 10, 0, 31),
  [625] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 10, 0, 32),
  [627] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 10, 0, 32),
  [629] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_statement, 10, 0, 29),
  [631] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_statement, 10, 0, 29),
  [633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 11, 0, 33),
  [635] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 11, 0, 33),
  [637] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 11, 0, 34),
  [639] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 11, 0, 34),
  [641] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 12, 0, 35),
  [643] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 12, 0, 35),
  [645] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 12, 0, 36),
  [647] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 12, 0, 36),
  [649] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_statement, 13, 0, 37),
  [651] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_statement, 13, 0, 37),
  [653] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_comment_tag, 3, 0, 0),
  [655] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_comment_tag, 3, 0, 0),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_break_statement, 3, 0, 0),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_break_statement, 3, 0, 0),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for_continue_statement, 3, 0, 0),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for_continue_statement, 3, 0, 0),
  [665] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set_statement, 4, 0, 0),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_statement, 4, 0, 0),
  [669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_include_statement, 4, 0, 0),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_include_statement, 4, 0, 0),
  [673] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_extends_statement, 4, 0, 0),
  [675] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_extends_statement, 4, 0, 0),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [679] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_import_statement, 6, 0, 13),
  [681] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 6, 0, 13),
  [683] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_statement, 6, 0, 0),
  [685] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_statement, 6, 0, 0),
  [687] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 7, 0, 15),
  [689] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 7, 0, 15),
  [691] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_filter_statement, 7, 0, 0),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_filter_statement, 7, 0, 0),
  [695] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_raw_statement, 7, 0, 19),
  [697] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_raw_statement, 7, 0, 19),
  [699] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 8, 0, 21),
  [701] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 8, 0, 21),
  [703] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_statement, 8, 0, 22),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_statement, 8, 0, 22),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_frontmatter, 2, 0, 0),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_frontmatter, 2, 0, 0),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_frontmatter, 3, 0, 0),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_frontmatter, 3, 0, 0),
  [715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [719] = {.entry = {.count = 1, .reusable = false}}, SHIFT(249),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [723] = {.entry = {.count = 1, .reusable = false}}, SHIFT(251),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [727] = {.entry = {.count = 1, .reusable = false}}, SHIFT(236),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(224),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [735] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(372),
  [738] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(372),
  [741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [747] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0),
  [749] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat2, 2, 0, 0), SHIFT_REPEAT(223),
  [752] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [754] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [756] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [758] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [760] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_test_expression, 4, 0, 12),
  [762] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [764] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [766] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [768] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [770] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [772] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [774] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [776] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [778] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [780] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [782] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [784] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0),
  [786] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2, 0, 0), SHIFT_REPEAT(234),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [795] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat3, 2, 0, 0),
  [797] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat3, 2, 0, 0), SHIFT_REPEAT(237),
  [800] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [802] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [804] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_test_expression, 3, 0, 10),
  [808] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [810] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [812] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [814] = {.entry = {.count = 1, .reusable = true}}, SHIFT(181),
  [816] = {.entry = {.count = 1, .reusable = false}}, SHIFT(19),
  [818] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [820] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 14),
  [824] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [834] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [836] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 17), SHIFT_REPEAT(270),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 17),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [849] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0), SHIFT_REPEAT(282),
  [852] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_argument_list_repeat1, 2, 0, 0),
  [854] = {.entry = {.count = 1, .reusable = false}}, SHIFT(24),
  [856] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [858] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [860] = {.entry = {.count = 1, .reusable = true}}, SHIFT(283),
  [862] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_array_repeat1, 2, 0, 0), SHIFT_REPEAT(89),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [877] = {.entry = {.count = 1, .reusable = false}}, SHIFT(377),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 5, 0, 16),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [891] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3, 0, 14),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 5, 0, 18),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3, 0, 0),
  [899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [907] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_test_expression, 6, 0, 23),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [915] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2, 0, 0),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [925] = {.entry = {.count = 1, .reusable = false}}, SHIFT(394),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [935] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [937] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [939] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [941] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [943] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_test_expression, 7, 0, 27),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [949] = {.entry = {.count = 1, .reusable = true}}, SHIFT(137),
  [951] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(144),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [979] = {.entry = {.count = 1, .reusable = false}}, SHIFT(399),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(189),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1007] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4, 0, 14),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [1011] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2, 0, 0),
  [1013] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_optional_parameter, 3, 0, 11),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4, 0, 16),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1023] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4, 0, 0),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1027] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4, 0, 18),
  [1029] = {.entry = {.count = 1, .reusable = false}}, SHIFT(239),
  [1031] = {.entry = {.count = 1, .reusable = false}}, SHIFT(415),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1035] = {.entry = {.count = 1, .reusable = false}}, SHIFT(381),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1041] = {.entry = {.count = 1, .reusable = false}}, SHIFT(391),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [1049] = {.entry = {.count = 1, .reusable = false}}, SHIFT(389),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1053] = {.entry = {.count = 1, .reusable = false}}, SHIFT(392),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1057] = {.entry = {.count = 1, .reusable = false}}, SHIFT(390),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(390),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(149),
  [1063] = {.entry = {.count = 1, .reusable = false}}, SHIFT(384),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1067] = {.entry = {.count = 1, .reusable = false}}, SHIFT(396),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1071] = {.entry = {.count = 1, .reusable = false}}, SHIFT(397),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1075] = {.entry = {.count = 1, .reusable = false}}, SHIFT(401),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1079] = {.entry = {.count = 1, .reusable = false}}, SHIFT(402),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1083] = {.entry = {.count = 1, .reusable = false}}, SHIFT(405),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [1099] = {.entry = {.count = 1, .reusable = false}}, SHIFT(410),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(185),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(317),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1177] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_frontmatter_delimiter = 0,
  ts_external_token_content = 1,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_frontmatter_delimiter] = sym_frontmatter_delimiter,
  [ts_external_token_content] = sym_content,
};

static const bool ts_external_scanner_states[3][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_frontmatter_delimiter] = true,
    [ts_external_token_content] = true,
  },
  [2] = {
    [ts_external_token_content] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_tera_external_scanner_create(void);
void tree_sitter_tera_external_scanner_destroy(void *);
bool tree_sitter_tera_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_tera_external_scanner_serialize(void *, char *);
void tree_sitter_tera_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_tera(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_tera_external_scanner_create,
      tree_sitter_tera_external_scanner_destroy,
      tree_sitter_tera_external_scanner_scan,
      tree_sitter_tera_external_scanner_serialize,
      tree_sitter_tera_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
