# Tree-sitter log

A tree sitter grammar that's trying to be general enough to work through most log files. Mainly inspired by the [VSCode extension] and [this repo].
For now it's integrated into [Helix Editor](https://github.com/helix-editor/helix), but can be used everywhere you use tree-sitter.

If something is not highlighted as you want, feel free to submit a PR or open an issue.

The most important files are *grammar.js* and *test/corpus/testsuite.log*, almost all the rest is generated by the `tree-sitter` command line tool.

## How to

You need to install the requirements for tree-sitter, you can follow the [official doc].

### Build

```sh
tree-sitter generate
```

### Test

```sh
tree-sitter generate && tree-sitter test
```

### Highlight a file 

You will need to configure a theme for this, see [this link](https://tree-sitter.github.io/tree-sitter/syntax-highlighting).
An example that defines the theme for the queries can be found in the file *config.json*.

```sh
tree-sitter generate && tree-sitter highlight <FILE_PATH>.log
```

## What can be improved
 
- add url parsing
- *known_failures.log* tests

[VSCode extension]: https://github.com/microsoft/vscode/tree/94c9ea46838a9a619aeafb7e8afd1170c967bb55/extensions/log
[this repo]: https://github.com/lpraneis/tree-sitter-tracing-log
[official doc]: https://tree-sitter.github.io/tree-sitter/creating-parsers#getting-started
