#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1443
#define LARGE_STATE_COUNT 124
#define SYMBOL_COUNT 208
#define ALIAS_COUNT 3
#define TOKEN_COUNT 105
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 19
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 87

enum {
  sym__identifier = 1,
  sym_comment = 2,
  sym_true = 3,
  sym_false = 4,
  sym_null = 5,
  sym_underscore = 6,
  sym_static_keyword = 7,
  anon_sym_remote = 8,
  anon_sym_master = 9,
  anon_sym_puppet = 10,
  anon_sym_remotesync = 11,
  anon_sym_mastersync = 12,
  anon_sym_puppetsync = 13,
  sym_escape_sequence = 14,
  sym_float = 15,
  sym_integer = 16,
  anon_sym_AMP = 17,
  sym_node_path = 18,
  sym_get_node = 19,
  anon_sym_SEMI = 20,
  anon_sym_AT = 21,
  anon_sym_COLON_EQ = 22,
  anon_sym_COLON = 23,
  anon_sym_EQ = 24,
  anon_sym_set = 25,
  anon_sym_get = 26,
  anon_sym_COMMA = 27,
  anon_sym_setget = 28,
  anon_sym_var = 29,
  anon_sym_export = 30,
  anon_sym_onready = 31,
  anon_sym_const = 32,
  anon_sym_return = 33,
  anon_sym_pass = 34,
  anon_sym_break = 35,
  sym_breakpoint_statement = 36,
  anon_sym_continue = 37,
  sym_tool_statement = 38,
  anon_sym_signal = 39,
  anon_sym_class_name = 40,
  anon_sym_extends = 41,
  anon_sym_if = 42,
  anon_sym_elif = 43,
  anon_sym_else = 44,
  anon_sym_for = 45,
  anon_sym_in = 46,
  anon_sym_while = 47,
  anon_sym_class = 48,
  anon_sym_enum = 49,
  anon_sym_LBRACE = 50,
  anon_sym_RBRACE = 51,
  anon_sym_match = 52,
  anon_sym_when = 53,
  sym_pattern_open_ending = 54,
  anon_sym_LBRACK = 55,
  anon_sym_RBRACK = 56,
  anon_sym_and = 57,
  anon_sym_AMP_AMP = 58,
  anon_sym_or = 59,
  anon_sym_PIPE_PIPE = 60,
  anon_sym_PLUS = 61,
  anon_sym_DASH = 62,
  anon_sym_STAR = 63,
  anon_sym_SLASH = 64,
  anon_sym_PERCENT = 65,
  anon_sym_PIPE = 66,
  anon_sym_CARET = 67,
  anon_sym_LT_LT = 68,
  anon_sym_GT_GT = 69,
  anon_sym_is = 70,
  anon_sym_not = 71,
  anon_sym_as = 72,
  anon_sym_BANG = 73,
  anon_sym_TILDE = 74,
  anon_sym_LT = 75,
  anon_sym_LT_EQ = 76,
  anon_sym_EQ_EQ = 77,
  anon_sym_BANG_EQ = 78,
  anon_sym_GT_EQ = 79,
  anon_sym_GT = 80,
  anon_sym_DOT = 81,
  anon_sym_LPAREN = 82,
  anon_sym_RPAREN = 83,
  anon_sym_await = 84,
  anon_sym_PLUS_EQ = 85,
  anon_sym_DASH_EQ = 86,
  anon_sym_STAR_EQ = 87,
  anon_sym_SLASH_EQ = 88,
  anon_sym_PERCENT_EQ = 89,
  anon_sym_GT_GT_EQ = 90,
  anon_sym_LT_LT_EQ = 91,
  anon_sym_AMP_EQ = 92,
  anon_sym_CARET_EQ = 93,
  anon_sym_PIPE_EQ = 94,
  anon_sym_DASH_GT = 95,
  anon_sym_func = 96,
  anon_sym__init = 97,
  sym__newline = 98,
  sym__indent = 99,
  sym__dedent = 100,
  sym__string_start = 101,
  sym__string_content = 102,
  sym__string_end = 103,
  sym__body_end = 104,
  sym_source = 105,
  sym_identifier = 106,
  sym_name = 107,
  sym_remote_keyword = 108,
  sym_string = 109,
  sym_string_name = 110,
  sym_type = 111,
  sym__statement = 112,
  sym_body = 113,
  sym__simple_statements = 114,
  sym_expression_statement = 115,
  sym_annotation = 116,
  aux_sym__annotations = 117,
  sym_annotations = 118,
  sym_inferred_type = 119,
  sym__variable_assignment = 120,
  sym__variable_inferred_type_assignment = 121,
  sym__variable_typed_assignment = 122,
  sym__variable_typed_definition = 123,
  sym_set_body = 124,
  sym_get_body = 125,
  sym__set_assign = 126,
  sym__get_assign = 127,
  sym__setget_body = 128,
  sym_setter = 129,
  sym_getter = 130,
  sym_setget = 131,
  sym__variable_statement = 132,
  sym_variable_statement = 133,
  sym_export_variable_statement = 134,
  sym_onready_variable_statement = 135,
  sym_const_statement = 136,
  sym_return_statement = 137,
  sym_pass_statement = 138,
  sym_break_statement = 139,
  sym_continue_statement = 140,
  sym_signal_statement = 141,
  sym_class_name_statement = 142,
  sym_extends_statement = 143,
  sym_if_statement = 144,
  sym_elif_clause = 145,
  sym_else_clause = 146,
  sym_for_statement = 147,
  sym_while_statement = 148,
  sym_class_definition = 149,
  sym_enum_definition = 150,
  sym_enumerator_list = 151,
  sym__enumerator_expression = 152,
  sym_enumerator = 153,
  sym_match_statement = 154,
  sym_match_body = 155,
  sym_pattern_guard = 156,
  sym_pattern_section = 157,
  sym__pattern = 158,
  sym_pattern_binding = 159,
  sym_pattern_array = 160,
  sym_pattern_dictionary = 161,
  sym_pattern_pair = 162,
  sym__expression = 163,
  sym__primary_expression = 164,
  sym__rhs_expression = 165,
  sym__attribute_expression = 166,
  sym_binary_operator = 167,
  sym_unary_operator = 168,
  sym_comparison_operator = 169,
  sym_subscript = 170,
  sym_attribute_call = 171,
  sym_attribute_subscript = 172,
  sym_attribute = 173,
  sym_conditional_expression = 174,
  sym_parenthesized_expression = 175,
  sym_await_expression = 176,
  sym_assignment = 177,
  sym_augmented_assignment = 178,
  sym_pair = 179,
  sym_dictionary = 180,
  sym_array = 181,
  sym_typed_parameter = 182,
  sym_default_parameter = 183,
  sym_typed_default_parameter = 184,
  sym__parameters = 185,
  sym_parameters = 186,
  sym__return_type = 187,
  sym_function_definition = 188,
  sym_lambda = 189,
  sym_constructor_definition = 190,
  sym_arguments = 191,
  sym_base_call = 192,
  sym_call = 193,
  aux_sym_source_repeat1 = 194,
  aux_sym_string_repeat1 = 195,
  aux_sym__simple_statements_repeat1 = 196,
  aux_sym_if_statement_repeat1 = 197,
  aux_sym_enumerator_list_repeat1 = 198,
  aux_sym_match_body_repeat1 = 199,
  aux_sym_pattern_section_repeat1 = 200,
  aux_sym_pattern_array_repeat1 = 201,
  aux_sym_pattern_dictionary_repeat1 = 202,
  aux_sym_comparison_operator_repeat1 = 203,
  aux_sym_attribute_repeat1 = 204,
  aux_sym_dictionary_repeat1 = 205,
  aux_sym_array_repeat1 = 206,
  aux_sym_parameters_repeat1 = 207,
  anon_alias_sym_LPAREN_RPAREN = 208,
  anon_alias_sym_body = 209,
  anon_alias_sym_value = 210,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__identifier] = "_identifier",
  [sym_comment] = "comment",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_underscore] = "underscore",
  [sym_static_keyword] = "static_keyword",
  [anon_sym_remote] = "remote",
  [anon_sym_master] = "master",
  [anon_sym_puppet] = "puppet",
  [anon_sym_remotesync] = "remotesync",
  [anon_sym_mastersync] = "mastersync",
  [anon_sym_puppetsync] = "puppetsync",
  [sym_escape_sequence] = "escape_sequence",
  [sym_float] = "float",
  [sym_integer] = "integer",
  [anon_sym_AMP] = "&",
  [sym_node_path] = "node_path",
  [sym_get_node] = "get_node",
  [anon_sym_SEMI] = ";",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_COLON] = ":",
  [anon_sym_EQ] = "=",
  [anon_sym_set] = "set",
  [anon_sym_get] = "get",
  [anon_sym_COMMA] = ",",
  [anon_sym_setget] = "setget",
  [anon_sym_var] = "var",
  [anon_sym_export] = "export",
  [anon_sym_onready] = "onready",
  [anon_sym_const] = "const",
  [anon_sym_return] = "return",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [sym_breakpoint_statement] = "breakpoint_statement",
  [anon_sym_continue] = "continue",
  [sym_tool_statement] = "tool_statement",
  [anon_sym_signal] = "signal",
  [anon_sym_class_name] = "class_name",
  [anon_sym_extends] = "extends",
  [anon_sym_if] = "if",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_class] = "class",
  [anon_sym_enum] = "enum",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_match] = "match",
  [anon_sym_when] = "when",
  [sym_pattern_open_ending] = "pattern_open_ending",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_and] = "and",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_or] = "or",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_is] = "is",
  [anon_sym_not] = "not",
  [anon_sym_as] = "as",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_DOT] = ".",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_func] = "func",
  [anon_sym__init] = "_init",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym__string_start] = "\"",
  [sym__string_content] = "_string_content",
  [sym__string_end] = "\"",
  [sym__body_end] = "_body_end",
  [sym_source] = "source",
  [sym_identifier] = "identifier",
  [sym_name] = "name",
  [sym_remote_keyword] = "remote_keyword",
  [sym_string] = "string",
  [sym_string_name] = "string_name",
  [sym_type] = "type",
  [sym__statement] = "_statement",
  [sym_body] = "body",
  [sym__simple_statements] = "_simple_statements",
  [sym_expression_statement] = "expression_statement",
  [sym_annotation] = "annotation",
  [aux_sym__annotations] = "_annotations",
  [sym_annotations] = "annotations",
  [sym_inferred_type] = "inferred_type",
  [sym__variable_assignment] = "_variable_assignment",
  [sym__variable_inferred_type_assignment] = "_variable_inferred_type_assignment",
  [sym__variable_typed_assignment] = "_variable_typed_assignment",
  [sym__variable_typed_definition] = "_variable_typed_definition",
  [sym_set_body] = "set_body",
  [sym_get_body] = "get_body",
  [sym__set_assign] = "_set_assign",
  [sym__get_assign] = "_get_assign",
  [sym__setget_body] = "_setget_body",
  [sym_setter] = "setter",
  [sym_getter] = "getter",
  [sym_setget] = "setget",
  [sym__variable_statement] = "_variable_statement",
  [sym_variable_statement] = "variable_statement",
  [sym_export_variable_statement] = "export_variable_statement",
  [sym_onready_variable_statement] = "onready_variable_statement",
  [sym_const_statement] = "const_statement",
  [sym_return_statement] = "return_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_signal_statement] = "signal_statement",
  [sym_class_name_statement] = "class_name_statement",
  [sym_extends_statement] = "extends_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_class_definition] = "class_definition",
  [sym_enum_definition] = "enum_definition",
  [sym_enumerator_list] = "enumerator_list",
  [sym__enumerator_expression] = "_enumerator_expression",
  [sym_enumerator] = "enumerator",
  [sym_match_statement] = "match_statement",
  [sym_match_body] = "match_body",
  [sym_pattern_guard] = "pattern_guard",
  [sym_pattern_section] = "pattern_section",
  [sym__pattern] = "_pattern",
  [sym_pattern_binding] = "pattern_binding",
  [sym_pattern_array] = "pattern_array",
  [sym_pattern_dictionary] = "pattern_dictionary",
  [sym_pattern_pair] = "pattern_pair",
  [sym__expression] = "_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym__rhs_expression] = "_rhs_expression",
  [sym__attribute_expression] = "_attribute_expression",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_subscript] = "subscript",
  [sym_attribute_call] = "attribute_call",
  [sym_attribute_subscript] = "attribute_subscript",
  [sym_attribute] = "attribute",
  [sym_conditional_expression] = "conditional_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_await_expression] = "await_expression",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pair] = "pair",
  [sym_dictionary] = "dictionary",
  [sym_array] = "array",
  [sym_typed_parameter] = "typed_parameter",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym__parameters] = "_parameters",
  [sym_parameters] = "parameters",
  [sym__return_type] = "_return_type",
  [sym_function_definition] = "function_definition",
  [sym_lambda] = "lambda",
  [sym_constructor_definition] = "constructor_definition",
  [sym_arguments] = "arguments",
  [sym_base_call] = "base_call",
  [sym_call] = "call",
  [aux_sym_source_repeat1] = "source_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym_match_body_repeat1] = "match_body_repeat1",
  [aux_sym_pattern_section_repeat1] = "pattern_section_repeat1",
  [aux_sym_pattern_array_repeat1] = "pattern_array_repeat1",
  [aux_sym_pattern_dictionary_repeat1] = "pattern_dictionary_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [anon_alias_sym_LPAREN_RPAREN] = "()",
  [anon_alias_sym_body] = "body",
  [anon_alias_sym_value] = "value",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__identifier] = sym__identifier,
  [sym_comment] = sym_comment,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_underscore] = sym_underscore,
  [sym_static_keyword] = sym_static_keyword,
  [anon_sym_remote] = anon_sym_remote,
  [anon_sym_master] = anon_sym_master,
  [anon_sym_puppet] = anon_sym_puppet,
  [anon_sym_remotesync] = anon_sym_remotesync,
  [anon_sym_mastersync] = anon_sym_mastersync,
  [anon_sym_puppetsync] = anon_sym_puppetsync,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_float] = sym_float,
  [sym_integer] = sym_integer,
  [anon_sym_AMP] = anon_sym_AMP,
  [sym_node_path] = sym_node_path,
  [sym_get_node] = sym_get_node,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_setget] = anon_sym_setget,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_onready] = anon_sym_onready,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [sym_breakpoint_statement] = sym_breakpoint_statement,
  [anon_sym_continue] = anon_sym_continue,
  [sym_tool_statement] = sym_tool_statement,
  [anon_sym_signal] = anon_sym_signal,
  [anon_sym_class_name] = anon_sym_class_name,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_match] = anon_sym_match,
  [anon_sym_when] = anon_sym_when,
  [sym_pattern_open_ending] = sym_pattern_open_ending,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_func] = anon_sym_func,
  [anon_sym__init] = anon_sym__init,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_start,
  [sym__body_end] = sym__body_end,
  [sym_source] = sym_source,
  [sym_identifier] = sym_identifier,
  [sym_name] = sym_name,
  [sym_remote_keyword] = sym_remote_keyword,
  [sym_string] = sym_string,
  [sym_string_name] = sym_string_name,
  [sym_type] = sym_type,
  [sym__statement] = sym__statement,
  [sym_body] = sym_body,
  [sym__simple_statements] = sym__simple_statements,
  [sym_expression_statement] = sym_expression_statement,
  [sym_annotation] = sym_annotation,
  [aux_sym__annotations] = aux_sym__annotations,
  [sym_annotations] = sym_annotations,
  [sym_inferred_type] = sym_inferred_type,
  [sym__variable_assignment] = sym__variable_assignment,
  [sym__variable_inferred_type_assignment] = sym__variable_inferred_type_assignment,
  [sym__variable_typed_assignment] = sym__variable_typed_assignment,
  [sym__variable_typed_definition] = sym__variable_typed_definition,
  [sym_set_body] = sym_set_body,
  [sym_get_body] = sym_get_body,
  [sym__set_assign] = sym__set_assign,
  [sym__get_assign] = sym__get_assign,
  [sym__setget_body] = sym__setget_body,
  [sym_setter] = sym_setter,
  [sym_getter] = sym_getter,
  [sym_setget] = sym_setget,
  [sym__variable_statement] = sym__variable_statement,
  [sym_variable_statement] = sym_variable_statement,
  [sym_export_variable_statement] = sym_export_variable_statement,
  [sym_onready_variable_statement] = sym_onready_variable_statement,
  [sym_const_statement] = sym_const_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_signal_statement] = sym_signal_statement,
  [sym_class_name_statement] = sym_class_name_statement,
  [sym_extends_statement] = sym_extends_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_enum_definition] = sym_enum_definition,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym__enumerator_expression] = sym__enumerator_expression,
  [sym_enumerator] = sym_enumerator,
  [sym_match_statement] = sym_match_statement,
  [sym_match_body] = sym_match_body,
  [sym_pattern_guard] = sym_pattern_guard,
  [sym_pattern_section] = sym_pattern_section,
  [sym__pattern] = sym__pattern,
  [sym_pattern_binding] = sym_pattern_binding,
  [sym_pattern_array] = sym_pattern_array,
  [sym_pattern_dictionary] = sym_pattern_dictionary,
  [sym_pattern_pair] = sym_pattern_pair,
  [sym__expression] = sym__expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym__rhs_expression] = sym__rhs_expression,
  [sym__attribute_expression] = sym__attribute_expression,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_subscript] = sym_subscript,
  [sym_attribute_call] = sym_attribute_call,
  [sym_attribute_subscript] = sym_attribute_subscript,
  [sym_attribute] = sym_attribute,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pair] = sym_pair,
  [sym_dictionary] = sym_dictionary,
  [sym_array] = sym_array,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym__parameters] = sym__parameters,
  [sym_parameters] = sym_parameters,
  [sym__return_type] = sym__return_type,
  [sym_function_definition] = sym_function_definition,
  [sym_lambda] = sym_lambda,
  [sym_constructor_definition] = sym_constructor_definition,
  [sym_arguments] = sym_arguments,
  [sym_base_call] = sym_base_call,
  [sym_call] = sym_call,
  [aux_sym_source_repeat1] = aux_sym_source_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym_match_body_repeat1] = aux_sym_match_body_repeat1,
  [aux_sym_pattern_section_repeat1] = aux_sym_pattern_section_repeat1,
  [aux_sym_pattern_array_repeat1] = aux_sym_pattern_array_repeat1,
  [aux_sym_pattern_dictionary_repeat1] = aux_sym_pattern_dictionary_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [anon_alias_sym_LPAREN_RPAREN] = anon_alias_sym_LPAREN_RPAREN,
  [anon_alias_sym_body] = anon_alias_sym_body,
  [anon_alias_sym_value] = anon_alias_sym_value,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym_static_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_remote] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_master] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_puppet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_remotesync] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mastersync] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_puppetsync] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_node_path] = {
    .visible = true,
    .named = true,
  },
  [sym_get_node] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_setget] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_onready] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [sym_breakpoint_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [sym_tool_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_signal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class_name] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_when] = {
    .visible = true,
    .named = false,
  },
  [sym_pattern_open_ending] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__init] = {
    .visible = true,
    .named = false,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = true,
    .named = false,
  },
  [sym__body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_source] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__annotations] = {
    .visible = false,
    .named = false,
  },
  [sym_annotations] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_type] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment] = {
    .visible = false,
    .named = true,
  },
  [sym__variable_inferred_type_assignment] = {
    .visible = false,
    .named = true,
  },
  [sym__variable_typed_assignment] = {
    .visible = false,
    .named = true,
  },
  [sym__variable_typed_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_set_body] = {
    .visible = true,
    .named = true,
  },
  [sym_get_body] = {
    .visible = true,
    .named = true,
  },
  [sym__set_assign] = {
    .visible = false,
    .named = true,
  },
  [sym__get_assign] = {
    .visible = false,
    .named = true,
  },
  [sym__setget_body] = {
    .visible = false,
    .named = true,
  },
  [sym_setter] = {
    .visible = true,
    .named = true,
  },
  [sym_getter] = {
    .visible = true,
    .named = true,
  },
  [sym_setget] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_onready_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_const_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_signal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_name_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym__enumerator_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_match_body] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_guard] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_section] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_array] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__rhs_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_call] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__return_type] = {
    .visible = false,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_base_call] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_LPAREN_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_body] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_value] = {
    .visible = true,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_body = 2,
  field_condition = 3,
  field_constructor_arguments = 4,
  field_export_arguments = 5,
  field_extends = 6,
  field_get = 7,
  field_icon_path = 8,
  field_key = 9,
  field_left = 10,
  field_name = 11,
  field_parameters = 12,
  field_return_type = 13,
  field_right = 14,
  field_set = 15,
  field_setget = 16,
  field_static = 17,
  field_type = 18,
  field_value = 19,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_constructor_arguments] = "constructor_arguments",
  [field_export_arguments] = "export_arguments",
  [field_extends] = "extends",
  [field_get] = "get",
  [field_icon_path] = "icon_path",
  [field_key] = "key",
  [field_left] = "left",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_set] = "set",
  [field_setget] = "setget",
  [field_static] = "static",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 5},
  [3] = {.index = 5, .length = 1},
  [4] = {.index = 6, .length = 5},
  [5] = {.index = 11, .length = 1},
  [6] = {.index = 12, .length = 2},
  [7] = {.index = 14, .length = 2},
  [8] = {.index = 16, .length = 3},
  [9] = {.index = 19, .length = 2},
  [10] = {.index = 21, .length = 2},
  [11] = {.index = 23, .length = 2},
  [12] = {.index = 25, .length = 5},
  [13] = {.index = 30, .length = 6},
  [14] = {.index = 36, .length = 1},
  [15] = {.index = 37, .length = 2},
  [16] = {.index = 39, .length = 1},
  [17] = {.index = 40, .length = 2},
  [18] = {.index = 42, .length = 3},
  [19] = {.index = 45, .length = 4},
  [20] = {.index = 49, .length = 3},
  [21] = {.index = 52, .length = 1},
  [22] = {.index = 53, .length = 1},
  [23] = {.index = 54, .length = 2},
  [24] = {.index = 56, .length = 3},
  [25] = {.index = 59, .length = 4},
  [26] = {.index = 63, .length = 6},
  [27] = {.index = 69, .length = 1},
  [28] = {.index = 70, .length = 2},
  [29] = {.index = 72, .length = 2},
  [30] = {.index = 74, .length = 2},
  [31] = {.index = 76, .length = 2},
  [32] = {.index = 78, .length = 2},
  [33] = {.index = 80, .length = 1},
  [34] = {.index = 81, .length = 2},
  [35] = {.index = 83, .length = 2},
  [36] = {.index = 85, .length = 3},
  [37] = {.index = 88, .length = 2},
  [38] = {.index = 90, .length = 4},
  [39] = {.index = 94, .length = 5},
  [40] = {.index = 99, .length = 2},
  [41] = {.index = 101, .length = 1},
  [42] = {.index = 102, .length = 3},
  [43] = {.index = 105, .length = 3},
  [44] = {.index = 108, .length = 3},
  [45] = {.index = 111, .length = 1},
  [46] = {.index = 112, .length = 1},
  [47] = {.index = 113, .length = 3},
  [48] = {.index = 116, .length = 3},
  [49] = {.index = 119, .length = 3},
  [50] = {.index = 122, .length = 4},
  [51] = {.index = 126, .length = 3},
  [52] = {.index = 129, .length = 3},
  [53] = {.index = 132, .length = 4},
  [54] = {.index = 136, .length = 3},
  [55] = {.index = 139, .length = 3},
  [56] = {.index = 142, .length = 2},
  [57] = {.index = 144, .length = 1},
  [58] = {.index = 145, .length = 1},
  [59] = {.index = 146, .length = 2},
  [60] = {.index = 148, .length = 1},
  [61] = {.index = 149, .length = 4},
  [62] = {.index = 153, .length = 2},
  [63] = {.index = 155, .length = 3},
  [64] = {.index = 158, .length = 4},
  [65] = {.index = 162, .length = 4},
  [66] = {.index = 166, .length = 5},
  [67] = {.index = 171, .length = 4},
  [68] = {.index = 175, .length = 3},
  [69] = {.index = 178, .length = 3},
  [71] = {.index = 181, .length = 2},
  [72] = {.index = 183, .length = 2},
  [73] = {.index = 185, .length = 1},
  [74] = {.index = 186, .length = 1},
  [75] = {.index = 187, .length = 2},
  [76] = {.index = 189, .length = 3},
  [77] = {.index = 192, .length = 3},
  [78] = {.index = 195, .length = 4},
  [81] = {.index = 199, .length = 2},
  [82] = {.index = 201, .length = 2},
  [83] = {.index = 203, .length = 4},
  [84] = {.index = 207, .length = 1},
  [85] = {.index = 208, .length = 1},
  [86] = {.index = 209, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0, .inherited = true},
    {field_setget, 0, .inherited = true},
    {field_static, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [5] =
    {field_name, 1},
  [6] =
    {field_name, 1, .inherited = true},
    {field_setget, 1, .inherited = true},
    {field_static, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [11] =
    {field_body, 1},
  [12] =
    {field_name, 2},
    {field_static, 0},
  [14] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [16] =
    {field_name, 1},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [19] =
    {field_type, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [21] =
    {field_get, 0, .inherited = true},
    {field_set, 0, .inherited = true},
  [23] =
    {field_name, 1},
    {field_setget, 2},
  [25] =
    {field_name, 2, .inherited = true},
    {field_setget, 2, .inherited = true},
    {field_static, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [30] =
    {field_export_arguments, 1},
    {field_name, 2, .inherited = true},
    {field_setget, 2, .inherited = true},
    {field_static, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [36] =
    {field_left, 0},
  [37] =
    {field_body, 2},
    {field_name, 1},
  [39] =
    {field_name, 2},
  [40] =
    {field_left, 0},
    {field_right, 2},
  [42] =
    {field_name, 2},
    {field_static, 0},
    {field_value, 3, .inherited = true},
  [45] =
    {field_name, 2},
    {field_static, 0},
    {field_type, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [49] =
    {field_name, 2},
    {field_setget, 3},
    {field_static, 0},
  [52] =
    {field_type, 1},
  [53] =
    {field_value, 1},
  [54] =
    {field_type, 0},
    {field_value, 1},
  [56] =
    {field_name, 1},
    {field_setget, 3},
    {field_value, 2, .inherited = true},
  [59] =
    {field_name, 1},
    {field_setget, 3},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [63] =
    {field_export_arguments, 1},
    {field_name, 3, .inherited = true},
    {field_setget, 3, .inherited = true},
    {field_static, 3, .inherited = true},
    {field_type, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [69] =
    {field_icon_path, 3},
  [70] =
    {field_body, 3},
    {field_condition, 1},
  [72] =
    {field_body, 3},
    {field_name, 1},
  [74] =
    {field_key, 0},
    {field_value, 2},
  [76] =
    {field_body, 3},
    {field_value, 1},
  [78] =
    {field_body, 3},
    {field_parameters, 1},
  [80] =
    {field_return_type, 1},
  [81] =
    {field_name, 3},
    {field_static, 1},
  [83] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [85] =
    {field_name, 2},
    {field_type, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [88] =
    {field_name, 2},
    {field_setget, 3},
  [90] =
    {field_name, 2},
    {field_setget, 4},
    {field_static, 0},
    {field_value, 3, .inherited = true},
  [94] =
    {field_name, 2},
    {field_setget, 4},
    {field_static, 0},
    {field_type, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [99] =
    {field_body, 4},
    {field_parameters, 2},
  [101] =
    {field_alternative, 0},
  [102] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [105] =
    {field_alternative, 4, .inherited = true},
    {field_body, 3},
    {field_condition, 1},
  [108] =
    {field_body, 4},
    {field_extends, 2},
    {field_name, 1},
  [111] =
    {field_type, 2},
  [112] =
    {field_value, 2},
  [113] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [116] =
    {field_body, 4},
    {field_parameters, 1},
    {field_return_type, 2, .inherited = true},
  [119] =
    {field_name, 3},
    {field_static, 1},
    {field_value, 4, .inherited = true},
  [122] =
    {field_name, 3},
    {field_static, 1},
    {field_type, 4, .inherited = true},
    {field_value, 4, .inherited = true},
  [126] =
    {field_name, 3},
    {field_setget, 4},
    {field_static, 1},
  [129] =
    {field_name, 2},
    {field_setget, 4},
    {field_value, 3, .inherited = true},
  [132] =
    {field_name, 2},
    {field_setget, 4},
    {field_type, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [136] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [139] =
    {field_body, 5},
    {field_parameters, 2},
    {field_return_type, 3, .inherited = true},
  [142] =
    {field_body, 5},
    {field_parameters, 3},
  [144] =
    {field_set, 2},
  [145] =
    {field_get, 2},
  [146] =
    {field_type, 1},
    {field_value, 3},
  [148] =
    {field_return_type, 2, .inherited = true},
  [149] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_body, 3},
    {field_condition, 1},
  [153] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [155] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [158] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 3, .inherited = true},
  [162] =
    {field_name, 3},
    {field_setget, 5},
    {field_static, 1},
    {field_value, 4, .inherited = true},
  [166] =
    {field_name, 3},
    {field_setget, 5},
    {field_static, 1},
    {field_type, 4, .inherited = true},
    {field_value, 4, .inherited = true},
  [171] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 4, .inherited = true},
  [175] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 4},
  [178] =
    {field_body, 6},
    {field_parameters, 3},
    {field_return_type, 4, .inherited = true},
  [181] =
    {field_get, 3},
    {field_set, 2},
  [183] =
    {field_get, 2},
    {field_set, 3},
  [185] =
    {field_return_type, 3, .inherited = true},
  [186] =
    {field_body, 2},
  [187] =
    {field_type, 2},
    {field_value, 4},
  [189] =
    {field_body, 6},
    {field_constructor_arguments, 4},
    {field_parameters, 2},
  [192] =
    {field_body, 6},
    {field_parameters, 2},
    {field_return_type, 4},
  [195] =
    {field_body, 7},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 5, .inherited = true},
  [199] =
    {field_get, 4, .inherited = true},
    {field_set, 2, .inherited = true},
  [201] =
    {field_get, 2, .inherited = true},
    {field_set, 4, .inherited = true},
  [203] =
    {field_body, 7},
    {field_left, 1},
    {field_right, 5},
    {field_type, 3},
  [207] =
    {field_body, 3},
  [208] =
    {field_body, 4},
  [209] =
    {field_body, 8},
    {field_constructor_arguments, 4},
    {field_parameters, 2},
    {field_return_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [1] = anon_alias_sym_value,
  },
  [70] = {
    [2] = anon_alias_sym_body,
  },
  [79] = {
    [3] = anon_alias_sym_body,
  },
  [80] = {
    [1] = anon_alias_sym_LPAREN_RPAREN,
    [3] = anon_alias_sym_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_string, 2,
    sym_string,
    anon_alias_sym_value,
  sym_body, 2,
    sym_body,
    anon_alias_sym_body,
  sym_parameters, 2,
    sym_parameters,
    anon_alias_sym_LPAREN_RPAREN,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 3,
  [5] = 2,
  [6] = 2,
  [7] = 7,
  [8] = 2,
  [9] = 3,
  [10] = 2,
  [11] = 3,
  [12] = 2,
  [13] = 3,
  [14] = 2,
  [15] = 2,
  [16] = 3,
  [17] = 2,
  [18] = 2,
  [19] = 3,
  [20] = 3,
  [21] = 3,
  [22] = 3,
  [23] = 23,
  [24] = 7,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 28,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 28,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 31,
  [39] = 28,
  [40] = 40,
  [41] = 26,
  [42] = 25,
  [43] = 43,
  [44] = 35,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 36,
  [50] = 50,
  [51] = 35,
  [52] = 52,
  [53] = 36,
  [54] = 36,
  [55] = 25,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 25,
  [60] = 60,
  [61] = 36,
  [62] = 35,
  [63] = 43,
  [64] = 48,
  [65] = 65,
  [66] = 66,
  [67] = 30,
  [68] = 40,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 71,
  [74] = 74,
  [75] = 75,
  [76] = 28,
  [77] = 47,
  [78] = 78,
  [79] = 74,
  [80] = 35,
  [81] = 57,
  [82] = 82,
  [83] = 72,
  [84] = 84,
  [85] = 60,
  [86] = 35,
  [87] = 70,
  [88] = 28,
  [89] = 25,
  [90] = 69,
  [91] = 78,
  [92] = 65,
  [93] = 75,
  [94] = 36,
  [95] = 58,
  [96] = 52,
  [97] = 45,
  [98] = 32,
  [99] = 50,
  [100] = 25,
  [101] = 66,
  [102] = 56,
  [103] = 103,
  [104] = 104,
  [105] = 104,
  [106] = 103,
  [107] = 103,
  [108] = 104,
  [109] = 103,
  [110] = 104,
  [111] = 103,
  [112] = 104,
  [113] = 103,
  [114] = 104,
  [115] = 103,
  [116] = 104,
  [117] = 104,
  [118] = 103,
  [119] = 104,
  [120] = 104,
  [121] = 103,
  [122] = 103,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 125,
  [127] = 124,
  [128] = 128,
  [129] = 128,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 137,
  [139] = 132,
  [140] = 130,
  [141] = 133,
  [142] = 134,
  [143] = 131,
  [144] = 135,
  [145] = 136,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 175,
  [178] = 148,
  [179] = 166,
  [180] = 162,
  [181] = 156,
  [182] = 160,
  [183] = 155,
  [184] = 153,
  [185] = 174,
  [186] = 173,
  [187] = 146,
  [188] = 151,
  [189] = 147,
  [190] = 176,
  [191] = 149,
  [192] = 163,
  [193] = 150,
  [194] = 157,
  [195] = 159,
  [196] = 152,
  [197] = 168,
  [198] = 161,
  [199] = 164,
  [200] = 165,
  [201] = 167,
  [202] = 170,
  [203] = 172,
  [204] = 158,
  [205] = 171,
  [206] = 154,
  [207] = 169,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 219,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 235,
  [238] = 238,
  [239] = 233,
  [240] = 240,
  [241] = 241,
  [242] = 233,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 235,
  [247] = 247,
  [248] = 248,
  [249] = 247,
  [250] = 233,
  [251] = 247,
  [252] = 252,
  [253] = 247,
  [254] = 233,
  [255] = 247,
  [256] = 235,
  [257] = 257,
  [258] = 258,
  [259] = 233,
  [260] = 247,
  [261] = 261,
  [262] = 233,
  [263] = 247,
  [264] = 264,
  [265] = 235,
  [266] = 266,
  [267] = 267,
  [268] = 235,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 235,
  [274] = 274,
  [275] = 212,
  [276] = 274,
  [277] = 277,
  [278] = 278,
  [279] = 210,
  [280] = 274,
  [281] = 281,
  [282] = 274,
  [283] = 278,
  [284] = 277,
  [285] = 285,
  [286] = 277,
  [287] = 285,
  [288] = 277,
  [289] = 285,
  [290] = 277,
  [291] = 291,
  [292] = 274,
  [293] = 278,
  [294] = 281,
  [295] = 208,
  [296] = 278,
  [297] = 274,
  [298] = 281,
  [299] = 291,
  [300] = 278,
  [301] = 291,
  [302] = 285,
  [303] = 291,
  [304] = 281,
  [305] = 285,
  [306] = 277,
  [307] = 291,
  [308] = 277,
  [309] = 309,
  [310] = 281,
  [311] = 209,
  [312] = 285,
  [313] = 291,
  [314] = 278,
  [315] = 281,
  [316] = 281,
  [317] = 285,
  [318] = 291,
  [319] = 278,
  [320] = 274,
  [321] = 321,
  [322] = 322,
  [323] = 321,
  [324] = 321,
  [325] = 325,
  [326] = 321,
  [327] = 321,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 321,
  [334] = 331,
  [335] = 321,
  [336] = 336,
  [337] = 330,
  [338] = 338,
  [339] = 339,
  [340] = 330,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 342,
  [346] = 346,
  [347] = 347,
  [348] = 342,
  [349] = 342,
  [350] = 350,
  [351] = 351,
  [352] = 351,
  [353] = 351,
  [354] = 346,
  [355] = 355,
  [356] = 356,
  [357] = 342,
  [358] = 351,
  [359] = 359,
  [360] = 343,
  [361] = 347,
  [362] = 356,
  [363] = 359,
  [364] = 351,
  [365] = 347,
  [366] = 347,
  [367] = 342,
  [368] = 343,
  [369] = 369,
  [370] = 369,
  [371] = 343,
  [372] = 351,
  [373] = 355,
  [374] = 347,
  [375] = 343,
  [376] = 343,
  [377] = 347,
  [378] = 351,
  [379] = 344,
  [380] = 342,
  [381] = 343,
  [382] = 347,
  [383] = 383,
  [384] = 384,
  [385] = 211,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 386,
  [390] = 390,
  [391] = 391,
  [392] = 390,
  [393] = 388,
  [394] = 394,
  [395] = 387,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 400,
  [404] = 397,
  [405] = 405,
  [406] = 399,
  [407] = 405,
  [408] = 408,
  [409] = 397,
  [410] = 408,
  [411] = 411,
  [412] = 412,
  [413] = 398,
  [414] = 414,
  [415] = 415,
  [416] = 399,
  [417] = 401,
  [418] = 411,
  [419] = 412,
  [420] = 398,
  [421] = 414,
  [422] = 422,
  [423] = 415,
  [424] = 411,
  [425] = 425,
  [426] = 412,
  [427] = 412,
  [428] = 425,
  [429] = 425,
  [430] = 425,
  [431] = 422,
  [432] = 425,
  [433] = 425,
  [434] = 425,
  [435] = 402,
  [436] = 401,
  [437] = 401,
  [438] = 415,
  [439] = 422,
  [440] = 414,
  [441] = 422,
  [442] = 422,
  [443] = 398,
  [444] = 412,
  [445] = 402,
  [446] = 411,
  [447] = 415,
  [448] = 408,
  [449] = 397,
  [450] = 399,
  [451] = 405,
  [452] = 400,
  [453] = 397,
  [454] = 408,
  [455] = 411,
  [456] = 412,
  [457] = 398,
  [458] = 414,
  [459] = 415,
  [460] = 400,
  [461] = 405,
  [462] = 399,
  [463] = 422,
  [464] = 422,
  [465] = 399,
  [466] = 401,
  [467] = 405,
  [468] = 400,
  [469] = 402,
  [470] = 397,
  [471] = 408,
  [472] = 411,
  [473] = 402,
  [474] = 412,
  [475] = 399,
  [476] = 405,
  [477] = 400,
  [478] = 402,
  [479] = 397,
  [480] = 405,
  [481] = 408,
  [482] = 408,
  [483] = 401,
  [484] = 414,
  [485] = 411,
  [486] = 400,
  [487] = 398,
  [488] = 398,
  [489] = 414,
  [490] = 415,
  [491] = 414,
  [492] = 401,
  [493] = 415,
  [494] = 402,
  [495] = 219,
  [496] = 219,
  [497] = 214,
  [498] = 222,
  [499] = 214,
  [500] = 222,
  [501] = 211,
  [502] = 221,
  [503] = 215,
  [504] = 220,
  [505] = 219,
  [506] = 213,
  [507] = 266,
  [508] = 216,
  [509] = 214,
  [510] = 222,
  [511] = 215,
  [512] = 217,
  [513] = 224,
  [514] = 229,
  [515] = 221,
  [516] = 224,
  [517] = 225,
  [518] = 226,
  [519] = 228,
  [520] = 218,
  [521] = 220,
  [522] = 219,
  [523] = 219,
  [524] = 226,
  [525] = 224,
  [526] = 227,
  [527] = 225,
  [528] = 226,
  [529] = 208,
  [530] = 228,
  [531] = 218,
  [532] = 218,
  [533] = 228,
  [534] = 216,
  [535] = 225,
  [536] = 216,
  [537] = 221,
  [538] = 229,
  [539] = 217,
  [540] = 219,
  [541] = 215,
  [542] = 228,
  [543] = 226,
  [544] = 227,
  [545] = 245,
  [546] = 213,
  [547] = 225,
  [548] = 224,
  [549] = 221,
  [550] = 227,
  [551] = 219,
  [552] = 229,
  [553] = 220,
  [554] = 217,
  [555] = 215,
  [556] = 217,
  [557] = 248,
  [558] = 245,
  [559] = 222,
  [560] = 212,
  [561] = 216,
  [562] = 218,
  [563] = 213,
  [564] = 261,
  [565] = 209,
  [566] = 210,
  [567] = 248,
  [568] = 266,
  [569] = 213,
  [570] = 261,
  [571] = 219,
  [572] = 211,
  [573] = 220,
  [574] = 214,
  [575] = 229,
  [576] = 227,
  [577] = 231,
  [578] = 241,
  [579] = 241,
  [580] = 271,
  [581] = 272,
  [582] = 238,
  [583] = 267,
  [584] = 231,
  [585] = 252,
  [586] = 219,
  [587] = 232,
  [588] = 241,
  [589] = 269,
  [590] = 236,
  [591] = 240,
  [592] = 270,
  [593] = 244,
  [594] = 243,
  [595] = 236,
  [596] = 258,
  [597] = 234,
  [598] = 598,
  [599] = 257,
  [600] = 269,
  [601] = 270,
  [602] = 264,
  [603] = 244,
  [604] = 243,
  [605] = 234,
  [606] = 271,
  [607] = 257,
  [608] = 272,
  [609] = 252,
  [610] = 232,
  [611] = 240,
  [612] = 264,
  [613] = 238,
  [614] = 213,
  [615] = 245,
  [616] = 213,
  [617] = 216,
  [618] = 212,
  [619] = 258,
  [620] = 214,
  [621] = 222,
  [622] = 215,
  [623] = 216,
  [624] = 217,
  [625] = 220,
  [626] = 214,
  [627] = 221,
  [628] = 224,
  [629] = 222,
  [630] = 225,
  [631] = 226,
  [632] = 228,
  [633] = 218,
  [634] = 267,
  [635] = 215,
  [636] = 217,
  [637] = 220,
  [638] = 221,
  [639] = 211,
  [640] = 257,
  [641] = 208,
  [642] = 224,
  [643] = 234,
  [644] = 225,
  [645] = 226,
  [646] = 243,
  [647] = 244,
  [648] = 228,
  [649] = 231,
  [650] = 258,
  [651] = 257,
  [652] = 234,
  [653] = 270,
  [654] = 269,
  [655] = 218,
  [656] = 219,
  [657] = 243,
  [658] = 244,
  [659] = 264,
  [660] = 227,
  [661] = 240,
  [662] = 236,
  [663] = 271,
  [664] = 272,
  [665] = 238,
  [666] = 267,
  [667] = 229,
  [668] = 241,
  [669] = 266,
  [670] = 261,
  [671] = 229,
  [672] = 209,
  [673] = 208,
  [674] = 252,
  [675] = 267,
  [676] = 238,
  [677] = 272,
  [678] = 271,
  [679] = 232,
  [680] = 236,
  [681] = 231,
  [682] = 210,
  [683] = 248,
  [684] = 248,
  [685] = 219,
  [686] = 210,
  [687] = 219,
  [688] = 232,
  [689] = 269,
  [690] = 240,
  [691] = 252,
  [692] = 270,
  [693] = 245,
  [694] = 209,
  [695] = 261,
  [696] = 212,
  [697] = 266,
  [698] = 227,
  [699] = 264,
  [700] = 258,
  [701] = 210,
  [702] = 243,
  [703] = 236,
  [704] = 270,
  [705] = 271,
  [706] = 270,
  [707] = 272,
  [708] = 211,
  [709] = 238,
  [710] = 267,
  [711] = 240,
  [712] = 208,
  [713] = 248,
  [714] = 269,
  [715] = 232,
  [716] = 248,
  [717] = 252,
  [718] = 210,
  [719] = 231,
  [720] = 232,
  [721] = 252,
  [722] = 261,
  [723] = 266,
  [724] = 209,
  [725] = 241,
  [726] = 261,
  [727] = 211,
  [728] = 257,
  [729] = 244,
  [730] = 243,
  [731] = 234,
  [732] = 231,
  [733] = 208,
  [734] = 209,
  [735] = 244,
  [736] = 266,
  [737] = 264,
  [738] = 267,
  [739] = 245,
  [740] = 269,
  [741] = 258,
  [742] = 238,
  [743] = 234,
  [744] = 264,
  [745] = 272,
  [746] = 271,
  [747] = 257,
  [748] = 212,
  [749] = 258,
  [750] = 240,
  [751] = 212,
  [752] = 245,
  [753] = 236,
  [754] = 241,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 757,
  [760] = 757,
  [761] = 761,
  [762] = 758,
  [763] = 763,
  [764] = 764,
  [765] = 758,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 761,
  [770] = 767,
  [771] = 771,
  [772] = 771,
  [773] = 767,
  [774] = 767,
  [775] = 767,
  [776] = 776,
  [777] = 767,
  [778] = 767,
  [779] = 779,
  [780] = 779,
  [781] = 781,
  [782] = 781,
  [783] = 781,
  [784] = 781,
  [785] = 779,
  [786] = 786,
  [787] = 786,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 131,
  [802] = 755,
  [803] = 755,
  [804] = 130,
  [805] = 805,
  [806] = 132,
  [807] = 756,
  [808] = 756,
  [809] = 136,
  [810] = 755,
  [811] = 134,
  [812] = 756,
  [813] = 135,
  [814] = 814,
  [815] = 815,
  [816] = 756,
  [817] = 755,
  [818] = 755,
  [819] = 756,
  [820] = 756,
  [821] = 755,
  [822] = 822,
  [823] = 822,
  [824] = 822,
  [825] = 822,
  [826] = 822,
  [827] = 827,
  [828] = 822,
  [829] = 822,
  [830] = 822,
  [831] = 831,
  [832] = 822,
  [833] = 822,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 836,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 838,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 848,
  [858] = 858,
  [859] = 859,
  [860] = 860,
  [861] = 858,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 827,
  [866] = 831,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 868,
  [871] = 132,
  [872] = 872,
  [873] = 873,
  [874] = 135,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 878,
  [879] = 134,
  [880] = 880,
  [881] = 881,
  [882] = 872,
  [883] = 835,
  [884] = 884,
  [885] = 136,
  [886] = 131,
  [887] = 130,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 891,
  [895] = 893,
  [896] = 896,
  [897] = 897,
  [898] = 898,
  [899] = 899,
  [900] = 900,
  [901] = 891,
  [902] = 896,
  [903] = 891,
  [904] = 847,
  [905] = 898,
  [906] = 900,
  [907] = 896,
  [908] = 900,
  [909] = 893,
  [910] = 893,
  [911] = 900,
  [912] = 912,
  [913] = 891,
  [914] = 900,
  [915] = 915,
  [916] = 900,
  [917] = 893,
  [918] = 835,
  [919] = 896,
  [920] = 912,
  [921] = 921,
  [922] = 892,
  [923] = 912,
  [924] = 924,
  [925] = 891,
  [926] = 900,
  [927] = 912,
  [928] = 924,
  [929] = 891,
  [930] = 898,
  [931] = 921,
  [932] = 898,
  [933] = 898,
  [934] = 934,
  [935] = 935,
  [936] = 896,
  [937] = 937,
  [938] = 893,
  [939] = 896,
  [940] = 912,
  [941] = 891,
  [942] = 912,
  [943] = 896,
  [944] = 944,
  [945] = 945,
  [946] = 891,
  [947] = 947,
  [948] = 912,
  [949] = 898,
  [950] = 912,
  [951] = 891,
  [952] = 899,
  [953] = 912,
  [954] = 954,
  [955] = 954,
  [956] = 956,
  [957] = 898,
  [958] = 896,
  [959] = 912,
  [960] = 898,
  [961] = 961,
  [962] = 961,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 791,
  [967] = 967,
  [968] = 968,
  [969] = 963,
  [970] = 970,
  [971] = 793,
  [972] = 972,
  [973] = 973,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 978,
  [979] = 973,
  [980] = 863,
  [981] = 974,
  [982] = 982,
  [983] = 973,
  [984] = 974,
  [985] = 985,
  [986] = 986,
  [987] = 794,
  [988] = 973,
  [989] = 974,
  [990] = 990,
  [991] = 991,
  [992] = 968,
  [993] = 993,
  [994] = 791,
  [995] = 973,
  [996] = 863,
  [997] = 793,
  [998] = 974,
  [999] = 999,
  [1000] = 991,
  [1001] = 985,
  [1002] = 982,
  [1003] = 999,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 863,
  [1008] = 132,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 974,
  [1015] = 1015,
  [1016] = 131,
  [1017] = 1017,
  [1018] = 1018,
  [1019] = 794,
  [1020] = 1020,
  [1021] = 135,
  [1022] = 1022,
  [1023] = 211,
  [1024] = 243,
  [1025] = 130,
  [1026] = 1026,
  [1027] = 231,
  [1028] = 136,
  [1029] = 134,
  [1030] = 1030,
  [1031] = 1031,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 1035,
  [1036] = 1022,
  [1037] = 961,
  [1038] = 1038,
  [1039] = 1039,
  [1040] = 1009,
  [1041] = 990,
  [1042] = 794,
  [1043] = 986,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1034,
  [1049] = 1049,
  [1050] = 791,
  [1051] = 973,
  [1052] = 1052,
  [1053] = 793,
  [1054] = 1054,
  [1055] = 1034,
  [1056] = 1056,
  [1057] = 1022,
  [1058] = 1058,
  [1059] = 1026,
  [1060] = 961,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 986,
  [1066] = 990,
  [1067] = 1009,
  [1068] = 990,
  [1069] = 986,
  [1070] = 1009,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 794,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1020,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1022,
  [1083] = 1030,
  [1084] = 1031,
  [1085] = 1058,
  [1086] = 1063,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1034,
  [1090] = 1039,
  [1091] = 1061,
  [1092] = 1022,
  [1093] = 1044,
  [1094] = 961,
  [1095] = 1034,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 1009,
  [1099] = 990,
  [1100] = 1054,
  [1101] = 791,
  [1102] = 986,
  [1103] = 1103,
  [1104] = 1064,
  [1105] = 1075,
  [1106] = 1106,
  [1107] = 1078,
  [1108] = 1108,
  [1109] = 793,
  [1110] = 1110,
  [1111] = 1111,
  [1112] = 1112,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1116,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1034,
  [1120] = 1120,
  [1121] = 1022,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 961,
  [1125] = 1009,
  [1126] = 990,
  [1127] = 986,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1130,
  [1137] = 1133,
  [1138] = 1132,
  [1139] = 1131,
  [1140] = 1130,
  [1141] = 1131,
  [1142] = 1142,
  [1143] = 1133,
  [1144] = 1144,
  [1145] = 1132,
  [1146] = 986,
  [1147] = 990,
  [1148] = 1148,
  [1149] = 1062,
  [1150] = 1009,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 1153,
  [1154] = 961,
  [1155] = 1155,
  [1156] = 1022,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1034,
  [1160] = 876,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 888,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 132,
  [1172] = 1170,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1170,
  [1176] = 1176,
  [1177] = 794,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1179,
  [1181] = 1181,
  [1182] = 1170,
  [1183] = 1183,
  [1184] = 1173,
  [1185] = 1183,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1190,
  [1191] = 1161,
  [1192] = 1192,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1170,
  [1198] = 878,
  [1199] = 1199,
  [1200] = 1162,
  [1201] = 1201,
  [1202] = 1202,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1169,
  [1206] = 1167,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1193,
  [1210] = 880,
  [1211] = 1211,
  [1212] = 1207,
  [1213] = 1163,
  [1214] = 876,
  [1215] = 1179,
  [1216] = 1173,
  [1217] = 1199,
  [1218] = 135,
  [1219] = 1219,
  [1220] = 1173,
  [1221] = 1221,
  [1222] = 1222,
  [1223] = 863,
  [1224] = 1169,
  [1225] = 1208,
  [1226] = 1226,
  [1227] = 1161,
  [1228] = 1228,
  [1229] = 1229,
  [1230] = 1186,
  [1231] = 131,
  [1232] = 1232,
  [1233] = 1187,
  [1234] = 1234,
  [1235] = 1226,
  [1236] = 1162,
  [1237] = 1201,
  [1238] = 1226,
  [1239] = 1201,
  [1240] = 1208,
  [1241] = 1241,
  [1242] = 1162,
  [1243] = 791,
  [1244] = 793,
  [1245] = 1245,
  [1246] = 1202,
  [1247] = 1247,
  [1248] = 1248,
  [1249] = 1208,
  [1250] = 1097,
  [1251] = 1179,
  [1252] = 888,
  [1253] = 136,
  [1254] = 876,
  [1255] = 1255,
  [1256] = 1173,
  [1257] = 1134,
  [1258] = 1208,
  [1259] = 880,
  [1260] = 1260,
  [1261] = 1135,
  [1262] = 878,
  [1263] = 1161,
  [1264] = 1264,
  [1265] = 1161,
  [1266] = 1255,
  [1267] = 1148,
  [1268] = 1161,
  [1269] = 1208,
  [1270] = 1173,
  [1271] = 1151,
  [1272] = 1162,
  [1273] = 1201,
  [1274] = 1144,
  [1275] = 1118,
  [1276] = 1276,
  [1277] = 1277,
  [1278] = 1112,
  [1279] = 1229,
  [1280] = 1280,
  [1281] = 1281,
  [1282] = 134,
  [1283] = 136,
  [1284] = 1260,
  [1285] = 1226,
  [1286] = 1226,
  [1287] = 1179,
  [1288] = 130,
  [1289] = 1289,
  [1290] = 878,
  [1291] = 1291,
  [1292] = 1173,
  [1293] = 1293,
  [1294] = 135,
  [1295] = 1289,
  [1296] = 1296,
  [1297] = 1097,
  [1298] = 880,
  [1299] = 1161,
  [1300] = 1190,
  [1301] = 1201,
  [1302] = 1179,
  [1303] = 1134,
  [1304] = 1135,
  [1305] = 1201,
  [1306] = 134,
  [1307] = 1162,
  [1308] = 1201,
  [1309] = 136,
  [1310] = 1148,
  [1311] = 1162,
  [1312] = 130,
  [1313] = 1313,
  [1314] = 1226,
  [1315] = 135,
  [1316] = 131,
  [1317] = 132,
  [1318] = 1318,
  [1319] = 888,
  [1320] = 1173,
  [1321] = 1151,
  [1322] = 1247,
  [1323] = 130,
  [1324] = 1144,
  [1325] = 1118,
  [1326] = 1296,
  [1327] = 1327,
  [1328] = 1112,
  [1329] = 1173,
  [1330] = 793,
  [1331] = 835,
  [1332] = 1170,
  [1333] = 863,
  [1334] = 1281,
  [1335] = 791,
  [1336] = 1226,
  [1337] = 1173,
  [1338] = 1280,
  [1339] = 134,
  [1340] = 132,
  [1341] = 1179,
  [1342] = 1264,
  [1343] = 1173,
  [1344] = 1173,
  [1345] = 1173,
  [1346] = 1173,
  [1347] = 1208,
  [1348] = 131,
  [1349] = 1245,
  [1350] = 1248,
  [1351] = 794,
  [1352] = 1352,
  [1353] = 880,
  [1354] = 136,
  [1355] = 130,
  [1356] = 876,
  [1357] = 1357,
  [1358] = 1358,
  [1359] = 1359,
  [1360] = 131,
  [1361] = 1361,
  [1362] = 888,
  [1363] = 1363,
  [1364] = 1087,
  [1365] = 132,
  [1366] = 1366,
  [1367] = 937,
  [1368] = 1368,
  [1369] = 888,
  [1370] = 1366,
  [1371] = 1371,
  [1372] = 1087,
  [1373] = 1373,
  [1374] = 130,
  [1375] = 1375,
  [1376] = 1376,
  [1377] = 132,
  [1378] = 1378,
  [1379] = 1378,
  [1380] = 131,
  [1381] = 1366,
  [1382] = 1382,
  [1383] = 1371,
  [1384] = 1384,
  [1385] = 1385,
  [1386] = 876,
  [1387] = 880,
  [1388] = 1357,
  [1389] = 135,
  [1390] = 1366,
  [1391] = 1391,
  [1392] = 1371,
  [1393] = 1393,
  [1394] = 878,
  [1395] = 135,
  [1396] = 1378,
  [1397] = 878,
  [1398] = 1391,
  [1399] = 1366,
  [1400] = 1358,
  [1401] = 1371,
  [1402] = 1371,
  [1403] = 1403,
  [1404] = 134,
  [1405] = 136,
  [1406] = 1359,
  [1407] = 937,
  [1408] = 1366,
  [1409] = 1378,
  [1410] = 1371,
  [1411] = 978,
  [1412] = 1412,
  [1413] = 1413,
  [1414] = 1382,
  [1415] = 1415,
  [1416] = 1416,
  [1417] = 1393,
  [1418] = 1403,
  [1419] = 1419,
  [1420] = 1420,
  [1421] = 1421,
  [1422] = 1413,
  [1423] = 1378,
  [1424] = 1424,
  [1425] = 1425,
  [1426] = 1416,
  [1427] = 1419,
  [1428] = 1373,
  [1429] = 1429,
  [1430] = 1378,
  [1431] = 1431,
  [1432] = 1431,
  [1433] = 1433,
  [1434] = 134,
  [1435] = 1435,
  [1436] = 1436,
  [1437] = 1378,
  [1438] = 1438,
  [1439] = 1439,
  [1440] = 1440,
  [1441] = 1376,
  [1442] = 1375,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(51);
      if (lookahead == '!') ADVANCE(111);
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '%') ADVANCE(100);
      if (lookahead == '&') ADVANCE(69);
      if (lookahead == '(') ADVANCE(123);
      if (lookahead == ')') ADVANCE(124);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(93);
      if (lookahead == '.') ADVANCE(122);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == '0') ADVANCE(63);
      if (lookahead == ':') ADVANCE(79);
      if (lookahead == ';') ADVANCE(74);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(119);
      if (lookahead == '@') ADVANCE(76);
      if (lookahead == '[') ADVANCE(86);
      if (lookahead == '\\') SKIP(47)
      if (lookahead == ']') ADVANCE(87);
      if (lookahead == '^') ADVANCE(104);
      if (lookahead == '{') ADVANCE(83);
      if (lookahead == '|') ADVANCE(101);
      if (lookahead == '}') ADVANCE(84);
      if (lookahead == '~') ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(62);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(8)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(8)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(9)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(9)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(56);
      if (lookahead == '\r') ADVANCE(55);
      if (lookahead == 'U') ADVANCE(57);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(43);
      if (lookahead == 'x') ADVANCE(41);
      if (lookahead != 0) ADVANCE(54);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(15)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '\r') SKIP(6)
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '%') ADVANCE(100);
      if (lookahead == '&') ADVANCE(69);
      if (lookahead == '(') ADVANCE(123);
      if (lookahead == ')') ADVANCE(124);
      if (lookahead == '*') ADVANCE(96);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(121);
      if (lookahead == '/') ADVANCE(98);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(74);
      if (lookahead == '<') ADVANCE(113);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(119);
      if (lookahead == '@') ADVANCE(75);
      if (lookahead == '[') ADVANCE(86);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(87);
      if (lookahead == '^') ADVANCE(105);
      if (lookahead == '|') ADVANCE(101);
      if (lookahead == '}') ADVANCE(84);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '%') ADVANCE(99);
      if (lookahead == '&') ADVANCE(68);
      if (lookahead == '(') ADVANCE(123);
      if (lookahead == '*') ADVANCE(95);
      if (lookahead == '+') ADVANCE(90);
      if (lookahead == '-') ADVANCE(94);
      if (lookahead == '.') ADVANCE(121);
      if (lookahead == '/') ADVANCE(97);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == '<') ADVANCE(114);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(120);
      if (lookahead == '@') ADVANCE(75);
      if (lookahead == '[') ADVANCE(86);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '^') ADVANCE(103);
      if (lookahead == '|') ADVANCE(102);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(11);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(71);
      if (lookahead == ' ' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(11);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(72);
      if (lookahead == ' ' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(12);
      if (lookahead == '\'') ADVANCE(18);
      if (lookahead == '=') ADVANCE(129);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(73);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(12);
      if (lookahead == '\'') ADVANCE(18);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(73);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '-') ADVANCE(26);
      if (lookahead == '.') ADVANCE(121);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '\'') ADVANCE(71);
      if (lookahead == ' ' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '\'') ADVANCE(72);
      if (lookahead == ' ' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '<') ADVANCE(24);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(134);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 26:
      if (lookahead == '>') ADVANCE(135);
      END_STATE();
    case 27:
      if (lookahead == '>') ADVANCE(25);
      END_STATE();
    case 28:
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(65);
      END_STATE();
    case 29:
      if (lookahead == '_') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(66);
      END_STATE();
    case 30:
      if (lookahead == '_') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 31:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 32:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(65);
      END_STATE();
    case 33:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(66);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(54);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(35);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(39);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 46:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 47:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(46)
      END_STATE();
    case 48:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(50)
      END_STATE();
    case 49:
      if (eof) ADVANCE(51);
      if (lookahead == '\n') SKIP(50)
      if (lookahead == '\r') SKIP(48)
      END_STATE();
    case 50:
      if (eof) ADVANCE(51);
      if (lookahead == '!') ADVANCE(110);
      if (lookahead == '#') ADVANCE(53);
      if (lookahead == '$') ADVANCE(14);
      if (lookahead == '%') ADVANCE(13);
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '(') ADVANCE(123);
      if (lookahead == ')') ADVANCE(124);
      if (lookahead == '*') ADVANCE(21);
      if (lookahead == '+') ADVANCE(91);
      if (lookahead == ',') ADVANCE(82);
      if (lookahead == '-') ADVANCE(92);
      if (lookahead == '.') ADVANCE(122);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == '0') ADVANCE(63);
      if (lookahead == ':') ADVANCE(78);
      if (lookahead == ';') ADVANCE(74);
      if (lookahead == '<') ADVANCE(19);
      if (lookahead == '=') ADVANCE(80);
      if (lookahead == '>') ADVANCE(27);
      if (lookahead == '@') ADVANCE(76);
      if (lookahead == '[') ADVANCE(86);
      if (lookahead == '\\') SKIP(49)
      if (lookahead == ']') ADVANCE(87);
      if (lookahead == '^') ADVANCE(10);
      if (lookahead == '{') ADVANCE(83);
      if (lookahead == '|') ADVANCE(23);
      if (lookahead == '}') ADVANCE(84);
      if (lookahead == '~') ADVANCE(112);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(50)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(62);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym__identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(52);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(53);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(56);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(5);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(60);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == '_') ADVANCE(64);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(28);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(29);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(30);
      if (lookahead == '_') ADVANCE(64);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(60);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(31);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(62);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(32);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(65);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(33);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(88);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(88);
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_node_path);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_get_node);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_get_node);
      if (('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '"') ADVANCE(11);
      if (lookahead == '\'') ADVANCE(17);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(77);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_pattern_open_ending);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(126);
      if (lookahead == '>') ADVANCE(135);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(135);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(134);
      if (lookahead == '|') ADVANCE(89);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(89);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '"') ADVANCE(11);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(106);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(118);
      if (lookahead == '>') ADVANCE(109);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(118);
      if (lookahead == '>') ADVANCE(108);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(58);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == '_') ADVANCE(2);
      if (lookahead == 'a') ADVANCE(3);
      if (lookahead == 'b') ADVANCE(4);
      if (lookahead == 'c') ADVANCE(5);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'f') ADVANCE(7);
      if (lookahead == 'g') ADVANCE(8);
      if (lookahead == 'i') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      if (lookahead == 'o') ADVANCE(12);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(14);
      if (lookahead == 's') ADVANCE(15);
      if (lookahead == 't') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(19)
      END_STATE();
    case 2:
      ACCEPT_TOKEN(sym_underscore);
      if (lookahead == 'i') ADVANCE(20);
      END_STATE();
    case 3:
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 's') ADVANCE(22);
      if (lookahead == 'w') ADVANCE(23);
      END_STATE();
    case 4:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'u') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(37);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 12:
      if (lookahead == 'n') ADVANCE(40);
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 'u') ADVANCE(43);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 'i') ADVANCE(46);
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(50);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(51);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(53);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(54);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(56);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(57);
      END_STATE();
    case 27:
      if (lookahead == 'i') ADVANCE(58);
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 28:
      if (lookahead == 'u') ADVANCE(60);
      END_STATE();
    case 29:
      if (lookahead == 'p') ADVANCE(61);
      if (lookahead == 't') ADVANCE(62);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 37:
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 42:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 43:
      if (lookahead == 'p') ADVANCE(73);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(74);
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 46:
      if (lookahead == 'g') ADVANCE(77);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(78);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(80);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(82);
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(85);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(86);
      END_STATE();
    case 56:
      if (lookahead == 's') ADVANCE(87);
      END_STATE();
    case 57:
      if (lookahead == 's') ADVANCE(88);
      if (lookahead == 't') ADVANCE(89);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(90);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(91);
      END_STATE();
    case 60:
      if (lookahead == 'm') ADVANCE(92);
      END_STATE();
    case 61:
      if (lookahead == 'o') ADVANCE(93);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(94);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(95);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 65:
      if (lookahead == 'c') ADVANCE(96);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(97);
      END_STATE();
    case 68:
      if (lookahead == 'c') ADVANCE(98);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(99);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(100);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(101);
      END_STATE();
    case 73:
      if (lookahead == 'p') ADVANCE(102);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(103);
      END_STATE();
    case 75:
      if (lookahead == 'u') ADVANCE(104);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_set);
      if (lookahead == 'g') ADVANCE(105);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(106);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(107);
      END_STATE();
    case 79:
      if (lookahead == 'l') ADVANCE(108);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(109);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 82:
      if (lookahead == 'n') ADVANCE(110);
      END_STATE();
    case 83:
      if (lookahead == 'l') ADVANCE(111);
      END_STATE();
    case 84:
      if (lookahead == 't') ADVANCE(112);
      END_STATE();
    case 85:
      if (lookahead == 't') ADVANCE(113);
      END_STATE();
    case 86:
      if (lookahead == 'k') ADVANCE(114);
      END_STATE();
    case 87:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(116);
      END_STATE();
    case 89:
      if (lookahead == 'i') ADVANCE(117);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 93:
      if (lookahead == 'r') ADVANCE(118);
      END_STATE();
    case 94:
      if (lookahead == 'n') ADVANCE(119);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 97:
      if (lookahead == 'e') ADVANCE(121);
      END_STATE();
    case 98:
      if (lookahead == 'h') ADVANCE(122);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 100:
      if (lookahead == 'a') ADVANCE(123);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 102:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 104:
      if (lookahead == 'r') ADVANCE(126);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(127);
      END_STATE();
    case 106:
      if (lookahead == 'a') ADVANCE(128);
      END_STATE();
    case 107:
      if (lookahead == 'i') ADVANCE(129);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_tool_statement);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_when);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(130);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym__init);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_break);
      if (lookahead == 'p') ADVANCE(131);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_class);
      if (lookahead == '_') ADVANCE(132);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(133);
      END_STATE();
    case 118:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 119:
      if (lookahead == 'd') ADVANCE(135);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 121:
      if (lookahead == 'r') ADVANCE(136);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 123:
      if (lookahead == 'd') ADVANCE(137);
      END_STATE();
    case 124:
      if (lookahead == 't') ADVANCE(138);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(139);
      END_STATE();
    case 126:
      if (lookahead == 'n') ADVANCE(140);
      END_STATE();
    case 127:
      if (lookahead == 't') ADVANCE(141);
      END_STATE();
    case 128:
      if (lookahead == 'l') ADVANCE(142);
      END_STATE();
    case 129:
      if (lookahead == 'c') ADVANCE(143);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 131:
      if (lookahead == 'o') ADVANCE(144);
      END_STATE();
    case 132:
      if (lookahead == 'n') ADVANCE(145);
      END_STATE();
    case 133:
      if (lookahead == 'u') ADVANCE(146);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 135:
      if (lookahead == 's') ADVANCE(147);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_master);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 137:
      if (lookahead == 'y') ADVANCE(149);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_puppet);
      if (lookahead == 's') ADVANCE(150);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_remote);
      if (lookahead == 's') ADVANCE(151);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_setget);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_signal);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_static_keyword);
      END_STATE();
    case 144:
      if (lookahead == 'i') ADVANCE(152);
      END_STATE();
    case 145:
      if (lookahead == 'a') ADVANCE(153);
      END_STATE();
    case 146:
      if (lookahead == 'e') ADVANCE(154);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 148:
      if (lookahead == 'y') ADVANCE(155);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_onready);
      END_STATE();
    case 150:
      if (lookahead == 'y') ADVANCE(156);
      END_STATE();
    case 151:
      if (lookahead == 'y') ADVANCE(157);
      END_STATE();
    case 152:
      if (lookahead == 'n') ADVANCE(158);
      END_STATE();
    case 153:
      if (lookahead == 'm') ADVANCE(159);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 155:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 156:
      if (lookahead == 'n') ADVANCE(161);
      END_STATE();
    case 157:
      if (lookahead == 'n') ADVANCE(162);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(163);
      END_STATE();
    case 159:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 160:
      if (lookahead == 'c') ADVANCE(165);
      END_STATE();
    case 161:
      if (lookahead == 'c') ADVANCE(166);
      END_STATE();
    case 162:
      if (lookahead == 'c') ADVANCE(167);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(sym_breakpoint_statement);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_class_name);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_mastersync);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_puppetsync);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_remotesync);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 50, .external_lex_state = 2},
  [2] = {.lex_state = 50, .external_lex_state = 3},
  [3] = {.lex_state = 50, .external_lex_state = 3},
  [4] = {.lex_state = 50, .external_lex_state = 3},
  [5] = {.lex_state = 50, .external_lex_state = 3},
  [6] = {.lex_state = 50, .external_lex_state = 3},
  [7] = {.lex_state = 50, .external_lex_state = 3},
  [8] = {.lex_state = 50, .external_lex_state = 3},
  [9] = {.lex_state = 50, .external_lex_state = 3},
  [10] = {.lex_state = 50, .external_lex_state = 3},
  [11] = {.lex_state = 50, .external_lex_state = 3},
  [12] = {.lex_state = 50, .external_lex_state = 3},
  [13] = {.lex_state = 50, .external_lex_state = 3},
  [14] = {.lex_state = 50, .external_lex_state = 3},
  [15] = {.lex_state = 50, .external_lex_state = 3},
  [16] = {.lex_state = 50, .external_lex_state = 3},
  [17] = {.lex_state = 50, .external_lex_state = 3},
  [18] = {.lex_state = 50, .external_lex_state = 3},
  [19] = {.lex_state = 50, .external_lex_state = 3},
  [20] = {.lex_state = 50, .external_lex_state = 3},
  [21] = {.lex_state = 50, .external_lex_state = 3},
  [22] = {.lex_state = 50, .external_lex_state = 3},
  [23] = {.lex_state = 50, .external_lex_state = 2},
  [24] = {.lex_state = 50, .external_lex_state = 2},
  [25] = {.lex_state = 50, .external_lex_state = 4},
  [26] = {.lex_state = 50, .external_lex_state = 4},
  [27] = {.lex_state = 50, .external_lex_state = 4},
  [28] = {.lex_state = 50, .external_lex_state = 4},
  [29] = {.lex_state = 50, .external_lex_state = 4},
  [30] = {.lex_state = 50, .external_lex_state = 4},
  [31] = {.lex_state = 50, .external_lex_state = 4},
  [32] = {.lex_state = 50, .external_lex_state = 4},
  [33] = {.lex_state = 50, .external_lex_state = 4},
  [34] = {.lex_state = 50, .external_lex_state = 4},
  [35] = {.lex_state = 50, .external_lex_state = 4},
  [36] = {.lex_state = 50, .external_lex_state = 4},
  [37] = {.lex_state = 50, .external_lex_state = 4},
  [38] = {.lex_state = 50, .external_lex_state = 4},
  [39] = {.lex_state = 50, .external_lex_state = 4},
  [40] = {.lex_state = 50, .external_lex_state = 4},
  [41] = {.lex_state = 50, .external_lex_state = 4},
  [42] = {.lex_state = 50, .external_lex_state = 4},
  [43] = {.lex_state = 50, .external_lex_state = 4},
  [44] = {.lex_state = 50, .external_lex_state = 4},
  [45] = {.lex_state = 50, .external_lex_state = 4},
  [46] = {.lex_state = 50, .external_lex_state = 4},
  [47] = {.lex_state = 50, .external_lex_state = 4},
  [48] = {.lex_state = 50, .external_lex_state = 4},
  [49] = {.lex_state = 50, .external_lex_state = 4},
  [50] = {.lex_state = 50, .external_lex_state = 4},
  [51] = {.lex_state = 50, .external_lex_state = 4},
  [52] = {.lex_state = 50, .external_lex_state = 4},
  [53] = {.lex_state = 50, .external_lex_state = 4},
  [54] = {.lex_state = 50, .external_lex_state = 4},
  [55] = {.lex_state = 50, .external_lex_state = 4},
  [56] = {.lex_state = 50, .external_lex_state = 4},
  [57] = {.lex_state = 50, .external_lex_state = 4},
  [58] = {.lex_state = 50, .external_lex_state = 4},
  [59] = {.lex_state = 50, .external_lex_state = 4},
  [60] = {.lex_state = 50, .external_lex_state = 4},
  [61] = {.lex_state = 50, .external_lex_state = 4},
  [62] = {.lex_state = 50, .external_lex_state = 4},
  [63] = {.lex_state = 50, .external_lex_state = 4},
  [64] = {.lex_state = 50, .external_lex_state = 4},
  [65] = {.lex_state = 50, .external_lex_state = 4},
  [66] = {.lex_state = 50, .external_lex_state = 4},
  [67] = {.lex_state = 50, .external_lex_state = 4},
  [68] = {.lex_state = 50, .external_lex_state = 4},
  [69] = {.lex_state = 50, .external_lex_state = 4},
  [70] = {.lex_state = 50, .external_lex_state = 4},
  [71] = {.lex_state = 50, .external_lex_state = 4},
  [72] = {.lex_state = 50, .external_lex_state = 4},
  [73] = {.lex_state = 50, .external_lex_state = 4},
  [74] = {.lex_state = 50, .external_lex_state = 4},
  [75] = {.lex_state = 50, .external_lex_state = 4},
  [76] = {.lex_state = 50, .external_lex_state = 4},
  [77] = {.lex_state = 50, .external_lex_state = 4},
  [78] = {.lex_state = 50, .external_lex_state = 4},
  [79] = {.lex_state = 50, .external_lex_state = 4},
  [80] = {.lex_state = 50, .external_lex_state = 4},
  [81] = {.lex_state = 50, .external_lex_state = 4},
  [82] = {.lex_state = 50, .external_lex_state = 4},
  [83] = {.lex_state = 50, .external_lex_state = 4},
  [84] = {.lex_state = 50, .external_lex_state = 4},
  [85] = {.lex_state = 50, .external_lex_state = 4},
  [86] = {.lex_state = 50, .external_lex_state = 4},
  [87] = {.lex_state = 50, .external_lex_state = 4},
  [88] = {.lex_state = 50, .external_lex_state = 4},
  [89] = {.lex_state = 50, .external_lex_state = 4},
  [90] = {.lex_state = 50, .external_lex_state = 4},
  [91] = {.lex_state = 50, .external_lex_state = 4},
  [92] = {.lex_state = 50, .external_lex_state = 4},
  [93] = {.lex_state = 50, .external_lex_state = 4},
  [94] = {.lex_state = 50, .external_lex_state = 4},
  [95] = {.lex_state = 50, .external_lex_state = 4},
  [96] = {.lex_state = 50, .external_lex_state = 4},
  [97] = {.lex_state = 50, .external_lex_state = 4},
  [98] = {.lex_state = 50, .external_lex_state = 4},
  [99] = {.lex_state = 50, .external_lex_state = 4},
  [100] = {.lex_state = 50, .external_lex_state = 4},
  [101] = {.lex_state = 50, .external_lex_state = 4},
  [102] = {.lex_state = 50, .external_lex_state = 4},
  [103] = {.lex_state = 50, .external_lex_state = 5},
  [104] = {.lex_state = 50, .external_lex_state = 5},
  [105] = {.lex_state = 50, .external_lex_state = 5},
  [106] = {.lex_state = 50, .external_lex_state = 5},
  [107] = {.lex_state = 50, .external_lex_state = 5},
  [108] = {.lex_state = 50, .external_lex_state = 5},
  [109] = {.lex_state = 50, .external_lex_state = 5},
  [110] = {.lex_state = 50, .external_lex_state = 5},
  [111] = {.lex_state = 50, .external_lex_state = 5},
  [112] = {.lex_state = 50, .external_lex_state = 5},
  [113] = {.lex_state = 50, .external_lex_state = 5},
  [114] = {.lex_state = 50, .external_lex_state = 5},
  [115] = {.lex_state = 50, .external_lex_state = 5},
  [116] = {.lex_state = 50, .external_lex_state = 5},
  [117] = {.lex_state = 50, .external_lex_state = 5},
  [118] = {.lex_state = 50, .external_lex_state = 5},
  [119] = {.lex_state = 50, .external_lex_state = 5},
  [120] = {.lex_state = 50, .external_lex_state = 5},
  [121] = {.lex_state = 50, .external_lex_state = 5},
  [122] = {.lex_state = 50, .external_lex_state = 5},
  [123] = {.lex_state = 50, .external_lex_state = 2},
  [124] = {.lex_state = 50, .external_lex_state = 3},
  [125] = {.lex_state = 50, .external_lex_state = 3},
  [126] = {.lex_state = 50, .external_lex_state = 2},
  [127] = {.lex_state = 50, .external_lex_state = 2},
  [128] = {.lex_state = 50, .external_lex_state = 3},
  [129] = {.lex_state = 50, .external_lex_state = 2},
  [130] = {.lex_state = 50, .external_lex_state = 3},
  [131] = {.lex_state = 50, .external_lex_state = 3},
  [132] = {.lex_state = 50, .external_lex_state = 3},
  [133] = {.lex_state = 50, .external_lex_state = 3},
  [134] = {.lex_state = 50, .external_lex_state = 3},
  [135] = {.lex_state = 50, .external_lex_state = 3},
  [136] = {.lex_state = 50, .external_lex_state = 3},
  [137] = {.lex_state = 50, .external_lex_state = 3},
  [138] = {.lex_state = 50, .external_lex_state = 2},
  [139] = {.lex_state = 50, .external_lex_state = 2},
  [140] = {.lex_state = 50, .external_lex_state = 2},
  [141] = {.lex_state = 50, .external_lex_state = 2},
  [142] = {.lex_state = 50, .external_lex_state = 2},
  [143] = {.lex_state = 50, .external_lex_state = 2},
  [144] = {.lex_state = 50, .external_lex_state = 2},
  [145] = {.lex_state = 50, .external_lex_state = 2},
  [146] = {.lex_state = 50, .external_lex_state = 3},
  [147] = {.lex_state = 50, .external_lex_state = 3},
  [148] = {.lex_state = 50, .external_lex_state = 3},
  [149] = {.lex_state = 50, .external_lex_state = 3},
  [150] = {.lex_state = 50, .external_lex_state = 3},
  [151] = {.lex_state = 50, .external_lex_state = 3},
  [152] = {.lex_state = 50, .external_lex_state = 3},
  [153] = {.lex_state = 50, .external_lex_state = 3},
  [154] = {.lex_state = 50, .external_lex_state = 3},
  [155] = {.lex_state = 50, .external_lex_state = 3},
  [156] = {.lex_state = 50, .external_lex_state = 3},
  [157] = {.lex_state = 50, .external_lex_state = 3},
  [158] = {.lex_state = 50, .external_lex_state = 3},
  [159] = {.lex_state = 50, .external_lex_state = 3},
  [160] = {.lex_state = 50, .external_lex_state = 3},
  [161] = {.lex_state = 50, .external_lex_state = 3},
  [162] = {.lex_state = 50, .external_lex_state = 3},
  [163] = {.lex_state = 50, .external_lex_state = 3},
  [164] = {.lex_state = 50, .external_lex_state = 3},
  [165] = {.lex_state = 50, .external_lex_state = 3},
  [166] = {.lex_state = 50, .external_lex_state = 3},
  [167] = {.lex_state = 50, .external_lex_state = 3},
  [168] = {.lex_state = 50, .external_lex_state = 3},
  [169] = {.lex_state = 50, .external_lex_state = 3},
  [170] = {.lex_state = 50, .external_lex_state = 3},
  [171] = {.lex_state = 50, .external_lex_state = 3},
  [172] = {.lex_state = 50, .external_lex_state = 3},
  [173] = {.lex_state = 50, .external_lex_state = 3},
  [174] = {.lex_state = 50, .external_lex_state = 3},
  [175] = {.lex_state = 50, .external_lex_state = 3},
  [176] = {.lex_state = 50, .external_lex_state = 3},
  [177] = {.lex_state = 50, .external_lex_state = 2},
  [178] = {.lex_state = 50, .external_lex_state = 2},
  [179] = {.lex_state = 50, .external_lex_state = 2},
  [180] = {.lex_state = 50, .external_lex_state = 2},
  [181] = {.lex_state = 50, .external_lex_state = 2},
  [182] = {.lex_state = 50, .external_lex_state = 2},
  [183] = {.lex_state = 50, .external_lex_state = 2},
  [184] = {.lex_state = 50, .external_lex_state = 2},
  [185] = {.lex_state = 50, .external_lex_state = 2},
  [186] = {.lex_state = 50, .external_lex_state = 2},
  [187] = {.lex_state = 50, .external_lex_state = 2},
  [188] = {.lex_state = 50, .external_lex_state = 2},
  [189] = {.lex_state = 50, .external_lex_state = 2},
  [190] = {.lex_state = 50, .external_lex_state = 2},
  [191] = {.lex_state = 50, .external_lex_state = 2},
  [192] = {.lex_state = 50, .external_lex_state = 2},
  [193] = {.lex_state = 50, .external_lex_state = 2},
  [194] = {.lex_state = 50, .external_lex_state = 2},
  [195] = {.lex_state = 50, .external_lex_state = 2},
  [196] = {.lex_state = 50, .external_lex_state = 2},
  [197] = {.lex_state = 50, .external_lex_state = 2},
  [198] = {.lex_state = 50, .external_lex_state = 2},
  [199] = {.lex_state = 50, .external_lex_state = 2},
  [200] = {.lex_state = 50, .external_lex_state = 2},
  [201] = {.lex_state = 50, .external_lex_state = 2},
  [202] = {.lex_state = 50, .external_lex_state = 2},
  [203] = {.lex_state = 50, .external_lex_state = 2},
  [204] = {.lex_state = 50, .external_lex_state = 2},
  [205] = {.lex_state = 50, .external_lex_state = 2},
  [206] = {.lex_state = 50, .external_lex_state = 2},
  [207] = {.lex_state = 50, .external_lex_state = 2},
  [208] = {.lex_state = 8, .external_lex_state = 6},
  [209] = {.lex_state = 8, .external_lex_state = 6},
  [210] = {.lex_state = 8, .external_lex_state = 6},
  [211] = {.lex_state = 8, .external_lex_state = 6},
  [212] = {.lex_state = 8, .external_lex_state = 6},
  [213] = {.lex_state = 8, .external_lex_state = 6},
  [214] = {.lex_state = 8, .external_lex_state = 6},
  [215] = {.lex_state = 8, .external_lex_state = 6},
  [216] = {.lex_state = 8, .external_lex_state = 6},
  [217] = {.lex_state = 8, .external_lex_state = 6},
  [218] = {.lex_state = 8, .external_lex_state = 6},
  [219] = {.lex_state = 8, .external_lex_state = 6},
  [220] = {.lex_state = 8, .external_lex_state = 6},
  [221] = {.lex_state = 8, .external_lex_state = 6},
  [222] = {.lex_state = 8, .external_lex_state = 6},
  [223] = {.lex_state = 50, .external_lex_state = 5},
  [224] = {.lex_state = 8, .external_lex_state = 6},
  [225] = {.lex_state = 8, .external_lex_state = 6},
  [226] = {.lex_state = 8, .external_lex_state = 6},
  [227] = {.lex_state = 8, .external_lex_state = 6},
  [228] = {.lex_state = 8, .external_lex_state = 6},
  [229] = {.lex_state = 8, .external_lex_state = 6},
  [230] = {.lex_state = 8, .external_lex_state = 6},
  [231] = {.lex_state = 8, .external_lex_state = 6},
  [232] = {.lex_state = 8, .external_lex_state = 6},
  [233] = {.lex_state = 50, .external_lex_state = 7},
  [234] = {.lex_state = 8, .external_lex_state = 6},
  [235] = {.lex_state = 50, .external_lex_state = 7},
  [236] = {.lex_state = 8, .external_lex_state = 6},
  [237] = {.lex_state = 50, .external_lex_state = 7},
  [238] = {.lex_state = 8, .external_lex_state = 6},
  [239] = {.lex_state = 50, .external_lex_state = 7},
  [240] = {.lex_state = 8, .external_lex_state = 6},
  [241] = {.lex_state = 8, .external_lex_state = 6},
  [242] = {.lex_state = 50, .external_lex_state = 7},
  [243] = {.lex_state = 8, .external_lex_state = 6},
  [244] = {.lex_state = 8, .external_lex_state = 6},
  [245] = {.lex_state = 8, .external_lex_state = 6},
  [246] = {.lex_state = 50, .external_lex_state = 7},
  [247] = {.lex_state = 50, .external_lex_state = 7},
  [248] = {.lex_state = 8, .external_lex_state = 6},
  [249] = {.lex_state = 50, .external_lex_state = 7},
  [250] = {.lex_state = 50, .external_lex_state = 7},
  [251] = {.lex_state = 50, .external_lex_state = 7},
  [252] = {.lex_state = 8, .external_lex_state = 6},
  [253] = {.lex_state = 50, .external_lex_state = 7},
  [254] = {.lex_state = 50, .external_lex_state = 7},
  [255] = {.lex_state = 50, .external_lex_state = 7},
  [256] = {.lex_state = 50, .external_lex_state = 7},
  [257] = {.lex_state = 8, .external_lex_state = 6},
  [258] = {.lex_state = 8, .external_lex_state = 6},
  [259] = {.lex_state = 50, .external_lex_state = 7},
  [260] = {.lex_state = 50, .external_lex_state = 7},
  [261] = {.lex_state = 8, .external_lex_state = 6},
  [262] = {.lex_state = 50, .external_lex_state = 7},
  [263] = {.lex_state = 50, .external_lex_state = 7},
  [264] = {.lex_state = 8, .external_lex_state = 6},
  [265] = {.lex_state = 50, .external_lex_state = 7},
  [266] = {.lex_state = 8, .external_lex_state = 6},
  [267] = {.lex_state = 8, .external_lex_state = 6},
  [268] = {.lex_state = 50, .external_lex_state = 7},
  [269] = {.lex_state = 8, .external_lex_state = 6},
  [270] = {.lex_state = 8, .external_lex_state = 6},
  [271] = {.lex_state = 8, .external_lex_state = 6},
  [272] = {.lex_state = 8, .external_lex_state = 6},
  [273] = {.lex_state = 50, .external_lex_state = 7},
  [274] = {.lex_state = 50, .external_lex_state = 8},
  [275] = {.lex_state = 9, .external_lex_state = 9},
  [276] = {.lex_state = 50, .external_lex_state = 8},
  [277] = {.lex_state = 50, .external_lex_state = 8},
  [278] = {.lex_state = 50, .external_lex_state = 10},
  [279] = {.lex_state = 9, .external_lex_state = 9},
  [280] = {.lex_state = 50, .external_lex_state = 8},
  [281] = {.lex_state = 50, .external_lex_state = 10},
  [282] = {.lex_state = 50, .external_lex_state = 8},
  [283] = {.lex_state = 50, .external_lex_state = 10},
  [284] = {.lex_state = 50, .external_lex_state = 8},
  [285] = {.lex_state = 50, .external_lex_state = 10},
  [286] = {.lex_state = 50, .external_lex_state = 8},
  [287] = {.lex_state = 50, .external_lex_state = 10},
  [288] = {.lex_state = 50, .external_lex_state = 8},
  [289] = {.lex_state = 50, .external_lex_state = 10},
  [290] = {.lex_state = 50, .external_lex_state = 8},
  [291] = {.lex_state = 50, .external_lex_state = 8},
  [292] = {.lex_state = 50, .external_lex_state = 8},
  [293] = {.lex_state = 50, .external_lex_state = 10},
  [294] = {.lex_state = 50, .external_lex_state = 10},
  [295] = {.lex_state = 9, .external_lex_state = 9},
  [296] = {.lex_state = 50, .external_lex_state = 10},
  [297] = {.lex_state = 50, .external_lex_state = 8},
  [298] = {.lex_state = 50, .external_lex_state = 10},
  [299] = {.lex_state = 50, .external_lex_state = 8},
  [300] = {.lex_state = 50, .external_lex_state = 10},
  [301] = {.lex_state = 50, .external_lex_state = 8},
  [302] = {.lex_state = 50, .external_lex_state = 10},
  [303] = {.lex_state = 50, .external_lex_state = 8},
  [304] = {.lex_state = 50, .external_lex_state = 10},
  [305] = {.lex_state = 50, .external_lex_state = 10},
  [306] = {.lex_state = 50, .external_lex_state = 8},
  [307] = {.lex_state = 50, .external_lex_state = 8},
  [308] = {.lex_state = 50, .external_lex_state = 8},
  [309] = {.lex_state = 50, .external_lex_state = 2},
  [310] = {.lex_state = 50, .external_lex_state = 10},
  [311] = {.lex_state = 9, .external_lex_state = 9},
  [312] = {.lex_state = 50, .external_lex_state = 10},
  [313] = {.lex_state = 50, .external_lex_state = 8},
  [314] = {.lex_state = 50, .external_lex_state = 10},
  [315] = {.lex_state = 50, .external_lex_state = 10},
  [316] = {.lex_state = 50, .external_lex_state = 10},
  [317] = {.lex_state = 50, .external_lex_state = 10},
  [318] = {.lex_state = 50, .external_lex_state = 8},
  [319] = {.lex_state = 50, .external_lex_state = 10},
  [320] = {.lex_state = 50, .external_lex_state = 8},
  [321] = {.lex_state = 50, .external_lex_state = 2},
  [322] = {.lex_state = 50, .external_lex_state = 2},
  [323] = {.lex_state = 50, .external_lex_state = 2},
  [324] = {.lex_state = 50, .external_lex_state = 2},
  [325] = {.lex_state = 50, .external_lex_state = 2},
  [326] = {.lex_state = 50, .external_lex_state = 2},
  [327] = {.lex_state = 50, .external_lex_state = 2},
  [328] = {.lex_state = 50, .external_lex_state = 2},
  [329] = {.lex_state = 50, .external_lex_state = 2},
  [330] = {.lex_state = 50, .external_lex_state = 7},
  [331] = {.lex_state = 50, .external_lex_state = 2},
  [332] = {.lex_state = 50, .external_lex_state = 2},
  [333] = {.lex_state = 50, .external_lex_state = 2},
  [334] = {.lex_state = 50, .external_lex_state = 2},
  [335] = {.lex_state = 50, .external_lex_state = 2},
  [336] = {.lex_state = 50, .external_lex_state = 2},
  [337] = {.lex_state = 50, .external_lex_state = 7},
  [338] = {.lex_state = 50, .external_lex_state = 2},
  [339] = {.lex_state = 50, .external_lex_state = 2},
  [340] = {.lex_state = 50, .external_lex_state = 7},
  [341] = {.lex_state = 50, .external_lex_state = 2},
  [342] = {.lex_state = 50, .external_lex_state = 2},
  [343] = {.lex_state = 50, .external_lex_state = 2},
  [344] = {.lex_state = 50, .external_lex_state = 2},
  [345] = {.lex_state = 50, .external_lex_state = 2},
  [346] = {.lex_state = 50, .external_lex_state = 2},
  [347] = {.lex_state = 50, .external_lex_state = 2},
  [348] = {.lex_state = 50, .external_lex_state = 2},
  [349] = {.lex_state = 50, .external_lex_state = 2},
  [350] = {.lex_state = 50, .external_lex_state = 2},
  [351] = {.lex_state = 50, .external_lex_state = 2},
  [352] = {.lex_state = 50, .external_lex_state = 2},
  [353] = {.lex_state = 50, .external_lex_state = 2},
  [354] = {.lex_state = 50, .external_lex_state = 2},
  [355] = {.lex_state = 50, .external_lex_state = 2},
  [356] = {.lex_state = 50, .external_lex_state = 2},
  [357] = {.lex_state = 50, .external_lex_state = 2},
  [358] = {.lex_state = 50, .external_lex_state = 2},
  [359] = {.lex_state = 50, .external_lex_state = 2},
  [360] = {.lex_state = 50, .external_lex_state = 2},
  [361] = {.lex_state = 50, .external_lex_state = 2},
  [362] = {.lex_state = 50, .external_lex_state = 2},
  [363] = {.lex_state = 50, .external_lex_state = 2},
  [364] = {.lex_state = 50, .external_lex_state = 2},
  [365] = {.lex_state = 50, .external_lex_state = 2},
  [366] = {.lex_state = 50, .external_lex_state = 2},
  [367] = {.lex_state = 50, .external_lex_state = 2},
  [368] = {.lex_state = 50, .external_lex_state = 2},
  [369] = {.lex_state = 50, .external_lex_state = 2},
  [370] = {.lex_state = 50, .external_lex_state = 2},
  [371] = {.lex_state = 50, .external_lex_state = 2},
  [372] = {.lex_state = 50, .external_lex_state = 2},
  [373] = {.lex_state = 50, .external_lex_state = 2},
  [374] = {.lex_state = 50, .external_lex_state = 2},
  [375] = {.lex_state = 50, .external_lex_state = 2},
  [376] = {.lex_state = 50, .external_lex_state = 2},
  [377] = {.lex_state = 50, .external_lex_state = 2},
  [378] = {.lex_state = 50, .external_lex_state = 2},
  [379] = {.lex_state = 50, .external_lex_state = 2},
  [380] = {.lex_state = 50, .external_lex_state = 2},
  [381] = {.lex_state = 50, .external_lex_state = 2},
  [382] = {.lex_state = 50, .external_lex_state = 2},
  [383] = {.lex_state = 50, .external_lex_state = 11},
  [384] = {.lex_state = 50, .external_lex_state = 2},
  [385] = {.lex_state = 8, .external_lex_state = 9},
  [386] = {.lex_state = 50, .external_lex_state = 2},
  [387] = {.lex_state = 50, .external_lex_state = 2},
  [388] = {.lex_state = 50, .external_lex_state = 2},
  [389] = {.lex_state = 50, .external_lex_state = 2},
  [390] = {.lex_state = 50, .external_lex_state = 2},
  [391] = {.lex_state = 50, .external_lex_state = 2},
  [392] = {.lex_state = 50, .external_lex_state = 2},
  [393] = {.lex_state = 50, .external_lex_state = 2},
  [394] = {.lex_state = 50, .external_lex_state = 2},
  [395] = {.lex_state = 50, .external_lex_state = 2},
  [396] = {.lex_state = 50, .external_lex_state = 2},
  [397] = {.lex_state = 50, .external_lex_state = 2},
  [398] = {.lex_state = 50, .external_lex_state = 2},
  [399] = {.lex_state = 50, .external_lex_state = 2},
  [400] = {.lex_state = 50, .external_lex_state = 2},
  [401] = {.lex_state = 50, .external_lex_state = 2},
  [402] = {.lex_state = 50, .external_lex_state = 2},
  [403] = {.lex_state = 50, .external_lex_state = 2},
  [404] = {.lex_state = 50, .external_lex_state = 2},
  [405] = {.lex_state = 50, .external_lex_state = 2},
  [406] = {.lex_state = 50, .external_lex_state = 2},
  [407] = {.lex_state = 50, .external_lex_state = 2},
  [408] = {.lex_state = 50, .external_lex_state = 2},
  [409] = {.lex_state = 50, .external_lex_state = 2},
  [410] = {.lex_state = 50, .external_lex_state = 2},
  [411] = {.lex_state = 50, .external_lex_state = 2},
  [412] = {.lex_state = 50, .external_lex_state = 2},
  [413] = {.lex_state = 50, .external_lex_state = 2},
  [414] = {.lex_state = 50, .external_lex_state = 2},
  [415] = {.lex_state = 50, .external_lex_state = 2},
  [416] = {.lex_state = 50, .external_lex_state = 2},
  [417] = {.lex_state = 50, .external_lex_state = 2},
  [418] = {.lex_state = 50, .external_lex_state = 2},
  [419] = {.lex_state = 50, .external_lex_state = 2},
  [420] = {.lex_state = 50, .external_lex_state = 2},
  [421] = {.lex_state = 50, .external_lex_state = 2},
  [422] = {.lex_state = 50, .external_lex_state = 2},
  [423] = {.lex_state = 50, .external_lex_state = 2},
  [424] = {.lex_state = 50, .external_lex_state = 2},
  [425] = {.lex_state = 50, .external_lex_state = 2},
  [426] = {.lex_state = 50, .external_lex_state = 2},
  [427] = {.lex_state = 50, .external_lex_state = 2},
  [428] = {.lex_state = 50, .external_lex_state = 2},
  [429] = {.lex_state = 50, .external_lex_state = 2},
  [430] = {.lex_state = 50, .external_lex_state = 2},
  [431] = {.lex_state = 50, .external_lex_state = 2},
  [432] = {.lex_state = 50, .external_lex_state = 2},
  [433] = {.lex_state = 50, .external_lex_state = 2},
  [434] = {.lex_state = 50, .external_lex_state = 2},
  [435] = {.lex_state = 50, .external_lex_state = 2},
  [436] = {.lex_state = 50, .external_lex_state = 2},
  [437] = {.lex_state = 50, .external_lex_state = 2},
  [438] = {.lex_state = 50, .external_lex_state = 2},
  [439] = {.lex_state = 50, .external_lex_state = 2},
  [440] = {.lex_state = 50, .external_lex_state = 2},
  [441] = {.lex_state = 50, .external_lex_state = 2},
  [442] = {.lex_state = 50, .external_lex_state = 2},
  [443] = {.lex_state = 50, .external_lex_state = 2},
  [444] = {.lex_state = 50, .external_lex_state = 2},
  [445] = {.lex_state = 50, .external_lex_state = 2},
  [446] = {.lex_state = 50, .external_lex_state = 2},
  [447] = {.lex_state = 50, .external_lex_state = 2},
  [448] = {.lex_state = 50, .external_lex_state = 2},
  [449] = {.lex_state = 50, .external_lex_state = 2},
  [450] = {.lex_state = 50, .external_lex_state = 2},
  [451] = {.lex_state = 50, .external_lex_state = 2},
  [452] = {.lex_state = 50, .external_lex_state = 2},
  [453] = {.lex_state = 50, .external_lex_state = 2},
  [454] = {.lex_state = 50, .external_lex_state = 2},
  [455] = {.lex_state = 50, .external_lex_state = 2},
  [456] = {.lex_state = 50, .external_lex_state = 2},
  [457] = {.lex_state = 50, .external_lex_state = 2},
  [458] = {.lex_state = 50, .external_lex_state = 2},
  [459] = {.lex_state = 50, .external_lex_state = 2},
  [460] = {.lex_state = 50, .external_lex_state = 2},
  [461] = {.lex_state = 50, .external_lex_state = 2},
  [462] = {.lex_state = 50, .external_lex_state = 2},
  [463] = {.lex_state = 50, .external_lex_state = 2},
  [464] = {.lex_state = 50, .external_lex_state = 2},
  [465] = {.lex_state = 50, .external_lex_state = 2},
  [466] = {.lex_state = 50, .external_lex_state = 2},
  [467] = {.lex_state = 50, .external_lex_state = 2},
  [468] = {.lex_state = 50, .external_lex_state = 2},
  [469] = {.lex_state = 50, .external_lex_state = 2},
  [470] = {.lex_state = 50, .external_lex_state = 2},
  [471] = {.lex_state = 50, .external_lex_state = 2},
  [472] = {.lex_state = 50, .external_lex_state = 2},
  [473] = {.lex_state = 50, .external_lex_state = 2},
  [474] = {.lex_state = 50, .external_lex_state = 2},
  [475] = {.lex_state = 50, .external_lex_state = 2},
  [476] = {.lex_state = 50, .external_lex_state = 2},
  [477] = {.lex_state = 50, .external_lex_state = 2},
  [478] = {.lex_state = 50, .external_lex_state = 2},
  [479] = {.lex_state = 50, .external_lex_state = 2},
  [480] = {.lex_state = 50, .external_lex_state = 2},
  [481] = {.lex_state = 50, .external_lex_state = 2},
  [482] = {.lex_state = 50, .external_lex_state = 2},
  [483] = {.lex_state = 50, .external_lex_state = 2},
  [484] = {.lex_state = 50, .external_lex_state = 2},
  [485] = {.lex_state = 50, .external_lex_state = 2},
  [486] = {.lex_state = 50, .external_lex_state = 2},
  [487] = {.lex_state = 50, .external_lex_state = 2},
  [488] = {.lex_state = 50, .external_lex_state = 2},
  [489] = {.lex_state = 50, .external_lex_state = 2},
  [490] = {.lex_state = 50, .external_lex_state = 2},
  [491] = {.lex_state = 50, .external_lex_state = 2},
  [492] = {.lex_state = 50, .external_lex_state = 2},
  [493] = {.lex_state = 50, .external_lex_state = 2},
  [494] = {.lex_state = 50, .external_lex_state = 2},
  [495] = {.lex_state = 8, .external_lex_state = 9},
  [496] = {.lex_state = 8, .external_lex_state = 12},
  [497] = {.lex_state = 8, .external_lex_state = 12},
  [498] = {.lex_state = 8, .external_lex_state = 12},
  [499] = {.lex_state = 8, .external_lex_state = 9},
  [500] = {.lex_state = 8, .external_lex_state = 9},
  [501] = {.lex_state = 8, .external_lex_state = 12},
  [502] = {.lex_state = 8, .external_lex_state = 13},
  [503] = {.lex_state = 8, .external_lex_state = 14},
  [504] = {.lex_state = 8, .external_lex_state = 14},
  [505] = {.lex_state = 8, .external_lex_state = 14},
  [506] = {.lex_state = 8, .external_lex_state = 13},
  [507] = {.lex_state = 8, .external_lex_state = 12},
  [508] = {.lex_state = 8, .external_lex_state = 13},
  [509] = {.lex_state = 8, .external_lex_state = 13},
  [510] = {.lex_state = 8, .external_lex_state = 13},
  [511] = {.lex_state = 8, .external_lex_state = 13},
  [512] = {.lex_state = 8, .external_lex_state = 13},
  [513] = {.lex_state = 8, .external_lex_state = 9},
  [514] = {.lex_state = 8, .external_lex_state = 12},
  [515] = {.lex_state = 8, .external_lex_state = 14},
  [516] = {.lex_state = 8, .external_lex_state = 14},
  [517] = {.lex_state = 8, .external_lex_state = 9},
  [518] = {.lex_state = 8, .external_lex_state = 14},
  [519] = {.lex_state = 8, .external_lex_state = 14},
  [520] = {.lex_state = 8, .external_lex_state = 14},
  [521] = {.lex_state = 8, .external_lex_state = 13},
  [522] = {.lex_state = 8, .external_lex_state = 14},
  [523] = {.lex_state = 8, .external_lex_state = 13},
  [524] = {.lex_state = 8, .external_lex_state = 9},
  [525] = {.lex_state = 8, .external_lex_state = 13},
  [526] = {.lex_state = 8, .external_lex_state = 12},
  [527] = {.lex_state = 8, .external_lex_state = 13},
  [528] = {.lex_state = 8, .external_lex_state = 13},
  [529] = {.lex_state = 8, .external_lex_state = 12},
  [530] = {.lex_state = 8, .external_lex_state = 13},
  [531] = {.lex_state = 8, .external_lex_state = 9},
  [532] = {.lex_state = 8, .external_lex_state = 12},
  [533] = {.lex_state = 8, .external_lex_state = 9},
  [534] = {.lex_state = 8, .external_lex_state = 14},
  [535] = {.lex_state = 8, .external_lex_state = 14},
  [536] = {.lex_state = 8, .external_lex_state = 9},
  [537] = {.lex_state = 8, .external_lex_state = 9},
  [538] = {.lex_state = 8, .external_lex_state = 9},
  [539] = {.lex_state = 8, .external_lex_state = 14},
  [540] = {.lex_state = 8, .external_lex_state = 12},
  [541] = {.lex_state = 8, .external_lex_state = 9},
  [542] = {.lex_state = 8, .external_lex_state = 12},
  [543] = {.lex_state = 8, .external_lex_state = 12},
  [544] = {.lex_state = 8, .external_lex_state = 9},
  [545] = {.lex_state = 8, .external_lex_state = 9},
  [546] = {.lex_state = 8, .external_lex_state = 14},
  [547] = {.lex_state = 8, .external_lex_state = 12},
  [548] = {.lex_state = 8, .external_lex_state = 12},
  [549] = {.lex_state = 8, .external_lex_state = 12},
  [550] = {.lex_state = 8, .external_lex_state = 14},
  [551] = {.lex_state = 8, .external_lex_state = 13},
  [552] = {.lex_state = 8, .external_lex_state = 14},
  [553] = {.lex_state = 8, .external_lex_state = 12},
  [554] = {.lex_state = 8, .external_lex_state = 12},
  [555] = {.lex_state = 8, .external_lex_state = 12},
  [556] = {.lex_state = 8, .external_lex_state = 9},
  [557] = {.lex_state = 8, .external_lex_state = 9},
  [558] = {.lex_state = 8, .external_lex_state = 12},
  [559] = {.lex_state = 8, .external_lex_state = 14},
  [560] = {.lex_state = 8, .external_lex_state = 12},
  [561] = {.lex_state = 8, .external_lex_state = 12},
  [562] = {.lex_state = 8, .external_lex_state = 13},
  [563] = {.lex_state = 8, .external_lex_state = 12},
  [564] = {.lex_state = 8, .external_lex_state = 12},
  [565] = {.lex_state = 8, .external_lex_state = 12},
  [566] = {.lex_state = 8, .external_lex_state = 12},
  [567] = {.lex_state = 8, .external_lex_state = 12},
  [568] = {.lex_state = 8, .external_lex_state = 9},
  [569] = {.lex_state = 8, .external_lex_state = 9},
  [570] = {.lex_state = 8, .external_lex_state = 9},
  [571] = {.lex_state = 8, .external_lex_state = 9},
  [572] = {.lex_state = 8, .external_lex_state = 13},
  [573] = {.lex_state = 8, .external_lex_state = 9},
  [574] = {.lex_state = 8, .external_lex_state = 14},
  [575] = {.lex_state = 8, .external_lex_state = 13},
  [576] = {.lex_state = 8, .external_lex_state = 13},
  [577] = {.lex_state = 8, .external_lex_state = 14},
  [578] = {.lex_state = 8, .external_lex_state = 13},
  [579] = {.lex_state = 8, .external_lex_state = 9},
  [580] = {.lex_state = 8, .external_lex_state = 12},
  [581] = {.lex_state = 8, .external_lex_state = 12},
  [582] = {.lex_state = 8, .external_lex_state = 12},
  [583] = {.lex_state = 8, .external_lex_state = 12},
  [584] = {.lex_state = 8, .external_lex_state = 12},
  [585] = {.lex_state = 8, .external_lex_state = 9},
  [586] = {.lex_state = 8, .external_lex_state = 15},
  [587] = {.lex_state = 8, .external_lex_state = 9},
  [588] = {.lex_state = 8, .external_lex_state = 12},
  [589] = {.lex_state = 8, .external_lex_state = 13},
  [590] = {.lex_state = 8, .external_lex_state = 12},
  [591] = {.lex_state = 8, .external_lex_state = 12},
  [592] = {.lex_state = 8, .external_lex_state = 13},
  [593] = {.lex_state = 8, .external_lex_state = 13},
  [594] = {.lex_state = 8, .external_lex_state = 13},
  [595] = {.lex_state = 8, .external_lex_state = 13},
  [596] = {.lex_state = 8, .external_lex_state = 12},
  [597] = {.lex_state = 8, .external_lex_state = 13},
  [598] = {.lex_state = 8, .external_lex_state = 9},
  [599] = {.lex_state = 8, .external_lex_state = 13},
  [600] = {.lex_state = 8, .external_lex_state = 12},
  [601] = {.lex_state = 8, .external_lex_state = 12},
  [602] = {.lex_state = 8, .external_lex_state = 12},
  [603] = {.lex_state = 8, .external_lex_state = 12},
  [604] = {.lex_state = 8, .external_lex_state = 12},
  [605] = {.lex_state = 8, .external_lex_state = 12},
  [606] = {.lex_state = 8, .external_lex_state = 13},
  [607] = {.lex_state = 8, .external_lex_state = 12},
  [608] = {.lex_state = 8, .external_lex_state = 13},
  [609] = {.lex_state = 8, .external_lex_state = 12},
  [610] = {.lex_state = 8, .external_lex_state = 12},
  [611] = {.lex_state = 8, .external_lex_state = 13},
  [612] = {.lex_state = 8, .external_lex_state = 9},
  [613] = {.lex_state = 8, .external_lex_state = 13},
  [614] = {.lex_state = 8, .external_lex_state = 16},
  [615] = {.lex_state = 8, .external_lex_state = 13},
  [616] = {.lex_state = 8, .external_lex_state = 15},
  [617] = {.lex_state = 8, .external_lex_state = 15},
  [618] = {.lex_state = 8, .external_lex_state = 13},
  [619] = {.lex_state = 8, .external_lex_state = 9},
  [620] = {.lex_state = 8, .external_lex_state = 15},
  [621] = {.lex_state = 8, .external_lex_state = 15},
  [622] = {.lex_state = 8, .external_lex_state = 15},
  [623] = {.lex_state = 8, .external_lex_state = 16},
  [624] = {.lex_state = 8, .external_lex_state = 15},
  [625] = {.lex_state = 8, .external_lex_state = 15},
  [626] = {.lex_state = 8, .external_lex_state = 16},
  [627] = {.lex_state = 8, .external_lex_state = 15},
  [628] = {.lex_state = 8, .external_lex_state = 15},
  [629] = {.lex_state = 8, .external_lex_state = 16},
  [630] = {.lex_state = 8, .external_lex_state = 15},
  [631] = {.lex_state = 8, .external_lex_state = 15},
  [632] = {.lex_state = 8, .external_lex_state = 15},
  [633] = {.lex_state = 8, .external_lex_state = 15},
  [634] = {.lex_state = 8, .external_lex_state = 13},
  [635] = {.lex_state = 8, .external_lex_state = 16},
  [636] = {.lex_state = 8, .external_lex_state = 16},
  [637] = {.lex_state = 8, .external_lex_state = 16},
  [638] = {.lex_state = 8, .external_lex_state = 16},
  [639] = {.lex_state = 8, .external_lex_state = 14},
  [640] = {.lex_state = 8, .external_lex_state = 14},
  [641] = {.lex_state = 8, .external_lex_state = 13},
  [642] = {.lex_state = 8, .external_lex_state = 16},
  [643] = {.lex_state = 8, .external_lex_state = 14},
  [644] = {.lex_state = 8, .external_lex_state = 16},
  [645] = {.lex_state = 8, .external_lex_state = 16},
  [646] = {.lex_state = 8, .external_lex_state = 14},
  [647] = {.lex_state = 8, .external_lex_state = 14},
  [648] = {.lex_state = 8, .external_lex_state = 16},
  [649] = {.lex_state = 8, .external_lex_state = 13},
  [650] = {.lex_state = 8, .external_lex_state = 13},
  [651] = {.lex_state = 8, .external_lex_state = 9},
  [652] = {.lex_state = 8, .external_lex_state = 9},
  [653] = {.lex_state = 8, .external_lex_state = 14},
  [654] = {.lex_state = 8, .external_lex_state = 14},
  [655] = {.lex_state = 8, .external_lex_state = 16},
  [656] = {.lex_state = 8, .external_lex_state = 16},
  [657] = {.lex_state = 8, .external_lex_state = 9},
  [658] = {.lex_state = 8, .external_lex_state = 9},
  [659] = {.lex_state = 8, .external_lex_state = 13},
  [660] = {.lex_state = 8, .external_lex_state = 15},
  [661] = {.lex_state = 8, .external_lex_state = 9},
  [662] = {.lex_state = 8, .external_lex_state = 9},
  [663] = {.lex_state = 8, .external_lex_state = 9},
  [664] = {.lex_state = 8, .external_lex_state = 9},
  [665] = {.lex_state = 8, .external_lex_state = 9},
  [666] = {.lex_state = 8, .external_lex_state = 9},
  [667] = {.lex_state = 8, .external_lex_state = 16},
  [668] = {.lex_state = 8, .external_lex_state = 14},
  [669] = {.lex_state = 8, .external_lex_state = 13},
  [670] = {.lex_state = 8, .external_lex_state = 13},
  [671] = {.lex_state = 8, .external_lex_state = 15},
  [672] = {.lex_state = 8, .external_lex_state = 13},
  [673] = {.lex_state = 8, .external_lex_state = 14},
  [674] = {.lex_state = 8, .external_lex_state = 13},
  [675] = {.lex_state = 8, .external_lex_state = 14},
  [676] = {.lex_state = 8, .external_lex_state = 14},
  [677] = {.lex_state = 8, .external_lex_state = 14},
  [678] = {.lex_state = 8, .external_lex_state = 14},
  [679] = {.lex_state = 8, .external_lex_state = 13},
  [680] = {.lex_state = 8, .external_lex_state = 14},
  [681] = {.lex_state = 8, .external_lex_state = 9},
  [682] = {.lex_state = 8, .external_lex_state = 13},
  [683] = {.lex_state = 8, .external_lex_state = 13},
  [684] = {.lex_state = 8, .external_lex_state = 14},
  [685] = {.lex_state = 8, .external_lex_state = 15},
  [686] = {.lex_state = 8, .external_lex_state = 14},
  [687] = {.lex_state = 8, .external_lex_state = 16},
  [688] = {.lex_state = 8, .external_lex_state = 14},
  [689] = {.lex_state = 8, .external_lex_state = 9},
  [690] = {.lex_state = 8, .external_lex_state = 14},
  [691] = {.lex_state = 8, .external_lex_state = 14},
  [692] = {.lex_state = 8, .external_lex_state = 9},
  [693] = {.lex_state = 8, .external_lex_state = 14},
  [694] = {.lex_state = 8, .external_lex_state = 14},
  [695] = {.lex_state = 8, .external_lex_state = 14},
  [696] = {.lex_state = 8, .external_lex_state = 14},
  [697] = {.lex_state = 8, .external_lex_state = 14},
  [698] = {.lex_state = 8, .external_lex_state = 16},
  [699] = {.lex_state = 8, .external_lex_state = 14},
  [700] = {.lex_state = 8, .external_lex_state = 14},
  [701] = {.lex_state = 8, .external_lex_state = 16},
  [702] = {.lex_state = 8, .external_lex_state = 15},
  [703] = {.lex_state = 8, .external_lex_state = 15},
  [704] = {.lex_state = 8, .external_lex_state = 15},
  [705] = {.lex_state = 8, .external_lex_state = 15},
  [706] = {.lex_state = 8, .external_lex_state = 16},
  [707] = {.lex_state = 8, .external_lex_state = 15},
  [708] = {.lex_state = 8, .external_lex_state = 16},
  [709] = {.lex_state = 8, .external_lex_state = 15},
  [710] = {.lex_state = 8, .external_lex_state = 15},
  [711] = {.lex_state = 8, .external_lex_state = 16},
  [712] = {.lex_state = 8, .external_lex_state = 15},
  [713] = {.lex_state = 8, .external_lex_state = 16},
  [714] = {.lex_state = 8, .external_lex_state = 16},
  [715] = {.lex_state = 8, .external_lex_state = 16},
  [716] = {.lex_state = 8, .external_lex_state = 15},
  [717] = {.lex_state = 8, .external_lex_state = 16},
  [718] = {.lex_state = 8, .external_lex_state = 15},
  [719] = {.lex_state = 8, .external_lex_state = 15},
  [720] = {.lex_state = 8, .external_lex_state = 15},
  [721] = {.lex_state = 8, .external_lex_state = 15},
  [722] = {.lex_state = 8, .external_lex_state = 16},
  [723] = {.lex_state = 8, .external_lex_state = 16},
  [724] = {.lex_state = 8, .external_lex_state = 15},
  [725] = {.lex_state = 8, .external_lex_state = 16},
  [726] = {.lex_state = 8, .external_lex_state = 15},
  [727] = {.lex_state = 8, .external_lex_state = 15},
  [728] = {.lex_state = 8, .external_lex_state = 15},
  [729] = {.lex_state = 8, .external_lex_state = 16},
  [730] = {.lex_state = 8, .external_lex_state = 16},
  [731] = {.lex_state = 8, .external_lex_state = 15},
  [732] = {.lex_state = 8, .external_lex_state = 16},
  [733] = {.lex_state = 8, .external_lex_state = 16},
  [734] = {.lex_state = 8, .external_lex_state = 16},
  [735] = {.lex_state = 8, .external_lex_state = 15},
  [736] = {.lex_state = 8, .external_lex_state = 15},
  [737] = {.lex_state = 8, .external_lex_state = 15},
  [738] = {.lex_state = 8, .external_lex_state = 16},
  [739] = {.lex_state = 8, .external_lex_state = 16},
  [740] = {.lex_state = 8, .external_lex_state = 15},
  [741] = {.lex_state = 8, .external_lex_state = 15},
  [742] = {.lex_state = 8, .external_lex_state = 16},
  [743] = {.lex_state = 8, .external_lex_state = 16},
  [744] = {.lex_state = 8, .external_lex_state = 16},
  [745] = {.lex_state = 8, .external_lex_state = 16},
  [746] = {.lex_state = 8, .external_lex_state = 16},
  [747] = {.lex_state = 8, .external_lex_state = 16},
  [748] = {.lex_state = 8, .external_lex_state = 16},
  [749] = {.lex_state = 8, .external_lex_state = 16},
  [750] = {.lex_state = 8, .external_lex_state = 15},
  [751] = {.lex_state = 8, .external_lex_state = 15},
  [752] = {.lex_state = 8, .external_lex_state = 15},
  [753] = {.lex_state = 8, .external_lex_state = 16},
  [754] = {.lex_state = 8, .external_lex_state = 15},
  [755] = {.lex_state = 8, .external_lex_state = 6},
  [756] = {.lex_state = 8, .external_lex_state = 6},
  [757] = {.lex_state = 8, .external_lex_state = 6},
  [758] = {.lex_state = 8, .external_lex_state = 6},
  [759] = {.lex_state = 8, .external_lex_state = 12},
  [760] = {.lex_state = 8, .external_lex_state = 9},
  [761] = {.lex_state = 8, .external_lex_state = 6},
  [762] = {.lex_state = 8, .external_lex_state = 12},
  [763] = {.lex_state = 8, .external_lex_state = 13},
  [764] = {.lex_state = 50, .external_lex_state = 2},
  [765] = {.lex_state = 8, .external_lex_state = 9},
  [766] = {.lex_state = 50, .external_lex_state = 2},
  [767] = {.lex_state = 8, .external_lex_state = 16},
  [768] = {.lex_state = 8, .external_lex_state = 13},
  [769] = {.lex_state = 8, .external_lex_state = 9},
  [770] = {.lex_state = 8, .external_lex_state = 16},
  [771] = {.lex_state = 0, .external_lex_state = 17},
  [772] = {.lex_state = 0, .external_lex_state = 17},
  [773] = {.lex_state = 8, .external_lex_state = 16},
  [774] = {.lex_state = 8, .external_lex_state = 16},
  [775] = {.lex_state = 8, .external_lex_state = 16},
  [776] = {.lex_state = 0, .external_lex_state = 17},
  [777] = {.lex_state = 8, .external_lex_state = 16},
  [778] = {.lex_state = 8, .external_lex_state = 16},
  [779] = {.lex_state = 0, .external_lex_state = 8},
  [780] = {.lex_state = 0, .external_lex_state = 8},
  [781] = {.lex_state = 8, .external_lex_state = 9},
  [782] = {.lex_state = 8, .external_lex_state = 9},
  [783] = {.lex_state = 8, .external_lex_state = 9},
  [784] = {.lex_state = 8, .external_lex_state = 9},
  [785] = {.lex_state = 0, .external_lex_state = 8},
  [786] = {.lex_state = 0, .external_lex_state = 2},
  [787] = {.lex_state = 0, .external_lex_state = 2},
  [788] = {.lex_state = 0, .external_lex_state = 2},
  [789] = {.lex_state = 0, .external_lex_state = 9},
  [790] = {.lex_state = 0, .external_lex_state = 2},
  [791] = {.lex_state = 50, .external_lex_state = 6},
  [792] = {.lex_state = 0, .external_lex_state = 2},
  [793] = {.lex_state = 50, .external_lex_state = 6},
  [794] = {.lex_state = 50, .external_lex_state = 6},
  [795] = {.lex_state = 0, .external_lex_state = 6},
  [796] = {.lex_state = 0, .external_lex_state = 9},
  [797] = {.lex_state = 0, .external_lex_state = 6},
  [798] = {.lex_state = 0, .external_lex_state = 6},
  [799] = {.lex_state = 0, .external_lex_state = 6},
  [800] = {.lex_state = 0, .external_lex_state = 6},
  [801] = {.lex_state = 0, .external_lex_state = 17},
  [802] = {.lex_state = 8, .external_lex_state = 9},
  [803] = {.lex_state = 8, .external_lex_state = 14},
  [804] = {.lex_state = 0, .external_lex_state = 17},
  [805] = {.lex_state = 0, .external_lex_state = 17},
  [806] = {.lex_state = 0, .external_lex_state = 17},
  [807] = {.lex_state = 8, .external_lex_state = 12},
  [808] = {.lex_state = 8, .external_lex_state = 13},
  [809] = {.lex_state = 0, .external_lex_state = 17},
  [810] = {.lex_state = 8, .external_lex_state = 13},
  [811] = {.lex_state = 0, .external_lex_state = 17},
  [812] = {.lex_state = 8, .external_lex_state = 9},
  [813] = {.lex_state = 0, .external_lex_state = 17},
  [814] = {.lex_state = 0, .external_lex_state = 17},
  [815] = {.lex_state = 0, .external_lex_state = 17},
  [816] = {.lex_state = 8, .external_lex_state = 14},
  [817] = {.lex_state = 8, .external_lex_state = 12},
  [818] = {.lex_state = 8, .external_lex_state = 15},
  [819] = {.lex_state = 8, .external_lex_state = 15},
  [820] = {.lex_state = 8, .external_lex_state = 16},
  [821] = {.lex_state = 8, .external_lex_state = 16},
  [822] = {.lex_state = 0, .external_lex_state = 6},
  [823] = {.lex_state = 0, .external_lex_state = 6},
  [824] = {.lex_state = 0, .external_lex_state = 6},
  [825] = {.lex_state = 0, .external_lex_state = 6},
  [826] = {.lex_state = 0, .external_lex_state = 6},
  [827] = {.lex_state = 0, .external_lex_state = 6},
  [828] = {.lex_state = 0, .external_lex_state = 6},
  [829] = {.lex_state = 0, .external_lex_state = 6},
  [830] = {.lex_state = 0, .external_lex_state = 6},
  [831] = {.lex_state = 0, .external_lex_state = 6},
  [832] = {.lex_state = 0, .external_lex_state = 6},
  [833] = {.lex_state = 0, .external_lex_state = 6},
  [834] = {.lex_state = 0, .external_lex_state = 6},
  [835] = {.lex_state = 0, .external_lex_state = 6},
  [836] = {.lex_state = 0, .external_lex_state = 9},
  [837] = {.lex_state = 0, .external_lex_state = 9},
  [838] = {.lex_state = 0, .external_lex_state = 15},
  [839] = {.lex_state = 0, .external_lex_state = 9},
  [840] = {.lex_state = 50, .external_lex_state = 6},
  [841] = {.lex_state = 50, .external_lex_state = 6},
  [842] = {.lex_state = 50, .external_lex_state = 6},
  [843] = {.lex_state = 0, .external_lex_state = 15},
  [844] = {.lex_state = 0, .external_lex_state = 9},
  [845] = {.lex_state = 0, .external_lex_state = 9},
  [846] = {.lex_state = 50, .external_lex_state = 6},
  [847] = {.lex_state = 0, .external_lex_state = 6},
  [848] = {.lex_state = 0, .external_lex_state = 15},
  [849] = {.lex_state = 50, .external_lex_state = 6},
  [850] = {.lex_state = 50, .external_lex_state = 6},
  [851] = {.lex_state = 50, .external_lex_state = 6},
  [852] = {.lex_state = 50, .external_lex_state = 6},
  [853] = {.lex_state = 50, .external_lex_state = 6},
  [854] = {.lex_state = 50, .external_lex_state = 6},
  [855] = {.lex_state = 50, .external_lex_state = 6},
  [856] = {.lex_state = 50, .external_lex_state = 6},
  [857] = {.lex_state = 0, .external_lex_state = 15},
  [858] = {.lex_state = 0, .external_lex_state = 15},
  [859] = {.lex_state = 0, .external_lex_state = 9},
  [860] = {.lex_state = 0, .external_lex_state = 9},
  [861] = {.lex_state = 0, .external_lex_state = 15},
  [862] = {.lex_state = 50, .external_lex_state = 6},
  [863] = {.lex_state = 50, .external_lex_state = 6},
  [864] = {.lex_state = 0, .external_lex_state = 9},
  [865] = {.lex_state = 0, .external_lex_state = 9},
  [866] = {.lex_state = 0, .external_lex_state = 9},
  [867] = {.lex_state = 0, .external_lex_state = 9},
  [868] = {.lex_state = 0, .external_lex_state = 9},
  [869] = {.lex_state = 0, .external_lex_state = 9},
  [870] = {.lex_state = 0, .external_lex_state = 9},
  [871] = {.lex_state = 50, .external_lex_state = 6},
  [872] = {.lex_state = 0, .external_lex_state = 9},
  [873] = {.lex_state = 0, .external_lex_state = 6},
  [874] = {.lex_state = 50, .external_lex_state = 6},
  [875] = {.lex_state = 50, .external_lex_state = 6},
  [876] = {.lex_state = 50, .external_lex_state = 6},
  [877] = {.lex_state = 50, .external_lex_state = 6},
  [878] = {.lex_state = 50, .external_lex_state = 6},
  [879] = {.lex_state = 50, .external_lex_state = 6},
  [880] = {.lex_state = 50, .external_lex_state = 6},
  [881] = {.lex_state = 50, .external_lex_state = 18},
  [882] = {.lex_state = 0, .external_lex_state = 9},
  [883] = {.lex_state = 0, .external_lex_state = 9},
  [884] = {.lex_state = 50, .external_lex_state = 6},
  [885] = {.lex_state = 50, .external_lex_state = 6},
  [886] = {.lex_state = 50, .external_lex_state = 6},
  [887] = {.lex_state = 50, .external_lex_state = 6},
  [888] = {.lex_state = 50, .external_lex_state = 6},
  [889] = {.lex_state = 50, .external_lex_state = 6},
  [890] = {.lex_state = 50, .external_lex_state = 18},
  [891] = {.lex_state = 0, .external_lex_state = 6},
  [892] = {.lex_state = 0, .external_lex_state = 9},
  [893] = {.lex_state = 0, .external_lex_state = 9},
  [894] = {.lex_state = 0, .external_lex_state = 6},
  [895] = {.lex_state = 0, .external_lex_state = 9},
  [896] = {.lex_state = 16, .external_lex_state = 19},
  [897] = {.lex_state = 50, .external_lex_state = 12},
  [898] = {.lex_state = 16, .external_lex_state = 19},
  [899] = {.lex_state = 0, .external_lex_state = 20},
  [900] = {.lex_state = 0, .external_lex_state = 9},
  [901] = {.lex_state = 0, .external_lex_state = 6},
  [902] = {.lex_state = 16, .external_lex_state = 19},
  [903] = {.lex_state = 0, .external_lex_state = 6},
  [904] = {.lex_state = 0, .external_lex_state = 9},
  [905] = {.lex_state = 16, .external_lex_state = 19},
  [906] = {.lex_state = 0, .external_lex_state = 9},
  [907] = {.lex_state = 16, .external_lex_state = 19},
  [908] = {.lex_state = 0, .external_lex_state = 9},
  [909] = {.lex_state = 0, .external_lex_state = 9},
  [910] = {.lex_state = 0, .external_lex_state = 9},
  [911] = {.lex_state = 0, .external_lex_state = 9},
  [912] = {.lex_state = 0, .external_lex_state = 6},
  [913] = {.lex_state = 0, .external_lex_state = 6},
  [914] = {.lex_state = 0, .external_lex_state = 9},
  [915] = {.lex_state = 0, .external_lex_state = 6},
  [916] = {.lex_state = 0, .external_lex_state = 9},
  [917] = {.lex_state = 0, .external_lex_state = 9},
  [918] = {.lex_state = 0, .external_lex_state = 21},
  [919] = {.lex_state = 16, .external_lex_state = 19},
  [920] = {.lex_state = 0, .external_lex_state = 6},
  [921] = {.lex_state = 0, .external_lex_state = 9},
  [922] = {.lex_state = 0, .external_lex_state = 9},
  [923] = {.lex_state = 0, .external_lex_state = 6},
  [924] = {.lex_state = 0, .external_lex_state = 20},
  [925] = {.lex_state = 0, .external_lex_state = 6},
  [926] = {.lex_state = 0, .external_lex_state = 9},
  [927] = {.lex_state = 0, .external_lex_state = 6},
  [928] = {.lex_state = 0, .external_lex_state = 20},
  [929] = {.lex_state = 0, .external_lex_state = 6},
  [930] = {.lex_state = 16, .external_lex_state = 19},
  [931] = {.lex_state = 0, .external_lex_state = 9},
  [932] = {.lex_state = 16, .external_lex_state = 19},
  [933] = {.lex_state = 16, .external_lex_state = 19},
  [934] = {.lex_state = 50, .external_lex_state = 9},
  [935] = {.lex_state = 0, .external_lex_state = 9},
  [936] = {.lex_state = 16, .external_lex_state = 19},
  [937] = {.lex_state = 0, .external_lex_state = 21},
  [938] = {.lex_state = 0, .external_lex_state = 9},
  [939] = {.lex_state = 16, .external_lex_state = 19},
  [940] = {.lex_state = 0, .external_lex_state = 6},
  [941] = {.lex_state = 0, .external_lex_state = 6},
  [942] = {.lex_state = 0, .external_lex_state = 6},
  [943] = {.lex_state = 16, .external_lex_state = 19},
  [944] = {.lex_state = 0, .external_lex_state = 21},
  [945] = {.lex_state = 0, .external_lex_state = 21},
  [946] = {.lex_state = 0, .external_lex_state = 6},
  [947] = {.lex_state = 50, .external_lex_state = 18},
  [948] = {.lex_state = 0, .external_lex_state = 6},
  [949] = {.lex_state = 16, .external_lex_state = 19},
  [950] = {.lex_state = 0, .external_lex_state = 6},
  [951] = {.lex_state = 0, .external_lex_state = 6},
  [952] = {.lex_state = 0, .external_lex_state = 20},
  [953] = {.lex_state = 0, .external_lex_state = 6},
  [954] = {.lex_state = 0, .external_lex_state = 9},
  [955] = {.lex_state = 0, .external_lex_state = 9},
  [956] = {.lex_state = 16, .external_lex_state = 19},
  [957] = {.lex_state = 16, .external_lex_state = 19},
  [958] = {.lex_state = 16, .external_lex_state = 19},
  [959] = {.lex_state = 0, .external_lex_state = 6},
  [960] = {.lex_state = 16, .external_lex_state = 19},
  [961] = {.lex_state = 0, .external_lex_state = 13},
  [962] = {.lex_state = 0, .external_lex_state = 13},
  [963] = {.lex_state = 0, .external_lex_state = 9},
  [964] = {.lex_state = 0, .external_lex_state = 6},
  [965] = {.lex_state = 0, .external_lex_state = 6},
  [966] = {.lex_state = 0, .external_lex_state = 13},
  [967] = {.lex_state = 0, .external_lex_state = 6},
  [968] = {.lex_state = 0, .external_lex_state = 9},
  [969] = {.lex_state = 0, .external_lex_state = 9},
  [970] = {.lex_state = 0, .external_lex_state = 6},
  [971] = {.lex_state = 0, .external_lex_state = 13},
  [972] = {.lex_state = 0, .external_lex_state = 6},
  [973] = {.lex_state = 15, .external_lex_state = 9},
  [974] = {.lex_state = 15, .external_lex_state = 9},
  [975] = {.lex_state = 0, .external_lex_state = 6},
  [976] = {.lex_state = 0, .external_lex_state = 6},
  [977] = {.lex_state = 0, .external_lex_state = 6},
  [978] = {.lex_state = 0, .external_lex_state = 6},
  [979] = {.lex_state = 15, .external_lex_state = 9},
  [980] = {.lex_state = 0, .external_lex_state = 13},
  [981] = {.lex_state = 15, .external_lex_state = 9},
  [982] = {.lex_state = 50, .external_lex_state = 9},
  [983] = {.lex_state = 15, .external_lex_state = 9},
  [984] = {.lex_state = 15, .external_lex_state = 9},
  [985] = {.lex_state = 0, .external_lex_state = 9},
  [986] = {.lex_state = 0, .external_lex_state = 13},
  [987] = {.lex_state = 0, .external_lex_state = 12},
  [988] = {.lex_state = 15, .external_lex_state = 9},
  [989] = {.lex_state = 15, .external_lex_state = 9},
  [990] = {.lex_state = 0, .external_lex_state = 14},
  [991] = {.lex_state = 15, .external_lex_state = 9},
  [992] = {.lex_state = 0, .external_lex_state = 9},
  [993] = {.lex_state = 0, .external_lex_state = 6},
  [994] = {.lex_state = 0, .external_lex_state = 12},
  [995] = {.lex_state = 15, .external_lex_state = 9},
  [996] = {.lex_state = 0, .external_lex_state = 12},
  [997] = {.lex_state = 0, .external_lex_state = 12},
  [998] = {.lex_state = 15, .external_lex_state = 9},
  [999] = {.lex_state = 15, .external_lex_state = 9},
  [1000] = {.lex_state = 15, .external_lex_state = 9},
  [1001] = {.lex_state = 0, .external_lex_state = 9},
  [1002] = {.lex_state = 50, .external_lex_state = 9},
  [1003] = {.lex_state = 15, .external_lex_state = 9},
  [1004] = {.lex_state = 0, .external_lex_state = 18},
  [1005] = {.lex_state = 0, .external_lex_state = 6},
  [1006] = {.lex_state = 0, .external_lex_state = 6},
  [1007] = {.lex_state = 0, .external_lex_state = 14},
  [1008] = {.lex_state = 0, .external_lex_state = 22},
  [1009] = {.lex_state = 0, .external_lex_state = 12},
  [1010] = {.lex_state = 0, .external_lex_state = 6},
  [1011] = {.lex_state = 0, .external_lex_state = 6},
  [1012] = {.lex_state = 0, .external_lex_state = 6},
  [1013] = {.lex_state = 0, .external_lex_state = 6},
  [1014] = {.lex_state = 15, .external_lex_state = 9},
  [1015] = {.lex_state = 0, .external_lex_state = 6},
  [1016] = {.lex_state = 0, .external_lex_state = 22},
  [1017] = {.lex_state = 0, .external_lex_state = 6},
  [1018] = {.lex_state = 0, .external_lex_state = 13},
  [1019] = {.lex_state = 0, .external_lex_state = 13},
  [1020] = {.lex_state = 0, .external_lex_state = 13},
  [1021] = {.lex_state = 0, .external_lex_state = 22},
  [1022] = {.lex_state = 0, .external_lex_state = 14},
  [1023] = {.lex_state = 50, .external_lex_state = 18},
  [1024] = {.lex_state = 50, .external_lex_state = 18},
  [1025] = {.lex_state = 0, .external_lex_state = 22},
  [1026] = {.lex_state = 15, .external_lex_state = 9},
  [1027] = {.lex_state = 50, .external_lex_state = 18},
  [1028] = {.lex_state = 0, .external_lex_state = 22},
  [1029] = {.lex_state = 0, .external_lex_state = 22},
  [1030] = {.lex_state = 0, .external_lex_state = 12},
  [1031] = {.lex_state = 15, .external_lex_state = 9},
  [1032] = {.lex_state = 0, .external_lex_state = 6},
  [1033] = {.lex_state = 0, .external_lex_state = 6},
  [1034] = {.lex_state = 0, .external_lex_state = 12},
  [1035] = {.lex_state = 0, .external_lex_state = 6},
  [1036] = {.lex_state = 0, .external_lex_state = 14},
  [1037] = {.lex_state = 0, .external_lex_state = 13},
  [1038] = {.lex_state = 0, .external_lex_state = 6},
  [1039] = {.lex_state = 15, .external_lex_state = 9},
  [1040] = {.lex_state = 0, .external_lex_state = 12},
  [1041] = {.lex_state = 0, .external_lex_state = 14},
  [1042] = {.lex_state = 0, .external_lex_state = 14},
  [1043] = {.lex_state = 0, .external_lex_state = 13},
  [1044] = {.lex_state = 15, .external_lex_state = 9},
  [1045] = {.lex_state = 0, .external_lex_state = 6},
  [1046] = {.lex_state = 0, .external_lex_state = 6},
  [1047] = {.lex_state = 0, .external_lex_state = 6},
  [1048] = {.lex_state = 0, .external_lex_state = 12},
  [1049] = {.lex_state = 0, .external_lex_state = 6},
  [1050] = {.lex_state = 0, .external_lex_state = 14},
  [1051] = {.lex_state = 15, .external_lex_state = 9},
  [1052] = {.lex_state = 0, .external_lex_state = 6},
  [1053] = {.lex_state = 0, .external_lex_state = 14},
  [1054] = {.lex_state = 0, .external_lex_state = 13},
  [1055] = {.lex_state = 0, .external_lex_state = 12},
  [1056] = {.lex_state = 0, .external_lex_state = 13},
  [1057] = {.lex_state = 0, .external_lex_state = 14},
  [1058] = {.lex_state = 15, .external_lex_state = 9},
  [1059] = {.lex_state = 0, .external_lex_state = 6},
  [1060] = {.lex_state = 0, .external_lex_state = 13},
  [1061] = {.lex_state = 0, .external_lex_state = 14},
  [1062] = {.lex_state = 0, .external_lex_state = 6},
  [1063] = {.lex_state = 15, .external_lex_state = 9},
  [1064] = {.lex_state = 0, .external_lex_state = 12},
  [1065] = {.lex_state = 0, .external_lex_state = 13},
  [1066] = {.lex_state = 0, .external_lex_state = 14},
  [1067] = {.lex_state = 0, .external_lex_state = 12},
  [1068] = {.lex_state = 0, .external_lex_state = 14},
  [1069] = {.lex_state = 0, .external_lex_state = 13},
  [1070] = {.lex_state = 0, .external_lex_state = 12},
  [1071] = {.lex_state = 0, .external_lex_state = 6},
  [1072] = {.lex_state = 0, .external_lex_state = 6},
  [1073] = {.lex_state = 0, .external_lex_state = 6},
  [1074] = {.lex_state = 50, .external_lex_state = 9},
  [1075] = {.lex_state = 0, .external_lex_state = 6},
  [1076] = {.lex_state = 0, .external_lex_state = 6},
  [1077] = {.lex_state = 0, .external_lex_state = 13},
  [1078] = {.lex_state = 15, .external_lex_state = 9},
  [1079] = {.lex_state = 0, .external_lex_state = 9},
  [1080] = {.lex_state = 0, .external_lex_state = 22},
  [1081] = {.lex_state = 0, .external_lex_state = 22},
  [1082] = {.lex_state = 0, .external_lex_state = 14},
  [1083] = {.lex_state = 0, .external_lex_state = 12},
  [1084] = {.lex_state = 15, .external_lex_state = 9},
  [1085] = {.lex_state = 15, .external_lex_state = 9},
  [1086] = {.lex_state = 0, .external_lex_state = 6},
  [1087] = {.lex_state = 0, .external_lex_state = 6},
  [1088] = {.lex_state = 0, .external_lex_state = 6},
  [1089] = {.lex_state = 0, .external_lex_state = 12},
  [1090] = {.lex_state = 15, .external_lex_state = 9},
  [1091] = {.lex_state = 0, .external_lex_state = 12},
  [1092] = {.lex_state = 0, .external_lex_state = 14},
  [1093] = {.lex_state = 15, .external_lex_state = 9},
  [1094] = {.lex_state = 0, .external_lex_state = 13},
  [1095] = {.lex_state = 0, .external_lex_state = 12},
  [1096] = {.lex_state = 0, .external_lex_state = 13},
  [1097] = {.lex_state = 50, .external_lex_state = 18},
  [1098] = {.lex_state = 0, .external_lex_state = 12},
  [1099] = {.lex_state = 0, .external_lex_state = 14},
  [1100] = {.lex_state = 0, .external_lex_state = 13},
  [1101] = {.lex_state = 50, .external_lex_state = 9},
  [1102] = {.lex_state = 0, .external_lex_state = 13},
  [1103] = {.lex_state = 0, .external_lex_state = 12},
  [1104] = {.lex_state = 0, .external_lex_state = 12},
  [1105] = {.lex_state = 15, .external_lex_state = 9},
  [1106] = {.lex_state = 0, .external_lex_state = 12},
  [1107] = {.lex_state = 15, .external_lex_state = 9},
  [1108] = {.lex_state = 0, .external_lex_state = 6},
  [1109] = {.lex_state = 50, .external_lex_state = 9},
  [1110] = {.lex_state = 0, .external_lex_state = 6},
  [1111] = {.lex_state = 0, .external_lex_state = 14},
  [1112] = {.lex_state = 50, .external_lex_state = 18},
  [1113] = {.lex_state = 0, .external_lex_state = 6},
  [1114] = {.lex_state = 0, .external_lex_state = 6},
  [1115] = {.lex_state = 0, .external_lex_state = 6},
  [1116] = {.lex_state = 50, .external_lex_state = 9},
  [1117] = {.lex_state = 0, .external_lex_state = 13},
  [1118] = {.lex_state = 50, .external_lex_state = 18},
  [1119] = {.lex_state = 0, .external_lex_state = 12},
  [1120] = {.lex_state = 0, .external_lex_state = 6},
  [1121] = {.lex_state = 0, .external_lex_state = 14},
  [1122] = {.lex_state = 0, .external_lex_state = 6},
  [1123] = {.lex_state = 0, .external_lex_state = 6},
  [1124] = {.lex_state = 0, .external_lex_state = 13},
  [1125] = {.lex_state = 0, .external_lex_state = 12},
  [1126] = {.lex_state = 0, .external_lex_state = 14},
  [1127] = {.lex_state = 0, .external_lex_state = 13},
  [1128] = {.lex_state = 0, .external_lex_state = 6},
  [1129] = {.lex_state = 0, .external_lex_state = 9},
  [1130] = {.lex_state = 0, .external_lex_state = 13},
  [1131] = {.lex_state = 0, .external_lex_state = 14},
  [1132] = {.lex_state = 0, .external_lex_state = 13},
  [1133] = {.lex_state = 0, .external_lex_state = 14},
  [1134] = {.lex_state = 50, .external_lex_state = 18},
  [1135] = {.lex_state = 50, .external_lex_state = 18},
  [1136] = {.lex_state = 0, .external_lex_state = 13},
  [1137] = {.lex_state = 0, .external_lex_state = 14},
  [1138] = {.lex_state = 0, .external_lex_state = 13},
  [1139] = {.lex_state = 0, .external_lex_state = 14},
  [1140] = {.lex_state = 0, .external_lex_state = 13},
  [1141] = {.lex_state = 0, .external_lex_state = 14},
  [1142] = {.lex_state = 50, .external_lex_state = 18},
  [1143] = {.lex_state = 0, .external_lex_state = 14},
  [1144] = {.lex_state = 50, .external_lex_state = 18},
  [1145] = {.lex_state = 0, .external_lex_state = 13},
  [1146] = {.lex_state = 0, .external_lex_state = 13},
  [1147] = {.lex_state = 0, .external_lex_state = 14},
  [1148] = {.lex_state = 50, .external_lex_state = 18},
  [1149] = {.lex_state = 15, .external_lex_state = 9},
  [1150] = {.lex_state = 0, .external_lex_state = 12},
  [1151] = {.lex_state = 50, .external_lex_state = 18},
  [1152] = {.lex_state = 0, .external_lex_state = 6},
  [1153] = {.lex_state = 0, .external_lex_state = 6},
  [1154] = {.lex_state = 0, .external_lex_state = 13},
  [1155] = {.lex_state = 0, .external_lex_state = 6},
  [1156] = {.lex_state = 0, .external_lex_state = 14},
  [1157] = {.lex_state = 0, .external_lex_state = 6},
  [1158] = {.lex_state = 0, .external_lex_state = 6},
  [1159] = {.lex_state = 0, .external_lex_state = 12},
  [1160] = {.lex_state = 0, .external_lex_state = 14},
  [1161] = {.lex_state = 0, .external_lex_state = 9},
  [1162] = {.lex_state = 0, .external_lex_state = 9},
  [1163] = {.lex_state = 0, .external_lex_state = 9},
  [1164] = {.lex_state = 0, .external_lex_state = 22},
  [1165] = {.lex_state = 0, .external_lex_state = 13},
  [1166] = {.lex_state = 0, .external_lex_state = 9},
  [1167] = {.lex_state = 0, .external_lex_state = 9},
  [1168] = {.lex_state = 0, .external_lex_state = 9},
  [1169] = {.lex_state = 0, .external_lex_state = 9},
  [1170] = {.lex_state = 0, .external_lex_state = 9},
  [1171] = {.lex_state = 0, .external_lex_state = 12},
  [1172] = {.lex_state = 0, .external_lex_state = 9},
  [1173] = {.lex_state = 0, .external_lex_state = 9},
  [1174] = {.lex_state = 50, .external_lex_state = 9},
  [1175] = {.lex_state = 0, .external_lex_state = 9},
  [1176] = {.lex_state = 0, .external_lex_state = 12},
  [1177] = {.lex_state = 0, .external_lex_state = 16},
  [1178] = {.lex_state = 50, .external_lex_state = 9},
  [1179] = {.lex_state = 0, .external_lex_state = 2},
  [1180] = {.lex_state = 0, .external_lex_state = 2},
  [1181] = {.lex_state = 0, .external_lex_state = 22},
  [1182] = {.lex_state = 0, .external_lex_state = 9},
  [1183] = {.lex_state = 50, .external_lex_state = 9},
  [1184] = {.lex_state = 0, .external_lex_state = 9},
  [1185] = {.lex_state = 50, .external_lex_state = 9},
  [1186] = {.lex_state = 50, .external_lex_state = 9},
  [1187] = {.lex_state = 0, .external_lex_state = 14},
  [1188] = {.lex_state = 0, .external_lex_state = 9},
  [1189] = {.lex_state = 0, .external_lex_state = 22},
  [1190] = {.lex_state = 0, .external_lex_state = 9},
  [1191] = {.lex_state = 0, .external_lex_state = 9},
  [1192] = {.lex_state = 0, .external_lex_state = 9},
  [1193] = {.lex_state = 0, .external_lex_state = 9},
  [1194] = {.lex_state = 0, .external_lex_state = 9},
  [1195] = {.lex_state = 0, .external_lex_state = 9},
  [1196] = {.lex_state = 0, .external_lex_state = 9},
  [1197] = {.lex_state = 0, .external_lex_state = 9},
  [1198] = {.lex_state = 0, .external_lex_state = 13},
  [1199] = {.lex_state = 15, .external_lex_state = 9},
  [1200] = {.lex_state = 0, .external_lex_state = 9},
  [1201] = {.lex_state = 0, .external_lex_state = 16},
  [1202] = {.lex_state = 50, .external_lex_state = 9},
  [1203] = {.lex_state = 0, .external_lex_state = 13},
  [1204] = {.lex_state = 0, .external_lex_state = 13},
  [1205] = {.lex_state = 0, .external_lex_state = 9},
  [1206] = {.lex_state = 0, .external_lex_state = 9},
  [1207] = {.lex_state = 0, .external_lex_state = 9},
  [1208] = {.lex_state = 0, .external_lex_state = 9},
  [1209] = {.lex_state = 0, .external_lex_state = 9},
  [1210] = {.lex_state = 0, .external_lex_state = 13},
  [1211] = {.lex_state = 0, .external_lex_state = 14},
  [1212] = {.lex_state = 0, .external_lex_state = 9},
  [1213] = {.lex_state = 0, .external_lex_state = 9},
  [1214] = {.lex_state = 0, .external_lex_state = 13},
  [1215] = {.lex_state = 0, .external_lex_state = 2},
  [1216] = {.lex_state = 0, .external_lex_state = 9},
  [1217] = {.lex_state = 15, .external_lex_state = 9},
  [1218] = {.lex_state = 0, .external_lex_state = 12},
  [1219] = {.lex_state = 0, .external_lex_state = 12},
  [1220] = {.lex_state = 0, .external_lex_state = 9},
  [1221] = {.lex_state = 0, .external_lex_state = 9},
  [1222] = {.lex_state = 0, .external_lex_state = 12},
  [1223] = {.lex_state = 50, .external_lex_state = 9},
  [1224] = {.lex_state = 0, .external_lex_state = 9},
  [1225] = {.lex_state = 0, .external_lex_state = 9},
  [1226] = {.lex_state = 0, .external_lex_state = 9},
  [1227] = {.lex_state = 0, .external_lex_state = 9},
  [1228] = {.lex_state = 0, .external_lex_state = 9},
  [1229] = {.lex_state = 50, .external_lex_state = 9},
  [1230] = {.lex_state = 50, .external_lex_state = 9},
  [1231] = {.lex_state = 0, .external_lex_state = 12},
  [1232] = {.lex_state = 0, .external_lex_state = 13},
  [1233] = {.lex_state = 0, .external_lex_state = 12},
  [1234] = {.lex_state = 0, .external_lex_state = 13},
  [1235] = {.lex_state = 0, .external_lex_state = 9},
  [1236] = {.lex_state = 0, .external_lex_state = 9},
  [1237] = {.lex_state = 0, .external_lex_state = 16},
  [1238] = {.lex_state = 0, .external_lex_state = 9},
  [1239] = {.lex_state = 0, .external_lex_state = 16},
  [1240] = {.lex_state = 0, .external_lex_state = 9},
  [1241] = {.lex_state = 0, .external_lex_state = 9},
  [1242] = {.lex_state = 0, .external_lex_state = 9},
  [1243] = {.lex_state = 0, .external_lex_state = 16},
  [1244] = {.lex_state = 0, .external_lex_state = 16},
  [1245] = {.lex_state = 50, .external_lex_state = 9},
  [1246] = {.lex_state = 50, .external_lex_state = 9},
  [1247] = {.lex_state = 0, .external_lex_state = 23},
  [1248] = {.lex_state = 50, .external_lex_state = 9},
  [1249] = {.lex_state = 0, .external_lex_state = 9},
  [1250] = {.lex_state = 0, .external_lex_state = 14},
  [1251] = {.lex_state = 0, .external_lex_state = 2},
  [1252] = {.lex_state = 0, .external_lex_state = 12},
  [1253] = {.lex_state = 0, .external_lex_state = 12},
  [1254] = {.lex_state = 0, .external_lex_state = 12},
  [1255] = {.lex_state = 0, .external_lex_state = 9},
  [1256] = {.lex_state = 0, .external_lex_state = 9},
  [1257] = {.lex_state = 0, .external_lex_state = 14},
  [1258] = {.lex_state = 0, .external_lex_state = 9},
  [1259] = {.lex_state = 0, .external_lex_state = 12},
  [1260] = {.lex_state = 0, .external_lex_state = 9},
  [1261] = {.lex_state = 0, .external_lex_state = 14},
  [1262] = {.lex_state = 0, .external_lex_state = 12},
  [1263] = {.lex_state = 0, .external_lex_state = 9},
  [1264] = {.lex_state = 50, .external_lex_state = 9},
  [1265] = {.lex_state = 0, .external_lex_state = 9},
  [1266] = {.lex_state = 0, .external_lex_state = 9},
  [1267] = {.lex_state = 0, .external_lex_state = 14},
  [1268] = {.lex_state = 0, .external_lex_state = 9},
  [1269] = {.lex_state = 0, .external_lex_state = 9},
  [1270] = {.lex_state = 0, .external_lex_state = 9},
  [1271] = {.lex_state = 0, .external_lex_state = 14},
  [1272] = {.lex_state = 0, .external_lex_state = 9},
  [1273] = {.lex_state = 0, .external_lex_state = 16},
  [1274] = {.lex_state = 0, .external_lex_state = 14},
  [1275] = {.lex_state = 0, .external_lex_state = 14},
  [1276] = {.lex_state = 0, .external_lex_state = 13},
  [1277] = {.lex_state = 0, .external_lex_state = 13},
  [1278] = {.lex_state = 0, .external_lex_state = 14},
  [1279] = {.lex_state = 50, .external_lex_state = 9},
  [1280] = {.lex_state = 0, .external_lex_state = 9},
  [1281] = {.lex_state = 0, .external_lex_state = 9},
  [1282] = {.lex_state = 0, .external_lex_state = 14},
  [1283] = {.lex_state = 0, .external_lex_state = 14},
  [1284] = {.lex_state = 0, .external_lex_state = 9},
  [1285] = {.lex_state = 0, .external_lex_state = 9},
  [1286] = {.lex_state = 0, .external_lex_state = 9},
  [1287] = {.lex_state = 0, .external_lex_state = 2},
  [1288] = {.lex_state = 0, .external_lex_state = 14},
  [1289] = {.lex_state = 0, .external_lex_state = 9},
  [1290] = {.lex_state = 0, .external_lex_state = 14},
  [1291] = {.lex_state = 0, .external_lex_state = 9},
  [1292] = {.lex_state = 0, .external_lex_state = 9},
  [1293] = {.lex_state = 0, .external_lex_state = 9},
  [1294] = {.lex_state = 0, .external_lex_state = 14},
  [1295] = {.lex_state = 0, .external_lex_state = 9},
  [1296] = {.lex_state = 0, .external_lex_state = 9},
  [1297] = {.lex_state = 0, .external_lex_state = 13},
  [1298] = {.lex_state = 0, .external_lex_state = 14},
  [1299] = {.lex_state = 0, .external_lex_state = 9},
  [1300] = {.lex_state = 0, .external_lex_state = 9},
  [1301] = {.lex_state = 0, .external_lex_state = 16},
  [1302] = {.lex_state = 0, .external_lex_state = 2},
  [1303] = {.lex_state = 0, .external_lex_state = 13},
  [1304] = {.lex_state = 0, .external_lex_state = 13},
  [1305] = {.lex_state = 0, .external_lex_state = 16},
  [1306] = {.lex_state = 0, .external_lex_state = 13},
  [1307] = {.lex_state = 0, .external_lex_state = 9},
  [1308] = {.lex_state = 0, .external_lex_state = 16},
  [1309] = {.lex_state = 0, .external_lex_state = 13},
  [1310] = {.lex_state = 0, .external_lex_state = 13},
  [1311] = {.lex_state = 0, .external_lex_state = 9},
  [1312] = {.lex_state = 0, .external_lex_state = 13},
  [1313] = {.lex_state = 0, .external_lex_state = 9},
  [1314] = {.lex_state = 0, .external_lex_state = 9},
  [1315] = {.lex_state = 0, .external_lex_state = 13},
  [1316] = {.lex_state = 0, .external_lex_state = 13},
  [1317] = {.lex_state = 0, .external_lex_state = 13},
  [1318] = {.lex_state = 0, .external_lex_state = 12},
  [1319] = {.lex_state = 0, .external_lex_state = 14},
  [1320] = {.lex_state = 0, .external_lex_state = 9},
  [1321] = {.lex_state = 0, .external_lex_state = 13},
  [1322] = {.lex_state = 0, .external_lex_state = 23},
  [1323] = {.lex_state = 0, .external_lex_state = 12},
  [1324] = {.lex_state = 0, .external_lex_state = 13},
  [1325] = {.lex_state = 0, .external_lex_state = 13},
  [1326] = {.lex_state = 0, .external_lex_state = 9},
  [1327] = {.lex_state = 0, .external_lex_state = 2},
  [1328] = {.lex_state = 0, .external_lex_state = 13},
  [1329] = {.lex_state = 0, .external_lex_state = 9},
  [1330] = {.lex_state = 0, .external_lex_state = 15},
  [1331] = {.lex_state = 50, .external_lex_state = 9},
  [1332] = {.lex_state = 0, .external_lex_state = 9},
  [1333] = {.lex_state = 0, .external_lex_state = 15},
  [1334] = {.lex_state = 0, .external_lex_state = 9},
  [1335] = {.lex_state = 0, .external_lex_state = 15},
  [1336] = {.lex_state = 0, .external_lex_state = 9},
  [1337] = {.lex_state = 0, .external_lex_state = 9},
  [1338] = {.lex_state = 0, .external_lex_state = 9},
  [1339] = {.lex_state = 0, .external_lex_state = 12},
  [1340] = {.lex_state = 0, .external_lex_state = 14},
  [1341] = {.lex_state = 0, .external_lex_state = 2},
  [1342] = {.lex_state = 50, .external_lex_state = 9},
  [1343] = {.lex_state = 0, .external_lex_state = 9},
  [1344] = {.lex_state = 0, .external_lex_state = 9},
  [1345] = {.lex_state = 0, .external_lex_state = 9},
  [1346] = {.lex_state = 0, .external_lex_state = 9},
  [1347] = {.lex_state = 0, .external_lex_state = 9},
  [1348] = {.lex_state = 0, .external_lex_state = 14},
  [1349] = {.lex_state = 50, .external_lex_state = 9},
  [1350] = {.lex_state = 50, .external_lex_state = 9},
  [1351] = {.lex_state = 0, .external_lex_state = 15},
  [1352] = {.lex_state = 50, .external_lex_state = 9},
  [1353] = {.lex_state = 0, .external_lex_state = 15},
  [1354] = {.lex_state = 50, .external_lex_state = 9},
  [1355] = {.lex_state = 50, .external_lex_state = 9},
  [1356] = {.lex_state = 0, .external_lex_state = 15},
  [1357] = {.lex_state = 50, .external_lex_state = 9},
  [1358] = {.lex_state = 50, .external_lex_state = 9},
  [1359] = {.lex_state = 50, .external_lex_state = 9},
  [1360] = {.lex_state = 50, .external_lex_state = 9},
  [1361] = {.lex_state = 0, .external_lex_state = 23},
  [1362] = {.lex_state = 0, .external_lex_state = 15},
  [1363] = {.lex_state = 0, .external_lex_state = 9},
  [1364] = {.lex_state = 0, .external_lex_state = 22},
  [1365] = {.lex_state = 50, .external_lex_state = 9},
  [1366] = {.lex_state = 50, .external_lex_state = 9},
  [1367] = {.lex_state = 0, .external_lex_state = 22},
  [1368] = {.lex_state = 0, .external_lex_state = 9},
  [1369] = {.lex_state = 50, .external_lex_state = 9},
  [1370] = {.lex_state = 50, .external_lex_state = 9},
  [1371] = {.lex_state = 50, .external_lex_state = 9},
  [1372] = {.lex_state = 0, .external_lex_state = 18},
  [1373] = {.lex_state = 0, .external_lex_state = 9},
  [1374] = {.lex_state = 0, .external_lex_state = 15},
  [1375] = {.lex_state = 0, .external_lex_state = 22},
  [1376] = {.lex_state = 0, .external_lex_state = 22},
  [1377] = {.lex_state = 0, .external_lex_state = 15},
  [1378] = {.lex_state = 0, .external_lex_state = 15},
  [1379] = {.lex_state = 0, .external_lex_state = 15},
  [1380] = {.lex_state = 0, .external_lex_state = 15},
  [1381] = {.lex_state = 50, .external_lex_state = 9},
  [1382] = {.lex_state = 50, .external_lex_state = 9},
  [1383] = {.lex_state = 50, .external_lex_state = 9},
  [1384] = {.lex_state = 0, .external_lex_state = 18},
  [1385] = {.lex_state = 50, .external_lex_state = 9},
  [1386] = {.lex_state = 50, .external_lex_state = 9},
  [1387] = {.lex_state = 50, .external_lex_state = 9},
  [1388] = {.lex_state = 50, .external_lex_state = 9},
  [1389] = {.lex_state = 0, .external_lex_state = 15},
  [1390] = {.lex_state = 50, .external_lex_state = 9},
  [1391] = {.lex_state = 50, .external_lex_state = 9},
  [1392] = {.lex_state = 50, .external_lex_state = 9},
  [1393] = {.lex_state = 50, .external_lex_state = 9},
  [1394] = {.lex_state = 50, .external_lex_state = 9},
  [1395] = {.lex_state = 50, .external_lex_state = 9},
  [1396] = {.lex_state = 0, .external_lex_state = 15},
  [1397] = {.lex_state = 0, .external_lex_state = 15},
  [1398] = {.lex_state = 50, .external_lex_state = 9},
  [1399] = {.lex_state = 50, .external_lex_state = 9},
  [1400] = {.lex_state = 50, .external_lex_state = 9},
  [1401] = {.lex_state = 50, .external_lex_state = 9},
  [1402] = {.lex_state = 50, .external_lex_state = 9},
  [1403] = {.lex_state = 50, .external_lex_state = 9},
  [1404] = {.lex_state = 50, .external_lex_state = 9},
  [1405] = {.lex_state = 0, .external_lex_state = 15},
  [1406] = {.lex_state = 50, .external_lex_state = 9},
  [1407] = {.lex_state = 0, .external_lex_state = 18},
  [1408] = {.lex_state = 50, .external_lex_state = 9},
  [1409] = {.lex_state = 0, .external_lex_state = 15},
  [1410] = {.lex_state = 50, .external_lex_state = 9},
  [1411] = {.lex_state = 50, .external_lex_state = 9},
  [1412] = {.lex_state = 0, .external_lex_state = 9},
  [1413] = {.lex_state = 0, .external_lex_state = 9},
  [1414] = {.lex_state = 50, .external_lex_state = 9},
  [1415] = {.lex_state = 0, .external_lex_state = 18},
  [1416] = {.lex_state = 50, .external_lex_state = 9},
  [1417] = {.lex_state = 50, .external_lex_state = 9},
  [1418] = {.lex_state = 50, .external_lex_state = 9},
  [1419] = {.lex_state = 50, .external_lex_state = 9},
  [1420] = {.lex_state = 0, .external_lex_state = 9},
  [1421] = {.lex_state = 50, .external_lex_state = 9},
  [1422] = {.lex_state = 0, .external_lex_state = 9},
  [1423] = {.lex_state = 0, .external_lex_state = 15},
  [1424] = {.lex_state = 50, .external_lex_state = 9},
  [1425] = {.lex_state = 0, .external_lex_state = 22},
  [1426] = {.lex_state = 50, .external_lex_state = 9},
  [1427] = {.lex_state = 50, .external_lex_state = 9},
  [1428] = {.lex_state = 0, .external_lex_state = 9},
  [1429] = {.lex_state = 0, .external_lex_state = 22},
  [1430] = {.lex_state = 0, .external_lex_state = 15},
  [1431] = {.lex_state = 50, .external_lex_state = 9},
  [1432] = {.lex_state = 50, .external_lex_state = 9},
  [1433] = {.lex_state = 50, .external_lex_state = 9},
  [1434] = {.lex_state = 0, .external_lex_state = 15},
  [1435] = {.lex_state = 0, .external_lex_state = 9},
  [1436] = {.lex_state = 50, .external_lex_state = 9},
  [1437] = {.lex_state = 0, .external_lex_state = 15},
  [1438] = {.lex_state = 0, .external_lex_state = 22},
  [1439] = {.lex_state = 0, .external_lex_state = 9},
  [1440] = {.lex_state = 0, .external_lex_state = 22},
  [1441] = {.lex_state = 0, .external_lex_state = 18},
  [1442] = {.lex_state = 0, .external_lex_state = 18},
};

enum {
  ts_external_token__newline = 0,
  ts_external_token__indent = 1,
  ts_external_token__dedent = 2,
  ts_external_token__string_start = 3,
  ts_external_token__string_content = 4,
  ts_external_token__string_end = 5,
  ts_external_token_comment = 6,
  ts_external_token_RBRACK = 7,
  ts_external_token_RPAREN = 8,
  ts_external_token_RBRACE = 9,
  ts_external_token_COMMA = 10,
  ts_external_token__body_end = 11,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
  [ts_external_token_comment] = sym_comment,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_RPAREN] = anon_sym_RPAREN,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_COMMA] = anon_sym_COMMA,
  [ts_external_token__body_end] = sym__body_end,
};

static const bool ts_external_scanner_states[24][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_RPAREN] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_COMMA] = true,
    [ts_external_token__body_end] = true,
  },
  [2] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token__body_end] = true,
  },
  [4] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token__body_end] = true,
  },
  [5] = {
    [ts_external_token__newline] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token__body_end] = true,
  },
  [6] = {
    [ts_external_token__newline] = true,
    [ts_external_token_comment] = true,
    [ts_external_token__body_end] = true,
  },
  [7] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
  },
  [8] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
  },
  [9] = {
    [ts_external_token_comment] = true,
  },
  [10] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
  },
  [11] = {
    [ts_external_token__indent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
  },
  [12] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
    [ts_external_token_COMMA] = true,
  },
  [13] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_COMMA] = true,
  },
  [14] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_COMMA] = true,
  },
  [15] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
  },
  [16] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
  },
  [17] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
  },
  [18] = {
    [ts_external_token_comment] = true,
    [ts_external_token_COMMA] = true,
  },
  [19] = {
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token_comment] = true,
  },
  [20] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
  },
  [21] = {
    [ts_external_token__newline] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_COMMA] = true,
    [ts_external_token__body_end] = true,
  },
  [22] = {
    [ts_external_token__dedent] = true,
    [ts_external_token_comment] = true,
  },
  [23] = {
    [ts_external_token__indent] = true,
    [ts_external_token_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [sym_static_keyword] = ACTIONS(1),
    [anon_sym_remote] = ACTIONS(1),
    [anon_sym_master] = ACTIONS(1),
    [anon_sym_puppet] = ACTIONS(1),
    [anon_sym_remotesync] = ACTIONS(1),
    [anon_sym_mastersync] = ACTIONS(1),
    [anon_sym_puppetsync] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [sym_node_path] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_setget] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_onready] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [sym_breakpoint_statement] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [sym_tool_statement] = ACTIONS(1),
    [anon_sym_signal] = ACTIONS(1),
    [anon_sym_class_name] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [anon_sym_when] = ACTIONS(1),
    [sym_pattern_open_ending] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym__init] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
    [sym__body_end] = ACTIONS(1),
  },
  [1] = {
    [sym_source] = STATE(1420),
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(836),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(23),
    [sym__simple_statements] = STATE(23),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(969),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym_if_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_class_definition] = STATE(23),
    [sym_enum_definition] = STATE(23),
    [sym_match_statement] = STATE(23),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(23),
    [sym_constructor_definition] = STATE(23),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(23),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(11),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_for] = ACTIONS(47),
    [anon_sym_while] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
  },
  [2] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(19),
    [sym__simple_statements] = STATE(19),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(19),
    [sym_for_statement] = STATE(19),
    [sym_while_statement] = STATE(19),
    [sym_class_definition] = STATE(19),
    [sym_enum_definition] = STATE(19),
    [sym_match_statement] = STATE(19),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(19),
    [sym_constructor_definition] = STATE(19),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(19),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(93),
  },
  [3] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(95),
  },
  [4] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(97),
  },
  [5] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(99),
  },
  [6] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(21),
    [sym__simple_statements] = STATE(21),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_class_definition] = STATE(21),
    [sym_enum_definition] = STATE(21),
    [sym_match_statement] = STATE(21),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(21),
    [sym_constructor_definition] = STATE(21),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(21),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(101),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(101),
  },
  [7] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(106),
    [sym_false] = ACTIONS(106),
    [sym_null] = ACTIONS(106),
    [sym_static_keyword] = ACTIONS(109),
    [anon_sym_remote] = ACTIONS(112),
    [anon_sym_master] = ACTIONS(112),
    [anon_sym_puppet] = ACTIONS(112),
    [anon_sym_remotesync] = ACTIONS(112),
    [anon_sym_mastersync] = ACTIONS(112),
    [anon_sym_puppetsync] = ACTIONS(112),
    [sym_float] = ACTIONS(115),
    [sym_integer] = ACTIONS(106),
    [anon_sym_AMP] = ACTIONS(118),
    [sym_node_path] = ACTIONS(115),
    [sym_get_node] = ACTIONS(115),
    [anon_sym_AT] = ACTIONS(121),
    [anon_sym_var] = ACTIONS(124),
    [anon_sym_export] = ACTIONS(127),
    [anon_sym_onready] = ACTIONS(130),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(136),
    [anon_sym_pass] = ACTIONS(139),
    [anon_sym_break] = ACTIONS(142),
    [sym_breakpoint_statement] = ACTIONS(145),
    [anon_sym_continue] = ACTIONS(148),
    [sym_tool_statement] = ACTIONS(145),
    [anon_sym_signal] = ACTIONS(151),
    [anon_sym_class_name] = ACTIONS(154),
    [anon_sym_extends] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(160),
    [anon_sym_for] = ACTIONS(163),
    [anon_sym_while] = ACTIONS(166),
    [anon_sym_class] = ACTIONS(169),
    [anon_sym_enum] = ACTIONS(172),
    [anon_sym_LBRACE] = ACTIONS(175),
    [anon_sym_match] = ACTIONS(178),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(184),
    [anon_sym_DASH] = ACTIONS(184),
    [anon_sym_not] = ACTIONS(187),
    [anon_sym_BANG] = ACTIONS(184),
    [anon_sym_TILDE] = ACTIONS(184),
    [anon_sym_DOT] = ACTIONS(190),
    [anon_sym_LPAREN] = ACTIONS(193),
    [anon_sym_await] = ACTIONS(196),
    [anon_sym_func] = ACTIONS(199),
    [sym__dedent] = ACTIONS(202),
    [sym__string_start] = ACTIONS(204),
    [sym__body_end] = ACTIONS(202),
  },
  [8] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(9),
    [sym__simple_statements] = STATE(9),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_class_definition] = STATE(9),
    [sym_enum_definition] = STATE(9),
    [sym_match_statement] = STATE(9),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(9),
    [sym_constructor_definition] = STATE(9),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(9),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(207),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(207),
  },
  [9] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(209),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(209),
  },
  [10] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(11),
    [sym__simple_statements] = STATE(11),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_class_definition] = STATE(11),
    [sym_enum_definition] = STATE(11),
    [sym_match_statement] = STATE(11),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(11),
    [sym_constructor_definition] = STATE(11),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(11),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(211),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(211),
  },
  [11] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(213),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(213),
  },
  [12] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(20),
    [sym__simple_statements] = STATE(20),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_class_definition] = STATE(20),
    [sym_enum_definition] = STATE(20),
    [sym_match_statement] = STATE(20),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(20),
    [sym_constructor_definition] = STATE(20),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(20),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(215),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(215),
  },
  [13] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(217),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(217),
  },
  [14] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(4),
    [sym__simple_statements] = STATE(4),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(4),
    [sym_for_statement] = STATE(4),
    [sym_while_statement] = STATE(4),
    [sym_class_definition] = STATE(4),
    [sym_enum_definition] = STATE(4),
    [sym_match_statement] = STATE(4),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(4),
    [sym_constructor_definition] = STATE(4),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(4),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(219),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(219),
  },
  [15] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(3),
    [sym__simple_statements] = STATE(3),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(3),
    [sym_for_statement] = STATE(3),
    [sym_while_statement] = STATE(3),
    [sym_class_definition] = STATE(3),
    [sym_enum_definition] = STATE(3),
    [sym_match_statement] = STATE(3),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(3),
    [sym_constructor_definition] = STATE(3),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(3),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(221),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(221),
  },
  [16] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(223),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(223),
  },
  [17] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(22),
    [sym__simple_statements] = STATE(22),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(22),
    [sym_for_statement] = STATE(22),
    [sym_while_statement] = STATE(22),
    [sym_class_definition] = STATE(22),
    [sym_enum_definition] = STATE(22),
    [sym_match_statement] = STATE(22),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(22),
    [sym_constructor_definition] = STATE(22),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(22),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(225),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(225),
  },
  [18] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(13),
    [sym__simple_statements] = STATE(13),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(13),
    [sym_for_statement] = STATE(13),
    [sym_while_statement] = STATE(13),
    [sym_class_definition] = STATE(13),
    [sym_enum_definition] = STATE(13),
    [sym_match_statement] = STATE(13),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(13),
    [sym_constructor_definition] = STATE(13),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(13),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(227),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(227),
  },
  [19] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(229),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(229),
  },
  [20] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(231),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(231),
  },
  [21] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(233),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(233),
  },
  [22] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(837),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(963),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(235),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(235),
  },
  [23] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(836),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(24),
    [sym__simple_statements] = STATE(24),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(969),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym_if_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_class_definition] = STATE(24),
    [sym_enum_definition] = STATE(24),
    [sym_match_statement] = STATE(24),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(24),
    [sym_constructor_definition] = STATE(24),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(24),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(11),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_if] = ACTIONS(45),
    [anon_sym_for] = ACTIONS(47),
    [anon_sym_while] = ACTIONS(49),
    [anon_sym_class] = ACTIONS(51),
    [anon_sym_enum] = ACTIONS(53),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_match] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
  },
  [24] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(836),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym__statement] = STATE(24),
    [sym__simple_statements] = STATE(24),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(969),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym_if_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_class_definition] = STATE(24),
    [sym_enum_definition] = STATE(24),
    [sym_match_statement] = STATE(24),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_function_definition] = STATE(24),
    [sym_constructor_definition] = STATE(24),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [aux_sym_source_repeat1] = STATE(24),
    [ts_builtin_sym_end] = ACTIONS(202),
    [sym__identifier] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(106),
    [sym_false] = ACTIONS(106),
    [sym_null] = ACTIONS(106),
    [sym_static_keyword] = ACTIONS(239),
    [anon_sym_remote] = ACTIONS(112),
    [anon_sym_master] = ACTIONS(112),
    [anon_sym_puppet] = ACTIONS(112),
    [anon_sym_remotesync] = ACTIONS(112),
    [anon_sym_mastersync] = ACTIONS(112),
    [anon_sym_puppetsync] = ACTIONS(112),
    [sym_float] = ACTIONS(115),
    [sym_integer] = ACTIONS(106),
    [anon_sym_AMP] = ACTIONS(118),
    [sym_node_path] = ACTIONS(115),
    [sym_get_node] = ACTIONS(115),
    [anon_sym_AT] = ACTIONS(121),
    [anon_sym_var] = ACTIONS(124),
    [anon_sym_export] = ACTIONS(127),
    [anon_sym_onready] = ACTIONS(130),
    [anon_sym_const] = ACTIONS(133),
    [anon_sym_return] = ACTIONS(136),
    [anon_sym_pass] = ACTIONS(139),
    [anon_sym_break] = ACTIONS(142),
    [sym_breakpoint_statement] = ACTIONS(242),
    [anon_sym_continue] = ACTIONS(148),
    [sym_tool_statement] = ACTIONS(242),
    [anon_sym_signal] = ACTIONS(151),
    [anon_sym_class_name] = ACTIONS(154),
    [anon_sym_extends] = ACTIONS(157),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(248),
    [anon_sym_while] = ACTIONS(251),
    [anon_sym_class] = ACTIONS(254),
    [anon_sym_enum] = ACTIONS(257),
    [anon_sym_LBRACE] = ACTIONS(175),
    [anon_sym_match] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(181),
    [anon_sym_PLUS] = ACTIONS(184),
    [anon_sym_DASH] = ACTIONS(184),
    [anon_sym_not] = ACTIONS(187),
    [anon_sym_BANG] = ACTIONS(184),
    [anon_sym_TILDE] = ACTIONS(184),
    [anon_sym_DOT] = ACTIONS(190),
    [anon_sym_LPAREN] = ACTIONS(193),
    [anon_sym_await] = ACTIONS(196),
    [anon_sym_func] = ACTIONS(263),
    [sym__string_start] = ACTIONS(204),
  },
  [25] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1290),
    [sym__simple_statements] = STATE(1340),
    [sym_expression_statement] = STATE(901),
    [sym_annotation] = STATE(832),
    [aux_sym__annotations] = STATE(832),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(901),
    [sym_export_variable_statement] = STATE(901),
    [sym_onready_variable_statement] = STATE(901),
    [sym_const_statement] = STATE(901),
    [sym_return_statement] = STATE(901),
    [sym_pass_statement] = STATE(901),
    [sym_break_statement] = STATE(901),
    [sym_continue_statement] = STATE(901),
    [sym_signal_statement] = STATE(901),
    [sym_class_name_statement] = STATE(901),
    [sym_extends_statement] = STATE(901),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(268),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(268),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(270),
    [sym__indent] = ACTIONS(272),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(270),
  },
  [26] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(164),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [27] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(805),
    [sym__simple_statements] = STATE(806),
    [sym_expression_statement] = STATE(929),
    [sym_annotation] = STATE(828),
    [aux_sym__annotations] = STATE(828),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(929),
    [sym_export_variable_statement] = STATE(929),
    [sym_onready_variable_statement] = STATE(929),
    [sym_const_statement] = STATE(929),
    [sym_return_statement] = STATE(929),
    [sym_pass_statement] = STATE(929),
    [sym_break_statement] = STATE(929),
    [sym_continue_statement] = STATE(929),
    [sym_signal_statement] = STATE(929),
    [sym_class_name_statement] = STATE(929),
    [sym_extends_statement] = STATE(929),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(278),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(278),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(280),
    [sym__indent] = ACTIONS(282),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(280),
  },
  [28] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1362),
    [sym__simple_statements] = STATE(1377),
    [sym_expression_statement] = STATE(941),
    [sym_annotation] = STATE(825),
    [aux_sym__annotations] = STATE(825),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(941),
    [sym_export_variable_statement] = STATE(941),
    [sym_onready_variable_statement] = STATE(941),
    [sym_const_statement] = STATE(941),
    [sym_return_statement] = STATE(941),
    [sym_pass_statement] = STATE(941),
    [sym_break_statement] = STATE(941),
    [sym_continue_statement] = STATE(941),
    [sym_signal_statement] = STATE(941),
    [sym_class_name_statement] = STATE(941),
    [sym_extends_statement] = STATE(941),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(284),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(284),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(286),
    [sym__indent] = ACTIONS(288),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(286),
  },
  [29] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1369),
    [sym__simple_statements] = STATE(1365),
    [sym_expression_statement] = STATE(903),
    [sym_annotation] = STATE(826),
    [aux_sym__annotations] = STATE(826),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(903),
    [sym_export_variable_statement] = STATE(903),
    [sym_onready_variable_statement] = STATE(903),
    [sym_const_statement] = STATE(903),
    [sym_return_statement] = STATE(903),
    [sym_pass_statement] = STATE(903),
    [sym_break_statement] = STATE(903),
    [sym_continue_statement] = STATE(903),
    [sym_signal_statement] = STATE(903),
    [sym_class_name_statement] = STATE(903),
    [sym_extends_statement] = STATE(903),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(290),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(290),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(292),
    [sym__indent] = ACTIONS(294),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(292),
  },
  [30] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(190),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [31] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(175),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [32] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(196),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [33] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1319),
    [sym__simple_statements] = STATE(1340),
    [sym_expression_statement] = STATE(901),
    [sym_annotation] = STATE(832),
    [aux_sym__annotations] = STATE(832),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(901),
    [sym_export_variable_statement] = STATE(901),
    [sym_onready_variable_statement] = STATE(901),
    [sym_const_statement] = STATE(901),
    [sym_return_statement] = STATE(901),
    [sym_pass_statement] = STATE(901),
    [sym_break_statement] = STATE(901),
    [sym_continue_statement] = STATE(901),
    [sym_signal_statement] = STATE(901),
    [sym_class_name_statement] = STATE(901),
    [sym_extends_statement] = STATE(901),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(268),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(268),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(270),
    [sym__indent] = ACTIONS(272),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(270),
  },
  [34] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(814),
    [sym__simple_statements] = STATE(806),
    [sym_expression_statement] = STATE(929),
    [sym_annotation] = STATE(828),
    [aux_sym__annotations] = STATE(828),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(929),
    [sym_export_variable_statement] = STATE(929),
    [sym_onready_variable_statement] = STATE(929),
    [sym_const_statement] = STATE(929),
    [sym_return_statement] = STATE(929),
    [sym_pass_statement] = STATE(929),
    [sym_break_statement] = STATE(929),
    [sym_continue_statement] = STATE(929),
    [sym_signal_statement] = STATE(929),
    [sym_class_name_statement] = STATE(929),
    [sym_extends_statement] = STATE(929),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(278),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(278),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(280),
    [sym__indent] = ACTIONS(282),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(280),
  },
  [35] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1386),
    [sym__simple_statements] = STATE(1365),
    [sym_expression_statement] = STATE(903),
    [sym_annotation] = STATE(826),
    [aux_sym__annotations] = STATE(826),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(903),
    [sym_export_variable_statement] = STATE(903),
    [sym_onready_variable_statement] = STATE(903),
    [sym_const_statement] = STATE(903),
    [sym_return_statement] = STATE(903),
    [sym_pass_statement] = STATE(903),
    [sym_break_statement] = STATE(903),
    [sym_continue_statement] = STATE(903),
    [sym_signal_statement] = STATE(903),
    [sym_class_name_statement] = STATE(903),
    [sym_extends_statement] = STATE(903),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(290),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(290),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(292),
    [sym__indent] = ACTIONS(294),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(292),
  },
  [36] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1387),
    [sym__simple_statements] = STATE(1365),
    [sym_expression_statement] = STATE(903),
    [sym_annotation] = STATE(826),
    [aux_sym__annotations] = STATE(826),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(903),
    [sym_export_variable_statement] = STATE(903),
    [sym_onready_variable_statement] = STATE(903),
    [sym_const_statement] = STATE(903),
    [sym_return_statement] = STATE(903),
    [sym_pass_statement] = STATE(903),
    [sym_break_statement] = STATE(903),
    [sym_continue_statement] = STATE(903),
    [sym_signal_statement] = STATE(903),
    [sym_class_name_statement] = STATE(903),
    [sym_extends_statement] = STATE(903),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(290),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(290),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(292),
    [sym__indent] = ACTIONS(294),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(292),
  },
  [37] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(815),
    [sym__simple_statements] = STATE(806),
    [sym_expression_statement] = STATE(929),
    [sym_annotation] = STATE(828),
    [aux_sym__annotations] = STATE(828),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(929),
    [sym_export_variable_statement] = STATE(929),
    [sym_onready_variable_statement] = STATE(929),
    [sym_const_statement] = STATE(929),
    [sym_return_statement] = STATE(929),
    [sym_pass_statement] = STATE(929),
    [sym_break_statement] = STATE(929),
    [sym_continue_statement] = STATE(929),
    [sym_signal_statement] = STATE(929),
    [sym_class_name_statement] = STATE(929),
    [sym_extends_statement] = STATE(929),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(278),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(278),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(280),
    [sym__indent] = ACTIONS(282),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(280),
  },
  [38] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(177),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [39] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(888),
    [sym__simple_statements] = STATE(871),
    [sym_expression_statement] = STATE(925),
    [sym_annotation] = STATE(833),
    [aux_sym__annotations] = STATE(833),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(925),
    [sym_export_variable_statement] = STATE(925),
    [sym_onready_variable_statement] = STATE(925),
    [sym_const_statement] = STATE(925),
    [sym_return_statement] = STATE(925),
    [sym_pass_statement] = STATE(925),
    [sym_break_statement] = STATE(925),
    [sym_continue_statement] = STATE(925),
    [sym_signal_statement] = STATE(925),
    [sym_class_name_statement] = STATE(925),
    [sym_extends_statement] = STATE(925),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(300),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(300),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(302),
    [sym__indent] = ACTIONS(304),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(302),
  },
  [40] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(179),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [41] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(199),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [42] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1397),
    [sym__simple_statements] = STATE(1377),
    [sym_expression_statement] = STATE(941),
    [sym_annotation] = STATE(825),
    [aux_sym__annotations] = STATE(825),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(941),
    [sym_export_variable_statement] = STATE(941),
    [sym_onready_variable_statement] = STATE(941),
    [sym_const_statement] = STATE(941),
    [sym_return_statement] = STATE(941),
    [sym_pass_statement] = STATE(941),
    [sym_break_statement] = STATE(941),
    [sym_continue_statement] = STATE(941),
    [sym_signal_statement] = STATE(941),
    [sym_class_name_statement] = STATE(941),
    [sym_extends_statement] = STATE(941),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(284),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(284),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(286),
    [sym__indent] = ACTIONS(288),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(286),
  },
  [43] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(200),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [44] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1160),
    [sym__simple_statements] = STATE(1340),
    [sym_expression_statement] = STATE(901),
    [sym_annotation] = STATE(832),
    [aux_sym__annotations] = STATE(832),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(901),
    [sym_export_variable_statement] = STATE(901),
    [sym_onready_variable_statement] = STATE(901),
    [sym_const_statement] = STATE(901),
    [sym_return_statement] = STATE(901),
    [sym_pass_statement] = STATE(901),
    [sym_break_statement] = STATE(901),
    [sym_continue_statement] = STATE(901),
    [sym_signal_statement] = STATE(901),
    [sym_class_name_statement] = STATE(901),
    [sym_extends_statement] = STATE(901),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(268),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(268),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(270),
    [sym__indent] = ACTIONS(272),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(270),
  },
  [45] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(194),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [46] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1164),
    [sym__simple_statements] = STATE(1008),
    [sym_expression_statement] = STATE(891),
    [sym_annotation] = STATE(829),
    [aux_sym__annotations] = STATE(829),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(891),
    [sym_export_variable_statement] = STATE(891),
    [sym_onready_variable_statement] = STATE(891),
    [sym_const_statement] = STATE(891),
    [sym_return_statement] = STATE(891),
    [sym_pass_statement] = STATE(891),
    [sym_break_statement] = STATE(891),
    [sym_continue_statement] = STATE(891),
    [sym_signal_statement] = STATE(891),
    [sym_class_name_statement] = STATE(891),
    [sym_extends_statement] = STATE(891),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(306),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(306),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(308),
    [sym__indent] = ACTIONS(310),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(308),
  },
  [47] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(181),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [48] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(172),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [49] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1353),
    [sym__simple_statements] = STATE(1377),
    [sym_expression_statement] = STATE(941),
    [sym_annotation] = STATE(825),
    [aux_sym__annotations] = STATE(825),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(941),
    [sym_export_variable_statement] = STATE(941),
    [sym_onready_variable_statement] = STATE(941),
    [sym_const_statement] = STATE(941),
    [sym_return_statement] = STATE(941),
    [sym_pass_statement] = STATE(941),
    [sym_break_statement] = STATE(941),
    [sym_continue_statement] = STATE(941),
    [sym_signal_statement] = STATE(941),
    [sym_class_name_statement] = STATE(941),
    [sym_extends_statement] = STATE(941),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(284),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(284),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(286),
    [sym__indent] = ACTIONS(288),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(286),
  },
  [50] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(178),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [51] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(876),
    [sym__simple_statements] = STATE(871),
    [sym_expression_statement] = STATE(925),
    [sym_annotation] = STATE(833),
    [aux_sym__annotations] = STATE(833),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(925),
    [sym_export_variable_statement] = STATE(925),
    [sym_onready_variable_statement] = STATE(925),
    [sym_const_statement] = STATE(925),
    [sym_return_statement] = STATE(925),
    [sym_pass_statement] = STATE(925),
    [sym_break_statement] = STATE(925),
    [sym_continue_statement] = STATE(925),
    [sym_signal_statement] = STATE(925),
    [sym_class_name_statement] = STATE(925),
    [sym_extends_statement] = STATE(925),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(300),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(300),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(302),
    [sym__indent] = ACTIONS(304),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(302),
  },
  [52] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(133),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [53] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1298),
    [sym__simple_statements] = STATE(1340),
    [sym_expression_statement] = STATE(901),
    [sym_annotation] = STATE(832),
    [aux_sym__annotations] = STATE(832),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(901),
    [sym_export_variable_statement] = STATE(901),
    [sym_onready_variable_statement] = STATE(901),
    [sym_const_statement] = STATE(901),
    [sym_return_statement] = STATE(901),
    [sym_pass_statement] = STATE(901),
    [sym_break_statement] = STATE(901),
    [sym_continue_statement] = STATE(901),
    [sym_signal_statement] = STATE(901),
    [sym_class_name_statement] = STATE(901),
    [sym_extends_statement] = STATE(901),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(268),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(268),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(270),
    [sym__indent] = ACTIONS(272),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(270),
  },
  [54] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(880),
    [sym__simple_statements] = STATE(871),
    [sym_expression_statement] = STATE(925),
    [sym_annotation] = STATE(833),
    [aux_sym__annotations] = STATE(833),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(925),
    [sym_export_variable_statement] = STATE(925),
    [sym_onready_variable_statement] = STATE(925),
    [sym_const_statement] = STATE(925),
    [sym_return_statement] = STATE(925),
    [sym_pass_statement] = STATE(925),
    [sym_break_statement] = STATE(925),
    [sym_continue_statement] = STATE(925),
    [sym_signal_statement] = STATE(925),
    [sym_class_name_statement] = STATE(925),
    [sym_extends_statement] = STATE(925),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(300),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(300),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(302),
    [sym__indent] = ACTIONS(304),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(302),
  },
  [55] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1262),
    [sym__simple_statements] = STATE(1171),
    [sym_expression_statement] = STATE(951),
    [sym_annotation] = STATE(824),
    [aux_sym__annotations] = STATE(824),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(951),
    [sym_export_variable_statement] = STATE(951),
    [sym_onready_variable_statement] = STATE(951),
    [sym_const_statement] = STATE(951),
    [sym_return_statement] = STATE(951),
    [sym_pass_statement] = STATE(951),
    [sym_break_statement] = STATE(951),
    [sym_continue_statement] = STATE(951),
    [sym_signal_statement] = STATE(951),
    [sym_class_name_statement] = STATE(951),
    [sym_extends_statement] = STATE(951),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(312),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(312),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(314),
    [sym__indent] = ACTIONS(316),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(314),
  },
  [56] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(191),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [57] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(167),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [58] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(126),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [59] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1394),
    [sym__simple_statements] = STATE(1365),
    [sym_expression_statement] = STATE(903),
    [sym_annotation] = STATE(826),
    [aux_sym__annotations] = STATE(826),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(903),
    [sym_export_variable_statement] = STATE(903),
    [sym_onready_variable_statement] = STATE(903),
    [sym_const_statement] = STATE(903),
    [sym_return_statement] = STATE(903),
    [sym_pass_statement] = STATE(903),
    [sym_break_statement] = STATE(903),
    [sym_continue_statement] = STATE(903),
    [sym_signal_statement] = STATE(903),
    [sym_class_name_statement] = STATE(903),
    [sym_extends_statement] = STATE(903),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(290),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(290),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(292),
    [sym__indent] = ACTIONS(294),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(292),
  },
  [60] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(183),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [61] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1259),
    [sym__simple_statements] = STATE(1171),
    [sym_expression_statement] = STATE(951),
    [sym_annotation] = STATE(824),
    [aux_sym__annotations] = STATE(824),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(951),
    [sym_export_variable_statement] = STATE(951),
    [sym_onready_variable_statement] = STATE(951),
    [sym_const_statement] = STATE(951),
    [sym_return_statement] = STATE(951),
    [sym_pass_statement] = STATE(951),
    [sym_break_statement] = STATE(951),
    [sym_continue_statement] = STATE(951),
    [sym_signal_statement] = STATE(951),
    [sym_class_name_statement] = STATE(951),
    [sym_extends_statement] = STATE(951),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(312),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(312),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(314),
    [sym__indent] = ACTIONS(316),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(314),
  },
  [62] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1254),
    [sym__simple_statements] = STATE(1171),
    [sym_expression_statement] = STATE(951),
    [sym_annotation] = STATE(824),
    [aux_sym__annotations] = STATE(824),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(951),
    [sym_export_variable_statement] = STATE(951),
    [sym_onready_variable_statement] = STATE(951),
    [sym_const_statement] = STATE(951),
    [sym_return_statement] = STATE(951),
    [sym_pass_statement] = STATE(951),
    [sym_break_statement] = STATE(951),
    [sym_continue_statement] = STATE(951),
    [sym_signal_statement] = STATE(951),
    [sym_class_name_statement] = STATE(951),
    [sym_extends_statement] = STATE(951),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(312),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(312),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(314),
    [sym__indent] = ACTIONS(316),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(314),
  },
  [63] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(165),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [64] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(203),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [65] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(184),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [66] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(159),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [67] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(176),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [68] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(166),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [69] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(170),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [70] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(158),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [71] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(187),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [72] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(171),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [73] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(146),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [74] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(147),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [75] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(186),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [76] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1252),
    [sym__simple_statements] = STATE(1171),
    [sym_expression_statement] = STATE(951),
    [sym_annotation] = STATE(824),
    [aux_sym__annotations] = STATE(824),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(951),
    [sym_export_variable_statement] = STATE(951),
    [sym_onready_variable_statement] = STATE(951),
    [sym_const_statement] = STATE(951),
    [sym_return_statement] = STATE(951),
    [sym_pass_statement] = STATE(951),
    [sym_break_statement] = STATE(951),
    [sym_continue_statement] = STATE(951),
    [sym_signal_statement] = STATE(951),
    [sym_class_name_statement] = STATE(951),
    [sym_extends_statement] = STATE(951),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(312),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(312),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(314),
    [sym__indent] = ACTIONS(316),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(314),
  },
  [77] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(156),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [78] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(188),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [79] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(189),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [80] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1214),
    [sym__simple_statements] = STATE(1317),
    [sym_expression_statement] = STATE(913),
    [sym_annotation] = STATE(830),
    [aux_sym__annotations] = STATE(830),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(913),
    [sym_export_variable_statement] = STATE(913),
    [sym_onready_variable_statement] = STATE(913),
    [sym_const_statement] = STATE(913),
    [sym_return_statement] = STATE(913),
    [sym_pass_statement] = STATE(913),
    [sym_break_statement] = STATE(913),
    [sym_continue_statement] = STATE(913),
    [sym_signal_statement] = STATE(913),
    [sym_class_name_statement] = STATE(913),
    [sym_extends_statement] = STATE(913),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(318),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(318),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(320),
    [sym__indent] = ACTIONS(322),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(320),
  },
  [81] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(201),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [82] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1181),
    [sym__simple_statements] = STATE(1008),
    [sym_expression_statement] = STATE(891),
    [sym_annotation] = STATE(829),
    [aux_sym__annotations] = STATE(829),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(891),
    [sym_export_variable_statement] = STATE(891),
    [sym_onready_variable_statement] = STATE(891),
    [sym_const_statement] = STATE(891),
    [sym_return_statement] = STATE(891),
    [sym_pass_statement] = STATE(891),
    [sym_break_statement] = STATE(891),
    [sym_continue_statement] = STATE(891),
    [sym_signal_statement] = STATE(891),
    [sym_class_name_statement] = STATE(891),
    [sym_extends_statement] = STATE(891),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(306),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(306),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(308),
    [sym__indent] = ACTIONS(310),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(308),
  },
  [83] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(205),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [84] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1189),
    [sym__simple_statements] = STATE(1008),
    [sym_expression_statement] = STATE(891),
    [sym_annotation] = STATE(829),
    [aux_sym__annotations] = STATE(829),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(891),
    [sym_export_variable_statement] = STATE(891),
    [sym_onready_variable_statement] = STATE(891),
    [sym_const_statement] = STATE(891),
    [sym_return_statement] = STATE(891),
    [sym_pass_statement] = STATE(891),
    [sym_break_statement] = STATE(891),
    [sym_continue_statement] = STATE(891),
    [sym_signal_statement] = STATE(891),
    [sym_class_name_statement] = STATE(891),
    [sym_extends_statement] = STATE(891),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(306),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(306),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(308),
    [sym__indent] = ACTIONS(310),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(308),
  },
  [85] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(155),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [86] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1356),
    [sym__simple_statements] = STATE(1377),
    [sym_expression_statement] = STATE(941),
    [sym_annotation] = STATE(825),
    [aux_sym__annotations] = STATE(825),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(941),
    [sym_export_variable_statement] = STATE(941),
    [sym_onready_variable_statement] = STATE(941),
    [sym_const_statement] = STATE(941),
    [sym_return_statement] = STATE(941),
    [sym_pass_statement] = STATE(941),
    [sym_break_statement] = STATE(941),
    [sym_continue_statement] = STATE(941),
    [sym_signal_statement] = STATE(941),
    [sym_class_name_statement] = STATE(941),
    [sym_extends_statement] = STATE(941),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(284),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(284),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(286),
    [sym__indent] = ACTIONS(288),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(286),
  },
  [87] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(204),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [88] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1165),
    [sym__simple_statements] = STATE(1317),
    [sym_expression_statement] = STATE(913),
    [sym_annotation] = STATE(830),
    [aux_sym__annotations] = STATE(830),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(913),
    [sym_export_variable_statement] = STATE(913),
    [sym_onready_variable_statement] = STATE(913),
    [sym_const_statement] = STATE(913),
    [sym_return_statement] = STATE(913),
    [sym_pass_statement] = STATE(913),
    [sym_break_statement] = STATE(913),
    [sym_continue_statement] = STATE(913),
    [sym_signal_statement] = STATE(913),
    [sym_class_name_statement] = STATE(913),
    [sym_extends_statement] = STATE(913),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(318),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(318),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(320),
    [sym__indent] = ACTIONS(322),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(320),
  },
  [89] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(878),
    [sym__simple_statements] = STATE(871),
    [sym_expression_statement] = STATE(925),
    [sym_annotation] = STATE(833),
    [aux_sym__annotations] = STATE(833),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(925),
    [sym_export_variable_statement] = STATE(925),
    [sym_onready_variable_statement] = STATE(925),
    [sym_const_statement] = STATE(925),
    [sym_return_statement] = STATE(925),
    [sym_pass_statement] = STATE(925),
    [sym_break_statement] = STATE(925),
    [sym_continue_statement] = STATE(925),
    [sym_signal_statement] = STATE(925),
    [sym_class_name_statement] = STATE(925),
    [sym_extends_statement] = STATE(925),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(300),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(300),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(302),
    [sym__indent] = ACTIONS(304),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(302),
  },
  [90] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(202),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [91] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(151),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [92] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(153),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [93] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(173),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [94] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1210),
    [sym__simple_statements] = STATE(1317),
    [sym_expression_statement] = STATE(913),
    [sym_annotation] = STATE(830),
    [aux_sym__annotations] = STATE(830),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(913),
    [sym_export_variable_statement] = STATE(913),
    [sym_onready_variable_statement] = STATE(913),
    [sym_const_statement] = STATE(913),
    [sym_return_statement] = STATE(913),
    [sym_pass_statement] = STATE(913),
    [sym_break_statement] = STATE(913),
    [sym_continue_statement] = STATE(913),
    [sym_signal_statement] = STATE(913),
    [sym_class_name_statement] = STATE(913),
    [sym_extends_statement] = STATE(913),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(318),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(318),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(320),
    [sym__indent] = ACTIONS(322),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(320),
  },
  [95] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(125),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [96] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(141),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [97] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(157),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [98] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(152),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [99] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(148),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [100] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(1198),
    [sym__simple_statements] = STATE(1317),
    [sym_expression_statement] = STATE(913),
    [sym_annotation] = STATE(830),
    [aux_sym__annotations] = STATE(830),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(913),
    [sym_export_variable_statement] = STATE(913),
    [sym_onready_variable_statement] = STATE(913),
    [sym_const_statement] = STATE(913),
    [sym_return_statement] = STATE(913),
    [sym_pass_statement] = STATE(913),
    [sym_break_statement] = STATE(913),
    [sym_continue_statement] = STATE(913),
    [sym_signal_statement] = STATE(913),
    [sym_class_name_statement] = STATE(913),
    [sym_extends_statement] = STATE(913),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(318),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(318),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(320),
    [sym__indent] = ACTIONS(322),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(320),
  },
  [101] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(195),
    [sym__simple_statements] = STATE(139),
    [sym_expression_statement] = STATE(894),
    [sym_annotation] = STATE(822),
    [aux_sym__annotations] = STATE(822),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(894),
    [sym_export_variable_statement] = STATE(894),
    [sym_onready_variable_statement] = STATE(894),
    [sym_const_statement] = STATE(894),
    [sym_return_statement] = STATE(894),
    [sym_pass_statement] = STATE(894),
    [sym_break_statement] = STATE(894),
    [sym_continue_statement] = STATE(894),
    [sym_signal_statement] = STATE(894),
    [sym_class_name_statement] = STATE(894),
    [sym_extends_statement] = STATE(894),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(296),
    [sym__indent] = ACTIONS(298),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(296),
  },
  [102] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_body] = STATE(149),
    [sym__simple_statements] = STATE(132),
    [sym_expression_statement] = STATE(946),
    [sym_annotation] = STATE(823),
    [aux_sym__annotations] = STATE(823),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(946),
    [sym_export_variable_statement] = STATE(946),
    [sym_onready_variable_statement] = STATE(946),
    [sym_const_statement] = STATE(946),
    [sym_return_statement] = STATE(946),
    [sym_pass_statement] = STATE(946),
    [sym_break_statement] = STATE(946),
    [sym_continue_statement] = STATE(946),
    [sym_signal_statement] = STATE(946),
    [sym_class_name_statement] = STATE(946),
    [sym_extends_statement] = STATE(946),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(274),
    [sym__indent] = ACTIONS(276),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(274),
  },
  [103] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(326),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(326),
  },
  [104] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(328),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(328),
  },
  [105] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(330),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(330),
  },
  [106] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(332),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(332),
  },
  [107] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(334),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(334),
  },
  [108] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(336),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(336),
  },
  [109] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(338),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(338),
  },
  [110] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(340),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(340),
  },
  [111] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(342),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(342),
  },
  [112] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(344),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(344),
  },
  [113] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(346),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(346),
  },
  [114] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(348),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(348),
  },
  [115] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(350),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(350),
  },
  [116] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(352),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(352),
  },
  [117] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(354),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(354),
  },
  [118] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(356),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(356),
  },
  [119] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(358),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(358),
  },
  [120] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(360),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(360),
  },
  [121] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(362),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(362),
  },
  [122] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(364),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(364),
  },
  [123] = {
    [sym_identifier] = STATE(257),
    [sym_remote_keyword] = STATE(844),
    [sym_string] = STATE(257),
    [sym_string_name] = STATE(234),
    [sym_expression_statement] = STATE(1015),
    [sym_annotation] = STATE(834),
    [aux_sym__annotations] = STATE(834),
    [sym_annotations] = STATE(1228),
    [sym__variable_statement] = STATE(970),
    [sym_variable_statement] = STATE(1015),
    [sym_export_variable_statement] = STATE(1015),
    [sym_onready_variable_statement] = STATE(1015),
    [sym_const_statement] = STATE(1015),
    [sym_return_statement] = STATE(1015),
    [sym_pass_statement] = STATE(1015),
    [sym_break_statement] = STATE(1015),
    [sym_continue_statement] = STATE(1015),
    [sym_signal_statement] = STATE(1015),
    [sym_class_name_statement] = STATE(1015),
    [sym_extends_statement] = STATE(1015),
    [sym__expression] = STATE(795),
    [sym__primary_expression] = STATE(229),
    [sym__attribute_expression] = STATE(1216),
    [sym_binary_operator] = STATE(257),
    [sym_unary_operator] = STATE(257),
    [sym_comparison_operator] = STATE(793),
    [sym_subscript] = STATE(257),
    [sym_attribute] = STATE(234),
    [sym_conditional_expression] = STATE(793),
    [sym_parenthesized_expression] = STATE(257),
    [sym_await_expression] = STATE(793),
    [sym_assignment] = STATE(972),
    [sym_augmented_assignment] = STATE(972),
    [sym_dictionary] = STATE(257),
    [sym_array] = STATE(257),
    [sym_base_call] = STATE(257),
    [sym_call] = STATE(257),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(266),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(324),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(324),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_extends] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(59),
    [anon_sym_PLUS] = ACTIONS(61),
    [anon_sym_DASH] = ACTIONS(61),
    [anon_sym_not] = ACTIONS(63),
    [anon_sym_BANG] = ACTIONS(61),
    [anon_sym_TILDE] = ACTIONS(61),
    [anon_sym_DOT] = ACTIONS(65),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__string_start] = ACTIONS(73),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 1,
      anon_sym_elif,
    ACTIONS(372), 1,
      anon_sym_else,
    STATE(128), 1,
      aux_sym_if_statement_repeat1,
    STATE(137), 1,
      sym_elif_clause,
    STATE(163), 1,
      sym_else_clause,
    ACTIONS(368), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(366), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [73] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(370), 1,
      anon_sym_elif,
    ACTIONS(372), 1,
      anon_sym_else,
    STATE(124), 1,
      aux_sym_if_statement_repeat1,
    STATE(137), 1,
      sym_elif_clause,
    STATE(150), 1,
      sym_else_clause,
    ACTIONS(376), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(374), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [146] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      anon_sym_elif,
    ACTIONS(380), 1,
      anon_sym_else,
    STATE(127), 1,
      aux_sym_if_statement_repeat1,
    STATE(138), 1,
      sym_elif_clause,
    STATE(193), 1,
      sym_else_clause,
    ACTIONS(376), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(374), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [218] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(378), 1,
      anon_sym_elif,
    ACTIONS(380), 1,
      anon_sym_else,
    STATE(129), 1,
      aux_sym_if_statement_repeat1,
    STATE(138), 1,
      sym_elif_clause,
    STATE(192), 1,
      sym_else_clause,
    ACTIONS(368), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(366), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [290] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(386), 1,
      anon_sym_elif,
    STATE(128), 1,
      aux_sym_if_statement_repeat1,
    STATE(137), 1,
      sym_elif_clause,
    ACTIONS(384), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(382), 37,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [358] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(389), 1,
      anon_sym_elif,
    STATE(129), 1,
      aux_sym_if_statement_repeat1,
    STATE(138), 1,
      sym_elif_clause,
    ACTIONS(384), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(382), 37,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(392), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(396), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [545] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(400), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(404), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(408), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [725] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(412), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(416), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [845] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(422), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(420), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [905] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(422), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(420), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(402), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(400), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(394), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(392), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1082] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(406), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(404), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1141] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(410), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(408), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(398), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(396), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(414), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(412), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(418), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(416), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(424), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1435] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(430), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(428), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(434), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(432), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(436), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(440), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(444), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1725] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(450), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(448), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(454), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(452), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(458), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(456), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1899] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(460), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [1957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(466), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(464), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(468), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(474), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(472), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(478), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(476), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2189] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(482), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(480), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(486), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(484), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(490), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(488), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(492), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2421] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(496), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(500), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(504), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(508), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(512), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2711] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(516), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(520), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(524), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(530), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(528), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [2943] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(534), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(532), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3001] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(538), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(536), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(542), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(540), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(544), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3175] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(542), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(540), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3232] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(434), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(432), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3289] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(506), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(504), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3346] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(490), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(488), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3403] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(466), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(464), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3460] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(482), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(480), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3517] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(462), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(460), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3574] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(454), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(452), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3631] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(538), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(536), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3688] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(534), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(532), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3745] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(426), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(424), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3802] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(446), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(444), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3859] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(430), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(428), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3916] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(544), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [3973] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(438), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(436), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4030] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(494), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(492), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4087] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(442), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(440), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4144] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(470), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(468), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4201] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(478), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(476), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4258] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(450), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(448), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4315] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(514), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(512), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4372] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(486), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(484), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4429] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(498), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(496), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4486] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(502), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(500), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4543] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(510), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(508), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4600] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(522), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(520), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4657] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(530), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(528), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4714] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(474), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(472), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4771] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(526), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(524), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4828] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(458), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(456), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(518), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(516), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_DOT,
      anon_sym_await,
      anon_sym_func,
  [4942] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(548), 34,
      sym__newline,
      sym__body_end,
      sym_static_keyword,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [4997] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(554), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(552), 34,
      sym__newline,
      sym__body_end,
      sym_static_keyword,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [5052] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(558), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(556), 34,
      sym__newline,
      sym__body_end,
      sym_static_keyword,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [5107] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(560), 34,
      sym__newline,
      sym__body_end,
      sym_static_keyword,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [5162] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(566), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 34,
      sym__newline,
      sym__body_end,
      sym_static_keyword,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [5217] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(568), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(570), 28,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5275] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(580), 1,
      anon_sym_DOT,
    STATE(214), 1,
      aux_sym_attribute_repeat1,
    ACTIONS(576), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 29,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5331] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(583), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 28,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5389] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(583), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 28,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5447] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(587), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(589), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(583), 8,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5511] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    ACTIONS(593), 1,
      anon_sym_CARET,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(587), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(595), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(589), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(583), 5,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5579] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(214), 1,
      aux_sym_attribute_repeat1,
    ACTIONS(597), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(599), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5633] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(587), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(595), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(589), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(583), 6,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5699] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    ACTIONS(593), 1,
      anon_sym_CARET,
    ACTIONS(601), 1,
      anon_sym_AMP,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(587), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(595), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(589), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(583), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5769] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(603), 1,
      anon_sym_LBRACK,
    STATE(261), 1,
      sym_arguments,
    ACTIONS(576), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 28,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5827] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(607), 1,
      anon_sym_func,
    STATE(229), 1,
      sym__primary_expression,
    STATE(863), 1,
      sym__expression,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    STATE(977), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(605), 3,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
    STATE(793), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [5917] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(583), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5977] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(589), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(583), 10,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6039] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    ACTIONS(593), 1,
      anon_sym_CARET,
    ACTIONS(601), 1,
      anon_sym_AMP,
    ACTIONS(611), 1,
      anon_sym_PIPE,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(587), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(595), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(609), 2,
      anon_sym_and,
      anon_sym_AMP_AMP,
    ACTIONS(583), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(585), 25,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6113] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(613), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(615), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6173] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    ACTIONS(593), 1,
      anon_sym_CARET,
    ACTIONS(601), 1,
      anon_sym_AMP,
    ACTIONS(611), 1,
      anon_sym_PIPE,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(587), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(595), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(583), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(585), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6245] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(593), 1,
      anon_sym_CARET,
    ACTIONS(601), 1,
      anon_sym_AMP,
    ACTIONS(611), 1,
      anon_sym_PIPE,
    ACTIONS(619), 1,
      anon_sym_EQ,
    ACTIONS(623), 1,
      anon_sym_LBRACK,
    ACTIONS(627), 1,
      anon_sym_is,
    STATE(241), 1,
      sym_arguments,
    STATE(756), 1,
      aux_sym_comparison_operator_repeat1,
    ACTIONS(587), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(595), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(609), 2,
      anon_sym_and,
      anon_sym_AMP_AMP,
    ACTIONS(625), 2,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
    ACTIONS(629), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(589), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(621), 5,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(617), 16,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6329] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(631), 1,
      anon_sym_DOT,
    STATE(214), 1,
      aux_sym_attribute_repeat1,
    ACTIONS(597), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(599), 29,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6385] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(635), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6436] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(637), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(639), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6487] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(651), 1,
      anon_sym_RBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1043), 1,
      sym_pair,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [6580] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(669), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(671), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6631] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(673), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [6724] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    ACTIONS(574), 1,
      anon_sym_LPAREN,
    ACTIONS(591), 1,
      anon_sym_is,
    ACTIONS(593), 1,
      anon_sym_CARET,
    ACTIONS(601), 1,
      anon_sym_AMP,
    ACTIONS(611), 1,
      anon_sym_PIPE,
    ACTIONS(623), 1,
      anon_sym_LBRACK,
    STATE(241), 1,
      sym_arguments,
    ACTIONS(587), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(595), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(609), 2,
      anon_sym_and,
      anon_sym_AMP_AMP,
    ACTIONS(625), 2,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
    ACTIONS(589), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(677), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(675), 21,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6801] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(679), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [6894] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(681), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(683), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6945] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(685), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1065), 1,
      sym_pair,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7038] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(583), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(585), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7089] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(689), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7140] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(691), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(986), 1,
      sym_pair,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7233] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(693), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(695), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7284] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(697), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(699), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7335] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(576), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(578), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7386] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(701), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7479] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(703), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7572] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(705), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(707), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7623] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(709), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7716] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(711), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1146), 1,
      sym_pair,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7809] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(713), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7902] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(715), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(717), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7953] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(719), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8046] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(721), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1102), 1,
      sym_pair,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8139] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(723), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8232] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(725), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8325] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(727), 1,
      anon_sym_DOT,
    ACTIONS(669), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(671), 29,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8378] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(729), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(731), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8429] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(733), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1069), 1,
      sym_pair,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8522] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(735), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8615] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(737), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(739), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8666] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(741), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1127), 1,
      sym_pair,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8759] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(743), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8852] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(747), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8903] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(749), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8996] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(751), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(753), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [9047] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(757), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [9098] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(759), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9191] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(763), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [9242] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(765), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(767), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [9293] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(771), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [9344] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(773), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(775), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [9395] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(777), 1,
      anon_sym_RBRACE,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9488] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(791), 1,
      anon_sym_RBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9576] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(566), 9,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 33,
      sym_static_keyword,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_onready,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_func,
  [9626] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(807), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9714] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(809), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9802] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(831), 1,
      anon_sym_RPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9890] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(558), 9,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(556), 33,
      sym_static_keyword,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_onready,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_func,
  [9940] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(839), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10028] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(841), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1067), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10116] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(843), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10204] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(845), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10292] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(847), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10380] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(849), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10468] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(851), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10556] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(853), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10644] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(855), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10732] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(857), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10820] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(859), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10908] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(861), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1068), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10996] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(863), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11084] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(865), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11172] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(867), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1125), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11260] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 9,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(548), 33,
      sym_static_keyword,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_onready,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_func,
  [11310] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(869), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11398] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(871), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11486] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(873), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1040), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11574] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(875), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1126), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11662] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(877), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11750] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(879), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(990), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11838] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(881), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11926] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(883), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1099), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12014] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(885), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1098), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12102] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(887), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12190] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(889), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12278] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(891), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1041), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12366] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(893), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12454] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(665), 1,
      anon_sym_func,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(598), 1,
      sym_identifier,
    STATE(1223), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1276), 1,
      sym_pair,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    STATE(1385), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12544] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(895), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1009), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12632] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(554), 9,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(552), 33,
      sym_static_keyword,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_onready,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_func,
  [12682] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(897), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12770] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(899), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1147), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12858] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(901), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12946] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(903), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1150), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13034] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(905), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1070), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13122] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(907), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13210] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(909), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1066), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13298] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    ACTIONS(911), 1,
      anon_sym_RPAREN,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13386] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(913), 1,
      anon_sym_RBRACK,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13474] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(935), 1,
      anon_sym_await,
    ACTIONS(937), 1,
      anon_sym_func,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(671), 1,
      sym__primary_expression,
    STATE(1220), 1,
      sym__attribute_expression,
    STATE(1333), 1,
      sym__expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    STATE(1378), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1330), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13559] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(607), 1,
      anon_sym_func,
    STATE(229), 1,
      sym__primary_expression,
    STATE(863), 1,
      sym__expression,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    STATE(877), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(793), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13644] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(935), 1,
      anon_sym_await,
    ACTIONS(937), 1,
      anon_sym_func,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(671), 1,
      sym__primary_expression,
    STATE(1220), 1,
      sym__attribute_expression,
    STATE(1333), 1,
      sym__expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    STATE(1437), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1330), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13729] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(935), 1,
      anon_sym_await,
    ACTIONS(937), 1,
      anon_sym_func,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(671), 1,
      sym__primary_expression,
    STATE(1220), 1,
      sym__attribute_expression,
    STATE(1333), 1,
      sym__expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    STATE(1430), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1330), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13814] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(607), 1,
      anon_sym_func,
    STATE(229), 1,
      sym__primary_expression,
    STATE(863), 1,
      sym__expression,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    STATE(1033), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(793), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13899] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(935), 1,
      anon_sym_await,
    ACTIONS(937), 1,
      anon_sym_func,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(671), 1,
      sym__primary_expression,
    STATE(1220), 1,
      sym__attribute_expression,
    STATE(1333), 1,
      sym__expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    STATE(1409), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1330), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13984] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(935), 1,
      anon_sym_await,
    ACTIONS(937), 1,
      anon_sym_func,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(671), 1,
      sym__primary_expression,
    STATE(1220), 1,
      sym__attribute_expression,
    STATE(1333), 1,
      sym__expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    STATE(1379), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1330), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14069] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(607), 1,
      anon_sym_func,
    STATE(229), 1,
      sym__primary_expression,
    STATE(863), 1,
      sym__expression,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    STATE(884), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(793), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14154] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(961), 1,
      anon_sym_await,
    ACTIONS(963), 1,
      anon_sym_func,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(575), 1,
      sym__primary_expression,
    STATE(980), 1,
      sym__expression,
    STATE(1344), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    STATE(1277), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(971), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14239] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(967), 1,
      anon_sym_RBRACE,
    ACTIONS(969), 1,
      sym_pattern_open_ending,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1130), 1,
      sym_pattern_pair,
    STATE(1178), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14326] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(803), 1,
      anon_sym_func,
    ACTIONS(805), 1,
      sym__string_start,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1007), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14411] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(607), 1,
      anon_sym_func,
    STATE(229), 1,
      sym__primary_expression,
    STATE(863), 1,
      sym__expression,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    STATE(889), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(793), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14496] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(935), 1,
      anon_sym_await,
    ACTIONS(937), 1,
      anon_sym_func,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(671), 1,
      sym__primary_expression,
    STATE(1220), 1,
      sym__attribute_expression,
    STATE(1333), 1,
      sym__expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    STATE(1423), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1330), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14581] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1233), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14666] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(935), 1,
      anon_sym_await,
    ACTIONS(937), 1,
      anon_sym_func,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(671), 1,
      sym__primary_expression,
    STATE(1220), 1,
      sym__attribute_expression,
    STATE(1333), 1,
      sym__expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    STATE(1396), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1330), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14751] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(607), 1,
      anon_sym_func,
    STATE(229), 1,
      sym__primary_expression,
    STATE(863), 1,
      sym__expression,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    STATE(1035), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(793), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14836] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(971), 1,
      anon_sym_RBRACE,
    ACTIONS(973), 1,
      sym_pattern_open_ending,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1136), 1,
      sym_pattern_pair,
    STATE(1178), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14923] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1176), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15008] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(835), 1,
      anon_sym_func,
    ACTIONS(837), 1,
      sym__string_start,
    STATE(514), 1,
      sym__primary_expression,
    STATE(996), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    STATE(1222), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15093] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(975), 1,
      anon_sym_RBRACE,
    ACTIONS(977), 1,
      sym_pattern_open_ending,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1140), 1,
      sym_pattern_pair,
    STATE(1178), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15180] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(979), 1,
      sym_pattern_open_ending,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1178), 1,
      sym__expression,
    STATE(1203), 1,
      sym_pattern_pair,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15264] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_await,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(667), 1,
      sym__primary_expression,
    STATE(1237), 1,
      sym__expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1244), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15342] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(805), 1,
      sym__string_start,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1042), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15420] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1183), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15498] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_await,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(667), 1,
      sym__primary_expression,
    STATE(1305), 1,
      sym__expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1244), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15576] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1342), 1,
      sym__expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15654] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(229), 1,
      sym__primary_expression,
    STATE(791), 1,
      sym__expression,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(793), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15732] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_await,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(667), 1,
      sym__primary_expression,
    STATE(1273), 1,
      sym__expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1244), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15810] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_await,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(667), 1,
      sym__primary_expression,
    STATE(1308), 1,
      sym__expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1244), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15888] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1174), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15966] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1272), 1,
      sym__expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16044] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1307), 1,
      sym__expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16122] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1311), 1,
      sym__expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16200] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1264), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16278] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1230), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16356] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1349), 1,
      sym__expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16434] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_await,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(667), 1,
      sym__primary_expression,
    STATE(1239), 1,
      sym__expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1244), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16512] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1236), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16590] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1248), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16668] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1074), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16746] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(801), 1,
      anon_sym_await,
    ACTIONS(805), 1,
      sym__string_start,
    STATE(552), 1,
      sym__primary_expression,
    STATE(1050), 1,
      sym__expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1053), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16824] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1245), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16902] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1350), 1,
      sym__expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16980] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1242), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17058] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(961), 1,
      anon_sym_await,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(575), 1,
      sym__primary_expression,
    STATE(966), 1,
      sym__expression,
    STATE(1344), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(971), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17136] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(935), 1,
      anon_sym_await,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(671), 1,
      sym__primary_expression,
    STATE(1220), 1,
      sym__attribute_expression,
    STATE(1335), 1,
      sym__expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1330), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17214] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_await,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(667), 1,
      sym__primary_expression,
    STATE(1201), 1,
      sym__expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1244), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17292] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(961), 1,
      anon_sym_await,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(575), 1,
      sym__primary_expression,
    STATE(1019), 1,
      sym__expression,
    STATE(1344), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(971), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17370] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1229), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17448] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1279), 1,
      sym__expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17526] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(935), 1,
      anon_sym_await,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(671), 1,
      sym__primary_expression,
    STATE(1220), 1,
      sym__attribute_expression,
    STATE(1351), 1,
      sym__expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1330), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17604] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1200), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17682] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1186), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17760] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(837), 1,
      sym__string_start,
    STATE(514), 1,
      sym__primary_expression,
    STATE(994), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17838] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(229), 1,
      sym__primary_expression,
    STATE(794), 1,
      sym__expression,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(793), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17916] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(833), 1,
      anon_sym_await,
    ACTIONS(837), 1,
      sym__string_start,
    STATE(514), 1,
      sym__primary_expression,
    STATE(987), 1,
      sym__expression,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(997), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17994] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_await,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(667), 1,
      sym__primary_expression,
    STATE(1243), 1,
      sym__expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1244), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18072] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1162), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18150] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1185), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18228] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_await,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(667), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1244), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18306] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      anon_sym_await,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(667), 1,
      sym__primary_expression,
    STATE(1177), 1,
      sym__expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1244), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18384] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(663), 1,
      anon_sym_await,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(538), 1,
      sym__primary_expression,
    STATE(1101), 1,
      sym__expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1109), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18462] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(1005), 1,
      anon_sym_EQ,
    ACTIONS(1007), 1,
      sym__indent,
    STATE(652), 1,
      sym_string_name,
    STATE(758), 1,
      sym_attribute,
    STATE(781), 1,
      sym__primary_expression,
    STATE(862), 1,
      sym_type,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(757), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18542] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(1005), 1,
      anon_sym_EQ,
    STATE(652), 1,
      sym_string_name,
    STATE(765), 1,
      sym_attribute,
    STATE(782), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1368), 1,
      sym_type,
    STATE(760), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18619] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 5,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(560), 29,
      sym_static_keyword,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_func,
  [18661] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(652), 1,
      sym_string_name,
    STATE(765), 1,
      sym_attribute,
    STATE(782), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1428), 1,
      sym_type,
    STATE(760), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18735] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(652), 1,
      sym_string_name,
    STATE(765), 1,
      sym_attribute,
    STATE(782), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1426), 1,
      sym_type,
    STATE(760), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18809] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(652), 1,
      sym_string_name,
    STATE(765), 1,
      sym_attribute,
    STATE(782), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1431), 1,
      sym_type,
    STATE(760), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18883] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(652), 1,
      sym_string_name,
    STATE(765), 1,
      sym_attribute,
    STATE(782), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1373), 1,
      sym_type,
    STATE(760), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18957] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    STATE(652), 1,
      sym_string_name,
    STATE(758), 1,
      sym_attribute,
    STATE(761), 1,
      sym_string,
    STATE(781), 1,
      sym__primary_expression,
    STATE(978), 1,
      sym_type,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(757), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 7,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19033] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(652), 1,
      sym_string_name,
    STATE(765), 1,
      sym_attribute,
    STATE(782), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1352), 1,
      sym_type,
    STATE(760), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19107] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(652), 1,
      sym_string_name,
    STATE(765), 1,
      sym_attribute,
    STATE(769), 1,
      sym_string,
    STATE(782), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1411), 1,
      sym_type,
    STATE(760), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 7,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19183] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(652), 1,
      sym_string_name,
    STATE(765), 1,
      sym_attribute,
    STATE(782), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1432), 1,
      sym_type,
    STATE(760), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19257] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(811), 1,
      sym__identifier,
    STATE(652), 1,
      sym_string_name,
    STATE(762), 1,
      sym_attribute,
    STATE(784), 1,
      sym__primary_expression,
    STATE(1103), 1,
      sym_type,
    STATE(1256), 1,
      sym__attribute_expression,
    STATE(759), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19331] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(657), 1,
      anon_sym_not,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    STATE(652), 1,
      sym_string_name,
    STATE(765), 1,
      sym_attribute,
    STATE(782), 1,
      sym__primary_expression,
    STATE(1270), 1,
      sym__attribute_expression,
    STATE(1416), 1,
      sym_type,
    STATE(760), 2,
      sym_identifier,
      sym_subscript,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 8,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19405] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(1009), 1,
      sym_integer,
    STATE(652), 1,
      sym_string_name,
    STATE(768), 1,
      sym_attribute,
    STATE(783), 1,
      sym__primary_expression,
    STATE(1234), 1,
      sym__enumerator_expression,
    STATE(1344), 1,
      sym__attribute_expression,
    ACTIONS(643), 3,
      sym_true,
      sym_false,
      sym_null,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 4,
      sym_string,
      sym_dictionary,
      sym_array,
      sym_base_call,
    STATE(763), 6,
      sym_identifier,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_call,
  [19481] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(627), 1,
      sym__primary_expression,
    STATE(1329), 1,
      sym__attribute_expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19548] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(530), 1,
      sym__primary_expression,
    STATE(1346), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19615] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(1011), 1,
      anon_sym_not,
    STATE(215), 1,
      sym__primary_expression,
    STATE(1184), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19682] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(220), 1,
      sym__primary_expression,
    STATE(1184), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19749] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(576), 1,
      sym__primary_expression,
    STATE(1346), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19816] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(614), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19883] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(521), 1,
      sym__primary_expression,
    STATE(1346), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19950] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(221), 1,
      sym__primary_expression,
    STATE(1184), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20017] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(512), 1,
      sym__primary_expression,
    STATE(1346), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20084] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    ACTIONS(1013), 1,
      anon_sym_not,
    STATE(635), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20151] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(636), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20218] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(224), 1,
      sym__primary_expression,
    STATE(1184), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20285] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(638), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20352] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(642), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20419] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(644), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20486] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(645), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20553] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(648), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20620] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(753), 1,
      sym__primary_expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20687] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(655), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20754] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(965), 1,
      sym__string_start,
    ACTIONS(1015), 1,
      anon_sym_not,
    STATE(511), 1,
      sym__primary_expression,
    STATE(1346), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20821] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(698), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20888] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(225), 1,
      sym__primary_expression,
    STATE(1184), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20955] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(226), 1,
      sym__primary_expression,
    STATE(1184), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21022] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(228), 1,
      sym__primary_expression,
    STATE(1184), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21089] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(236), 1,
      sym__primary_expression,
    STATE(1216), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21156] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    ACTIONS(1013), 1,
      anon_sym_not,
    STATE(623), 1,
      sym__primary_expression,
    STATE(1345), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21223] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(218), 1,
      sym__primary_expression,
    STATE(1184), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21290] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(527), 1,
      sym__primary_expression,
    STATE(1346), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21357] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(778), 1,
      sym__primary_expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21424] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(939), 1,
      sym__string_start,
    STATE(631), 1,
      sym__primary_expression,
    STATE(1329), 1,
      sym__attribute_expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21491] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(955), 1,
      anon_sym_not,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(965), 1,
      sym__string_start,
    STATE(528), 1,
      sym__primary_expression,
    STATE(1346), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21558] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(777), 1,
      sym__primary_expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21625] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(774), 1,
      sym__primary_expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21692] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(770), 1,
      sym__primary_expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21759] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(805), 1,
      sym__string_start,
    ACTIONS(1017), 1,
      anon_sym_not,
    STATE(534), 1,
      sym__primary_expression,
    STATE(1320), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21826] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(775), 1,
      sym__primary_expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21893] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(773), 1,
      sym__primary_expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21960] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(981), 1,
      sym__identifier,
    ACTIONS(987), 1,
      anon_sym_AMP,
    ACTIONS(989), 1,
      anon_sym_LBRACE,
    ACTIONS(991), 1,
      anon_sym_LBRACK,
    ACTIONS(995), 1,
      anon_sym_not,
    ACTIONS(997), 1,
      anon_sym_DOT,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      sym__string_start,
    STATE(767), 1,
      sym__primary_expression,
    STATE(1337), 1,
      sym__attribute_expression,
    STATE(743), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(985), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(983), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(993), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(747), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22027] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(811), 1,
      sym__identifier,
    ACTIONS(817), 1,
      anon_sym_AMP,
    ACTIONS(819), 1,
      anon_sym_LBRACE,
    ACTIONS(821), 1,
      anon_sym_LBRACK,
    ACTIONS(825), 1,
      anon_sym_not,
    ACTIONS(827), 1,
      anon_sym_DOT,
    ACTIONS(829), 1,
      anon_sym_LPAREN,
    ACTIONS(837), 1,
      sym__string_start,
    STATE(563), 1,
      sym__primary_expression,
    STATE(1343), 1,
      sym__attribute_expression,
    STATE(605), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(815), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(813), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(823), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(607), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22094] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(55), 1,
      anon_sym_LBRACE,
    ACTIONS(59), 1,
      anon_sym_LBRACK,
    ACTIONS(63), 1,
      anon_sym_not,
    ACTIONS(65), 1,
      anon_sym_DOT,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(227), 1,
      sym__primary_expression,
    STATE(1184), 1,
      sym__attribute_expression,
    STATE(234), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(61), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(257), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22161] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(805), 1,
      sym__string_start,
    STATE(550), 1,
      sym__primary_expression,
    STATE(1320), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22228] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(805), 1,
      sym__string_start,
    STATE(520), 1,
      sym__primary_expression,
    STATE(1320), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22295] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(915), 1,
      sym__identifier,
    ACTIONS(921), 1,
      anon_sym_AMP,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(931), 1,
      anon_sym_DOT,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    ACTIONS(939), 1,
      sym__string_start,
    ACTIONS(1019), 1,
      anon_sym_not,
    STATE(617), 1,
      sym__primary_expression,
    STATE(1329), 1,
      sym__attribute_expression,
    STATE(731), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(919), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(917), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(728), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22362] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(805), 1,
      sym__string_start,
    STATE(680), 1,
      sym__primary_expression,
    STATE(1173), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22429] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(941), 1,
      sym__identifier,
    ACTIONS(947), 1,
      anon_sym_AMP,
    ACTIONS(949), 1,
      anon_sym_LBRACE,
    ACTIONS(951), 1,
      anon_sym_LBRACK,
    ACTIONS(957), 1,
      anon_sym_DOT,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    ACTIONS(965), 1,
      sym__string_start,
    ACTIONS(1015), 1,
      anon_sym_not,
    STATE(508), 1,
      sym__primary_expression,
    STATE(1346), 1,
      sym__attribute_expression,
    STATE(597), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(945), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(943), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(953), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(599), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22496] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(641), 1,
      sym__identifier,
    ACTIONS(647), 1,
      anon_sym_AMP,
    ACTIONS(649), 1,
      anon_sym_LBRACE,
    ACTIONS(653), 1,
      anon_sym_LBRACK,
    ACTIONS(659), 1,
      anon_sym_DOT,
    ACTIONS(661), 1,
      anon_sym_LPAREN,
    ACTIONS(667), 1,
      sym__string_start,
    ACTIONS(1021), 1,
      anon_sym_not,
    STATE(536), 1,
      sym__primary_expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(652), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(645), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(643), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(655), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(651), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22563] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(805), 1,
      sym__string_start,
    STATE(519), 1,
      sym__primary_expression,
    STATE(1320), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22630] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(779), 1,
      sym__identifier,
    ACTIONS(785), 1,
      anon_sym_AMP,
    ACTIONS(787), 1,
      anon_sym_LBRACE,
    ACTIONS(789), 1,
      anon_sym_LBRACK,
    ACTIONS(795), 1,
      anon_sym_not,
    ACTIONS(797), 1,
      anon_sym_DOT,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    ACTIONS(805), 1,
      sym__string_start,
    STATE(518), 1,
      sym__primary_expression,
    STATE(1320), 1,
      sym__attribute_expression,
    STATE(643), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(783), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(781), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(793), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(640), 10,
  