/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.reader.trex.ng;

import com.sun.msv.datatype.ErrorDatatypeLibrary;
import com.sun.msv.datatype.xsd.StringType;
import com.sun.msv.datatype.xsd.ngimpl.DataTypeLibraryImpl;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.relaxng.datatype.BuiltinDatatypeLibrary;
import com.sun.msv.grammar.relaxng.datatype.CompatibilityDatatypeLibrary;
import com.sun.msv.grammar.trex.TREXGrammar;
import com.sun.msv.reader.ChoiceState;
import com.sun.msv.reader.GrammarReader;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.State;
import com.sun.msv.reader.TerminalState;
import com.sun.msv.reader.trex.DivInGrammarState;
import com.sun.msv.reader.trex.IncludePatternState;
import com.sun.msv.reader.trex.NameClassChoiceState;
import com.sun.msv.reader.trex.RootState;
import com.sun.msv.reader.trex.TREXBaseReader;
import com.sun.msv.reader.trex.TREXSequencedStringChecker;
import com.sun.msv.reader.trex.ng.AttributeState;
import com.sun.msv.reader.trex.ng.DataParamState;
import com.sun.msv.reader.trex.ng.DataState;
import com.sun.msv.reader.trex.ng.DefineState;
import com.sun.msv.reader.trex.ng.ElementState;
import com.sun.msv.reader.trex.ng.GrammarState;
import com.sun.msv.reader.trex.ng.IncludeMergeState;
import com.sun.msv.reader.trex.ng.ListState;
import com.sun.msv.reader.trex.ng.NGNameState;
import com.sun.msv.reader.trex.ng.RefState;
import com.sun.msv.reader.trex.ng.RestrictionChecker;
import com.sun.msv.reader.trex.ng.StartState;
import com.sun.msv.reader.trex.ng.ValueState;
import com.sun.msv.util.LightStack;
import com.sun.msv.util.StartTagInfo;
import com.sun.msv.util.Util;
import com.sun.msv.verifier.jarv.RELAXNGFactoryImpl;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.iso_relax.verifier.Schema;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.DatatypeLibrary;
import org.relaxng.datatype.DatatypeLibraryFactory;
import org.relaxng.datatype.helpers.DatatypeLibraryLoader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class RELAXNGReader
extends TREXBaseReader {
    protected static Schema relaxNGSchema4Schema = null;
    private final Map refExpParseInfos = new HashMap();
    protected RefExpParseInfo currentNamedPattern = null;
    protected boolean directRefernce = true;
    public static final String RELAXNGNamespace = "http://relaxng.org/ns/structure/1.0";
    protected final RestrictionChecker restrictionChecker = new RestrictionChecker(this);
    private DatatypeLibrary datatypeLib = BuiltinDatatypeLibrary.theInstance;
    protected String datatypeLibURI = "";
    private final LightStack dtLibStack = new LightStack();
    private final LightStack dtLibURIStack = new LightStack();
    public static final String ERR_BAD_FACET = "RELAXNGReader.BadFacet";
    public static final String ERR_INVALID_PARAMETERS = "RELAXNGReader.InvalidParameters";
    public static final String ERR_BAD_DATA_VALUE = "RELAXNGReader.BadDataValue";
    public static final String ERR_UNDEFINED_KEY = "RELAXNGReader.UndefinedKey";
    public static final String ERR_UNDEFINED_DATATYPE_1 = "RELAXNGReader.UndefinedDataType1";
    public static final String ERR_INCONSISTENT_KEY_TYPE = "RELAXNGReader.InconsistentKeyType";
    public static final String ERR_INCONSISTENT_COMBINE = "RELAXNGReader.InconsistentCombine";
    public static final String ERR_REDEFINING_UNDEFINED = "RELAXNGReader.RedefiningUndefined";
    public static final String ERR_UNKNOWN_DATATYPE_VOCABULARY_1 = "RELAXNGReader.UnknownDatatypeVocabulary1";
    public static final String ERR_MULTIPLE_EXCEPT = "RELAXNGReader.MultipleExcept";
    public static final String ERR_NOT_ABSOLUTE_URI = "RELAXNGReader.NotAbsoluteURI";
    public static final String ERR_INFOSET_URI_ATTRIBUTE = "RELAXNGReader.InfosetUriAttribute";
    public static final String ERR_XMLNS_ATTRIBUTE = "RELAXNGReader.XmlnsAttribute";
    public static final String ERR_NAKED_INFINITE_ATTRIBUTE_NAMECLASS = "RELAXNGReader.NakedInfiniteAttributeNameClass";
    static /* synthetic */ Class class$com$sun$msv$reader$trex$ng$RELAXNGReader;

    public static TREXGrammar parse(String string, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController) {
        RELAXNGReader rELAXNGReader = new RELAXNGReader(grammarReaderController, sAXParserFactory);
        rELAXNGReader.parse(string);
        return rELAXNGReader.getResult();
    }

    public static TREXGrammar parse(InputSource inputSource, SAXParserFactory sAXParserFactory, GrammarReaderController grammarReaderController) {
        RELAXNGReader rELAXNGReader = new RELAXNGReader(grammarReaderController, sAXParserFactory);
        rELAXNGReader.parse(inputSource);
        return rELAXNGReader.getResult();
    }

    public RELAXNGReader(GrammarReaderController grammarReaderController) {
        this(grammarReaderController, GrammarReader.createParserFactory());
    }

    public RELAXNGReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory) {
        this(grammarReaderController, sAXParserFactory, new StateFactory(), new ExpressionPool());
    }

    public RELAXNGReader(GrammarReaderController grammarReaderController, SAXParserFactory sAXParserFactory, StateFactory stateFactory, ExpressionPool expressionPool) {
        super(grammarReaderController, sAXParserFactory, expressionPool, stateFactory, new RootState());
    }

    public static Schema getRELAXNGSchema4Schema() {
        if (relaxNGSchema4Schema == null) {
            try {
                relaxNGSchema4Schema = new RELAXNGFactoryImpl().compileSchema((class$com$sun$msv$reader$trex$ng$RELAXNGReader == null ? (class$com$sun$msv$reader$trex$ng$RELAXNGReader = RELAXNGReader.class$("com.sun.msv.reader.trex.ng.RELAXNGReader")) : class$com$sun$msv$reader$trex$ng$RELAXNGReader).getResourceAsStream("relaxng.rng"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new Error("unable to load schema-for-schema for RELAX NG");
            }
        }
        return relaxNGSchema4Schema;
    }

    protected String localizeMessage(String string, Object[] objectArray) {
        String string2;
        try {
            string2 = ResourceBundle.getBundle("com.sun.msv.reader.trex.ng.Messages").getString(string);
        }
        catch (Exception exception) {
            return super.localizeMessage(string, objectArray);
        }
        return MessageFormat.format(string2, objectArray);
    }

    protected TREXGrammar getGrammar() {
        return this.grammar;
    }

    protected RefExpParseInfo getRefExpParseInfo(ReferenceExp referenceExp) {
        RefExpParseInfo refExpParseInfo = (RefExpParseInfo)this.refExpParseInfos.get(referenceExp);
        if (refExpParseInfo == null) {
            refExpParseInfo = new RefExpParseInfo();
            this.refExpParseInfos.put(referenceExp, refExpParseInfo);
        }
        return refExpParseInfo;
    }

    protected boolean isGrammarElement(StartTagInfo startTagInfo) {
        return RELAXNGNamespace.equals(startTagInfo.namespaceURI) || "http://relaxng.org/ns/structure/0.9".equals(startTagInfo.namespaceURI);
    }

    protected StateFactory getStateFactory() {
        return (StateFactory)this.sfactory;
    }

    protected State createNameClassChildState(State state, StartTagInfo startTagInfo) {
        if (startTagInfo.localName.equals("name")) {
            return this.sfactory.nsName(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("anyName")) {
            return this.sfactory.nsAnyName(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("nsName")) {
            return this.sfactory.nsNsName(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("choice")) {
            return this.sfactory.nsChoice(state, startTagInfo);
        }
        return null;
    }

    public State createExpressionChildState(State state, StartTagInfo startTagInfo) {
        if (startTagInfo.localName.equals("text")) {
            return this.getStateFactory().text(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("data")) {
            return this.getStateFactory().data(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("value")) {
            return this.getStateFactory().value(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("list")) {
            return this.getStateFactory().list(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("externalRef")) {
            return this.getStateFactory().externalRef(state, startTagInfo);
        }
        if (startTagInfo.localName.equals("parentRef")) {
            return this.getStateFactory().parentRef(state, startTagInfo);
        }
        return super.createExpressionChildState(state, startTagInfo);
    }

    public Datatype resolveDataType(String string) {
        try {
            return this.getCurrentDatatypeLibrary().createDatatype(string);
        }
        catch (DatatypeException datatypeException) {
            this.reportError(ERR_UNDEFINED_DATATYPE_1, (Object)string, (Object)datatypeException.getMessage());
            return StringType.theInstance;
        }
    }

    public DatatypeLibrary resolveDataTypeLibrary(String string) {
        try {
            DatatypeLibrary datatypeLibrary = this.getStateFactory().getDatatypeLibrary(string);
            if (datatypeLibrary != null) {
                return datatypeLibrary;
            }
            this.reportError("TREXGrammarReader.UnknownDataTypeVocabulary", (Object)string);
        }
        catch (Throwable throwable) {
            this.reportError(ERR_UNKNOWN_DATATYPE_VOCABULARY_1, (Object)string, (Object)throwable.toString());
        }
        return ErrorDatatypeLibrary.theInstance;
    }

    private void checkRunawayExpression(ReferenceExp referenceExp, Stack stack, Set set) throws AbortException {
        Serializable serializable;
        if (!set.add(referenceExp)) {
            return;
        }
        stack.push(referenceExp);
        Iterator iterator = ((AbstractList)this.getRefExpParseInfo((ReferenceExp)referenceExp).directRefs).iterator();
        while (iterator.hasNext()) {
            serializable = (ReferenceExp)iterator.next();
            int n = stack.lastIndexOf(serializable);
            if (n != -1) {
                String string = "";
                Vector<Locator> vector = new Vector<Locator>();
                while (n < stack.size()) {
                    ReferenceExp referenceExp2 = (ReferenceExp)stack.get(n);
                    if (referenceExp2.name != null) {
                        if (string.length() != 0) {
                            string = string + " > ";
                        }
                        string = string + referenceExp2.name;
                        Locator locator = this.getDeclaredLocationOf(referenceExp2);
                        if (locator != null) {
                            vector.add(locator);
                        }
                    }
                    ++n;
                }
                string = string + " > " + ((ReferenceExp)serializable).name;
                this.reportError(vector.toArray(new Locator[vector.size()]), "GrammarReader.Abstract.RunAwayExpression", new Object[]{string});
                throw new AbortException();
            }
            this.checkRunawayExpression((ReferenceExp)serializable, stack, set);
        }
        serializable = new Stack();
        iterator = ((AbstractList)this.getRefExpParseInfo((ReferenceExp)referenceExp).indirectRefs).iterator();
        while (iterator.hasNext()) {
            this.checkRunawayExpression((ReferenceExp)iterator.next(), (Stack)serializable, set);
        }
        stack.pop();
    }

    public void wrapUp() {
        try {
            this.checkRunawayExpression(this.grammar, new Stack(), new HashSet());
        }
        catch (AbortException abortException) {
            // empty catch block
        }
        if (!this.hadError) {
            this.grammar.visit(new TREXSequencedStringChecker(this, true));
        }
        if (!this.hadError) {
            this.restrictionChecker.check();
        }
    }

    public DatatypeLibrary getCurrentDatatypeLibrary() {
        if (this.datatypeLib == null) {
            this.datatypeLib = this.resolveDataTypeLibrary(this.datatypeLibURI);
            if (this.datatypeLib == null) {
                throw new Error();
            }
        }
        return this.datatypeLib;
    }

    public String resolveNamespacePrefix(String string) {
        if (string.equals("")) {
            return this.targetNamespace;
        }
        return super.resolveNamespacePrefix(string);
    }

    public void startDocument() throws SAXException {
        this.dtLibStack.push(this.datatypeLib);
        this.dtLibURIStack.push(this.datatypeLibURI);
        this.datatypeLib = BuiltinDatatypeLibrary.theInstance;
        this.datatypeLibURI = "";
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.datatypeLib = (DatatypeLibrary)this.dtLibStack.pop();
        this.datatypeLibURI = (String)this.dtLibURIStack.pop();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4;
        this.dtLibStack.push(this.datatypeLib);
        this.dtLibURIStack.push(this.datatypeLibURI);
        if (attributes.getIndex("datatypeLibrary") != -1) {
            this.datatypeLibURI = attributes.getValue("datatypeLibrary");
            this.datatypeLib = null;
            if (!Util.isAbsoluteURI(this.datatypeLibURI)) {
                this.reportError(ERR_NOT_ABSOLUTE_URI, (Object)this.datatypeLibURI);
            }
            if (this.datatypeLibURI.indexOf(35) >= 0) {
                this.reportError("GrammarReader.FragmentIdentifier", (Object)this.datatypeLibURI);
            }
        }
        if (attributes.getIndex("ns") != -1 && !Util.isAbsoluteURI(string4 = attributes.getValue("ns"))) {
            this.reportError(ERR_NOT_ABSOLUTE_URI, (Object)string4);
        }
        super.startElement(string, string2, string3, attributes);
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        super.endElement(string, string2, string3);
        this.datatypeLib = (DatatypeLibrary)this.dtLibStack.pop();
        this.datatypeLibURI = (String)this.dtLibURIStack.pop();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AbortException
    extends Exception {
        private AbortException() {
        }
    }

    public static class StateFactory
    extends TREXBaseReader.StateFactory {
        private DatatypeLibraryFactory loader;
        private DatatypeLibrary xsdlib;
        private DatatypeLibrary compatibilityLib;

        public State nsAnyName(State state, StartTagInfo startTagInfo) {
            return new NGNameState.AnyNameState();
        }

        public State nsNsName(State state, StartTagInfo startTagInfo) {
            return new NGNameState.NsNameState();
        }

        public State nsExcept(State state, StartTagInfo startTagInfo) {
            return new NameClassChoiceState();
        }

        public State text(State state, StartTagInfo startTagInfo) {
            return new TerminalState(Expression.anyString);
        }

        public State data(State state, StartTagInfo startTagInfo) {
            return new DataState();
        }

        public State dataParam(State state, StartTagInfo startTagInfo) {
            return new DataParamState();
        }

        public State value(State state, StartTagInfo startTagInfo) {
            return new ValueState();
        }

        public State list(State state, StartTagInfo startTagInfo) {
            return new ListState();
        }

        public State define(State state, StartTagInfo startTagInfo) {
            return new DefineState();
        }

        public State start(State state, StartTagInfo startTagInfo) {
            return new StartState();
        }

        public State redefine(State state, StartTagInfo startTagInfo) {
            return new DefineState();
        }

        public State includeGrammar(State state, StartTagInfo startTagInfo) {
            return new IncludeMergeState();
        }

        public State externalRef(State state, StartTagInfo startTagInfo) {
            return new IncludePatternState();
        }

        public State divInGrammar(State state, StartTagInfo startTagInfo) {
            return new DivInGrammarState();
        }

        public State dataExcept(State state, StartTagInfo startTagInfo) {
            return new ChoiceState();
        }

        public State attribute(State state, StartTagInfo startTagInfo) {
            return new AttributeState();
        }

        public State element(State state, StartTagInfo startTagInfo) {
            return new ElementState();
        }

        public State grammar(State state, StartTagInfo startTagInfo) {
            return new GrammarState();
        }

        public State ref(State state, StartTagInfo startTagInfo) {
            return new RefState(false);
        }

        public State parentRef(State state, StartTagInfo startTagInfo) {
            return new RefState(true);
        }

        public DatatypeLibrary getDatatypeLibrary(String string) throws Exception {
            if (string.equals("")) {
                return BuiltinDatatypeLibrary.theInstance;
            }
            if (string.equals("http://www.w3.org/2001/XMLSchema-datatypes") || string.equals("http://www.w3.org/2001/XMLSchema")) {
                if (this.xsdlib == null) {
                    this.xsdlib = new DataTypeLibraryImpl();
                }
                return this.xsdlib;
            }
            if (string.equals("http://relaxng.org/ns/compatibility/datatypes/1.0")) {
                if (this.compatibilityLib == null) {
                    this.compatibilityLib = new CompatibilityDatatypeLibrary();
                }
                return this.compatibilityLib;
            }
            if (this.loader == null) {
                this.loader = new DatatypeLibraryLoader();
            }
            return this.loader.createDatatypeLibrary(string);
        }
    }

    protected static class RefExpParseInfo {
        public boolean haveHead = false;
        public String combineMethod = null;
        public static RedefinitionStatus notBeingRedefined = new RedefinitionStatus();
        public static RedefinitionStatus originalNotFoundYet = new RedefinitionStatus();
        public static RedefinitionStatus originalFound = new RedefinitionStatus();
        public RedefinitionStatus redefinition = notBeingRedefined;
        public final Vector directRefs = new Vector();
        public final Vector indirectRefs = new Vector();

        protected RefExpParseInfo() {
        }

        public void set(RefExpParseInfo refExpParseInfo) {
            this.haveHead = refExpParseInfo.haveHead;
            this.combineMethod = refExpParseInfo.combineMethod;
            this.redefinition = refExpParseInfo.redefinition;
        }

        public static class RedefinitionStatus {
        }
    }
}

