// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudWebhookCreateWebhookRequestBody hashicorp cloud webhook create webhook request body
//
// swagger:model hashicorp.cloud.webhook.CreateWebhookRequestBody
type HashicorpCloudWebhookCreateWebhookRequestBody struct {

	// The required information for delivering event payloads.
	Config *HashicorpCloudWebhookWebhookConfig `json:"config,omitempty"`

	// The webhook description. Useful for providing a summary of the webhook.
	Description string `json:"description,omitempty"`

	// When set to 'true', a verification request will be sent and the webhook created enabled and only if the verification succeeds.
	// When set to 'false', the webhook configuration won't be verified and the webhook created disabled.
	// When left unset, a verification request will be sent and the webhook will be created enabled if it succeeds,
	// or disabled if it fails.
	Enabled *bool `json:"enabled,omitempty"`

	// The webhook name.
	Name string `json:"name,omitempty"`

	// The resource lifecycle events that this webhook is subscribed to.
	Subscriptions []*HashicorpCloudWebhookWebhookSubscription `json:"subscriptions"`

	// The optional payload used to deliver a test request to validate the webhook configuration.
	// If not set, the webhook service delivers a generic payload.
	TestPayload *HashicorpCloudWebhookWebhookPayload `json:"test_payload,omitempty"`
}

// Validate validates this hashicorp cloud webhook create webhook request body
func (m *HashicorpCloudWebhookCreateWebhookRequestBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateConfig(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSubscriptions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTestPayload(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookCreateWebhookRequestBody) validateConfig(formats strfmt.Registry) error {
	if swag.IsZero(m.Config) { // not required
		return nil
	}

	if m.Config != nil {
		if err := m.Config.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWebhookCreateWebhookRequestBody) validateSubscriptions(formats strfmt.Registry) error {
	if swag.IsZero(m.Subscriptions) { // not required
		return nil
	}

	for i := 0; i < len(m.Subscriptions); i++ {
		if swag.IsZero(m.Subscriptions[i]) { // not required
			continue
		}

		if m.Subscriptions[i] != nil {
			if err := m.Subscriptions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subscriptions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("subscriptions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWebhookCreateWebhookRequestBody) validateTestPayload(formats strfmt.Registry) error {
	if swag.IsZero(m.TestPayload) { // not required
		return nil
	}

	if m.TestPayload != nil {
		if err := m.TestPayload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("test_payload")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("test_payload")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud webhook create webhook request body based on the context it is used
func (m *HashicorpCloudWebhookCreateWebhookRequestBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateConfig(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSubscriptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTestPayload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookCreateWebhookRequestBody) contextValidateConfig(ctx context.Context, formats strfmt.Registry) error {

	if m.Config != nil {

		if swag.IsZero(m.Config) { // not required
			return nil
		}

		if err := m.Config.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("config")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("config")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWebhookCreateWebhookRequestBody) contextValidateSubscriptions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Subscriptions); i++ {

		if m.Subscriptions[i] != nil {

			if swag.IsZero(m.Subscriptions[i]) { // not required
				return nil
			}

			if err := m.Subscriptions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("subscriptions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("subscriptions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWebhookCreateWebhookRequestBody) contextValidateTestPayload(ctx context.Context, formats strfmt.Registry) error {

	if m.TestPayload != nil {

		if swag.IsZero(m.TestPayload) { // not required
			return nil
		}

		if err := m.TestPayload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("test_payload")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("test_payload")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWebhookCreateWebhookRequestBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWebhookCreateWebhookRequestBody) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWebhookCreateWebhookRequestBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
