// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceUIGetActionConfigBundleReader is a Reader for the WaypointServiceUIGetActionConfigBundle structure.
type WaypointServiceUIGetActionConfigBundleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUIGetActionConfigBundleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUIGetActionConfigBundleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUIGetActionConfigBundleDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUIGetActionConfigBundleOK creates a WaypointServiceUIGetActionConfigBundleOK with default headers values
func NewWaypointServiceUIGetActionConfigBundleOK() *WaypointServiceUIGetActionConfigBundleOK {
	return &WaypointServiceUIGetActionConfigBundleOK{}
}

/*
WaypointServiceUIGetActionConfigBundleOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUIGetActionConfigBundleOK struct {
	Payload *models.HashicorpCloudWaypointUIGetActionConfigResponse
}

// IsSuccess returns true when this waypoint service Ui get action config bundle o k response has a 2xx status code
func (o *WaypointServiceUIGetActionConfigBundleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service Ui get action config bundle o k response has a 3xx status code
func (o *WaypointServiceUIGetActionConfigBundleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service Ui get action config bundle o k response has a 4xx status code
func (o *WaypointServiceUIGetActionConfigBundleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service Ui get action config bundle o k response has a 5xx status code
func (o *WaypointServiceUIGetActionConfigBundleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service Ui get action config bundle o k response a status code equal to that given
func (o *WaypointServiceUIGetActionConfigBundleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service Ui get action config bundle o k response
func (o *WaypointServiceUIGetActionConfigBundleOK) Code() int {
	return 200
}

func (o *WaypointServiceUIGetActionConfigBundleOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfig/{action_id}][%d] waypointServiceUiGetActionConfigBundleOK %s", 200, payload)
}

func (o *WaypointServiceUIGetActionConfigBundleOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfig/{action_id}][%d] waypointServiceUiGetActionConfigBundleOK %s", 200, payload)
}

func (o *WaypointServiceUIGetActionConfigBundleOK) GetPayload() *models.HashicorpCloudWaypointUIGetActionConfigResponse {
	return o.Payload
}

func (o *WaypointServiceUIGetActionConfigBundleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUIGetActionConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUIGetActionConfigBundleDefault creates a WaypointServiceUIGetActionConfigBundleDefault with default headers values
func NewWaypointServiceUIGetActionConfigBundleDefault(code int) *WaypointServiceUIGetActionConfigBundleDefault {
	return &WaypointServiceUIGetActionConfigBundleDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUIGetActionConfigBundleDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUIGetActionConfigBundleDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service UI get action config bundle default response has a 2xx status code
func (o *WaypointServiceUIGetActionConfigBundleDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service UI get action config bundle default response has a 3xx status code
func (o *WaypointServiceUIGetActionConfigBundleDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service UI get action config bundle default response has a 4xx status code
func (o *WaypointServiceUIGetActionConfigBundleDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service UI get action config bundle default response has a 5xx status code
func (o *WaypointServiceUIGetActionConfigBundleDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service UI get action config bundle default response a status code equal to that given
func (o *WaypointServiceUIGetActionConfigBundleDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service UI get action config bundle default response
func (o *WaypointServiceUIGetActionConfigBundleDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUIGetActionConfigBundleDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfig/{action_id}][%d] WaypointService_UI_GetActionConfigBundle default %s", o._statusCode, payload)
}

func (o *WaypointServiceUIGetActionConfigBundleDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/ui/actionconfig/{action_id}][%d] WaypointService_UI_GetActionConfigBundle default %s", o._statusCode, payload)
}

func (o *WaypointServiceUIGetActionConfigBundleDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUIGetActionConfigBundleDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
