// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceGetApplicationReader is a Reader for the WaypointServiceGetApplication structure.
type WaypointServiceGetApplicationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceGetApplicationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceGetApplicationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceGetApplicationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceGetApplicationOK creates a WaypointServiceGetApplicationOK with default headers values
func NewWaypointServiceGetApplicationOK() *WaypointServiceGetApplicationOK {
	return &WaypointServiceGetApplicationOK{}
}

/*
WaypointServiceGetApplicationOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceGetApplicationOK struct {
	Payload *models.HashicorpCloudWaypointGetApplicationResponse
}

// IsSuccess returns true when this waypoint service get application o k response has a 2xx status code
func (o *WaypointServiceGetApplicationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service get application o k response has a 3xx status code
func (o *WaypointServiceGetApplicationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service get application o k response has a 4xx status code
func (o *WaypointServiceGetApplicationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service get application o k response has a 5xx status code
func (o *WaypointServiceGetApplicationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service get application o k response a status code equal to that given
func (o *WaypointServiceGetApplicationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service get application o k response
func (o *WaypointServiceGetApplicationOK) Code() int {
	return 200
}

func (o *WaypointServiceGetApplicationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/applications/{application.id}][%d] waypointServiceGetApplicationOK %s", 200, payload)
}

func (o *WaypointServiceGetApplicationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/applications/{application.id}][%d] waypointServiceGetApplicationOK %s", 200, payload)
}

func (o *WaypointServiceGetApplicationOK) GetPayload() *models.HashicorpCloudWaypointGetApplicationResponse {
	return o.Payload
}

func (o *WaypointServiceGetApplicationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointGetApplicationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceGetApplicationDefault creates a WaypointServiceGetApplicationDefault with default headers values
func NewWaypointServiceGetApplicationDefault(code int) *WaypointServiceGetApplicationDefault {
	return &WaypointServiceGetApplicationDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceGetApplicationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceGetApplicationDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service get application default response has a 2xx status code
func (o *WaypointServiceGetApplicationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service get application default response has a 3xx status code
func (o *WaypointServiceGetApplicationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service get application default response has a 4xx status code
func (o *WaypointServiceGetApplicationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service get application default response has a 5xx status code
func (o *WaypointServiceGetApplicationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service get application default response a status code equal to that given
func (o *WaypointServiceGetApplicationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service get application default response
func (o *WaypointServiceGetApplicationDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceGetApplicationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/applications/{application.id}][%d] WaypointService_GetApplication default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetApplicationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/applications/{application.id}][%d] WaypointService_GetApplication default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetApplicationDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceGetApplicationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
