// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceGetAddOnParams creates a new WaypointServiceGetAddOnParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceGetAddOnParams() *WaypointServiceGetAddOnParams {
	return &WaypointServiceGetAddOnParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceGetAddOnParamsWithTimeout creates a new WaypointServiceGetAddOnParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceGetAddOnParamsWithTimeout(timeout time.Duration) *WaypointServiceGetAddOnParams {
	return &WaypointServiceGetAddOnParams{
		timeout: timeout,
	}
}

// NewWaypointServiceGetAddOnParamsWithContext creates a new WaypointServiceGetAddOnParams object
// with the ability to set a context for a request.
func NewWaypointServiceGetAddOnParamsWithContext(ctx context.Context) *WaypointServiceGetAddOnParams {
	return &WaypointServiceGetAddOnParams{
		Context: ctx,
	}
}

// NewWaypointServiceGetAddOnParamsWithHTTPClient creates a new WaypointServiceGetAddOnParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceGetAddOnParamsWithHTTPClient(client *http.Client) *WaypointServiceGetAddOnParams {
	return &WaypointServiceGetAddOnParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceGetAddOnParams contains all the parameters to send to the API endpoint

	for the waypoint service get add on operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceGetAddOnParams struct {

	// AddOnID.
	AddOnID string

	// AddOnName.
	AddOnName *string

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service get add on params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetAddOnParams) WithDefaults() *WaypointServiceGetAddOnParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service get add on params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetAddOnParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithTimeout(timeout time.Duration) *WaypointServiceGetAddOnParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithContext(ctx context.Context) *WaypointServiceGetAddOnParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithHTTPClient(client *http.Client) *WaypointServiceGetAddOnParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddOnID adds the addOnID to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithAddOnID(addOnID string) *WaypointServiceGetAddOnParams {
	o.SetAddOnID(addOnID)
	return o
}

// SetAddOnID adds the addOnId to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetAddOnID(addOnID string) {
	o.AddOnID = addOnID
}

// WithAddOnName adds the addOnName to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithAddOnName(addOnName *string) *WaypointServiceGetAddOnParams {
	o.SetAddOnName(addOnName)
	return o
}

// SetAddOnName adds the addOnName to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetAddOnName(addOnName *string) {
	o.AddOnName = addOnName
}

// WithNamespaceID adds the namespaceID to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithNamespaceID(namespaceID string) *WaypointServiceGetAddOnParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceGetAddOnParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceGetAddOnParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceGetAddOnParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceGetAddOnParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get add on params
func (o *WaypointServiceGetAddOnParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceGetAddOnParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param add_on.id
	if err := r.SetPathParam("add_on.id", o.AddOnID); err != nil {
		return err
	}

	if o.AddOnName != nil {

		// query param add_on.name
		var qrAddOnName string

		if o.AddOnName != nil {
			qrAddOnName = *o.AddOnName
		}
		qAddOnName := qrAddOnName
		if qAddOnName != "" {

			if err := r.SetQueryParam("add_on.name", qAddOnName); err != nil {
				return err
			}
		}
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
