// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewDirectUploadBoxParams creates a new DirectUploadBoxParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDirectUploadBoxParams() *DirectUploadBoxParams {
	return &DirectUploadBoxParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDirectUploadBoxParamsWithTimeout creates a new DirectUploadBoxParams object
// with the ability to set a timeout on a request.
func NewDirectUploadBoxParamsWithTimeout(timeout time.Duration) *DirectUploadBoxParams {
	return &DirectUploadBoxParams{
		timeout: timeout,
	}
}

// NewDirectUploadBoxParamsWithContext creates a new DirectUploadBoxParams object
// with the ability to set a context for a request.
func NewDirectUploadBoxParamsWithContext(ctx context.Context) *DirectUploadBoxParams {
	return &DirectUploadBoxParams{
		Context: ctx,
	}
}

// NewDirectUploadBoxParamsWithHTTPClient creates a new DirectUploadBoxParams object
// with the ability to set a custom HTTPClient for a request.
func NewDirectUploadBoxParamsWithHTTPClient(client *http.Client) *DirectUploadBoxParams {
	return &DirectUploadBoxParams{
		HTTPClient: client,
	}
}

/*
DirectUploadBoxParams contains all the parameters to send to the API endpoint

	for the direct upload box operation.

	Typically these are written to a http.Request.
*/
type DirectUploadBoxParams struct {

	/* Architecture.

	   The type of the Architecture.
	*/
	Architecture string

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Provider.

	   The name of the Provider.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version for the Provider.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the direct upload box params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DirectUploadBoxParams) WithDefaults() *DirectUploadBoxParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the direct upload box params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DirectUploadBoxParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the direct upload box params
func (o *DirectUploadBoxParams) WithTimeout(timeout time.Duration) *DirectUploadBoxParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the direct upload box params
func (o *DirectUploadBoxParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the direct upload box params
func (o *DirectUploadBoxParams) WithContext(ctx context.Context) *DirectUploadBoxParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the direct upload box params
func (o *DirectUploadBoxParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the direct upload box params
func (o *DirectUploadBoxParams) WithHTTPClient(client *http.Client) *DirectUploadBoxParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the direct upload box params
func (o *DirectUploadBoxParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithArchitecture adds the architecture to the direct upload box params
func (o *DirectUploadBoxParams) WithArchitecture(architecture string) *DirectUploadBoxParams {
	o.SetArchitecture(architecture)
	return o
}

// SetArchitecture adds the architecture to the direct upload box params
func (o *DirectUploadBoxParams) SetArchitecture(architecture string) {
	o.Architecture = architecture
}

// WithBox adds the box to the direct upload box params
func (o *DirectUploadBoxParams) WithBox(box string) *DirectUploadBoxParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the direct upload box params
func (o *DirectUploadBoxParams) SetBox(box string) {
	o.Box = box
}

// WithProvider adds the provider to the direct upload box params
func (o *DirectUploadBoxParams) WithProvider(provider string) *DirectUploadBoxParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the direct upload box params
func (o *DirectUploadBoxParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the direct upload box params
func (o *DirectUploadBoxParams) WithRegistry(registry string) *DirectUploadBoxParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the direct upload box params
func (o *DirectUploadBoxParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the direct upload box params
func (o *DirectUploadBoxParams) WithVersion(version string) *DirectUploadBoxParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the direct upload box params
func (o *DirectUploadBoxParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *DirectUploadBoxParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param architecture
	if err := r.SetPathParam("architecture", o.Architecture); err != nil {
		return err
	}

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
