// Code generated by go-swagger; DO NOT EDIT.

package streaming_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new streaming service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for streaming service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	StreamingServiceCreateDestination(params *StreamingServiceCreateDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceCreateDestinationOK, error)

	StreamingServiceCreateDestinationFilter(params *StreamingServiceCreateDestinationFilterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceCreateDestinationFilterOK, error)

	StreamingServiceDeleteDestination(params *StreamingServiceDeleteDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceDeleteDestinationOK, error)

	StreamingServiceGetDestination(params *StreamingServiceGetDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceGetDestinationOK, error)

	StreamingServiceListDestinations(params *StreamingServiceListDestinationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceListDestinationsOK, error)

	StreamingServiceTestDestination(params *StreamingServiceTestDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceTestDestinationOK, error)

	StreamingServiceUpdateDestination(params *StreamingServiceUpdateDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceUpdateDestinationOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
StreamingServiceCreateDestination creates a streaming destination
*/
func (a *Client) StreamingServiceCreateDestination(params *StreamingServiceCreateDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceCreateDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStreamingServiceCreateDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StreamingService_CreateDestination",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{organization_id}/destinations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StreamingServiceCreateDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StreamingServiceCreateDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StreamingServiceCreateDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StreamingServiceCreateDestinationFilter attaches a filter to a streaming destination
*/
func (a *Client) StreamingServiceCreateDestinationFilter(params *StreamingServiceCreateDestinationFilterParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceCreateDestinationFilterOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStreamingServiceCreateDestinationFilterParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StreamingService_CreateDestinationFilter",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{organization_id}/destinations/{destination_id}/filters",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StreamingServiceCreateDestinationFilterReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StreamingServiceCreateDestinationFilterOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StreamingServiceCreateDestinationFilterDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StreamingServiceDeleteDestination deletes a streaming destination
*/
func (a *Client) StreamingServiceDeleteDestination(params *StreamingServiceDeleteDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceDeleteDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStreamingServiceDeleteDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StreamingService_DeleteDestination",
		Method:             "DELETE",
		PathPattern:        "/logs/2021-03-30/organizations/{organization_id}/destinations/{destination_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StreamingServiceDeleteDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StreamingServiceDeleteDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StreamingServiceDeleteDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StreamingServiceGetDestination gets a streaming destination
*/
func (a *Client) StreamingServiceGetDestination(params *StreamingServiceGetDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceGetDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStreamingServiceGetDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StreamingService_GetDestination",
		Method:             "GET",
		PathPattern:        "/logs/2021-03-30/organizations/{organization_id}/destinations/{destination_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StreamingServiceGetDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StreamingServiceGetDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StreamingServiceGetDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StreamingServiceListDestinations lists the streaming destinations in an organization
*/
func (a *Client) StreamingServiceListDestinations(params *StreamingServiceListDestinationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceListDestinationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStreamingServiceListDestinationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StreamingService_ListDestinations",
		Method:             "GET",
		PathPattern:        "/logs/2021-03-30/organizations/{organization_id}/destinations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StreamingServiceListDestinationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StreamingServiceListDestinationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StreamingServiceListDestinationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StreamingServiceTestDestination tests a streaming destination
*/
func (a *Client) StreamingServiceTestDestination(params *StreamingServiceTestDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceTestDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStreamingServiceTestDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StreamingService_TestDestination",
		Method:             "POST",
		PathPattern:        "/logs/2021-03-30/organizations/{organization_id}/destinations/test",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StreamingServiceTestDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StreamingServiceTestDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StreamingServiceTestDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
StreamingServiceUpdateDestination updates a streaming destination
*/
func (a *Client) StreamingServiceUpdateDestination(params *StreamingServiceUpdateDestinationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*StreamingServiceUpdateDestinationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewStreamingServiceUpdateDestinationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "StreamingService_UpdateDestination",
		Method:             "PATCH",
		PathPattern:        "/logs/2021-03-30/organizations/{organization_id}/destinations/{id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &StreamingServiceUpdateDestinationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*StreamingServiceUpdateDestinationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*StreamingServiceUpdateDestinationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
