// Code generated by go-swagger; DO NOT EDIT.

package services

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetServiceParams creates a new GetServiceParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetServiceParams() *GetServiceParams {
	return &GetServiceParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetServiceParamsWithTimeout creates a new GetServiceParams object
// with the ability to set a timeout on a request.
func NewGetServiceParamsWithTimeout(timeout time.Duration) *GetServiceParams {
	return &GetServiceParams{
		timeout: timeout,
	}
}

// NewGetServiceParamsWithContext creates a new GetServiceParams object
// with the ability to set a context for a request.
func NewGetServiceParamsWithContext(ctx context.Context) *GetServiceParams {
	return &GetServiceParams{
		Context: ctx,
	}
}

// NewGetServiceParamsWithHTTPClient creates a new GetServiceParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetServiceParamsWithHTTPClient(client *http.Client) *GetServiceParams {
	return &GetServiceParams{
		HTTPClient: client,
	}
}

/*
GetServiceParams contains all the parameters to send to the API endpoint

	for the get service operation.

	Typically these are written to a http.Request.
*/
type GetServiceParams struct {

	/* ClusterResourceName.

	   Cluster Resource Name will be of the form `consul/project/<project_id>/cluster/<cluster_id>`
	*/
	ClusterResourceName string

	/* Namespace.

	   Query param filter: `namespace` of the service.
	*/
	Namespace *string

	/* Partition.

	   Query param filter: `partition` of the service.
	*/
	Partition *string

	/* ServiceName.

	   The `name` of the service.
	*/
	ServiceName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get service params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetServiceParams) WithDefaults() *GetServiceParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get service params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetServiceParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get service params
func (o *GetServiceParams) WithTimeout(timeout time.Duration) *GetServiceParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get service params
func (o *GetServiceParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get service params
func (o *GetServiceParams) WithContext(ctx context.Context) *GetServiceParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get service params
func (o *GetServiceParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get service params
func (o *GetServiceParams) WithHTTPClient(client *http.Client) *GetServiceParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get service params
func (o *GetServiceParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterResourceName adds the clusterResourceName to the get service params
func (o *GetServiceParams) WithClusterResourceName(clusterResourceName string) *GetServiceParams {
	o.SetClusterResourceName(clusterResourceName)
	return o
}

// SetClusterResourceName adds the clusterResourceName to the get service params
func (o *GetServiceParams) SetClusterResourceName(clusterResourceName string) {
	o.ClusterResourceName = clusterResourceName
}

// WithNamespace adds the namespace to the get service params
func (o *GetServiceParams) WithNamespace(namespace *string) *GetServiceParams {
	o.SetNamespace(namespace)
	return o
}

// SetNamespace adds the namespace to the get service params
func (o *GetServiceParams) SetNamespace(namespace *string) {
	o.Namespace = namespace
}

// WithPartition adds the partition to the get service params
func (o *GetServiceParams) WithPartition(partition *string) *GetServiceParams {
	o.SetPartition(partition)
	return o
}

// SetPartition adds the partition to the get service params
func (o *GetServiceParams) SetPartition(partition *string) {
	o.Partition = partition
}

// WithServiceName adds the serviceName to the get service params
func (o *GetServiceParams) WithServiceName(serviceName string) *GetServiceParams {
	o.SetServiceName(serviceName)
	return o
}

// SetServiceName adds the serviceName to the get service params
func (o *GetServiceParams) SetServiceName(serviceName string) {
	o.ServiceName = serviceName
}

// WriteToRequest writes these params to a swagger request
func (o *GetServiceParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_resource_name
	if err := r.SetPathParam("cluster_resource_name", o.ClusterResourceName); err != nil {
		return err
	}

	if o.Namespace != nil {

		// query param namespace
		var qrNamespace string

		if o.Namespace != nil {
			qrNamespace = *o.Namespace
		}
		qNamespace := qrNamespace
		if qNamespace != "" {

			if err := r.SetQueryParam("namespace", qNamespace); err != nil {
				return err
			}
		}
	}

	if o.Partition != nil {

		// query param partition
		var qrPartition string

		if o.Partition != nil {
			qrPartition = *o.Partition
		}
		qPartition := qrPartition
		if qPartition != "" {

			if err := r.SetQueryParam("partition", qPartition); err != nil {
				return err
			}
		}
	}

	// path param service_name
	if err := r.SetPathParam("service_name", o.ServiceName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
