// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2023-10-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GetNodeReader is a Reader for the GetNode structure.
type GetNodeReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetNodeReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetNodeOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetNodeDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetNodeOK creates a GetNodeOK with default headers values
func NewGetNodeOK() *GetNodeOK {
	return &GetNodeOK{}
}

/*
GetNodeOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetNodeOK struct {
	Payload *models.HashicorpCloudConsulCloudManager20231010GetNodeResponse
}

// IsSuccess returns true when this get node o k response has a 2xx status code
func (o *GetNodeOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get node o k response has a 3xx status code
func (o *GetNodeOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get node o k response has a 4xx status code
func (o *GetNodeOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get node o k response has a 5xx status code
func (o *GetNodeOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get node o k response a status code equal to that given
func (o *GetNodeOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get node o k response
func (o *GetNodeOK) Code() int {
	return 200
}

func (o *GetNodeOK) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/{parent_resource_name}/node/{node_name}][%d] getNodeOK  %+v", 200, o.Payload)
}

func (o *GetNodeOK) String() string {
	return fmt.Sprintf("[GET /2023-10-10/{parent_resource_name}/node/{node_name}][%d] getNodeOK  %+v", 200, o.Payload)
}

func (o *GetNodeOK) GetPayload() *models.HashicorpCloudConsulCloudManager20231010GetNodeResponse {
	return o.Payload
}

func (o *GetNodeOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulCloudManager20231010GetNodeResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetNodeDefault creates a GetNodeDefault with default headers values
func NewGetNodeDefault(code int) *GetNodeDefault {
	return &GetNodeDefault{
		_statusCode: code,
	}
}

/*
GetNodeDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetNodeDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this get node default response has a 2xx status code
func (o *GetNodeDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get node default response has a 3xx status code
func (o *GetNodeDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get node default response has a 4xx status code
func (o *GetNodeDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get node default response has a 5xx status code
func (o *GetNodeDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get node default response a status code equal to that given
func (o *GetNodeDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get node default response
func (o *GetNodeDefault) Code() int {
	return o._statusCode
}

func (o *GetNodeDefault) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/{parent_resource_name}/node/{node_name}][%d] Get Node default  %+v", o._statusCode, o.Payload)
}

func (o *GetNodeDefault) String() string {
	return fmt.Sprintf("[GET /2023-10-10/{parent_resource_name}/node/{node_name}][%d] Get Node default  %+v", o._statusCode, o.Payload)
}

func (o *GetNodeDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GetNodeDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
