// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// ProductServiceEstimateCostBody EstimateCostRequest returns hourly and monthly pricing information for a given package for the given resource type.
//
// swagger:model ProductServiceEstimateCostBody
type ProductServiceEstimateCostBody struct {

	// customized_input allows the quantity of dependent products (i.e. number of Vault Clients for a Vault Cluster) to be specified for the cost estimation.
	CustomizedInput []*Billing20201105CustomizedInput `json:"customized_input"`

	// package_item_selection is the item/option selections that cost will be estimated for.
	PackageItemSelection []*Billing20201105PackageItemSelection `json:"package_item_selection"`

	// package_key is the key of the package being retrieved.
	PackageKey string `json:"package_key,omitempty"`

	// project_id the project ID used to scope the request for the package.
	ProjectID string `json:"project_id,omitempty"`

	// region is the cloud provider & region to scope the request.
	Region *LocationRegion `json:"region,omitempty"`
}

// Validate validates this product service estimate cost body
func (m *ProductServiceEstimateCostBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCustomizedInput(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePackageItemSelection(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ProductServiceEstimateCostBody) validateCustomizedInput(formats strfmt.Registry) error {
	if swag.IsZero(m.CustomizedInput) { // not required
		return nil
	}

	for i := 0; i < len(m.CustomizedInput); i++ {
		if swag.IsZero(m.CustomizedInput[i]) { // not required
			continue
		}

		if m.CustomizedInput[i] != nil {
			if err := m.CustomizedInput[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("customized_input" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("customized_input" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ProductServiceEstimateCostBody) validatePackageItemSelection(formats strfmt.Registry) error {
	if swag.IsZero(m.PackageItemSelection) { // not required
		return nil
	}

	for i := 0; i < len(m.PackageItemSelection); i++ {
		if swag.IsZero(m.PackageItemSelection[i]) { // not required
			continue
		}

		if m.PackageItemSelection[i] != nil {
			if err := m.PackageItemSelection[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("package_item_selection" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("package_item_selection" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ProductServiceEstimateCostBody) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(m.Region) { // not required
		return nil
	}

	if m.Region != nil {
		if err := m.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this product service estimate cost body based on the context it is used
func (m *ProductServiceEstimateCostBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCustomizedInput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePackageItemSelection(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ProductServiceEstimateCostBody) contextValidateCustomizedInput(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.CustomizedInput); i++ {

		if m.CustomizedInput[i] != nil {

			if swag.IsZero(m.CustomizedInput[i]) { // not required
				return nil
			}

			if err := m.CustomizedInput[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("customized_input" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("customized_input" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ProductServiceEstimateCostBody) contextValidatePackageItemSelection(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PackageItemSelection); i++ {

		if m.PackageItemSelection[i] != nil {

			if swag.IsZero(m.PackageItemSelection[i]) { // not required
				return nil
			}

			if err := m.PackageItemSelection[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("package_item_selection" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("package_item_selection" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *ProductServiceEstimateCostBody) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if m.Region != nil {

		if swag.IsZero(m.Region) { // not required
			return nil
		}

		if err := m.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ProductServiceEstimateCostBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ProductServiceEstimateCostBody) UnmarshalBinary(b []byte) error {
	var res ProductServiceEstimateCostBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
