// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105ConsumptionPool ConsumptionPool represents a FCP Consumption Pool
//
// swagger:model billing_20201105ConsumptionPool
type Billing20201105ConsumptionPool struct {

	// active_from is the timestamp of when the consumption pool became active.
	// Format: date-time
	ActiveFrom strfmt.DateTime `json:"active_from,omitempty"`

	// active_until is the timestamp of when the consumption pool became inactive.
	// Format: date-time
	ActiveUntil strfmt.DateTime `json:"active_until,omitempty"`

	// billing_account_id is the slug ID of the Billing Account this
	// consumption pool is belongs to.
	BillingAccountID string `json:"billing_account_id,omitempty"`

	// created_at is the time when consumption pool has been created.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// discounts is the list of discounts associated with the consumption pool.
	Discounts []*Cloudbilling20201105Discount `json:"discounts"`

	// id is the id associated with the consumption pool.
	ID string `json:"id,omitempty"`

	// initial_amount is the initial amount on the consumption pool in USD.
	InitialAmount string `json:"initial_amount,omitempty"`

	// organization_id is the organization where the billing account belongs to.
	OrganizationID string `json:"organization_id,omitempty"`

	// recognized_balance is the official remaining balance of this consumption pool in USD
	// as of the last recognition event.
	RecognizedBalance string `json:"recognized_balance,omitempty"`

	// roll_in_percentage is the percentage of a remaining balance an account is allowed to rolled in to
	// this renewal consumption pool.
	// For renewal consumption pools, must be between 0 and 100.
	// For non-renewal consumption it will always be 0.
	RollInPercentage string `json:"roll_in_percentage,omitempty"`

	// running_total is a running usage estimate since the last recognition event.
	// This number will be increased after each new running transaction and
	// zeroed after a recognition event (if recognition event covered all available running
	// transactions)
	RunningTotal string `json:"running_total,omitempty"`

	// status is the current status of the consumption pool (ex. active, upcoming, rolled over, expired).
	Status *Billing20201105ConsumptionPoolStatus `json:"status,omitempty"`

	// support_level is the support level associated with the consumption pool.
	SupportLevel string `json:"support_level,omitempty"`

	// support_levels is the list of products and their corresponding support levels for the associated consumption pool
	SupportLevels []*Billing20201105SupportLevel `json:"support_levels"`

	// updated_at is the last time the consumption pool has been updated.
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this billing 20201105 consumption pool
func (m *Billing20201105ConsumptionPool) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActiveFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateActiveUntil(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDiscounts(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSupportLevels(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105ConsumptionPool) validateActiveFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveFrom) { // not required
		return nil
	}

	if err := validate.FormatOf("active_from", "body", "date-time", m.ActiveFrom.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105ConsumptionPool) validateActiveUntil(formats strfmt.Registry) error {
	if swag.IsZero(m.ActiveUntil) { // not required
		return nil
	}

	if err := validate.FormatOf("active_until", "body", "date-time", m.ActiveUntil.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105ConsumptionPool) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105ConsumptionPool) validateDiscounts(formats strfmt.Registry) error {
	if swag.IsZero(m.Discounts) { // not required
		return nil
	}

	for i := 0; i < len(m.Discounts); i++ {
		if swag.IsZero(m.Discounts[i]) { // not required
			continue
		}

		if m.Discounts[i] != nil {
			if err := m.Discounts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("discounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("discounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105ConsumptionPool) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105ConsumptionPool) validateSupportLevels(formats strfmt.Registry) error {
	if swag.IsZero(m.SupportLevels) { // not required
		return nil
	}

	for i := 0; i < len(m.SupportLevels); i++ {
		if swag.IsZero(m.SupportLevels[i]) { // not required
			continue
		}

		if m.SupportLevels[i] != nil {
			if err := m.SupportLevels[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("support_levels" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("support_levels" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105ConsumptionPool) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this billing 20201105 consumption pool based on the context it is used
func (m *Billing20201105ConsumptionPool) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDiscounts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSupportLevels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105ConsumptionPool) contextValidateDiscounts(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Discounts); i++ {

		if m.Discounts[i] != nil {

			if swag.IsZero(m.Discounts[i]) { // not required
				return nil
			}

			if err := m.Discounts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("discounts" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("discounts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105ConsumptionPool) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {

		if swag.IsZero(m.Status) { // not required
			return nil
		}

		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105ConsumptionPool) contextValidateSupportLevels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SupportLevels); i++ {

		if m.SupportLevels[i] != nil {

			if swag.IsZero(m.SupportLevels[i]) { // not required
				return nil
			}

			if err := m.SupportLevels[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("support_levels" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("support_levels" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105ConsumptionPool) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105ConsumptionPool) UnmarshalBinary(b []byte) error {
	var res Billing20201105ConsumptionPool
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
