// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceUpdateVariableReader is a Reader for the WaypointServiceUpdateVariable structure.
type WaypointServiceUpdateVariableReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUpdateVariableReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUpdateVariableOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUpdateVariableDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUpdateVariableOK creates a WaypointServiceUpdateVariableOK with default headers values
func NewWaypointServiceUpdateVariableOK() *WaypointServiceUpdateVariableOK {
	return &WaypointServiceUpdateVariableOK{}
}

/*
WaypointServiceUpdateVariableOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUpdateVariableOK struct {
	Payload *models.HashicorpCloudWaypointUpdateVariableResponse
}

// IsSuccess returns true when this waypoint service update variable o k response has a 2xx status code
func (o *WaypointServiceUpdateVariableOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service update variable o k response has a 3xx status code
func (o *WaypointServiceUpdateVariableOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service update variable o k response has a 4xx status code
func (o *WaypointServiceUpdateVariableOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service update variable o k response has a 5xx status code
func (o *WaypointServiceUpdateVariableOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service update variable o k response a status code equal to that given
func (o *WaypointServiceUpdateVariableOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service update variable o k response
func (o *WaypointServiceUpdateVariableOK) Code() int {
	return 200
}

func (o *WaypointServiceUpdateVariableOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /waypoint/2023-08-18/namespace/{namespace.id}/variable][%d] waypointServiceUpdateVariableOK %s", 200, payload)
}

func (o *WaypointServiceUpdateVariableOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /waypoint/2023-08-18/namespace/{namespace.id}/variable][%d] waypointServiceUpdateVariableOK %s", 200, payload)
}

func (o *WaypointServiceUpdateVariableOK) GetPayload() *models.HashicorpCloudWaypointUpdateVariableResponse {
	return o.Payload
}

func (o *WaypointServiceUpdateVariableOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUpdateVariableResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUpdateVariableDefault creates a WaypointServiceUpdateVariableDefault with default headers values
func NewWaypointServiceUpdateVariableDefault(code int) *WaypointServiceUpdateVariableDefault {
	return &WaypointServiceUpdateVariableDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUpdateVariableDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUpdateVariableDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service update variable default response has a 2xx status code
func (o *WaypointServiceUpdateVariableDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service update variable default response has a 3xx status code
func (o *WaypointServiceUpdateVariableDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service update variable default response has a 4xx status code
func (o *WaypointServiceUpdateVariableDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service update variable default response has a 5xx status code
func (o *WaypointServiceUpdateVariableDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service update variable default response a status code equal to that given
func (o *WaypointServiceUpdateVariableDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service update variable default response
func (o *WaypointServiceUpdateVariableDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUpdateVariableDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /waypoint/2023-08-18/namespace/{namespace.id}/variable][%d] WaypointService_UpdateVariable default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpdateVariableDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /waypoint/2023-08-18/namespace/{namespace.id}/variable][%d] WaypointService_UpdateVariable default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpdateVariableDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUpdateVariableDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
