// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2021-04-30/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceListChannelHistoryReader is a Reader for the PackerServiceListChannelHistory structure.
type PackerServiceListChannelHistoryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceListChannelHistoryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceListChannelHistoryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceListChannelHistoryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceListChannelHistoryOK creates a PackerServiceListChannelHistoryOK with default headers values
func NewPackerServiceListChannelHistoryOK() *PackerServiceListChannelHistoryOK {
	return &PackerServiceListChannelHistoryOK{}
}

/*
PackerServiceListChannelHistoryOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceListChannelHistoryOK struct {
	Payload *models.HashicorpCloudPackerListChannelHistoryResponse
}

// IsSuccess returns true when this packer service list channel history o k response has a 2xx status code
func (o *PackerServiceListChannelHistoryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service list channel history o k response has a 3xx status code
func (o *PackerServiceListChannelHistoryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service list channel history o k response has a 4xx status code
func (o *PackerServiceListChannelHistoryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service list channel history o k response has a 5xx status code
func (o *PackerServiceListChannelHistoryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service list channel history o k response a status code equal to that given
func (o *PackerServiceListChannelHistoryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service list channel history o k response
func (o *PackerServiceListChannelHistoryOK) Code() int {
	return 200
}

func (o *PackerServiceListChannelHistoryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}/history][%d] packerServiceListChannelHistoryOK %s", 200, payload)
}

func (o *PackerServiceListChannelHistoryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}/history][%d] packerServiceListChannelHistoryOK %s", 200, payload)
}

func (o *PackerServiceListChannelHistoryOK) GetPayload() *models.HashicorpCloudPackerListChannelHistoryResponse {
	return o.Payload
}

func (o *PackerServiceListChannelHistoryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPackerListChannelHistoryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceListChannelHistoryDefault creates a PackerServiceListChannelHistoryDefault with default headers values
func NewPackerServiceListChannelHistoryDefault(code int) *PackerServiceListChannelHistoryDefault {
	return &PackerServiceListChannelHistoryDefault{
		_statusCode: code,
	}
}

/*
PackerServiceListChannelHistoryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceListChannelHistoryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service list channel history default response has a 2xx status code
func (o *PackerServiceListChannelHistoryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service list channel history default response has a 3xx status code
func (o *PackerServiceListChannelHistoryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service list channel history default response has a 4xx status code
func (o *PackerServiceListChannelHistoryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service list channel history default response has a 5xx status code
func (o *PackerServiceListChannelHistoryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service list channel history default response a status code equal to that given
func (o *PackerServiceListChannelHistoryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service list channel history default response
func (o *PackerServiceListChannelHistoryDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceListChannelHistoryDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}/history][%d] PackerService_ListChannelHistory default %s", o._statusCode, payload)
}

func (o *PackerServiceListChannelHistoryDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/images/{bucket_slug}/channels/{slug}/history][%d] PackerService_ListChannelHistory default %s", o._statusCode, payload)
}

func (o *PackerServiceListChannelHistoryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceListChannelHistoryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
