// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// GroupsServiceDeleteGroupReader is a Reader for the GroupsServiceDeleteGroup structure.
type GroupsServiceDeleteGroupReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GroupsServiceDeleteGroupReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGroupsServiceDeleteGroupOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGroupsServiceDeleteGroupDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGroupsServiceDeleteGroupOK creates a GroupsServiceDeleteGroupOK with default headers values
func NewGroupsServiceDeleteGroupOK() *GroupsServiceDeleteGroupOK {
	return &GroupsServiceDeleteGroupOK{}
}

/*
GroupsServiceDeleteGroupOK describes a response with status code 200, with default header values.

A successful response.
*/
type GroupsServiceDeleteGroupOK struct {
	Payload interface{}
}

// IsSuccess returns true when this groups service delete group o k response has a 2xx status code
func (o *GroupsServiceDeleteGroupOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this groups service delete group o k response has a 3xx status code
func (o *GroupsServiceDeleteGroupOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this groups service delete group o k response has a 4xx status code
func (o *GroupsServiceDeleteGroupOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this groups service delete group o k response has a 5xx status code
func (o *GroupsServiceDeleteGroupOK) IsServerError() bool {
	return false
}

// IsCode returns true when this groups service delete group o k response a status code equal to that given
func (o *GroupsServiceDeleteGroupOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the groups service delete group o k response
func (o *GroupsServiceDeleteGroupOK) Code() int {
	return 200
}

func (o *GroupsServiceDeleteGroupOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/{resource_name}][%d] groupsServiceDeleteGroupOK %s", 200, payload)
}

func (o *GroupsServiceDeleteGroupOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/{resource_name}][%d] groupsServiceDeleteGroupOK %s", 200, payload)
}

func (o *GroupsServiceDeleteGroupOK) GetPayload() interface{} {
	return o.Payload
}

func (o *GroupsServiceDeleteGroupOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGroupsServiceDeleteGroupDefault creates a GroupsServiceDeleteGroupDefault with default headers values
func NewGroupsServiceDeleteGroupDefault(code int) *GroupsServiceDeleteGroupDefault {
	return &GroupsServiceDeleteGroupDefault{
		_statusCode: code,
	}
}

/*
GroupsServiceDeleteGroupDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GroupsServiceDeleteGroupDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this groups service delete group default response has a 2xx status code
func (o *GroupsServiceDeleteGroupDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this groups service delete group default response has a 3xx status code
func (o *GroupsServiceDeleteGroupDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this groups service delete group default response has a 4xx status code
func (o *GroupsServiceDeleteGroupDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this groups service delete group default response has a 5xx status code
func (o *GroupsServiceDeleteGroupDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this groups service delete group default response a status code equal to that given
func (o *GroupsServiceDeleteGroupDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the groups service delete group default response
func (o *GroupsServiceDeleteGroupDefault) Code() int {
	return o._statusCode
}

func (o *GroupsServiceDeleteGroupDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/{resource_name}][%d] GroupsService_DeleteGroup default %s", o._statusCode, payload)
}

func (o *GroupsServiceDeleteGroupDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /iam/2019-12-10/{resource_name}][%d] GroupsService_DeleteGroup default %s", o._statusCode, payload)
}

func (o *GroupsServiceDeleteGroupDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *GroupsServiceDeleteGroupDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
