/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.items.events;

import java.time.ZonedDateTime;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.events.ItemEvent;
import org.openhab.core.types.State;

@NonNullByDefault
public class ItemStateUpdatedEvent
extends ItemEvent {
    public static final String TYPE = ItemStateUpdatedEvent.class.getSimpleName();
    protected final State itemState;
    protected final @Nullable ZonedDateTime lastStateUpdate;

    protected ItemStateUpdatedEvent(String topic, String payload, String itemName, State itemState, @Nullable ZonedDateTime lastStateUpdate, @Nullable String source) {
        super(topic, payload, itemName, source);
        this.itemState = itemState;
        this.lastStateUpdate = lastStateUpdate;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public State getItemState() {
        return this.itemState;
    }

    public @Nullable ZonedDateTime getLastStateUpdate() {
        return this.lastStateUpdate;
    }

    public String toString() {
        return String.format("Item '%s' updated to %s", this.itemName, this.itemState);
    }
}

