// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// TrafficRulesRateLimitConfig traffic rules rate limit config
//
// swagger:model trafficRulesRateLimitConfig
type TrafficRulesRateLimitConfig struct {

	// algorithm
	// Enum: [sliding_window]
	Algorithm string `json:"algorithm,omitempty"`

	// window limit
	WindowLimit int64 `json:"window_limit,omitempty"`

	// window size
	WindowSize int64 `json:"window_size,omitempty"`
}

// Validate validates this traffic rules rate limit config
func (m *TrafficRulesRateLimitConfig) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAlgorithm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var trafficRulesRateLimitConfigTypeAlgorithmPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["sliding_window"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		trafficRulesRateLimitConfigTypeAlgorithmPropEnum = append(trafficRulesRateLimitConfigTypeAlgorithmPropEnum, v)
	}
}

const (

	// TrafficRulesRateLimitConfigAlgorithmSlidingWindow captures enum value "sliding_window"
	TrafficRulesRateLimitConfigAlgorithmSlidingWindow string = "sliding_window"
)

// prop value enum
func (m *TrafficRulesRateLimitConfig) validateAlgorithmEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, trafficRulesRateLimitConfigTypeAlgorithmPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *TrafficRulesRateLimitConfig) validateAlgorithm(formats strfmt.Registry) error {

	if swag.IsZero(m.Algorithm) { // not required
		return nil
	}

	// value enum
	if err := m.validateAlgorithmEnum("algorithm", "body", m.Algorithm); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TrafficRulesRateLimitConfig) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TrafficRulesRateLimitConfig) UnmarshalBinary(b []byte) error {
	var res TrafficRulesRateLimitConfig
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
