// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_response_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteHTTPResponseRuleFrontendAcceptedCode is the HTTP code returned for type DeleteHTTPResponseRuleFrontendAccepted
const DeleteHTTPResponseRuleFrontendAcceptedCode int = 202

/*
DeleteHTTPResponseRuleFrontendAccepted Configuration change accepted and reload requested

swagger:response deleteHttpResponseRuleFrontendAccepted
*/
type DeleteHTTPResponseRuleFrontendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteHTTPResponseRuleFrontendAccepted creates DeleteHTTPResponseRuleFrontendAccepted with default headers values
func NewDeleteHTTPResponseRuleFrontendAccepted() *DeleteHTTPResponseRuleFrontendAccepted {

	return &DeleteHTTPResponseRuleFrontendAccepted{}
}

// WithReloadID adds the reloadId to the delete Http response rule frontend accepted response
func (o *DeleteHTTPResponseRuleFrontendAccepted) WithReloadID(reloadID string) *DeleteHTTPResponseRuleFrontendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Http response rule frontend accepted response
func (o *DeleteHTTPResponseRuleFrontendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteHTTPResponseRuleFrontendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteHTTPResponseRuleFrontendNoContentCode is the HTTP code returned for type DeleteHTTPResponseRuleFrontendNoContent
const DeleteHTTPResponseRuleFrontendNoContentCode int = 204

/*
DeleteHTTPResponseRuleFrontendNoContent HTTP Response Rule deleted

swagger:response deleteHttpResponseRuleFrontendNoContent
*/
type DeleteHTTPResponseRuleFrontendNoContent struct {
}

// NewDeleteHTTPResponseRuleFrontendNoContent creates DeleteHTTPResponseRuleFrontendNoContent with default headers values
func NewDeleteHTTPResponseRuleFrontendNoContent() *DeleteHTTPResponseRuleFrontendNoContent {

	return &DeleteHTTPResponseRuleFrontendNoContent{}
}

// WriteResponse to the client
func (o *DeleteHTTPResponseRuleFrontendNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteHTTPResponseRuleFrontendNotFoundCode is the HTTP code returned for type DeleteHTTPResponseRuleFrontendNotFound
const DeleteHTTPResponseRuleFrontendNotFoundCode int = 404

/*
DeleteHTTPResponseRuleFrontendNotFound The specified resource was not found

swagger:response deleteHttpResponseRuleFrontendNotFound
*/
type DeleteHTTPResponseRuleFrontendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPResponseRuleFrontendNotFound creates DeleteHTTPResponseRuleFrontendNotFound with default headers values
func NewDeleteHTTPResponseRuleFrontendNotFound() *DeleteHTTPResponseRuleFrontendNotFound {

	return &DeleteHTTPResponseRuleFrontendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Http response rule frontend not found response
func (o *DeleteHTTPResponseRuleFrontendNotFound) WithConfigurationVersion(configurationVersion string) *DeleteHTTPResponseRuleFrontendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Http response rule frontend not found response
func (o *DeleteHTTPResponseRuleFrontendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Http response rule frontend not found response
func (o *DeleteHTTPResponseRuleFrontendNotFound) WithPayload(payload *models.Error) *DeleteHTTPResponseRuleFrontendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Http response rule frontend not found response
func (o *DeleteHTTPResponseRuleFrontendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPResponseRuleFrontendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteHTTPResponseRuleFrontendDefault General Error

swagger:response deleteHttpResponseRuleFrontendDefault
*/
type DeleteHTTPResponseRuleFrontendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteHTTPResponseRuleFrontendDefault creates DeleteHTTPResponseRuleFrontendDefault with default headers values
func NewDeleteHTTPResponseRuleFrontendDefault(code int) *DeleteHTTPResponseRuleFrontendDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteHTTPResponseRuleFrontendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete HTTP response rule frontend default response
func (o *DeleteHTTPResponseRuleFrontendDefault) WithStatusCode(code int) *DeleteHTTPResponseRuleFrontendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete HTTP response rule frontend default response
func (o *DeleteHTTPResponseRuleFrontendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete HTTP response rule frontend default response
func (o *DeleteHTTPResponseRuleFrontendDefault) WithConfigurationVersion(configurationVersion string) *DeleteHTTPResponseRuleFrontendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete HTTP response rule frontend default response
func (o *DeleteHTTPResponseRuleFrontendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete HTTP response rule frontend default response
func (o *DeleteHTTPResponseRuleFrontendDefault) WithPayload(payload *models.Error) *DeleteHTTPResponseRuleFrontendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete HTTP response rule frontend default response
func (o *DeleteHTTPResponseRuleFrontendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteHTTPResponseRuleFrontendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
