// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package http_error_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateHTTPErrorRuleDefaultsCreatedCode is the HTTP code returned for type CreateHTTPErrorRuleDefaultsCreated
const CreateHTTPErrorRuleDefaultsCreatedCode int = 201

/*
CreateHTTPErrorRuleDefaultsCreated HTTP Error Rule created

swagger:response createHttpErrorRuleDefaultsCreated
*/
type CreateHTTPErrorRuleDefaultsCreated struct {

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleDefaultsCreated creates CreateHTTPErrorRuleDefaultsCreated with default headers values
func NewCreateHTTPErrorRuleDefaultsCreated() *CreateHTTPErrorRuleDefaultsCreated {

	return &CreateHTTPErrorRuleDefaultsCreated{}
}

// WithPayload adds the payload to the create Http error rule defaults created response
func (o *CreateHTTPErrorRuleDefaultsCreated) WithPayload(payload *models.HTTPErrorRule) *CreateHTTPErrorRuleDefaultsCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule defaults created response
func (o *CreateHTTPErrorRuleDefaultsCreated) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleDefaultsCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorRuleDefaultsAcceptedCode is the HTTP code returned for type CreateHTTPErrorRuleDefaultsAccepted
const CreateHTTPErrorRuleDefaultsAcceptedCode int = 202

/*
CreateHTTPErrorRuleDefaultsAccepted Configuration change accepted and reload requested

swagger:response createHttpErrorRuleDefaultsAccepted
*/
type CreateHTTPErrorRuleDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.HTTPErrorRule `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleDefaultsAccepted creates CreateHTTPErrorRuleDefaultsAccepted with default headers values
func NewCreateHTTPErrorRuleDefaultsAccepted() *CreateHTTPErrorRuleDefaultsAccepted {

	return &CreateHTTPErrorRuleDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the create Http error rule defaults accepted response
func (o *CreateHTTPErrorRuleDefaultsAccepted) WithReloadID(reloadID string) *CreateHTTPErrorRuleDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Http error rule defaults accepted response
func (o *CreateHTTPErrorRuleDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Http error rule defaults accepted response
func (o *CreateHTTPErrorRuleDefaultsAccepted) WithPayload(payload *models.HTTPErrorRule) *CreateHTTPErrorRuleDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule defaults accepted response
func (o *CreateHTTPErrorRuleDefaultsAccepted) SetPayload(payload *models.HTTPErrorRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorRuleDefaultsBadRequestCode is the HTTP code returned for type CreateHTTPErrorRuleDefaultsBadRequest
const CreateHTTPErrorRuleDefaultsBadRequestCode int = 400

/*
CreateHTTPErrorRuleDefaultsBadRequest Bad request

swagger:response createHttpErrorRuleDefaultsBadRequest
*/
type CreateHTTPErrorRuleDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleDefaultsBadRequest creates CreateHTTPErrorRuleDefaultsBadRequest with default headers values
func NewCreateHTTPErrorRuleDefaultsBadRequest() *CreateHTTPErrorRuleDefaultsBadRequest {

	return &CreateHTTPErrorRuleDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http error rule defaults bad request response
func (o *CreateHTTPErrorRuleDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorRuleDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http error rule defaults bad request response
func (o *CreateHTTPErrorRuleDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http error rule defaults bad request response
func (o *CreateHTTPErrorRuleDefaultsBadRequest) WithPayload(payload *models.Error) *CreateHTTPErrorRuleDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule defaults bad request response
func (o *CreateHTTPErrorRuleDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateHTTPErrorRuleDefaultsConflictCode is the HTTP code returned for type CreateHTTPErrorRuleDefaultsConflict
const CreateHTTPErrorRuleDefaultsConflictCode int = 409

/*
CreateHTTPErrorRuleDefaultsConflict The specified resource already exists

swagger:response createHttpErrorRuleDefaultsConflict
*/
type CreateHTTPErrorRuleDefaultsConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleDefaultsConflict creates CreateHTTPErrorRuleDefaultsConflict with default headers values
func NewCreateHTTPErrorRuleDefaultsConflict() *CreateHTTPErrorRuleDefaultsConflict {

	return &CreateHTTPErrorRuleDefaultsConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Http error rule defaults conflict response
func (o *CreateHTTPErrorRuleDefaultsConflict) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorRuleDefaultsConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Http error rule defaults conflict response
func (o *CreateHTTPErrorRuleDefaultsConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Http error rule defaults conflict response
func (o *CreateHTTPErrorRuleDefaultsConflict) WithPayload(payload *models.Error) *CreateHTTPErrorRuleDefaultsConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Http error rule defaults conflict response
func (o *CreateHTTPErrorRuleDefaultsConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleDefaultsConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateHTTPErrorRuleDefaultsDefault General Error

swagger:response createHttpErrorRuleDefaultsDefault
*/
type CreateHTTPErrorRuleDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateHTTPErrorRuleDefaultsDefault creates CreateHTTPErrorRuleDefaultsDefault with default headers values
func NewCreateHTTPErrorRuleDefaultsDefault(code int) *CreateHTTPErrorRuleDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateHTTPErrorRuleDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create HTTP error rule defaults default response
func (o *CreateHTTPErrorRuleDefaultsDefault) WithStatusCode(code int) *CreateHTTPErrorRuleDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create HTTP error rule defaults default response
func (o *CreateHTTPErrorRuleDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create HTTP error rule defaults default response
func (o *CreateHTTPErrorRuleDefaultsDefault) WithConfigurationVersion(configurationVersion string) *CreateHTTPErrorRuleDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create HTTP error rule defaults default response
func (o *CreateHTTPErrorRuleDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create HTTP error rule defaults default response
func (o *CreateHTTPErrorRuleDefaultsDefault) WithPayload(payload *models.Error) *CreateHTTPErrorRuleDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create HTTP error rule defaults default response
func (o *CreateHTTPErrorRuleDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateHTTPErrorRuleDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
