// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package fcgi_app

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// DeleteFCGIAppAcceptedCode is the HTTP code returned for type DeleteFCGIAppAccepted
const DeleteFCGIAppAcceptedCode int = 202

/*
DeleteFCGIAppAccepted Configuration change accepted and reload requested

swagger:response deleteFcgiAppAccepted
*/
type DeleteFCGIAppAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`
}

// NewDeleteFCGIAppAccepted creates DeleteFCGIAppAccepted with default headers values
func NewDeleteFCGIAppAccepted() *DeleteFCGIAppAccepted {

	return &DeleteFCGIAppAccepted{}
}

// WithReloadID adds the reloadId to the delete Fcgi app accepted response
func (o *DeleteFCGIAppAccepted) WithReloadID(reloadID string) *DeleteFCGIAppAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the delete Fcgi app accepted response
func (o *DeleteFCGIAppAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WriteResponse to the client
func (o *DeleteFCGIAppAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(202)
}

// DeleteFCGIAppNoContentCode is the HTTP code returned for type DeleteFCGIAppNoContent
const DeleteFCGIAppNoContentCode int = 204

/*
DeleteFCGIAppNoContent Application deleted

swagger:response deleteFcgiAppNoContent
*/
type DeleteFCGIAppNoContent struct {
}

// NewDeleteFCGIAppNoContent creates DeleteFCGIAppNoContent with default headers values
func NewDeleteFCGIAppNoContent() *DeleteFCGIAppNoContent {

	return &DeleteFCGIAppNoContent{}
}

// WriteResponse to the client
func (o *DeleteFCGIAppNoContent) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.Header().Del(runtime.HeaderContentType) //Remove Content-Type on empty responses

	rw.WriteHeader(204)
}

// DeleteFCGIAppNotFoundCode is the HTTP code returned for type DeleteFCGIAppNotFound
const DeleteFCGIAppNotFoundCode int = 404

/*
DeleteFCGIAppNotFound The specified resource was not found

swagger:response deleteFcgiAppNotFound
*/
type DeleteFCGIAppNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteFCGIAppNotFound creates DeleteFCGIAppNotFound with default headers values
func NewDeleteFCGIAppNotFound() *DeleteFCGIAppNotFound {

	return &DeleteFCGIAppNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the delete Fcgi app not found response
func (o *DeleteFCGIAppNotFound) WithConfigurationVersion(configurationVersion string) *DeleteFCGIAppNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete Fcgi app not found response
func (o *DeleteFCGIAppNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete Fcgi app not found response
func (o *DeleteFCGIAppNotFound) WithPayload(payload *models.Error) *DeleteFCGIAppNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete Fcgi app not found response
func (o *DeleteFCGIAppNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteFCGIAppNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DeleteFCGIAppDefault General Error

swagger:response deleteFcgiAppDefault
*/
type DeleteFCGIAppDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDeleteFCGIAppDefault creates DeleteFCGIAppDefault with default headers values
func NewDeleteFCGIAppDefault(code int) *DeleteFCGIAppDefault {
	if code <= 0 {
		code = 500
	}

	return &DeleteFCGIAppDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the delete FCGI app default response
func (o *DeleteFCGIAppDefault) WithStatusCode(code int) *DeleteFCGIAppDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the delete FCGI app default response
func (o *DeleteFCGIAppDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the delete FCGI app default response
func (o *DeleteFCGIAppDefault) WithConfigurationVersion(configurationVersion string) *DeleteFCGIAppDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the delete FCGI app default response
func (o *DeleteFCGIAppDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the delete FCGI app default response
func (o *DeleteFCGIAppDefault) WithPayload(payload *models.Error) *DeleteFCGIAppDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the delete FCGI app default response
func (o *DeleteFCGIAppDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DeleteFCGIAppDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
