// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package acl

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateACLBackendCreatedCode is the HTTP code returned for type CreateACLBackendCreated
const CreateACLBackendCreatedCode int = 201

/*
CreateACLBackendCreated ACL line created

swagger:response createAclBackendCreated
*/
type CreateACLBackendCreated struct {

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewCreateACLBackendCreated creates CreateACLBackendCreated with default headers values
func NewCreateACLBackendCreated() *CreateACLBackendCreated {

	return &CreateACLBackendCreated{}
}

// WithPayload adds the payload to the create Acl backend created response
func (o *CreateACLBackendCreated) WithPayload(payload *models.ACL) *CreateACLBackendCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl backend created response
func (o *CreateACLBackendCreated) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLBackendCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateACLBackendAcceptedCode is the HTTP code returned for type CreateACLBackendAccepted
const CreateACLBackendAcceptedCode int = 202

/*
CreateACLBackendAccepted Configuration change accepted and reload requested

swagger:response createAclBackendAccepted
*/
type CreateACLBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.ACL `json:"body,omitempty"`
}

// NewCreateACLBackendAccepted creates CreateACLBackendAccepted with default headers values
func NewCreateACLBackendAccepted() *CreateACLBackendAccepted {

	return &CreateACLBackendAccepted{}
}

// WithReloadID adds the reloadId to the create Acl backend accepted response
func (o *CreateACLBackendAccepted) WithReloadID(reloadID string) *CreateACLBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create Acl backend accepted response
func (o *CreateACLBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create Acl backend accepted response
func (o *CreateACLBackendAccepted) WithPayload(payload *models.ACL) *CreateACLBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl backend accepted response
func (o *CreateACLBackendAccepted) SetPayload(payload *models.ACL) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateACLBackendBadRequestCode is the HTTP code returned for type CreateACLBackendBadRequest
const CreateACLBackendBadRequestCode int = 400

/*
CreateACLBackendBadRequest Bad request

swagger:response createAclBackendBadRequest
*/
type CreateACLBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateACLBackendBadRequest creates CreateACLBackendBadRequest with default headers values
func NewCreateACLBackendBadRequest() *CreateACLBackendBadRequest {

	return &CreateACLBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create Acl backend bad request response
func (o *CreateACLBackendBadRequest) WithConfigurationVersion(configurationVersion string) *CreateACLBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Acl backend bad request response
func (o *CreateACLBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Acl backend bad request response
func (o *CreateACLBackendBadRequest) WithPayload(payload *models.Error) *CreateACLBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl backend bad request response
func (o *CreateACLBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateACLBackendConflictCode is the HTTP code returned for type CreateACLBackendConflict
const CreateACLBackendConflictCode int = 409

/*
CreateACLBackendConflict The specified resource already exists

swagger:response createAclBackendConflict
*/
type CreateACLBackendConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateACLBackendConflict creates CreateACLBackendConflict with default headers values
func NewCreateACLBackendConflict() *CreateACLBackendConflict {

	return &CreateACLBackendConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create Acl backend conflict response
func (o *CreateACLBackendConflict) WithConfigurationVersion(configurationVersion string) *CreateACLBackendConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Acl backend conflict response
func (o *CreateACLBackendConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Acl backend conflict response
func (o *CreateACLBackendConflict) WithPayload(payload *models.Error) *CreateACLBackendConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl backend conflict response
func (o *CreateACLBackendConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLBackendConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateACLBackendDefault General Error

swagger:response createAclBackendDefault
*/
type CreateACLBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateACLBackendDefault creates CreateACLBackendDefault with default headers values
func NewCreateACLBackendDefault(code int) *CreateACLBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateACLBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create Acl backend default response
func (o *CreateACLBackendDefault) WithStatusCode(code int) *CreateACLBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create Acl backend default response
func (o *CreateACLBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create Acl backend default response
func (o *CreateACLBackendDefault) WithConfigurationVersion(configurationVersion string) *CreateACLBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create Acl backend default response
func (o *CreateACLBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create Acl backend default response
func (o *CreateACLBackendDefault) WithPayload(payload *models.Error) *CreateACLBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create Acl backend default response
func (o *CreateACLBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateACLBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
