---
name: "🎨 Submit a design proposal"
about: Submit a design to resolve an open issue that has both `needs-design` and `help-wanted` labels
title: ''
labels: enhancement
assignees: ''

---

<!-- See [CONTRIBUTING.md](../CONTRIBUTING.md#proposing-a-design) for more information.-->

### Link to issue for design submission

<!-- 
Provide a link to the issue this design is for.

All design submissions must be linked to an open issue that
has both the `needs-design` and `help-wanted` labels.
-->

### Proposed Design

<!--
Describe the design you are proposing to resolve the issue.

All CLI designs must adhere to the [Primer CLI design reference](https://primer.style/cli/).
-->

### Mockup

<!--
Provide a mockup of the design you are proposing. All mockups should clearly illustrate the command(s) being run and the expected output(s). 

When color and formatting are important, consider using our [CLI design Google Docs Template](https://docs.google.com/document/d/1JIRErIUuJ6fTgabiFYfCH3x91pyHuytbfa0QLnTfXKM/edit#heading=h.or54sa47ylpg).

Code blocks can also be used to submit a design mockup - remember to include the command(s) being run. Example:

```shell
$ gh issue list --json title -L 5
[
  {
    "title": "`gh pr checks <pr> --required` should not fail when there are no required checks"
  },
  {
    "title": "gh pr view commits should include commit description"
  },
  {
    "title": "Adapt the color of the device code to the color used by the terminal"
  },
  {
    "title": "`gh pr create` does not default to fork when user has write access to upstream"
  },
  {
    "title": "First party discussions support"
  }
]
```
-->