/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2023 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * Menger - Smooth Chebyshev, based on :
 * http://www.fractalforums.com/fragmentarium/help-t22583/
 * and Chebyshev rotation from eiffie

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_menger_smooth_chebyshev.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MengerSmoothChebyshevIteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL t; // temp

	// chebyshev rotation
	if (aux->i >= fractal->transformCommon.startIterationsC
			&& aux->i < fractal->transformCommon.stopIterationsC1)
	{
		if (fractal->transformCommon.functionEnabledSwFalse)
		{
			REAL temp = z.x;
			z.x = z.y;
			z.y = temp;
		}
		REAL F = z.x / z.y;
		if (z.y == 0.0f)
			t = (z.x > 0.0f ? 0.0 : 4.0f);
		else if (fabs(F) < 1.0f)
		{
			if (z.y > 0.0f)
				t = 2.0f - F;
			else
				t = 6.0f - F;
		}
		else
		{
			F = z.y / z.x;
			if (z.x > 0.0f)
				t = fmod(F, 8.0f);
			else
				t = 4.0f + F;
		}

		t += fractal->transformCommon.offset1;

		REAL Length2 = max(fabs(z.x), fabs(z.y));

		REAL C = t - 8.0f * floor(t / 8.0f);

		C = fabs(C - 4.0f) - 2.0f;
		z.x = clamp(C, -1.0f, 1.0f) * Length2;

		REAL S = t - 2.0f;
		S = S - 8.0f * floor(S / 8.0f);
		S = fabs(S - 4.0f) - 2.0f;
		z.y = clamp(S, -1.0f, 1.0f) * Length2;
		aux->DE *= SQRT_1_2_F * 2.0f;
	}

	if (fractal->transformCommon.functionEnabled)
	{
		z = (REAL4){native_sqrt(z.x * z.x + fractal->transformCommon.offset0),
			native_sqrt(z.y * z.y + fractal->transformCommon.offset0),
			native_sqrt(z.z * z.z + fractal->transformCommon.offset0), z.w};
	}
	if (fractal->transformCommon.functionEnabledFFalse)
	{
		z = fabs(z);
		t = fractal->transformCommon.offset;
		z += (REAL4){t, t, t, 0.0f};
	}

	if (aux->i >= fractal->transformCommon.startIterationsE
			&& aux->i < fractal->transformCommon.stopIterationsE)
	{
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix, z);
	}

	REAL OffsetS = 0.0f;
	if (aux->i >= fractal->transformCommon.startIterationsD
			&& aux->i < fractal->transformCommon.stopIterationsD)
	{
		OffsetS = fractal->transformCommon.offset0005;
	}

	REAL col = 0.0f;
	if (z.x < z.y) col += fractal->foldColor.difs0000.x;
	t = z.x - z.y;
	t = fractal->transformCommon.scale05
			* (t - native_sqrt(t * t + OffsetS * fractal->transformCommon.constantMultiplier111.x));
	z.x = z.x - t;
	z.y = z.y + t;

	if (z.x < z.z) col += fractal->foldColor.difs0000.y;
	t = z.x - z.z;
	t = fractal->transformCommon.scale05
			* (t - native_sqrt(t * t + OffsetS * fractal->transformCommon.constantMultiplier111.y));
	z.x = z.x - t;
	z.z = z.z + t;

	if (z.y < z.z) col += fractal->foldColor.difs0000.z;
	t = z.y - z.z;
	t = fractal->transformCommon.scale05
			* (t - native_sqrt(t * t + OffsetS * fractal->transformCommon.constantMultiplier111.z));
	z.y = z.y - t;
	z.z = z.z + t;

	t = fractal->transformCommon.constantMultiplier221.z * FRAC_1_3_F;
	z.z -= t;
	z.z = -native_sqrt(z.z * z.z + OffsetS + fractal->transformCommon.offsetA0);
	z.z += t;

	z.x = fractal->transformCommon.scale3 * z.x - fractal->transformCommon.constantMultiplier221.x;
	z.y = fractal->transformCommon.scale3 * z.y - fractal->transformCommon.constantMultiplier221.y;
	z.z = fractal->transformCommon.scale3 * z.z;

	aux->DE *= fractal->transformCommon.scale3;

	if (fractal->transformCommon.rotationEnabled
			&& aux->i >= fractal->transformCommon.startIterationsR
			&& aux->i < fractal->transformCommon.stopIterationsR)
	{
		z = Matrix33MulFloat4(fractal->transformCommon.rotationMatrix2, z);
	}

	if (fractal->transformCommon.functionEnabledxFalse
			&& aux->i >= fractal->transformCommon.startIterationsA
			&& aux->i < fractal->transformCommon.stopIterationsA) // box offset
	{
		z.x += sign(z.x) * fractal->transformCommon.additionConstantA000.x;
		z.y += sign(z.y) * fractal->transformCommon.additionConstantA000.y;
		z.z += sign(z.z) * fractal->transformCommon.additionConstantA000.z;
	}

	if (fractal->foldColor.auxColorEnabledFalse && aux->i >= fractal->foldColor.startIterationsA
			&& aux->i < fractal->foldColor.stopIterationsA)
	{
		aux->color += col;
	}
	return z;
}