// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ListPeersByClusterPartitionReader is a Reader for the ListPeersByClusterPartition structure.
type ListPeersByClusterPartitionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListPeersByClusterPartitionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListPeersByClusterPartitionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListPeersByClusterPartitionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListPeersByClusterPartitionOK creates a ListPeersByClusterPartitionOK with default headers values
func NewListPeersByClusterPartitionOK() *ListPeersByClusterPartitionOK {
	return &ListPeersByClusterPartitionOK{}
}

/*
ListPeersByClusterPartitionOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListPeersByClusterPartitionOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215ListPeersByClusterPartitionResponse
}

// IsSuccess returns true when this list peers by cluster partition o k response has a 2xx status code
func (o *ListPeersByClusterPartitionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list peers by cluster partition o k response has a 3xx status code
func (o *ListPeersByClusterPartitionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list peers by cluster partition o k response has a 4xx status code
func (o *ListPeersByClusterPartitionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list peers by cluster partition o k response has a 5xx status code
func (o *ListPeersByClusterPartitionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list peers by cluster partition o k response a status code equal to that given
func (o *ListPeersByClusterPartitionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list peers by cluster partition o k response
func (o *ListPeersByClusterPartitionOK) Code() int {
	return 200
}

func (o *ListPeersByClusterPartitionOK) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peers_by_cluster_partition][%d] listPeersByClusterPartitionOK  %+v", 200, o.Payload)
}

func (o *ListPeersByClusterPartitionOK) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peers_by_cluster_partition][%d] listPeersByClusterPartitionOK  %+v", 200, o.Payload)
}

func (o *ListPeersByClusterPartitionOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215ListPeersByClusterPartitionResponse {
	return o.Payload
}

func (o *ListPeersByClusterPartitionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215ListPeersByClusterPartitionResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListPeersByClusterPartitionDefault creates a ListPeersByClusterPartitionDefault with default headers values
func NewListPeersByClusterPartitionDefault(code int) *ListPeersByClusterPartitionDefault {
	return &ListPeersByClusterPartitionDefault{
		_statusCode: code,
	}
}

/*
ListPeersByClusterPartitionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListPeersByClusterPartitionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this list peers by cluster partition default response has a 2xx status code
func (o *ListPeersByClusterPartitionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list peers by cluster partition default response has a 3xx status code
func (o *ListPeersByClusterPartitionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list peers by cluster partition default response has a 4xx status code
func (o *ListPeersByClusterPartitionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list peers by cluster partition default response has a 5xx status code
func (o *ListPeersByClusterPartitionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list peers by cluster partition default response a status code equal to that given
func (o *ListPeersByClusterPartitionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list peers by cluster partition default response
func (o *ListPeersByClusterPartitionDefault) Code() int {
	return o._statusCode
}

func (o *ListPeersByClusterPartitionDefault) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peers_by_cluster_partition][%d] ListPeersByClusterPartition default  %+v", o._statusCode, o.Payload)
}

func (o *ListPeersByClusterPartitionDefault) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/peers_by_cluster_partition][%d] ListPeersByClusterPartition default  %+v", o._statusCode, o.Payload)
}

func (o *ListPeersByClusterPartitionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ListPeersByClusterPartitionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
