/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.shrink.ClassUsageMarker;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.ShortestUsageMarker;
import proguard.util.Processable;

public class ShortestClassUsageMarker
extends ClassUsageMarker {
    public ShortestClassUsageMarker(ShortestUsageMarker usageMarker, String reason) {
        super(usageMarker);
        this.setCurrentUsageMark(new ShortestUsageMark(reason));
    }

    @Override
    public ShortestUsageMarker getUsageMarker() {
        return (ShortestUsageMarker)super.getUsageMarker();
    }

    @Override
    protected void markProgramClassBody(ProgramClass programClass) {
        ShortestUsageMark previousUsageMark = this.getCurrentUsageMark();
        this.setCurrentUsageMark(new ShortestUsageMark(this.getShortestUsageMark(programClass), "is extended by   ", 10000, programClass));
        super.markProgramClassBody(programClass);
        this.setCurrentUsageMark(previousUsageMark);
    }

    @Override
    protected void markProgramFieldBody(ProgramClass programClass, ProgramField programField) {
        ShortestUsageMark previousUsageMark = this.getCurrentUsageMark();
        this.setCurrentUsageMark(new ShortestUsageMark(this.getShortestUsageMark(programField), "is referenced by ", 1, programClass, programField));
        super.markProgramFieldBody(programClass, programField);
        this.setCurrentUsageMark(previousUsageMark);
    }

    @Override
    protected void markProgramMethodBody(ProgramClass programClass, ProgramMethod programMethod) {
        ShortestUsageMark previousUsageMark = this.getCurrentUsageMark();
        this.setCurrentUsageMark(new ShortestUsageMark(this.getShortestUsageMark(programMethod), "is invoked by    ", 1, programClass, programMethod));
        super.markProgramMethodBody(programClass, programMethod);
        this.setCurrentUsageMark(previousUsageMark);
    }

    @Override
    protected void markMethodHierarchy(Clazz clazz, Method method) {
        ShortestUsageMark previousUsageMark = this.getCurrentUsageMark();
        this.setCurrentUsageMark(new ShortestUsageMark(this.getShortestUsageMark(method), "implements       ", 100, clazz, method));
        super.markMethodHierarchy(clazz, method);
        this.setCurrentUsageMark(previousUsageMark);
    }

    @Override
    public boolean shouldBeMarkedAsUsed(ProgramClass programClass) {
        return this.getUsageMarker().shouldBeMarkedAsUsed(programClass);
    }

    @Override
    public boolean shouldBeMarkedAsUsed(ProgramClass programClass, ProgramMember programMember) {
        return this.getUsageMarker().shouldBeMarkedAsUsed(programClass, programMember);
    }

    @Override
    public boolean shouldBeMarkedAsUsed(Processable processable) {
        return this.getUsageMarker().shouldBeMarkedAsUsed(processable);
    }

    @Override
    public boolean isUsed(Processable processable) {
        return this.getUsageMarker().isUsed(processable);
    }

    @Override
    public void markAsPossiblyUsed(Processable processable) {
        this.getUsageMarker().markAsPossiblyUsed(processable);
    }

    @Override
    public boolean shouldBeMarkedAsPossiblyUsed(ProgramClass programClass, ProgramMember programMember) {
        return this.getUsageMarker().shouldBeMarkedAsPossiblyUsed(programClass, programMember);
    }

    @Override
    public boolean shouldBeMarkedAsPossiblyUsed(Processable processable) {
        return this.getUsageMarker().shouldBeMarkedAsPossiblyUsed(processable);
    }

    @Override
    public boolean isPossiblyUsed(Processable processable) {
        return this.getUsageMarker().isPossiblyUsed(processable);
    }

    protected ShortestUsageMark getShortestUsageMark(Processable processable) {
        return this.getUsageMarker().getShortestUsageMark(processable);
    }

    private ShortestUsageMark getCurrentUsageMark() {
        return this.getUsageMarker().currentUsageMark;
    }

    private void setCurrentUsageMark(ShortestUsageMark shortestUsageMark) {
        this.getUsageMarker().setCurrentUsageMark(shortestUsageMark);
    }
}

