/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;

public class ConstantTagFilter
implements ConstantVisitor {
    private final int constantTagMask;
    private final ConstantVisitor constantVisitor;

    public ConstantTagFilter(int constantTag, ConstantVisitor constantVisitor) {
        this.constantTagMask = 1 << constantTag;
        this.constantVisitor = constantVisitor;
    }

    public ConstantTagFilter(int[] constantTags, ConstantVisitor constantVisitor) {
        int constantTagMask = 0;
        for (int index = 0; index < constantTags.length; ++index) {
            constantTagMask |= 1 << constantTags[index];
        }
        this.constantTagMask = constantTagMask;
        this.constantVisitor = constantVisitor;
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
        if ((1 << constant.getTag() & this.constantTagMask) != 0) {
            constant.accept(clazz, this.constantVisitor);
        }
    }
}

