/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.internal.p2.discovery.AbstractCatalogSource;
import org.eclipse.equinox.internal.p2.discovery.model.AbstractCatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.Group;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.discovery.model.Messages;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.discovery.model.ValidationException;

public class CatalogCategory
extends AbstractCatalogItem {
    private AbstractCatalogSource source;
    private final List<CatalogItem> items = new ArrayList<CatalogItem>();
    protected String id;
    protected String name;
    protected String description;
    protected String relevance;
    protected Icon icon;
    protected Overview overview;
    protected List<Group> group = new ArrayList<Group>();

    public List<CatalogItem> getItems() {
        return this.items;
    }

    public AbstractCatalogSource getSource() {
        return this.source;
    }

    public void setSource(AbstractCatalogSource source) {
        this.source = source;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRelevance() {
        return this.relevance;
    }

    public void setRelevance(String relevance) {
        this.relevance = relevance;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Overview getOverview() {
        return this.overview;
    }

    public void setOverview(Overview overview) {
        this.overview = overview;
    }

    public List<Group> getGroup() {
        return this.group;
    }

    public void setGroup(List<Group> group) {
        this.group = group;
    }

    public void validate() throws ValidationException {
        if (this.id == null || this.id.length() == 0) {
            throw new ValidationException(Messages.CatalogCategory_must_specify_CatalogCategory_id);
        }
        if (this.name == null || this.name.length() == 0) {
            throw new ValidationException(Messages.CatalogCategory_must_specify_CatalogCategory_name);
        }
        if (this.description == null || this.description.length() == 0) {
            throw new ValidationException("Must specify connectorCategory/@description");
        }
        if (this.icon != null) {
            this.icon.validate();
        }
        if (this.relevance != null) {
            try {
                int r = Integer.parseInt(this.relevance, 10);
                if (r < 0 || r > 100) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new ValidationException(Messages.CatalogCategory_CatalogCategory_relevance_invalid);
            }
        }
        if (this.overview != null) {
            this.overview.validate();
        }
        for (Group groupItem : this.group) {
            groupItem.validate();
        }
    }
}

