/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html;

import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.renderer.AttributablePart;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.HtmlAppendableBase;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.TagRange;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlWriter
extends HtmlAppendableBase<HtmlWriter> {
    @Nullable
    private NodeRendererContext context;
    @Nullable
    private AttributablePart useAttributes;

    public HtmlWriter(int indentSize, int formatOptions) {
        super(indentSize, formatOptions);
    }

    public HtmlWriter(HtmlWriter other, boolean inheritIndent) {
        super(other, inheritIndent);
        this.context = other.context;
    }

    public HtmlWriter(int indentSize, int formatOptions, boolean suppressOpenTagLine, boolean suppressCloseTagLine) {
        this(null, indentSize, formatOptions, suppressOpenTagLine, suppressCloseTagLine);
    }

    public HtmlWriter(@Nullable Appendable appendable, int indentSize, int formatOptions, boolean suppressOpenTagLine, boolean suppressCloseTagLine) {
        super(appendable, indentSize, formatOptions);
        this.setSuppressOpenTagLine(suppressOpenTagLine);
        this.setSuppressCloseTagLine(suppressCloseTagLine);
    }

    void setContext(@NotNull NodeRendererContext context) {
        this.context = context;
    }

    @NotNull
    public NodeRendererContext getContext() {
        assert (this.context != null);
        return this.context;
    }

    @NotNull
    public HtmlWriter srcPos() {
        return this.context == null ? this : this.srcPos(this.context.getCurrentNode().getChars());
    }

    @NotNull
    public HtmlWriter srcPosWithEOL() {
        return this.context == null ? this : this.srcPosWithEOL(this.context.getCurrentNode().getChars());
    }

    @NotNull
    public HtmlWriter srcPosWithTrailingEOL() {
        return this.context == null ? this : this.srcPosWithTrailingEOL(this.context.getCurrentNode().getChars());
    }

    @NotNull
    public HtmlWriter srcPos(@NotNull BasedSequence sourceText) {
        if (sourceText.isNotNull()) {
            BasedSequence trimmed = (BasedSequence)sourceText.trimEOL();
            return this.srcPos(trimmed.getStartOffset(), trimmed.getEndOffset());
        }
        return this;
    }

    @NotNull
    public HtmlWriter srcPosWithEOL(@NotNull BasedSequence sourceText) {
        if (sourceText.isNotNull()) {
            return this.srcPos(sourceText.getStartOffset(), sourceText.getEndOffset());
        }
        return this;
    }

    @NotNull
    public HtmlWriter srcPosWithTrailingEOL(@NotNull BasedSequence sourceText) {
        if (sourceText.isNotNull()) {
            char c;
            int endOffset;
            BasedSequence base = sourceText.getBaseSequence();
            for (endOffset = sourceText.getEndOffset(); endOffset < base.length() && ((c = base.charAt(endOffset)) == ' ' || c == '\t'); ++endOffset) {
            }
            if (endOffset < base.length() && base.charAt(endOffset) == '\r') {
                ++endOffset;
            }
            if (endOffset < base.length() && base.charAt(endOffset) == '\n') {
                ++endOffset;
            }
            return this.srcPos(sourceText.getStartOffset(), endOffset);
        }
        return this;
    }

    @NotNull
    public HtmlWriter srcPos(int startOffset, int endOffset) {
        if (startOffset <= endOffset && this.context != null && !this.context.getHtmlOptions().sourcePositionAttribute.isEmpty()) {
            super.attr(this.context.getHtmlOptions().sourcePositionAttribute, startOffset + "-" + endOffset);
        }
        return this;
    }

    @Override
    @NotNull
    public HtmlWriter withAttr() {
        return this.withAttr(AttributablePart.NODE);
    }

    @NotNull
    public HtmlWriter withAttr(@NotNull AttributablePart part) {
        super.withAttr();
        this.useAttributes = part;
        return this;
    }

    @NotNull
    public HtmlWriter withAttr(@NotNull LinkStatus status2) {
        this.attr("Link Status", status2.getName());
        return this.withAttr(AttributablePart.LINK);
    }

    @NotNull
    public HtmlWriter withAttr(@NotNull ResolvedLink resolvedLink) {
        return this.withAttr(resolvedLink.getStatus());
    }

    @Override
    @NotNull
    public HtmlWriter tag(@NotNull CharSequence tagName, boolean voidElement) {
        if (this.useAttributes != null) {
            String attributeValue;
            Attributes attributes;
            if (this.context != null) {
                attributes = this.context.extendRenderingNodeAttributes(this.useAttributes, this.getAttributes());
                String sourcePositionAttribute = this.context.getHtmlOptions().sourcePositionAttribute;
                attributeValue = attributes.getValue(sourcePositionAttribute);
            } else {
                attributeValue = "";
                attributes = new Attributes();
            }
            if (!attributeValue.isEmpty()) {
                int pos = attributeValue.indexOf(45);
                int startOffset = -1;
                int endOffset = -1;
                if (pos != -1) {
                    try {
                        startOffset = Integer.parseInt(attributeValue.substring(0, pos));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    try {
                        endOffset = Integer.parseInt(attributeValue.substring(pos + 1));
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (startOffset >= 0 && startOffset < endOffset) {
                    ArrayList<TagRange> tagRanges = HtmlRenderer.TAG_RANGES.get(this.context.getDocument());
                    tagRanges.add(new TagRange(tagName, startOffset, endOffset));
                }
            }
            this.setAttributes(attributes);
            this.useAttributes = null;
        }
        super.tag(tagName, voidElement);
        return this;
    }
}

