/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution.application;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;

public final class AppMainV2 {
    public static final String LAUNCHER_PORT_NUMBER = "idea.launcher.port";
    public static final String LAUNCHER_USE_JDK_21_PREVIEW = "idea.launcher.use.21.preview";
    private static final String LAUNCHER_MAIN_CLASS = "idea.launcher.main.class";

    private static void startMonitor(final int portNumber) {
        Thread t = new Thread("Monitor Ctrl-Break"){

            @Override
            public void run() {
                try (Socket client = new Socket("127.0.0.1", portNumber);
                     BufferedReader reader = new BufferedReader(new InputStreamReader(client.getInputStream(), "US-ASCII"));){
                    while (true) {
                        String msg;
                        if ((msg = reader.readLine()) == null || "TERM".equals(msg)) {
                            return;
                        }
                        if (!"STOP".equals(msg)) continue;
                        System.exit(1);
                    }
                }
                catch (Exception exception) {
                    return;
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    public static void main(String[] args) throws Throwable {
        Class<?> appClass;
        Method m;
        try {
            int portNumber = Integer.parseInt(System.getProperty(LAUNCHER_PORT_NUMBER));
            AppMainV2.startMonitor(portNumber);
        }
        catch (Throwable t) {
            System.err.println("Launcher failed - \"Dump Threads\" and \"Exit\" actions are unavailable (" + t.getMessage() + ')');
        }
        String[] params = args;
        String mainClass = System.getProperty(LAUNCHER_MAIN_CLASS);
        if (mainClass == null) {
            mainClass = args[0];
            System.setProperty(LAUNCHER_MAIN_CLASS, mainClass);
            params = Arrays.copyOfRange(args, 1, args.length);
        }
        if ((m = AppMainV2.findMethodToRun(appClass = Class.forName(mainClass))) == null) {
            try {
                m = appClass.getMethod("main", String[].class);
            }
            catch (NoSuchMethodException e) {
                if (!AppMainV2.startJavaFXApplication(params, appClass)) {
                    throw new IllegalArgumentException("Main method is not found");
                }
                return;
            }
        }
        if (!Void.TYPE.isAssignableFrom(m.getReturnType())) {
            System.err.println("main method must return a value of type void");
            return;
        }
        try {
            m.setAccessible(true);
            int parameterCount = m.getParameterTypes().length;
            Object objInstance = null;
            if (!Modifier.isStatic(m.getModifiers())) {
                Constructor<?> declaredConstructor;
                try {
                    declaredConstructor = appClass.getDeclaredConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    System.err.println("Non-static main() method was invoked: class must have constructor with no parameters");
                    return;
                }
                declaredConstructor.setAccessible(true);
                objInstance = declaredConstructor.newInstance(new Object[0]);
            }
            if (parameterCount == 0) {
                m.invoke(objInstance, new Object[0]);
            } else {
                m.invoke(objInstance, new Object[]{params});
            }
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private static MainMethodStatus getMainMethodStatus(Method method, MainMethodSearchMode mode) {
        if ("main".equals(method.getName()) && !Modifier.isPrivate(method.getModifiers()) && (mode == MainMethodSearchMode.ALL_METHOD || mode == MainMethodSearchMode.STATIC_METHOD && Modifier.isStatic(method.getModifiers()))) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1 && parameterTypes[0] == String[].class) {
                return MainMethodStatus.WithArgs;
            }
            if (parameterTypes.length == 0) {
                return MainMethodStatus.WithoutArgs;
            }
        }
        return MainMethodStatus.NotMain;
    }

    private static boolean isJava21Preview() {
        try {
            return Boolean.parseBoolean(System.getProperty(LAUNCHER_USE_JDK_21_PREVIEW));
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static Method findMethodToRun(Class<?> aClass) {
        boolean java21Preview = AppMainV2.isJava21Preview();
        Method methodWithoutArgsCandidate = null;
        if (java21Preview) {
            for (Method declaredMethod : aClass.getDeclaredMethods()) {
                Method[] status = AppMainV2.getMainMethodStatus(declaredMethod, MainMethodSearchMode.STATIC_METHOD);
                if (status == MainMethodStatus.WithArgs) {
                    return declaredMethod;
                }
                if (status != MainMethodStatus.WithoutArgs || methodWithoutArgsCandidate != null) continue;
                methodWithoutArgsCandidate = declaredMethod;
            }
        }
        if (methodWithoutArgsCandidate != null) {
            return methodWithoutArgsCandidate;
        }
        ArrayDeque classesToVisit = new ArrayDeque();
        classesToVisit.add(aClass);
        HashSet visited = new HashSet();
        while (!classesToVisit.isEmpty()) {
            Method[] declaredMethods;
            Class last = (Class)classesToVisit.removeLast();
            for (Method method : declaredMethods = last.getDeclaredMethods()) {
                if (Modifier.isAbstract(aClass.getModifiers()) && !Modifier.isStatic(method.getModifiers())) continue;
                MainMethodStatus status = AppMainV2.getMainMethodStatus(method, java21Preview ? MainMethodSearchMode.NON_STATIC_METHOD : MainMethodSearchMode.ALL_METHOD);
                if (status == MainMethodStatus.WithArgs) {
                    return method;
                }
                if (status != MainMethodStatus.WithoutArgs || methodWithoutArgsCandidate != null) continue;
                methodWithoutArgsCandidate = method;
            }
            visited.add(aClass);
            Class superclass = last.getSuperclass();
            if (superclass != null) {
                classesToVisit.add(superclass);
            }
            for (Class<?> anInterface : last.getInterfaces()) {
                if (visited.contains(anInterface)) continue;
                classesToVisit.add(anInterface);
            }
        }
        return methodWithoutArgsCandidate;
    }

    private static boolean startJavaFXApplication(String[] params, Class<?> appClass) {
        try {
            Method launchApplication = Class.forName("com.sun.javafx.application.LauncherImpl").getMethod("launchApplication", Class.class, String[].class);
            launchApplication.invoke(null, appClass, params);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void premain(String args) {
        try {
            int p = args.indexOf(58);
            int portNumber = Integer.parseInt(p > 0 ? args.substring(0, p) : args);
            AppMainV2.startMonitor(portNumber);
        }
        catch (Throwable t) {
            System.err.println("Launcher failed - \"Dump Threads\" and \"Exit\" actions are unavailable (" + t.getMessage() + ')');
        }
    }

    private static enum MainMethodSearchMode {
        ALL_METHOD,
        STATIC_METHOD,
        NON_STATIC_METHOD;

    }

    static enum MainMethodStatus {
        NotMain,
        WithArgs,
        WithoutArgs;

    }

    public static final class Agent {
        public static void premain(String args, Instrumentation i) {
            AppMainV2.premain(args);
        }
    }
}

